/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.io.File;
import java.util.ArrayList;
import zombie.MapCollisionData;
import zombie.ZomboidFileSystem;
import zombie.ai.states.WalkTowardState;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.LotHeader;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.popman.MPDebugInfo;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.vehicles.VehiclesDB2;

public final class ZombiePopulationRenderer {
    private float xPos;
    private float yPos;
    private float offx;
    private float offy;
    private float zoom;
    private float draww;
    private float drawh;
    private static final int VERSION = 1;
    private final ArrayList<ConfigOption> options = new ArrayList();
    private BooleanDebugOption CellGrid = new BooleanDebugOption("CellGrid", true);
    private BooleanDebugOption MetaGridBuildings = new BooleanDebugOption("MetaGrid.Buildings", true);
    private BooleanDebugOption ZombiesStanding = new BooleanDebugOption("Zombies.Standing", true);
    private BooleanDebugOption ZombiesMoving = new BooleanDebugOption("Zombies.Moving", true);
    private BooleanDebugOption MCDObstacles = new BooleanDebugOption("MapCollisionData.Obstacles", true);
    private BooleanDebugOption MCDRegularChunkOutlines = new BooleanDebugOption("MapCollisionData.RegularChunkOutlines", true);
    private BooleanDebugOption MCDRooms = new BooleanDebugOption("MapCollisionData.Rooms", true);
    private BooleanDebugOption Vehicles = new BooleanDebugOption("Vehicles", true);

    private native void n_render(float var1, int var2, int var3, float var4, float var5, int var6, int var7);

    private native void n_setWallFollowerStart(int var1, int var2);

    private native void n_setWallFollowerEnd(int var1, int var2);

    private native void n_wallFollowerMouseMove(int var1, int var2);

    private native void n_setDebugOption(String var1, String var2);

    public float worldToScreenX(float f) {
        f -= this.xPos;
        f *= this.zoom;
        f += this.offx;
        return f += this.draww / 2.0f;
    }

    public float worldToScreenY(float f) {
        f -= this.yPos;
        f *= this.zoom;
        f += this.offy;
        return f += this.drawh / 2.0f;
    }

    public float uiToWorldX(float f) {
        f -= this.draww / 2.0f;
        f /= this.zoom;
        return f += this.xPos;
    }

    public float uiToWorldY(float f) {
        f -= this.drawh / 2.0f;
        f /= this.zoom;
        return f += this.yPos;
    }

    public void renderString(float f, float f2, String string, double d, double d2, double d3, double d4) {
        float f3 = this.worldToScreenX(f);
        float f4 = this.worldToScreenY(f2);
        SpriteRenderer.instance.render(null, f3 - 2.0f, f4 - 2.0f, TextManager.instance.MeasureStringX(UIFont.Small, string) + 4, TextManager.instance.font.getLineHeight() + 4, 0.0f, 0.0f, 0.0f, 0.75f, null);
        TextManager.instance.DrawString(f3, f4, string, d, d2, d3, d4);
    }

    public void renderRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.worldToScreenX(f);
        float f10 = this.worldToScreenY(f2);
        float f11 = this.worldToScreenX(f + f3);
        float f12 = this.worldToScreenY(f2 + f4);
        f3 = f11 - f9;
        f4 = f12 - f10;
        if (f9 >= this.offx + this.draww || f11 < this.offx || f10 >= this.offy + this.drawh || f12 < this.offy) {
            return;
        }
        SpriteRenderer.instance.render(null, f9, f10, f3, f4, f5, f6, f7, f8, null);
    }

    public void renderLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.worldToScreenX(f);
        float f10 = this.worldToScreenY(f2);
        float f11 = this.worldToScreenX(f3);
        float f12 = this.worldToScreenY(f4);
        if (f9 >= (float)Core.getInstance().getScreenWidth() && f11 >= (float)Core.getInstance().getScreenWidth() || f10 >= (float)Core.getInstance().getScreenHeight() && f12 >= (float)Core.getInstance().getScreenHeight() || f9 < 0.0f && f11 < 0.0f || f10 < 0.0f && f12 < 0.0f) {
            return;
        }
        SpriteRenderer.instance.renderline(null, (int)f9, (int)f10, (int)f11, (int)f12, f5, f6, f7, f8);
    }

    public void renderCircle(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        int n = 32;
        double d = (double)f + (double)f3 * Math.cos(Math.toRadians(0.0f / (float)n));
        double d2 = (double)f2 + (double)f3 * Math.sin(Math.toRadians(0.0f / (float)n));
        for (int i = 1; i <= n; ++i) {
            double d3 = (double)f + (double)f3 * Math.cos(Math.toRadians((float)i * 360.0f / (float)n));
            double d4 = (double)f2 + (double)f3 * Math.sin(Math.toRadians((float)i * 360.0f / (float)n));
            int n2 = (int)this.worldToScreenX((float)d);
            int n3 = (int)this.worldToScreenY((float)d2);
            int n4 = (int)this.worldToScreenX((float)d3);
            int n5 = (int)this.worldToScreenY((float)d4);
            SpriteRenderer.instance.renderline(null, n2, n3, n4, n5, f4, f5, f6, f7);
            d = d3;
            d2 = d4;
        }
    }

    public void renderZombie(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f / this.zoom + 0.5f;
        this.renderRect(f - f6 / 2.0f, f2 - f6 / 2.0f, f6, f6, f3, f4, f5, 1.0f);
    }

    public void renderVehicle(int n, float f, float f2, float f3, float f4, float f5) {
        float f6 = 2.0f / this.zoom + 0.5f;
        this.renderRect(f - f6 / 2.0f, f2 - f6 / 2.0f, f6, f6, f3, f4, f5, 1.0f);
        this.renderString(f, f2, String.format("%d", n), f3, f4, f5, 1.0);
    }

    public void outlineRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.renderLine(f, f2, f + f3, f2, f5, f6, f7, f8);
        this.renderLine(f + f3, f2, f + f3, f2 + f4, f5, f6, f7, f8);
        this.renderLine(f, f2 + f4, f + f3, f2 + f4, f5, f6, f7, f8);
        this.renderLine(f, f2, f, f2 + f4, f5, f6, f7, f8);
    }

    public void renderCellInfo(int n, int n2, int n3, int n4, float f) {
        float f2 = this.worldToScreenX(n * 300) + 4.0f;
        float f3 = this.worldToScreenY(n2 * 300) + 4.0f;
        String string = n3 + " / " + n4;
        if (f > 0.0f) {
            string = string + String.format(" %.2f", Float.valueOf(f));
        }
        SpriteRenderer.instance.render(null, f2 - 2.0f, f3 - 2.0f, TextManager.instance.MeasureStringX(UIFont.Small, string) + 4, TextManager.instance.font.getLineHeight() + 4, 0.0f, 0.0f, 0.0f, 0.75f, null);
        TextManager.instance.DrawString(f2, f3, string, 1.0, 1.0, 1.0, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(UIElement uIElement, float f, float f2, float f3) {
        Object object = MapCollisionData.instance.renderLock;
        synchronized (object) {
            this._render(uIElement, f, f2, f3);
        }
    }

    private void _render(UIElement uIElement, float f, float f2, float f3) {
        int n;
        this.draww = uIElement.getWidth().intValue();
        this.drawh = uIElement.getHeight().intValue();
        this.xPos = f2;
        this.yPos = f3;
        this.offx = uIElement.getAbsoluteX().intValue();
        this.offy = uIElement.getAbsoluteY().intValue();
        this.zoom = f;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[0];
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        IsoMetaCell[][] isoMetaCellArray = isoMetaGrid.Grid;
        int n2 = (int)(this.uiToWorldX(0.0f) / 300.0f) - isoMetaGrid.minX;
        int n3 = (int)(this.uiToWorldY(0.0f) / 300.0f) - isoMetaGrid.minY;
        int n4 = (int)(this.uiToWorldX(this.draww) / 300.0f) + 1 - isoMetaGrid.minX;
        int n5 = (int)(this.uiToWorldY(this.drawh) / 300.0f) + 1 - isoMetaGrid.minY;
        n2 = PZMath.clamp(n2, 0, isoMetaGrid.getWidth() - 1);
        n3 = PZMath.clamp(n3, 0, isoMetaGrid.getHeight() - 1);
        n4 = PZMath.clamp(n4, 0, isoMetaGrid.getWidth() - 1);
        n5 = PZMath.clamp(n5, 0, isoMetaGrid.getHeight() - 1);
        if (this.MetaGridBuildings.getValue()) {
            for (n = n2; n <= n4; ++n) {
                for (int i = n3; i <= n5; ++i) {
                    LotHeader lotHeader = isoMetaCellArray[n][i].info;
                    if (lotHeader == null) continue;
                    for (int j = 0; j < lotHeader.Buildings.size(); ++j) {
                        BuildingDef buildingDef = lotHeader.Buildings.get(j);
                        for (int k = 0; k < buildingDef.rooms.size(); ++k) {
                            if (buildingDef.rooms.get((int)k).level > 0) continue;
                            ArrayList<RoomDef.RoomRect> arrayList = buildingDef.rooms.get(k).getRects();
                            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                                RoomDef.RoomRect roomRect = arrayList.get(i2);
                                if (buildingDef.bAlarmed) {
                                    this.renderRect(roomRect.getX(), roomRect.getY(), roomRect.getW(), roomRect.getH(), 0.8f, 0.8f, 0.5f, 0.3f);
                                    continue;
                                }
                                this.renderRect(roomRect.getX(), roomRect.getY(), roomRect.getW(), roomRect.getH(), 0.5f, 0.5f, 0.8f, 0.3f);
                            }
                        }
                    }
                }
            }
        }
        if (this.CellGrid.getValue()) {
            for (n = n3; n <= n5; ++n) {
                this.renderLine(isoMetaGrid.minX * 300, (isoMetaGrid.minY + n) * 300, (isoMetaGrid.maxX + 1) * 300, (isoMetaGrid.minY + n) * 300, 1.0f, 1.0f, 1.0f, 0.15f);
            }
            for (n = n2; n <= n4; ++n) {
                this.renderLine((isoMetaGrid.minX + n) * 300, isoMetaGrid.minY * 300, (isoMetaGrid.minX + n) * 300, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.15f);
            }
        }
        for (n = 0; n < IsoWorld.instance.CurrentCell.getZombieList().size(); ++n) {
            IsoZombie isoZombie = IsoWorld.instance.CurrentCell.getZombieList().get(n);
            float f4 = 1.0f;
            float f5 = 1.0f;
            float f6 = 0.0f;
            if (isoZombie.isReanimatedPlayer()) {
                f4 = 0.0f;
            }
            this.renderZombie(isoZombie.x, isoZombie.y, f4, f5, f6);
            if (isoZombie.getCurrentState() != WalkTowardState.instance()) continue;
            this.renderLine(isoZombie.x, isoZombie.y, isoZombie.getPathTargetX(), isoZombie.getPathTargetY(), 1.0f, 1.0f, 1.0f, 0.5f);
        }
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            IsoPlayer isoPlayer = IsoPlayer.players[n];
            if (isoPlayer == null) continue;
            this.renderZombie(isoPlayer.x, isoPlayer.y, 0.0f, 0.5f, 0.0f);
        }
        if (GameClient.bClient) {
            MPDebugInfo.instance.render(this, f);
            return;
        }
        if (this.Vehicles.getValue()) {
            VehiclesDB2.instance.renderDebug(this);
        }
        this.n_render(f, (int)this.offx, (int)this.offy, f2, f3, (int)this.draww, (int)this.drawh);
    }

    public void setWallFollowerStart(int n, int n2) {
        if (GameClient.bClient) {
            return;
        }
        this.n_setWallFollowerStart(n, n2);
    }

    public void setWallFollowerEnd(int n, int n2) {
        if (GameClient.bClient) {
            return;
        }
        this.n_setWallFollowerEnd(n, n2);
    }

    public void wallFollowerMouseMove(int n, int n2) {
        if (GameClient.bClient) {
            return;
        }
        this.n_wallFollowerMouseMove(n, n2);
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void save() {
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "popman-options.ini";
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, 1, this.options);
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            this.n_setDebugOption(configOption.getName(), configOption.getValueAsString());
        }
    }

    public void load() {
        ConfigOption configOption;
        int n;
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "popman-options.ini";
        if (configFile.read(string)) {
            for (n = 0; n < configFile.getOptions().size(); ++n) {
                configOption = configFile.getOptions().get(n);
                ConfigOption configOption2 = this.getOptionByName(configOption.getName());
                if (configOption2 == null) continue;
                configOption2.parse(configOption.getValueAsString());
            }
        }
        for (n = 0; n < this.options.size(); ++n) {
            configOption = this.options.get(n);
            this.n_setDebugOption(configOption.getName(), configOption.getValueAsString());
        }
    }

    public class BooleanDebugOption
    extends BooleanConfigOption {
        public BooleanDebugOption(String string, boolean bl) {
            super(string, bl);
            ZombiePopulationRenderer.this.options.add(this);
        }
    }
}

