/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import se.krka.kahlua.vm.KahluaTable;
import zombie.DebugFileWatcher;
import zombie.GameTime;
import zombie.MapCollisionData;
import zombie.PersistentOutfits;
import zombie.PredicatedFileWatcher;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZomboidFileSystem;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardState;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.gameStates.ChooseGameInfo;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.popman.DebugCommands;
import zombie.popman.LoadedAreas;
import zombie.popman.MPDebugInfo;
import zombie.popman.PlayerSpawns;
import zombie.popman.ZombieTriggerXmlFile;
import zombie.util.PZXmlParserException;
import zombie.util.PZXmlUtil;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.PolygonalMap2;

public final class ZombiePopulationManager {
    public static final ZombiePopulationManager instance = new ZombiePopulationManager();
    protected static final int SQUARES_PER_CHUNK = 10;
    protected static final int CHUNKS_PER_CELL = 30;
    protected static final int SQUARES_PER_CELL = 300;
    protected static final byte OLD_ZOMBIE_CRAWLER_CAN_WALK = 1;
    protected static final byte OLD_ZOMBIE_FAKE_DEAD = 2;
    protected static final byte OLD_ZOMBIE_CRAWLER = 3;
    protected static final byte OLD_ZOMBIE_WALKER = 4;
    protected static final int ZOMBIE_STATE_INITIALIZED = 1;
    protected static final int ZOMBIE_STATE_CRAWLING = 2;
    protected static final int ZOMBIE_STATE_CAN_WALK = 4;
    protected static final int ZOMBIE_STATE_FAKE_DEAD = 8;
    protected static final int ZOMBIE_STATE_CRAWL_UNDER_VEHICLE = 16;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected boolean bStopped;
    protected boolean bClient;
    private final DebugCommands dbgCommands = new DebugCommands();
    public static boolean bDebugLoggingEnabled = false;
    private final LoadedAreas loadedAreas = new LoadedAreas(false);
    private final LoadedAreas loadedServerCells = new LoadedAreas(true);
    private final PlayerSpawns playerSpawns = new PlayerSpawns();
    private short[] realZombieCount;
    private short[] realZombieCount2;
    private long realZombieUpdateTime = 0L;
    private final ArrayList<IsoZombie> saveRealZombieHack = new ArrayList();
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
    private final TIntHashSet newChunks = new TIntHashSet();
    private final ArrayList<ChooseGameInfo.SpawnOrigin> spawnOrigins = new ArrayList();
    public float[] radarXY;
    public int radarCount;
    public boolean radarRenderFlag;
    public boolean radarRequestFlag;
    private final ArrayList<IsoDirections> m_sittingDirections = new ArrayList();

    ZombiePopulationManager() {
        this.newChunks.setAutoCompactionFactor(0.0f);
    }

    private static native void n_init(boolean var0, boolean var1, int var2, int var3, int var4, int var5);

    private static native void n_config(float var0, float var1, float var2, int var3, float var4, float var5, float var6, float var7, int var8);

    private static native void n_setSpawnOrigins(int[] var0);

    private static native void n_setOutfitNames(String[] var0);

    private static native void n_updateMain(float var0, double var1);

    private static native boolean n_hasDataForThread();

    private static native void n_updateThread();

    private static native boolean n_shouldWait();

    private static native void n_beginSaveRealZombies(int var0);

    private static native void n_saveRealZombies(int var0, ByteBuffer var1);

    private static native void n_save();

    private static native void n_stop();

    private static native void n_addZombie(float var0, float var1, float var2, byte var3, int var4, int var5, int var6, int var7);

    private static native void n_aggroTarget(int var0, int var1, int var2);

    private static native void n_loadChunk(int var0, int var1, boolean var2);

    private static native void n_loadedAreas(int var0, int[] var1, boolean var2);

    protected static native void n_realZombieCount(short var0, short[] var1);

    protected static native void n_spawnHorde(int var0, int var1, int var2, int var3, float var4, float var5, int var6);

    private static native void n_worldSound(int var0, int var1, int var2, int var3);

    private static native int n_getAddZombieCount();

    private static native int n_getAddZombieData(int var0, ByteBuffer var1);

    private static native boolean n_hasRadarData();

    private static native void n_requestRadarData();

    private static native int n_getRadarZombieData(float[] var0);

    private static void noise(String string) {
        if (bDebugLoggingEnabled && (Core.bDebug || GameServer.bServer && GameServer.bDebug)) {
            DebugLog.log("ZPOP: " + string);
        }
    }

    public static void init() {
        String string = "";
        if ("1".equals(System.getProperty("zomboid.debuglibs.popman"))) {
            DebugLog.log("***** Loading debug version of PZPopMan");
            string = "d";
        }
        if (System.getProperty("os.name").contains("OS X")) {
            System.loadLibrary("PZPopMan");
        } else if (System.getProperty("sun.arch.data.model").equals("64")) {
            System.loadLibrary("PZPopMan64" + string);
        } else {
            System.loadLibrary("PZPopMan32" + string);
        }
        DebugFileWatcher.instance.add(new PredicatedFileWatcher(ZomboidFileSystem.instance.getMessagingDirSub("Trigger_Zombie.xml"), ZombiePopulationManager::onTriggeredZombieFile));
    }

    private static void onTriggeredZombieFile(String string) {
        ZombieTriggerXmlFile zombieTriggerXmlFile;
        DebugLog.General.println("ZombiePopulationManager.onTriggeredZombieFile(" + string + ">");
        try {
            zombieTriggerXmlFile = PZXmlUtil.parse(ZombieTriggerXmlFile.class, string);
        }
        catch (PZXmlParserException pZXmlParserException) {
            System.err.println("ZombiePopulationManager.onTriggeredZombieFile> Exception thrown. " + pZXmlParserException);
            pZXmlParserException.printStackTrace();
            return;
        }
        if (zombieTriggerXmlFile.spawnHorde > 0) {
            ZombiePopulationManager.processTriggerSpawnHorde(zombieTriggerXmlFile);
        }
        if (zombieTriggerXmlFile.setDebugLoggingEnabled && bDebugLoggingEnabled != zombieTriggerXmlFile.bDebugLoggingEnabled) {
            bDebugLoggingEnabled = zombieTriggerXmlFile.bDebugLoggingEnabled;
            DebugLog.General.println("  bDebugLoggingEnabled: " + bDebugLoggingEnabled);
        }
    }

    private static void processTriggerSpawnHorde(ZombieTriggerXmlFile zombieTriggerXmlFile) {
        DebugLog.General.println("  spawnHorde: " + zombieTriggerXmlFile.spawnHorde);
        if (IsoPlayer.getInstance() == null) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        instance.createHordeFromTo((int)isoPlayer.x, (int)isoPlayer.y, (int)isoPlayer.x, (int)isoPlayer.y, zombieTriggerXmlFile.spawnHorde);
    }

    public void init(IsoMetaGrid isoMetaGrid) {
        this.bClient = GameClient.bClient;
        if (this.bClient) {
            return;
        }
        this.minX = isoMetaGrid.getMinX();
        this.minY = isoMetaGrid.getMinY();
        this.width = isoMetaGrid.getWidth();
        this.height = isoMetaGrid.getHeight();
        this.bStopped = false;
        ZombiePopulationManager.n_init(this.bClient, GameServer.bServer, this.minX, this.minY, this.width, this.height);
        this.onConfigReloaded();
        String[] stringArray = PersistentOutfits.instance.getOutfitNames().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].toLowerCase();
        }
        ZombiePopulationManager.n_setOutfitNames(stringArray);
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (ChooseGameInfo.SpawnOrigin spawnOrigin : this.spawnOrigins) {
            tIntArrayList.add(spawnOrigin.x);
            tIntArrayList.add(spawnOrigin.y);
            tIntArrayList.add(spawnOrigin.w);
            tIntArrayList.add(spawnOrigin.h);
        }
        ZombiePopulationManager.n_setSpawnOrigins(tIntArrayList.toArray());
    }

    public void onConfigReloaded() {
        SandboxOptions.ZombieConfig zombieConfig = SandboxOptions.instance.zombieConfig;
        ZombiePopulationManager.n_config((float)zombieConfig.PopulationMultiplier.getValue(), (float)zombieConfig.PopulationStartMultiplier.getValue(), (float)zombieConfig.PopulationPeakMultiplier.getValue(), zombieConfig.PopulationPeakDay.getValue(), (float)zombieConfig.RespawnHours.getValue(), (float)zombieConfig.RespawnUnseenHours.getValue(), (float)zombieConfig.RespawnMultiplier.getValue() * 100.0f, (float)zombieConfig.RedistributeHours.getValue(), zombieConfig.FollowSoundDistance.getValue());
    }

    public void registerSpawnOrigin(int n, int n2, int n3, int n4, KahluaTable kahluaTable) {
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            return;
        }
        this.spawnOrigins.add(new ChooseGameInfo.SpawnOrigin(n, n2, n3, n4));
    }

    public void playerSpawnedAt(int n, int n2, int n3) {
        this.playerSpawns.addSpawn(n, n2, n3);
    }

    public void addChunkToWorld(IsoChunk isoChunk) {
        if (this.bClient) {
            return;
        }
        if (isoChunk.isNewChunk()) {
            int n = isoChunk.wy << 16 | isoChunk.wx;
            this.newChunks.add(n);
        }
        ZombiePopulationManager.n_loadChunk(isoChunk.wx, isoChunk.wy, true);
    }

    public void removeChunkFromWorld(IsoChunk isoChunk) {
        int n;
        if (this.bClient) {
            return;
        }
        if (this.bStopped) {
            return;
        }
        ZombiePopulationManager.n_loadChunk(isoChunk.wx, isoChunk.wy, false);
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    IsoGridSquare isoGridSquare = isoChunk.getGridSquare(j, i, n);
                    if (isoGridSquare == null || isoGridSquare.getMovingObjects().isEmpty()) continue;
                    for (int k = 0; k < isoGridSquare.getMovingObjects().size(); ++k) {
                        IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(k);
                        if (!(isoMovingObject instanceof IsoZombie)) continue;
                        IsoZombie isoZombie = (IsoZombie)isoMovingObject;
                        if (GameServer.bServer && isoZombie.bIndoorZombie || isoZombie.isReanimatedPlayer()) continue;
                        int n2 = this.getZombieState(isoZombie);
                        if (n == 0 && isoGridSquare.getRoom() == null && (isoZombie.getCurrentState() == WalkTowardState.instance() || isoZombie.getCurrentState() == PathFindState.instance())) {
                            ZombiePopulationManager.n_addZombie(isoZombie.x, isoZombie.y, isoZombie.z, (byte)isoZombie.dir.index(), isoZombie.getPersistentOutfitID(), n2, isoZombie.getPathTargetX(), isoZombie.getPathTargetY());
                            continue;
                        }
                        ZombiePopulationManager.n_addZombie(isoZombie.x, isoZombie.y, isoZombie.z, (byte)isoZombie.dir.index(), isoZombie.getPersistentOutfitID(), n2, -1, -1);
                    }
                }
            }
        }
        n = isoChunk.wy << 16 | isoChunk.wx;
        this.newChunks.remove(n);
        if (GameServer.bServer) {
            MapCollisionData.instance.notifyThread();
        }
    }

    public void virtualizeZombie(IsoZombie isoZombie) {
        int n = this.getZombieState(isoZombie);
        ZombiePopulationManager.n_addZombie(isoZombie.x, isoZombie.y, isoZombie.z, (byte)isoZombie.dir.index(), isoZombie.getPersistentOutfitID(), n, isoZombie.getPathTargetX(), isoZombie.getPathTargetY());
        isoZombie.removeFromWorld();
        isoZombie.removeFromSquare();
    }

    private int getZombieState(IsoZombie isoZombie) {
        int n = 1;
        if (isoZombie.isCrawling()) {
            n |= 2;
        }
        if (isoZombie.isCanWalk()) {
            n |= 4;
        }
        if (isoZombie.isFakeDead()) {
            n |= 8;
        }
        if (isoZombie.isCanCrawlUnderVehicle()) {
            n |= 0x10;
        }
        return n;
    }

    public void setAggroTarget(int n, int n2, int n3) {
        ZombiePopulationManager.n_aggroTarget(n, n2, n3);
    }

    public void createHordeFromTo(int n, int n2, int n3, int n4, int n5) {
        ZombiePopulationManager.n_spawnHorde(n, n2, 0, 0, n3, n4, n5);
    }

    public void createHordeInAreaTo(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ZombiePopulationManager.n_spawnHorde(n, n2, n3, n4, n5, n6, n7);
    }

    public void addWorldSound(WorldSoundManager.WorldSound worldSound, boolean bl) {
        if (this.bClient) {
            return;
        }
        if (worldSound.radius < 50) {
            return;
        }
        if (worldSound.sourceIsZombie) {
            return;
        }
        int n = SandboxOptions.instance.Lore.Hearing.getValue();
        if (n == 4) {
            n = 2;
        }
        float f = WorldSoundManager.instance.getHearingMultiplier(n);
        ZombiePopulationManager.n_worldSound(worldSound.x, worldSound.y, (int)PZMath.ceil((float)worldSound.radius * f), worldSound.volume);
    }

    private void updateRealZombieCount() {
        int n;
        if (this.realZombieCount == null || this.realZombieCount.length != this.width * this.height) {
            this.realZombieCount = new short[this.width * this.height];
            this.realZombieCount2 = new short[this.width * this.height * 2];
        }
        Arrays.fill(this.realZombieCount, (short)0);
        ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
        for (n = 0; n < arrayList.size(); ++n) {
            IsoZombie isoZombie = arrayList.get(n);
            int n2 = (int)(isoZombie.x / 300.0f) - this.minX;
            int n3 = (int)(isoZombie.y / 300.0f) - this.minY;
            int n4 = n2 + n3 * this.width;
            this.realZombieCount[n4] = (short)(this.realZombieCount[n4] + 1);
        }
        n = 0;
        for (int i = 0; i < this.width * this.height; ++i) {
            if (this.realZombieCount[i] <= 0) continue;
            this.realZombieCount2[n * 2 + 0] = (short)i;
            this.realZombieCount2[n * 2 + 1] = this.realZombieCount[i];
            n = (short)(n + 1);
        }
        ZombiePopulationManager.n_realZombieCount((short)n, this.realZombieCount2);
    }

    public void updateMain() {
        int n;
        if (this.bClient) {
            return;
        }
        long l = System.currentTimeMillis();
        ZombiePopulationManager.n_updateMain(GameTime.getInstance().getMultiplier(), GameTime.getInstance().getWorldAgeHours());
        int n2 = 0;
        int n3 = 0;
        int n4 = ZombiePopulationManager.n_getAddZombieCount();
        int n5 = 0;
        while (n5 < n4) {
            this.byteBuffer.clear();
            n = ZombiePopulationManager.n_getAddZombieData(n5, this.byteBuffer);
            n5 += n;
            for (int i = 0; i < n; ++i) {
                IsoGridSquare isoGridSquare;
                float f = this.byteBuffer.getFloat();
                float f2 = this.byteBuffer.getFloat();
                float f3 = this.byteBuffer.getFloat();
                IsoDirections isoDirections = IsoDirections.fromIndex(this.byteBuffer.get());
                int n6 = this.byteBuffer.getInt();
                int n7 = this.byteBuffer.getInt();
                int n8 = this.byteBuffer.getInt();
                int n9 = this.byteBuffer.getInt();
                int n10 = (int)f2 / 10;
                int n11 = (int)f / 10;
                int n12 = n10 << 16 | n11;
                if (this.newChunks.contains(n12) && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f, (int)f2, (int)f3)) != null && isoGridSquare.roomID != -1) continue;
                if (n8 != -1 && this.loadedAreas.isOnEdge((int)f, (int)f2)) {
                    n8 = -1;
                    n9 = -1;
                }
                if (n8 == -1) {
                    this.addZombieStanding(f, f2, f3, isoDirections, n6, n7);
                    ++n2;
                    continue;
                }
                this.addZombieMoving(f, f2, f3, isoDirections, n6, n7, n8, n9);
                ++n3;
            }
        }
        if (n2 > 0) {
            ZombiePopulationManager.noise("unloaded -> real " + n4);
        }
        if (n3 > 0) {
            ZombiePopulationManager.noise("virtual -> real " + n4);
        }
        if (this.radarRenderFlag && this.radarXY != null) {
            if (this.radarRequestFlag) {
                if (ZombiePopulationManager.n_hasRadarData()) {
                    this.radarCount = ZombiePopulationManager.n_getRadarZombieData(this.radarXY);
                    this.radarRenderFlag = false;
                    this.radarRequestFlag = false;
                }
            } else {
                ZombiePopulationManager.n_requestRadarData();
                this.radarRequestFlag = true;
            }
        }
        this.updateLoadedAreas();
        if (this.realZombieUpdateTime + 5000L < l) {
            this.realZombieUpdateTime = l;
            this.updateRealZombieCount();
        }
        if (GameServer.bServer) {
            MPDebugInfo.instance.serverUpdate();
        }
        n5 = ZombiePopulationManager.n_hasDataForThread() ? 1 : 0;
        n = MapCollisionData.instance.hasDataForThread() ? 1 : 0;
        if (n5 != 0 || n != 0) {
            MapCollisionData.instance.notifyThread();
        }
        this.playerSpawns.update();
    }

    private void addZombieStanding(float f, float f2, float f3, IsoDirections isoDirections, int n, int n2) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f, (int)f2, (int)f3);
        if (isoGridSquare != null && (isoGridSquare.SolidFloorCached ? isoGridSquare.SolidFloor : isoGridSquare.TreatAsSolidFloor())) {
            if (!Core.bLastStand && !this.playerSpawns.allowZombie(isoGridSquare)) {
                ZombiePopulationManager.noise("removed zombie near player spawn " + (int)f + "," + (int)f2 + "," + (int)f3);
                return;
            }
            VirtualZombieManager.instance.choices.clear();
            IsoGridSquare isoGridSquare2 = null;
            if (!this.isCrawling(n2) && !this.isFakeDead(n2) && Rand.Next(3) == 0) {
                isoGridSquare2 = this.getSquareForSittingZombie(f, f2, (int)f3);
            }
            if (isoGridSquare2 != null) {
                VirtualZombieManager.instance.choices.add(isoGridSquare2);
            } else {
                VirtualZombieManager.instance.choices.add(isoGridSquare);
            }
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(n, isoDirections.index(), false);
            if (isoZombie != null) {
                if (isoGridSquare2 != null) {
                    this.sitAgainstWall(isoZombie, isoGridSquare2);
                } else {
                    isoZombie.setX(f);
                    isoZombie.setY(f2);
                }
                if (this.isFakeDead(n2)) {
                    isoZombie.setHealth(0.5f + Rand.Next(0.0f, 0.3f));
                    isoZombie.sprite = isoZombie.legsSprite;
                    isoZombie.setFakeDead(true);
                } else if (this.isCrawling(n2)) {
                    isoZombie.setCrawler(true);
                    isoZombie.setCanWalk(this.isCanWalk(n2));
                    isoZombie.setOnFloor(true);
                    isoZombie.setFallOnFront(true);
                    isoZombie.walkVariant = "ZombieWalk";
                    isoZombie.DoZombieStats();
                }
                if (this.isInitialized(n2)) {
                    isoZombie.setCanCrawlUnderVehicle(this.isCanCrawlUnderVehicle(n2));
                } else {
                    this.firstTimeLoaded(isoZombie, n2);
                }
            }
        } else {
            ZombiePopulationManager.noise("real -> unloaded");
            ZombiePopulationManager.n_addZombie(f, f2, f3, (byte)isoDirections.index(), n, n2, -1, -1);
        }
    }

    private IsoGridSquare getSquareForSittingZombie(float f, float f2, int n) {
        int n2 = 3;
        for (int i = -n2; i < n2; ++i) {
            for (int j = -n2; j < n2; ++j) {
                int n3;
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f + i, (int)f2 + j, n);
                if (isoGridSquare == null || !isoGridSquare.isFree(true) || isoGridSquare.getBuilding() != null || (n3 = isoGridSquare.getWallType()) == 0 || PolygonalMap2.instance.lineClearCollide(f, f2, (float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z, null, false, true)) continue;
                return isoGridSquare;
            }
        }
        return null;
    }

    public void sitAgainstWall(IsoZombie isoZombie, IsoGridSquare isoGridSquare) {
        float f = (float)isoGridSquare.x + 0.5f;
        float f2 = (float)isoGridSquare.y + 0.5f;
        isoZombie.setX(f);
        isoZombie.setY(f2);
        isoZombie.setSitAgainstWall(true);
        int n = isoGridSquare.getWallType();
        if (n == 0) {
            return;
        }
        this.m_sittingDirections.clear();
        if ((n & 1) != 0 && (n & 4) != 0) {
            this.m_sittingDirections.add(IsoDirections.SE);
        }
        if ((n & 1) != 0 && (n & 8) != 0) {
            this.m_sittingDirections.add(IsoDirections.SW);
        }
        if ((n & 2) != 0 && (n & 4) != 0) {
            this.m_sittingDirections.add(IsoDirections.NE);
        }
        if ((n & 2) != 0 && (n & 8) != 0) {
            this.m_sittingDirections.add(IsoDirections.NW);
        }
        if ((n & 1) != 0) {
            this.m_sittingDirections.add(IsoDirections.S);
        }
        if ((n & 2) != 0) {
            this.m_sittingDirections.add(IsoDirections.N);
        }
        if ((n & 4) != 0) {
            this.m_sittingDirections.add(IsoDirections.E);
        }
        if ((n & 8) != 0) {
            this.m_sittingDirections.add(IsoDirections.W);
        }
        IsoDirections isoDirections = PZArrayUtil.pickRandom(this.m_sittingDirections);
        if (GameClient.bClient) {
            int n2 = (isoGridSquare.x & 1) + (isoGridSquare.y & 1);
            isoDirections = this.m_sittingDirections.get(n2 % this.m_sittingDirections.size());
        }
        isoZombie.setDir(isoDirections);
        isoZombie.setForwardDirection(isoDirections.ToVector());
        if (isoZombie.getAnimationPlayer() != null) {
            isoZombie.getAnimationPlayer().SetForceDir(isoZombie.getForwardDirection());
        }
    }

    private void addZombieMoving(float f, float f2, float f3, IsoDirections isoDirections, int n, int n2, int n3, int n4) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)f, (int)f2, (int)f3);
        if (isoGridSquare != null && (isoGridSquare.SolidFloorCached ? isoGridSquare.SolidFloor : isoGridSquare.TreatAsSolidFloor())) {
            if (!Core.bLastStand && !this.playerSpawns.allowZombie(isoGridSquare)) {
                ZombiePopulationManager.noise("removed zombie near player spawn " + (int)f + "," + (int)f2 + "," + (int)f3);
                return;
            }
            VirtualZombieManager.instance.choices.clear();
            VirtualZombieManager.instance.choices.add(isoGridSquare);
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(n, isoDirections.index(), false);
            if (isoZombie != null) {
                isoZombie.setX(f);
                isoZombie.setY(f2);
                if (this.isCrawling(n2)) {
                    isoZombie.setCrawler(true);
                    isoZombie.setCanWalk(this.isCanWalk(n2));
                    isoZombie.setOnFloor(true);
                    isoZombie.setFallOnFront(true);
                    isoZombie.walkVariant = "ZombieWalk";
                    isoZombie.DoZombieStats();
                }
                if (this.isInitialized(n2)) {
                    isoZombie.setCanCrawlUnderVehicle(this.isCanCrawlUnderVehicle(n2));
                } else {
                    this.firstTimeLoaded(isoZombie, n2);
                }
                if (Math.abs((float)n3 - f) > 1.0f || Math.abs((float)n4 - f2) > 1.0f) {
                    isoZombie.AllowRepathDelay = -1.0f;
                    isoZombie.pathToLocation(n3, n4, 0);
                }
            }
        } else {
            ZombiePopulationManager.noise("real -> virtual " + f + "," + f2);
            ZombiePopulationManager.n_addZombie(f, f2, f3, (byte)isoDirections.index(), n, n2, n3, n4);
        }
    }

    private boolean isInitialized(int n) {
        return (n & 1) != 0;
    }

    private boolean isCrawling(int n) {
        return (n & 2) != 0;
    }

    private boolean isCanWalk(int n) {
        return (n & 4) != 0;
    }

    private boolean isFakeDead(int n) {
        return (n & 8) != 0;
    }

    private boolean isCanCrawlUnderVehicle(int n) {
        return (n & 0x10) != 0;
    }

    private void firstTimeLoaded(IsoZombie isoZombie, int n) {
    }

    public void updateThread() {
        ZombiePopulationManager.n_updateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldWait() {
        Object object = MapCollisionData.instance.renderLock;
        synchronized (object) {
            return ZombiePopulationManager.n_shouldWait();
        }
    }

    public void updateLoadedAreas() {
        if (this.loadedAreas.set()) {
            ZombiePopulationManager.n_loadedAreas(this.loadedAreas.count, this.loadedAreas.areas, false);
        }
        if (GameServer.bServer && this.loadedServerCells.set()) {
            ZombiePopulationManager.n_loadedAreas(this.loadedServerCells.count, this.loadedServerCells.areas, true);
        }
    }

    public void dbgSpawnTimeToZero(int n, int n2) {
        if (this.bClient && GameClient.connection.accessLevel != 32) {
            return;
        }
        this.dbgCommands.SpawnTimeToZero(n, n2);
    }

    public void dbgClearZombies(int n, int n2) {
        if (this.bClient && GameClient.connection.accessLevel != 32) {
            return;
        }
        this.dbgCommands.ClearZombies(n, n2);
    }

    public void dbgSpawnNow(int n, int n2) {
        if (this.bClient && GameClient.connection.accessLevel != 32) {
            return;
        }
        this.dbgCommands.SpawnNow(n, n2);
    }

    public void beginSaveRealZombies() {
        if (this.bClient) {
            return;
        }
        this.saveRealZombieHack.clear();
        ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
        for (IsoZombie isoZombie : arrayList) {
            if (isoZombie.isReanimatedPlayer() || GameServer.bServer && isoZombie.bIndoorZombie) continue;
            this.saveRealZombieHack.add(isoZombie);
        }
        int n = this.saveRealZombieHack.size();
        ZombiePopulationManager.n_beginSaveRealZombies(n);
        int n2 = 0;
        while (n2 < n) {
            this.byteBuffer.clear();
            int n3 = 0;
            while (n2 < n) {
                int n4 = this.byteBuffer.position();
                IsoZombie isoZombie = this.saveRealZombieHack.get(n2++);
                this.byteBuffer.putFloat(isoZombie.x);
                this.byteBuffer.putFloat(isoZombie.y);
                this.byteBuffer.putFloat(isoZombie.z);
                this.byteBuffer.put((byte)isoZombie.dir.index());
                this.byteBuffer.putInt(isoZombie.getPersistentOutfitID());
                int n5 = this.getZombieState(isoZombie);
                this.byteBuffer.putInt(n5);
                ++n3;
                int n6 = this.byteBuffer.position() - n4;
                if (this.byteBuffer.position() + n6 <= this.byteBuffer.capacity()) continue;
                break;
            }
            ZombiePopulationManager.n_saveRealZombies(n3, this.byteBuffer);
        }
        this.saveRealZombieHack.clear();
    }

    public void endSaveRealZombies() {
        if (this.bClient) {
            return;
        }
    }

    public void save() {
        if (this.bClient) {
            return;
        }
        ZombiePopulationManager.n_save();
    }

    public void stop() {
        if (this.bClient) {
            return;
        }
        this.bStopped = true;
        ZombiePopulationManager.n_stop();
        this.loadedAreas.clear();
        this.newChunks.clear();
        this.spawnOrigins.clear();
        this.radarXY = null;
        this.radarCount = 0;
        this.radarRenderFlag = false;
        this.radarRequestFlag = false;
    }
}

