/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ObjectPool<T> {
    private final Allocator<T> allocator;
    private final ArrayList<T> pool = new ArrayList<T>(){

        @Override
        public boolean contains(Object object) {
            for (int i = 0; i < ObjectPool.this.pool.size(); ++i) {
                if (ObjectPool.this.pool.get(i) != object) continue;
                return true;
            }
            return false;
        }
    };

    public ObjectPool() {
        this(null);
    }

    public ObjectPool(Allocator<T> allocator) {
        this.allocator = allocator;
    }

    public T alloc() {
        return this.pool.isEmpty() ? this.makeObject() : this.pool.remove(this.pool.size() - 1);
    }

    public void release(T t) {
        assert (t != null);
        assert (!this.pool.contains(t));
        this.pool.add(t);
    }

    public void release(List<T> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            this.release(list.get(i));
        }
    }

    public void release(Iterable<T> iterable) {
        for (T t : iterable) {
            if (t == null) continue;
            this.release(t);
        }
    }

    public void release(T[] TArray) {
        if (TArray == null) {
            return;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            this.release(TArray[i]);
        }
    }

    public void releaseAll(List<T> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            this.release(list.get(i));
        }
    }

    public void clear() {
        this.pool.clear();
    }

    protected T makeObject() {
        if (this.allocator != null) {
            return this.allocator.allocate();
        }
        throw new UnsupportedOperationException("Allocator is null. The ObjectPool is intended to be used with an allocator, or with the function makeObject overridden in a subclass.");
    }

    public void forEach(Consumer<T> consumer) {
        for (int i = 0; i < this.pool.size(); ++i) {
            consumer.accept(this.pool.get(i));
        }
    }

    public static interface Allocator<T> {
        public T allocate();
    }
}

