/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import zombie.VirtualZombieManager;
import zombie.ai.states.ZombieHitReactionState;
import zombie.ai.states.ZombieOnGroundState;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.NetworkZombieVariables;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.packets.ZombiePacket;
import zombie.popman.ZombieCountOptimiser;

public class NetworkZombieSimulator {
    public static final int MAX_ZOMBIES_PER_UPDATE = 300;
    private static final NetworkZombieSimulator instance = new NetworkZombieSimulator();
    private static final ZombiePacket zombiePacket = new ZombiePacket();
    private final ByteBuffer bb = ByteBuffer.allocate(1000000);
    private final ArrayList<Short> unknownZombies = new ArrayList();
    private final HashSet<Short> authoriseZombies = new HashSet();
    private final ArrayDeque<IsoZombie> SendQueue = new ArrayDeque();
    private final ArrayDeque<IsoZombie> ExtraSendQueue = new ArrayDeque();
    private HashSet<Short> authoriseZombiesCurrent = new HashSet();
    private HashSet<Short> authoriseZombiesLast = new HashSet();
    UpdateLimit ZombieSimulationReliableLimit = new UpdateLimit(1000L);

    public static NetworkZombieSimulator getInstance() {
        return instance;
    }

    public int getAuthorizedZombieCount() {
        return (int)IsoWorld.instance.CurrentCell.getZombieList().stream().filter(isoZombie -> isoZombie.authOwner == GameClient.connection).count();
    }

    public int getUnauthorizedZombieCount() {
        return (int)IsoWorld.instance.CurrentCell.getZombieList().stream().filter(isoZombie -> isoZombie.authOwner == null).count();
    }

    public void clear() {
        HashSet<Short> hashSet = this.authoriseZombiesCurrent;
        this.authoriseZombiesCurrent = this.authoriseZombiesLast;
        this.authoriseZombiesLast = hashSet;
        this.authoriseZombiesLast.removeIf(s -> GameClient.getZombie(s) == null);
        this.authoriseZombiesCurrent.clear();
    }

    public void addExtraUpdate(IsoZombie isoZombie) {
        if (isoZombie.authOwner == GameClient.connection && !this.ExtraSendQueue.contains(isoZombie)) {
            this.ExtraSendQueue.add(isoZombie);
        }
    }

    public void add(short s) {
        this.authoriseZombiesCurrent.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added() {
        Serializable serializable2;
        Sets.SetView setView = Sets.difference(this.authoriseZombiesCurrent, this.authoriseZombiesLast);
        for (Serializable serializable2 : setView) {
            Serializable serializable3 = GameClient.getZombie(serializable2);
            if (serializable3 != null && ((IsoZombie)serializable3).OnlineID == serializable2) {
                this.becomeLocal((IsoZombie)serializable3);
                continue;
            }
            if (this.unknownZombies.contains(serializable2)) continue;
            this.unknownZombies.add((Short)serializable2);
        }
        UnmodifiableIterator unmodifiableIterator = Sets.difference(this.authoriseZombiesLast, this.authoriseZombiesCurrent);
        for (Serializable serializable3 : unmodifiableIterator) {
            IsoZombie isoZombie = GameClient.getZombie((Short)serializable3);
            if (isoZombie == null) continue;
            this.becomeRemote(isoZombie);
        }
        serializable2 = this.authoriseZombies;
        synchronized (serializable2) {
            this.authoriseZombies.clear();
            this.authoriseZombies.addAll(this.authoriseZombiesCurrent);
        }
    }

    public void becomeLocal(IsoZombie isoZombie) {
        isoZombie.lastRemoteUpdate = 0;
        isoZombie.authOwner = GameClient.connection;
        isoZombie.authOwnerPlayer = IsoPlayer.getInstance();
        isoZombie.networkAI.setUpdateTimer(0.0f);
        isoZombie.AllowRepathDelay = 0.0f;
        isoZombie.networkAI.mindSync.restorePFBTarget();
    }

    public void becomeRemote(IsoZombie isoZombie) {
        if (isoZombie.isDead() && isoZombie.authOwner == GameClient.connection) {
            isoZombie.getNetworkCharacterAI().setLocal(true);
        }
        isoZombie.lastRemoteUpdate = 0;
        isoZombie.authOwner = null;
        isoZombie.authOwnerPlayer = null;
        if (isoZombie.group != null) {
            isoZombie.group.remove(isoZombie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZombieSimulated(Short s) {
        HashSet<Short> hashSet = this.authoriseZombies;
        synchronized (hashSet) {
            return this.authoriseZombies.contains(s);
        }
    }

    public void receivePacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        if (!DebugOptions.instance.Network.Client.UpdateZombiesFromPacket.getValue()) {
            return;
        }
        short s = byteBuffer.getShort();
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            this.parseZombie(byteBuffer, udpConnection);
        }
    }

    private void parseZombie(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        ZombiePacket zombiePacket = NetworkZombieSimulator.zombiePacket;
        zombiePacket.parse(byteBuffer, udpConnection);
        if (zombiePacket.id == -1) {
            DebugLog.General.error("NetworkZombieSimulator.parseZombie id=" + zombiePacket.id);
            return;
        }
        try {
            IsoZombie isoZombie = (IsoZombie)GameClient.IDToZombieMap.get(zombiePacket.id);
            if (isoZombie == null) {
                if (IsoDeadBody.isDead(zombiePacket.id)) {
                    DebugLog.Death.debugln("Skip dead zombie creation id=%d", zombiePacket.id);
                    return;
                }
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(zombiePacket.realX, zombiePacket.realY, (double)zombiePacket.realZ);
                if (isoGridSquare != null) {
                    VirtualZombieManager.instance.choices.clear();
                    VirtualZombieManager.instance.choices.add(isoGridSquare);
                    isoZombie = VirtualZombieManager.instance.createRealZombieAlways(zombiePacket.descriptorID, IsoDirections.getRandom().index(), false);
                    DebugLog.log(DebugType.ActionSystem, "ParseZombie: CreateRealZombieAlways id=" + zombiePacket.id);
                    if (isoZombie != null) {
                        isoZombie.setFakeDead(false);
                        isoZombie.OnlineID = zombiePacket.id;
                        GameClient.IDToZombieMap.put(zombiePacket.id, (Object)isoZombie);
                        isoZombie.nx = isoZombie.x = zombiePacket.realX;
                        isoZombie.lx = isoZombie.x;
                        isoZombie.ny = isoZombie.y = zombiePacket.realY;
                        isoZombie.ly = isoZombie.y;
                        isoZombie.lz = isoZombie.z = (float)zombiePacket.realZ;
                        isoZombie.setForwardDirection(isoZombie.dir.ToVector());
                        isoZombie.setCurrent(isoGridSquare);
                        isoZombie.networkAI.targetX = zombiePacket.x;
                        isoZombie.networkAI.targetY = zombiePacket.y;
                        isoZombie.networkAI.targetZ = zombiePacket.z;
                        isoZombie.networkAI.predictionType = zombiePacket.moveType;
                        isoZombie.networkAI.reanimatedBodyID = zombiePacket.reanimatedBodyID;
                        NetworkZombieVariables.setInt(isoZombie, (short)0, zombiePacket.realHealth);
                        NetworkZombieVariables.setInt(isoZombie, (short)2, zombiePacket.speedMod);
                        NetworkZombieVariables.setInt(isoZombie, (short)1, zombiePacket.target);
                        NetworkZombieVariables.setInt(isoZombie, (short)3, zombiePacket.timeSinceSeenFlesh);
                        NetworkZombieVariables.setInt(isoZombie, (short)4, zombiePacket.smParamTargetAngle);
                        NetworkZombieVariables.setBooleanVariables(isoZombie, zombiePacket.booleanVariables);
                        if (isoZombie.isKnockedDown()) {
                            isoZombie.setOnFloor(true);
                            isoZombie.changeState(ZombieOnGroundState.instance());
                        }
                        isoZombie.setWalkType(zombiePacket.walkType.toString());
                        isoZombie.realState = zombiePacket.realState;
                        if (isoZombie.isReanimatedPlayer()) {
                            IsoDeadBody isoDeadBody = IsoDeadBody.getDeadBody(isoZombie.networkAI.reanimatedBodyID);
                            if (isoDeadBody != null) {
                                isoZombie.setDir(isoDeadBody.getDir());
                                isoZombie.setForwardDirection(isoDeadBody.getDir().ToVector());
                                isoZombie.setFallOnFront(isoDeadBody.isFallOnFront());
                            }
                            isoZombie.getStateMachine().changeState(ZombieOnGroundState.instance(), null);
                            isoZombie.bNeverDoneAlpha = false;
                        }
                        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                            IsoPlayer isoPlayer = IsoPlayer.players[i];
                            if (isoGridSquare.isCanSee(i)) {
                                isoZombie.setAlphaAndTarget(i, 1.0f);
                            }
                            if (isoPlayer == null || isoPlayer.ReanimatedCorpseID != zombiePacket.id || zombiePacket.id == -1) continue;
                            isoPlayer.ReanimatedCorpseID = -1;
                            isoPlayer.ReanimatedCorpse = isoZombie;
                        }
                        isoZombie.networkAI.mindSync.parse(zombiePacket);
                    } else {
                        DebugLog.log("Error: VirtualZombieManager can't create zombie");
                    }
                }
                if (isoZombie == null) {
                    return;
                }
            }
            if (NetworkZombieSimulator.getInstance().isZombieSimulated(isoZombie.OnlineID)) {
                isoZombie.authOwner = GameClient.connection;
                isoZombie.authOwnerPlayer = IsoPlayer.getInstance();
                return;
            }
            isoZombie.authOwner = null;
            isoZombie.authOwnerPlayer = null;
            if (!isoZombie.networkAI.isSetVehicleHit() || !isoZombie.isCurrentState(ZombieHitReactionState.instance())) {
                isoZombie.networkAI.parse(zombiePacket);
                isoZombie.networkAI.mindSync.parse(zombiePacket);
            }
            isoZombie.lastRemoteUpdate = 0;
            if (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie)) {
                IsoWorld.instance.CurrentCell.getZombieList().add(isoZombie);
            }
            if (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoZombie)) {
                IsoWorld.instance.CurrentCell.getObjectList().add(isoZombie);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean anyUnknownZombies() {
        return this.unknownZombies.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        Object object;
        int n;
        int n2;
        IsoZombie isoZombie;
        AbstractCollection abstractCollection;
        if (this.authoriseZombies.size() == 0 && this.unknownZombies.size() == 0) {
            return;
        }
        if (this.SendQueue.isEmpty()) {
            abstractCollection = this.authoriseZombies;
            synchronized (abstractCollection) {
                for (Short s : this.authoriseZombies) {
                    isoZombie = GameClient.getZombie(s);
                    if (isoZombie == null || isoZombie.OnlineID == -1) continue;
                    this.SendQueue.add(isoZombie);
                }
            }
        }
        this.bb.clear();
        abstractCollection = ZombieCountOptimiser.zombiesForDelete;
        synchronized (abstractCollection) {
            n2 = ZombieCountOptimiser.zombiesForDelete.size();
            this.bb.putShort((short)n2);
            for (n = 0; n < n2; ++n) {
                this.bb.putShort(ZombieCountOptimiser.zombiesForDelete.get((int)n).OnlineID);
            }
            ZombieCountOptimiser.zombiesForDelete.clear();
        }
        int n3 = this.unknownZombies.size();
        this.bb.putShort((short)n3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.bb.putShort(this.unknownZombies.get(n2));
        }
        this.unknownZombies.clear();
        n2 = this.bb.position();
        this.bb.putShort((short)300);
        n = 0;
        while (!this.SendQueue.isEmpty()) {
            isoZombie = this.SendQueue.poll();
            this.ExtraSendQueue.remove(isoZombie);
            isoZombie.zombiePacket.set(isoZombie);
            if (isoZombie.OnlineID == -1) continue;
            isoZombie.zombiePacket.write(this.bb);
            isoZombie.networkAI.targetX = isoZombie.realx = isoZombie.x;
            isoZombie.networkAI.targetY = isoZombie.realy = isoZombie.y;
            isoZombie.realz = (byte)isoZombie.z;
            isoZombie.networkAI.targetZ = isoZombie.realz;
            isoZombie.realdir = isoZombie.getDir();
            if (++n < 300) continue;
            break;
        }
        if (n < 300) {
            int n4 = this.bb.position();
            this.bb.position(n2);
            this.bb.putShort((short)n);
            this.bb.position(n4);
        }
        if (n > 0 || n3 > 0) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            object = n3 > 0 && this.ZombieSimulationReliableLimit.Check() ? PacketTypes.PacketType.ZombieSimulationReliable : PacketTypes.PacketType.ZombieSimulation;
            object.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put(this.bb.array(), 0, this.bb.position());
            object.send(GameClient.connection);
        }
        if (!this.ExtraSendQueue.isEmpty()) {
            this.bb.clear();
            this.bb.putShort((short)0);
            this.bb.putShort((short)0);
            n2 = this.bb.position();
            this.bb.putShort((short)0);
            int n5 = 0;
            while (!this.ExtraSendQueue.isEmpty()) {
                object = this.ExtraSendQueue.poll();
                ((IsoZombie)object).zombiePacket.set((IsoZombie)object);
                if (((IsoZombie)object).OnlineID == -1) continue;
                ((IsoZombie)object).zombiePacket.write(this.bb);
                ((IsoZombie)object).networkAI.targetX = ((IsoZombie)object).realx = ((IsoZombie)object).x;
                ((IsoZombie)object).networkAI.targetY = ((IsoZombie)object).realy = ((IsoZombie)object).y;
                ((IsoZombie)object).realz = (byte)((IsoZombie)object).z;
                ((IsoZombie)object).networkAI.targetZ = ((IsoZombie)object).realz;
                ((IsoZombie)object).realdir = ((IsoObject)object).getDir();
                ++n5;
            }
            int n6 = this.bb.position();
            this.bb.position(n2);
            this.bb.putShort((short)n5);
            this.bb.position(n6);
            if (n5 > 0) {
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.ZombieSimulation.doPacket(byteBufferWriter);
                byteBufferWriter.bb.put(this.bb.array(), 0, this.bb.position());
                PacketTypes.PacketType.ZombieSimulation.send(GameClient.connection);
            }
        }
    }

    public void remove(IsoZombie isoZombie) {
        if (isoZombie == null || isoZombie.OnlineID == -1) {
            return;
        }
        GameClient.IDToZombieMap.remove(isoZombie.OnlineID);
    }

    public void clearTargetAuth(IsoPlayer isoPlayer) {
        if (Core.bDebug) {
            DebugLog.log(DebugType.Multiplayer, "Clear zombies target and auth for player id=" + isoPlayer.getOnlineID());
        }
        if (GameClient.bClient) {
            for (IsoZombie isoZombie : GameClient.IDToZombieMap.valueCollection()) {
                if (isoZombie.target != isoPlayer) continue;
                isoZombie.setTarget(null);
            }
        }
    }
}

