/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import zombie.VirtualZombieManager;
import zombie.characters.IsoZombie;
import zombie.characters.NetworkZombieVariables;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.network.MPStatistics;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;
import zombie.network.packets.ZombiePacket;
import zombie.popman.NetworkZombieList;
import zombie.popman.NetworkZombieManager;

public class NetworkZombiePacker {
    private static final NetworkZombiePacker instance = new NetworkZombiePacker();
    private final ArrayList<DeletedZombie> zombiesDeleted = new ArrayList();
    private final ArrayList<DeletedZombie> zombiesDeletedForSending = new ArrayList();
    private final HashSet<IsoZombie> zombiesReceived = new HashSet();
    private final ArrayList<IsoZombie> zombiesProcessing = new ArrayList();
    private final NetworkZombieList zombiesRequest = new NetworkZombieList();
    private final ZombiePacket packet = new ZombiePacket();
    private HashSet<UdpConnection> extraUpdate = new HashSet();
    private final ByteBuffer bb = ByteBuffer.allocate(1000000);
    UpdateLimit ZombieSimulationReliableLimit = new UpdateLimit(5000L);

    public static NetworkZombiePacker getInstance() {
        return instance;
    }

    public void setExtraUpdate() {
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
            if (!udpConnection.isFullyConnected()) continue;
            this.extraUpdate.add(udpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteZombie(IsoZombie isoZombie) {
        ArrayList<DeletedZombie> arrayList = this.zombiesDeleted;
        synchronized (arrayList) {
            this.zombiesDeleted.add(new DeletedZombie(isoZombie.OnlineID, isoZombie.x, isoZombie.y));
        }
    }

    public void receivePacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        int n;
        int n2;
        int n3 = byteBuffer.getShort();
        for (n2 = 0; n2 < n3; ++n2) {
            n = byteBuffer.getShort();
            IsoZombie isoZombie = ServerMap.instance.ZombieMap.get((short)n);
            if (isoZombie == null || udpConnection.accessLevel != 32 && isoZombie.authOwner != udpConnection) continue;
            this.deleteZombie(isoZombie);
            DebugLog.Multiplayer.noise("Zombie was deleted id=%d (%f, %f)", isoZombie.OnlineID, Float.valueOf(isoZombie.x), Float.valueOf(isoZombie.y));
            VirtualZombieManager.instance.removeZombieFromWorld(isoZombie);
            MPStatistics.serverZombieCulled();
        }
        n2 = byteBuffer.getShort();
        for (n = 0; n < n2; ++n) {
            short s = byteBuffer.getShort();
            IsoZombie isoZombie = ServerMap.instance.ZombieMap.get(s);
            if (isoZombie == null) continue;
            this.zombiesRequest.getNetworkZombie((UdpConnection)udpConnection).zombies.add(isoZombie);
        }
        n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            this.parseZombie(byteBuffer, udpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseZombie(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.packet.parse(byteBuffer, udpConnection);
        if (this.packet.id == -1) {
            DebugLog.General.error("NetworkZombiePacker.parseZombie id=" + this.packet.id);
            return;
        }
        try {
            IsoZombie isoZombie = ServerMap.instance.ZombieMap.get(this.packet.id);
            if (isoZombie == null) {
                return;
            }
            if (isoZombie.authOwner != udpConnection) {
                NetworkZombieManager.getInstance().recheck(udpConnection);
                this.extraUpdate.add(udpConnection);
                return;
            }
            this.applyZombie(isoZombie);
            isoZombie.lastRemoteUpdate = 0;
            if (!IsoWorld.instance.CurrentCell.getZombieList().contains(isoZombie)) {
                IsoWorld.instance.CurrentCell.getZombieList().add(isoZombie);
            }
            if (!IsoWorld.instance.CurrentCell.getObjectList().contains(isoZombie)) {
                IsoWorld.instance.CurrentCell.getObjectList().add(isoZombie);
            }
            isoZombie.zombiePacket.copy(this.packet);
            isoZombie.zombiePacketUpdated = true;
            HashSet<IsoZombie> hashSet = this.zombiesReceived;
            synchronized (hashSet) {
                this.zombiesReceived.add(isoZombie);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postupdate() {
        this.updateAuth();
        Object object = this.zombiesReceived;
        synchronized (object) {
            this.zombiesProcessing.clear();
            this.zombiesProcessing.addAll(this.zombiesReceived);
            this.zombiesReceived.clear();
        }
        object = this.zombiesDeleted;
        synchronized (object) {
            this.zombiesDeletedForSending.clear();
            this.zombiesDeletedForSending.addAll(this.zombiesDeleted);
            this.zombiesDeleted.clear();
        }
        for (UdpConnection udpConnection : GameServer.udpEngine.connections) {
            if (udpConnection == null || !udpConnection.isFullyConnected()) continue;
            this.send(udpConnection);
        }
    }

    private void updateAuth() {
        ArrayList<IsoZombie> arrayList = IsoWorld.instance.CurrentCell.getZombieList();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoZombie isoZombie = arrayList.get(i);
            NetworkZombieManager.getInstance().updateAuth(isoZombie);
        }
    }

    public int getZombieData(UdpConnection udpConnection, ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.putShort((short)300);
        int n2 = 0;
        try {
            int n3;
            NetworkZombieList.NetworkZombie networkZombie = this.zombiesRequest.getNetworkZombie(udpConnection);
            while (!networkZombie.zombies.isEmpty()) {
                IsoZombie isoZombie = networkZombie.zombies.poll();
                isoZombie.zombiePacket.set(isoZombie);
                if (isoZombie.OnlineID == -1) continue;
                isoZombie.zombiePacket.write(byteBuffer);
                isoZombie.zombiePacketUpdated = false;
                if (++n2 < 300) continue;
                break;
            }
            for (n3 = 0; n3 < this.zombiesProcessing.size(); ++n3) {
                IsoZombie isoZombie = this.zombiesProcessing.get(n3);
                if (isoZombie.authOwner == null || isoZombie.authOwner == udpConnection || !udpConnection.RelevantTo(isoZombie.x, isoZombie.y, (udpConnection.ReleventRange - 2) * 10) || isoZombie.OnlineID == -1) continue;
                isoZombie.zombiePacket.write(byteBuffer);
                isoZombie.zombiePacketUpdated = false;
                ++n2;
            }
            n3 = byteBuffer.position();
            byteBuffer.position(n);
            byteBuffer.putShort((short)n2);
            byteBuffer.position(n3);
        }
        catch (BufferOverflowException bufferOverflowException) {
            bufferOverflowException.printStackTrace();
        }
        return n2;
    }

    public void send(UdpConnection udpConnection) {
        this.bb.clear();
        this.bb.put(udpConnection.isNeighborPlayer ? (byte)1 : 0);
        int n = this.bb.position();
        short s = 0;
        this.bb.putShort((short)0);
        for (DeletedZombie deletedZombie : this.zombiesDeletedForSending) {
            if (!udpConnection.RelevantTo(deletedZombie.x, deletedZombie.y)) continue;
            s = (short)(s + 1);
            this.bb.putShort(deletedZombie.OnlineID);
        }
        int n2 = this.bb.position();
        this.bb.position(n);
        this.bb.putShort(s);
        this.bb.position(n2);
        NetworkZombieManager.getInstance().getZombieAuth(udpConnection, this.bb);
        int n3 = this.getZombieData(udpConnection, this.bb);
        if (n3 <= 0 && !udpConnection.timerSendZombie.check() && !this.extraUpdate.contains(udpConnection)) {
            return;
        }
        this.extraUpdate.remove(udpConnection);
        udpConnection.timerSendZombie.reset(3800L);
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType packetType = this.ZombieSimulationReliableLimit.Check() ? PacketTypes.PacketType.ZombieSimulationReliable : PacketTypes.PacketType.ZombieSimulation;
        packetType.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put(this.bb.array(), 0, this.bb.position());
        packetType.send(udpConnection);
    }

    private void applyZombie(IsoZombie isoZombie) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)this.packet.x, (int)this.packet.y, this.packet.z);
        isoZombie.nx = isoZombie.x = this.packet.realX;
        isoZombie.lx = isoZombie.x;
        isoZombie.ny = isoZombie.y = this.packet.realY;
        isoZombie.ly = isoZombie.y;
        isoZombie.lz = isoZombie.z = (float)this.packet.realZ;
        isoZombie.setForwardDirection(isoZombie.dir.ToVector());
        isoZombie.setCurrent(isoGridSquare);
        isoZombie.networkAI.targetX = this.packet.x;
        isoZombie.networkAI.targetY = this.packet.y;
        isoZombie.networkAI.targetZ = this.packet.z;
        isoZombie.networkAI.predictionType = this.packet.moveType;
        NetworkZombieVariables.setInt(isoZombie, (short)0, this.packet.realHealth);
        NetworkZombieVariables.setInt(isoZombie, (short)2, this.packet.speedMod);
        NetworkZombieVariables.setInt(isoZombie, (short)1, this.packet.target);
        NetworkZombieVariables.setInt(isoZombie, (short)3, this.packet.timeSinceSeenFlesh);
        NetworkZombieVariables.setInt(isoZombie, (short)4, this.packet.smParamTargetAngle);
        NetworkZombieVariables.setBooleanVariables(isoZombie, this.packet.booleanVariables);
        isoZombie.setWalkType(this.packet.walkType.toString());
        isoZombie.realState = this.packet.realState;
    }

    class DeletedZombie {
        short OnlineID;
        float x;
        float y;

        public DeletedZombie(short s, float f, float f2) {
            this.OnlineID = s;
            this.x = f;
            this.y = f2;
        }
    }
}

