/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import zombie.GameTime;
import zombie.WorldSoundManager;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.RakVoice;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugOptions;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.popman.LoadedAreas;
import zombie.popman.ObjectPool;
import zombie.popman.ZombiePopulationManager;
import zombie.popman.ZombiePopulationRenderer;

public final class MPDebugInfo {
    public static final MPDebugInfo instance = new MPDebugInfo();
    private static final ConcurrentHashMap<Long, MPSoundDebugInfo> debugSounds = new ConcurrentHashMap();
    private final ArrayList<MPCell> loadedCells = new ArrayList();
    private final ObjectPool<MPCell> cellPool = new ObjectPool<MPCell>(MPCell::new);
    private final LoadedAreas loadedAreas = new LoadedAreas(false);
    private ArrayList<MPRepopEvent> repopEvents = new ArrayList();
    private final ObjectPool<MPRepopEvent> repopEventPool = new ObjectPool<MPRepopEvent>(MPRepopEvent::new);
    private short repopEpoch = 0;
    private long requestTime = 0L;
    private boolean requestFlag = false;
    private boolean requestPacketReceived = false;
    private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
    private float RESPAWN_EVERY_HOURS = 1.0f;
    private float REPOP_DISPLAY_HOURS = 0.5f;

    private static native boolean n_hasData(boolean var0);

    private static native void n_requestData();

    private static native int n_getLoadedCellsCount();

    private static native int n_getLoadedCellsData(int var0, ByteBuffer var1);

    private static native int n_getLoadedAreasCount();

    private static native int n_getLoadedAreasData(int var0, ByteBuffer var1);

    private static native int n_getRepopEventCount();

    private static native int n_getRepopEventData(int var0, ByteBuffer var1);

    private void requestServerInfo() {
        if (!GameClient.bClient) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.requestTime + 1000L > l) {
            return;
        }
        this.requestTime = l;
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.KeepAlive.doPacket(byteBufferWriter);
        byteBufferWriter.bb.put((byte)1);
        byteBufferWriter.bb.putShort(this.repopEpoch);
        PacketTypes.PacketType.KeepAlive.send(GameClient.connection);
    }

    public void clientPacket(ByteBuffer byteBuffer) {
        int n;
        int n2;
        if (!GameClient.bClient) {
            return;
        }
        byte by = byteBuffer.get();
        if (by == 1) {
            this.cellPool.release((List<MPCell>)this.loadedCells);
            this.loadedCells.clear();
            this.RESPAWN_EVERY_HOURS = byteBuffer.getFloat();
            n2 = byteBuffer.getShort();
            for (n = 0; n < n2; ++n) {
                MPCell mPCell = this.cellPool.alloc();
                mPCell.cx = byteBuffer.getShort();
                mPCell.cy = byteBuffer.getShort();
                mPCell.currentPopulation = byteBuffer.getShort();
                mPCell.desiredPopulation = byteBuffer.getShort();
                mPCell.lastRepopTime = byteBuffer.getFloat();
                this.loadedCells.add(mPCell);
            }
            this.loadedAreas.clear();
            n = byteBuffer.getShort();
            for (int i = 0; i < n; ++i) {
                short s = byteBuffer.getShort();
                short s2 = byteBuffer.getShort();
                short s3 = byteBuffer.getShort();
                short s4 = byteBuffer.getShort();
                this.loadedAreas.add(s, s2, s3, s4);
            }
        }
        if (by == 2) {
            this.repopEventPool.release((List<MPRepopEvent>)this.repopEvents);
            this.repopEvents.clear();
            this.repopEpoch = byteBuffer.getShort();
            n2 = byteBuffer.getShort();
            for (n = 0; n < n2; ++n) {
                MPRepopEvent mPRepopEvent = this.repopEventPool.alloc();
                mPRepopEvent.wx = byteBuffer.getShort();
                mPRepopEvent.wy = byteBuffer.getShort();
                mPRepopEvent.worldAge = byteBuffer.getFloat();
                this.repopEvents.add(mPRepopEvent);
            }
        }
    }

    public void serverPacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        short s;
        if (!GameServer.bServer) {
            return;
        }
        if (udpConnection.accessLevel != 32) {
            return;
        }
        int n = byteBuffer.get();
        if (n == 1) {
            int n2;
            this.requestTime = System.currentTimeMillis();
            this.requestPacketReceived = true;
            s = byteBuffer.getShort();
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.KeepAlive.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)1);
            byteBufferWriter.bb.putFloat(this.RESPAWN_EVERY_HOURS);
            byteBufferWriter.bb.putShort((short)this.loadedCells.size());
            for (n2 = 0; n2 < this.loadedCells.size(); ++n2) {
                MPCell mPCell = this.loadedCells.get(n2);
                byteBufferWriter.bb.putShort(mPCell.cx);
                byteBufferWriter.bb.putShort(mPCell.cy);
                byteBufferWriter.bb.putShort(mPCell.currentPopulation);
                byteBufferWriter.bb.putShort(mPCell.desiredPopulation);
                byteBufferWriter.bb.putFloat(mPCell.lastRepopTime);
            }
            byteBufferWriter.bb.putShort((short)this.loadedAreas.count);
            for (n2 = 0; n2 < this.loadedAreas.count; ++n2) {
                int n3 = n2 * 4;
                byteBufferWriter.bb.putShort((short)this.loadedAreas.areas[n3++]);
                byteBufferWriter.bb.putShort((short)this.loadedAreas.areas[n3++]);
                byteBufferWriter.bb.putShort((short)this.loadedAreas.areas[n3++]);
                byteBufferWriter.bb.putShort((short)this.loadedAreas.areas[n3++]);
            }
            if (s != this.repopEpoch) {
                n = 2;
            }
            PacketTypes.PacketType.KeepAlive.send(udpConnection);
        }
        if (n == 2) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.KeepAlive.doPacket(byteBufferWriter);
            byteBufferWriter.bb.put((byte)2);
            byteBufferWriter.bb.putShort(this.repopEpoch);
            byteBufferWriter.bb.putShort((short)this.repopEvents.size());
            for (int i = 0; i < this.repopEvents.size(); ++i) {
                MPRepopEvent mPRepopEvent = this.repopEvents.get(i);
                byteBufferWriter.bb.putShort((short)mPRepopEvent.wx);
                byteBufferWriter.bb.putShort((short)mPRepopEvent.wy);
                byteBufferWriter.bb.putFloat(mPRepopEvent.worldAge);
            }
            PacketTypes.PacketType.KeepAlive.send(udpConnection);
            return;
        }
        if (n == 3) {
            s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            ZombiePopulationManager.instance.dbgSpawnTimeToZero(s, s2);
            return;
        }
        if (n == 4) {
            s = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            ZombiePopulationManager.instance.dbgClearZombies(s, s3);
            return;
        }
        if (n == 5) {
            s = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            ZombiePopulationManager.instance.dbgSpawnNow(s, s4);
            return;
        }
    }

    public void request() {
        if (!GameServer.bServer) {
            return;
        }
        this.requestTime = System.currentTimeMillis();
    }

    private void addRepopEvent(int n, int n2, float f) {
        float f2 = (float)GameTime.getInstance().getWorldAgeHours();
        while (!this.repopEvents.isEmpty() && this.repopEvents.get((int)0).worldAge + this.REPOP_DISPLAY_HOURS < f2) {
            this.repopEventPool.release(this.repopEvents.remove(0));
        }
        this.repopEvents.add(this.repopEventPool.alloc().init(n, n2, f));
        this.repopEpoch = (short)(this.repopEpoch + 1);
    }

    public void serverUpdate() {
        short s;
        int n;
        int n2;
        int n3;
        int n4;
        if (!GameServer.bServer) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.requestTime + 10000L < l) {
            this.requestFlag = false;
            this.requestPacketReceived = false;
            return;
        }
        if (this.requestFlag) {
            if (MPDebugInfo.n_hasData(false)) {
                this.requestFlag = false;
                this.cellPool.release((List<MPCell>)this.loadedCells);
                this.loadedCells.clear();
                this.loadedAreas.clear();
                n4 = MPDebugInfo.n_getLoadedCellsCount();
                n3 = 0;
                while (n3 < n4) {
                    this.byteBuffer.clear();
                    n2 = MPDebugInfo.n_getLoadedCellsData(n3, this.byteBuffer);
                    n3 += n2;
                    for (n = 0; n < n2; ++n) {
                        MPCell mPCell = this.cellPool.alloc();
                        mPCell.cx = this.byteBuffer.getShort();
                        mPCell.cy = this.byteBuffer.getShort();
                        mPCell.currentPopulation = this.byteBuffer.getShort();
                        mPCell.desiredPopulation = this.byteBuffer.getShort();
                        mPCell.lastRepopTime = this.byteBuffer.getFloat();
                        this.loadedCells.add(mPCell);
                    }
                }
                n4 = MPDebugInfo.n_getLoadedAreasCount();
                n3 = 0;
                while (n3 < n4) {
                    this.byteBuffer.clear();
                    n2 = MPDebugInfo.n_getLoadedAreasData(n3, this.byteBuffer);
                    n3 += n2;
                    for (n = 0; n < n2; ++n) {
                        boolean bl = this.byteBuffer.get() == 0;
                        s = this.byteBuffer.getShort();
                        short s2 = this.byteBuffer.getShort();
                        short s3 = this.byteBuffer.getShort();
                        short s4 = this.byteBuffer.getShort();
                        this.loadedAreas.add(s, s2, s3, s4);
                    }
                }
            }
        } else if (this.requestPacketReceived) {
            MPDebugInfo.n_requestData();
            this.requestFlag = true;
            this.requestPacketReceived = false;
        }
        if (MPDebugInfo.n_hasData(true)) {
            n4 = MPDebugInfo.n_getRepopEventCount();
            n3 = 0;
            while (n3 < n4) {
                this.byteBuffer.clear();
                n2 = MPDebugInfo.n_getRepopEventData(n3, this.byteBuffer);
                n3 += n2;
                for (n = 0; n < n2; ++n) {
                    short s5 = this.byteBuffer.getShort();
                    s = this.byteBuffer.getShort();
                    float f = this.byteBuffer.getFloat();
                    this.addRepopEvent(s5, s, f);
                }
            }
        }
    }

    boolean isRespawnEnabled() {
        if (IsoWorld.getZombiesDisabled()) {
            return false;
        }
        return !(this.RESPAWN_EVERY_HOURS <= 0.0f);
    }

    public void render(ZombiePopulationRenderer zombiePopulationRenderer, float f) {
        int n;
        this.requestServerInfo();
        float f2 = (float)GameTime.getInstance().getWorldAgeHours();
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        zombiePopulationRenderer.outlineRect((float)(isoMetaGrid.minX * 300) * 1.0f, (float)(isoMetaGrid.minY * 300) * 1.0f, (float)((isoMetaGrid.maxX - isoMetaGrid.minX + 1) * 300) * 1.0f, (float)((isoMetaGrid.maxY - isoMetaGrid.minY + 1) * 300) * 1.0f, 1.0f, 1.0f, 1.0f, 0.25f);
        for (n = 0; n < this.loadedCells.size(); ++n) {
            MPCell mPCell = this.loadedCells.get(n);
            zombiePopulationRenderer.outlineRect(mPCell.cx * 300, mPCell.cy * 300, 300.0f, 300.0f, 1.0f, 1.0f, 1.0f, 0.25f);
            if (!this.isRespawnEnabled()) continue;
            float f3 = Math.min(f2 - mPCell.lastRepopTime, this.RESPAWN_EVERY_HOURS) / this.RESPAWN_EVERY_HOURS;
            if (mPCell.lastRepopTime > f2) {
                f3 = 0.0f;
            }
            zombiePopulationRenderer.outlineRect(mPCell.cx * 300 + 1, mPCell.cy * 300 + 1, 298.0f, 298.0f, 0.0f, 1.0f, 0.0f, f3 * f3);
        }
        for (n = 0; n < this.loadedAreas.count; ++n) {
            int n2 = n * 4;
            int n3 = this.loadedAreas.areas[n2++];
            int n4 = this.loadedAreas.areas[n2++];
            int n5 = this.loadedAreas.areas[n2++];
            int n6 = this.loadedAreas.areas[n2++];
            zombiePopulationRenderer.outlineRect(n3 * 10, n4 * 10, n5 * 10, n6 * 10, 0.7f, 0.7f, 0.7f, 1.0f);
        }
        for (n = 0; n < this.repopEvents.size(); ++n) {
            MPRepopEvent mPRepopEvent = this.repopEvents.get(n);
            if (mPRepopEvent.worldAge + this.REPOP_DISPLAY_HOURS < f2) continue;
            float f4 = 1.0f - (f2 - mPRepopEvent.worldAge) / this.REPOP_DISPLAY_HOURS;
            f4 = Math.max(f4, 0.1f);
            zombiePopulationRenderer.outlineRect(mPRepopEvent.wx * 10, mPRepopEvent.wy * 10, 50.0f, 50.0f, 0.0f, 0.0f, 1.0f, f4);
        }
        if (GameClient.bClient && DebugOptions.instance.MultiplayerShowPosition.getValue()) {
            float f5 = (IsoChunkMap.ChunkGridWidth / 2 + 2) * 10;
            for (Map.Entry<Short, Vector2> entry2 : GameClient.positions.entrySet()) {
                IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(entry2.getKey());
                Color color = Color.white;
                if (isoPlayer != null) {
                    color = isoPlayer.getSpeakColour();
                }
                Vector2 vector22 = entry2.getValue();
                zombiePopulationRenderer.renderZombie(vector22.x, vector22.y, color.r, color.g, color.b);
                zombiePopulationRenderer.renderCircle(vector22.x, vector22.y, f5, color.r, color.g, color.b, color.a);
                zombiePopulationRenderer.renderString(vector22.x, vector22.y, isoPlayer == null ? String.valueOf(entry2.getKey()) : isoPlayer.getUsername(), color.r, color.g, color.b, color.a);
            }
            if (IsoPlayer.getInstance() != null) {
                IsoPlayer isoPlayer = IsoPlayer.getInstance();
                Color color = isoPlayer.getSpeakColour();
                zombiePopulationRenderer.renderZombie(isoPlayer.x, isoPlayer.y, color.r, color.g, color.b);
                zombiePopulationRenderer.renderCircle(isoPlayer.x, isoPlayer.y, f5, color.r, color.g, color.b, color.a);
                zombiePopulationRenderer.renderString(isoPlayer.x, isoPlayer.y, isoPlayer.getUsername(), color.r, color.g, color.b, color.a);
                color = Colors.LightBlue;
                zombiePopulationRenderer.renderCircle(isoPlayer.x, isoPlayer.y, RakVoice.GetMinDistance(), color.r, color.g, color.b, color.a);
                zombiePopulationRenderer.renderCircle(isoPlayer.x, isoPlayer.y, RakVoice.GetMaxDistance(), color.r, color.g, color.b, color.a);
            }
        }
        if (f > 0.25f) {
            for (int i = 0; i < this.loadedCells.size(); ++i) {
                MPCell mPCell = this.loadedCells.get(i);
                zombiePopulationRenderer.renderCellInfo(mPCell.cx, mPCell.cy, mPCell.currentPopulation, mPCell.desiredPopulation, mPCell.lastRepopTime + this.RESPAWN_EVERY_HOURS - f2);
            }
        }
        try {
            debugSounds.entrySet().removeIf(entry -> System.currentTimeMillis() > (Long)entry.getKey() + 1000L);
            for (Map.Entry<Long, MPSoundDebugInfo> entry3 : debugSounds.entrySet()) {
                Color color = Colors.LightBlue;
                if (entry3.getValue().sourceIsZombie) {
                    color = Colors.GreenYellow;
                } else if (entry3.getValue().bRepeating) {
                    color = Colors.Coral;
                }
                float f6 = 1.0f - Math.max(0.0f, Math.min(1.0f, (float)(System.currentTimeMillis() - entry3.getKey()) / 1000.0f));
                zombiePopulationRenderer.renderCircle(entry3.getValue().x, entry3.getValue().y, entry3.getValue().radius, color.r, color.g, color.b, f6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void AddDebugSound(WorldSoundManager.WorldSound worldSound) {
        try {
            debugSounds.put(System.currentTimeMillis(), new MPSoundDebugInfo(worldSound));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class MPCell {
        public short cx;
        public short cy;
        public short currentPopulation;
        public short desiredPopulation;
        public float lastRepopTime;

        private MPCell() {
        }

        MPCell init(int n, int n2, int n3, int n4, float f) {
            this.cx = (short)n;
            this.cy = (short)n2;
            this.currentPopulation = (short)n3;
            this.desiredPopulation = (short)n4;
            this.lastRepopTime = f;
            return this;
        }
    }

    private static final class MPRepopEvent {
        public int wx;
        public int wy;
        public float worldAge;

        private MPRepopEvent() {
        }

        public MPRepopEvent init(int n, int n2, float f) {
            this.wx = n;
            this.wy = n2;
            this.worldAge = f;
            return this;
        }
    }

    private static class MPSoundDebugInfo {
        int x;
        int y;
        int radius;
        boolean bRepeating;
        boolean sourceIsZombie;

        MPSoundDebugInfo(WorldSoundManager.WorldSound worldSound) {
            this.x = worldSound.x;
            this.y = worldSound.y;
            this.radius = worldSound.radius;
            this.bRepeating = worldSound.bRepeating;
            this.sourceIsZombie = worldSound.sourceIsZombie;
        }
    }
}

