/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import zombie.characters.IsoLivingCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Instance;

public class Weapon
extends Instance
implements INetworkPacket {
    protected InventoryItem item;
    protected HandWeapon weapon;

    public void set(HandWeapon handWeapon) {
        super.set(handWeapon.getRegistry_id());
        this.item = handWeapon;
        this.weapon = handWeapon;
    }

    public void parse(ByteBuffer byteBuffer, IsoLivingCharacter isoLivingCharacter) {
        boolean bl;
        boolean bl2 = bl = byteBuffer.get() == 1;
        if (bl) {
            this.ID = byteBuffer.getShort();
            byteBuffer.get();
            if (isoLivingCharacter != null) {
                this.item = isoLivingCharacter.getPrimaryHandItem();
                if (this.item == null || this.item.getRegistry_id() != this.ID) {
                    this.item = InventoryItemFactory.CreateItem(this.ID);
                }
                if (this.item != null) {
                    try {
                        this.item.load(byteBuffer, 195);
                    }
                    catch (IOException | BufferUnderflowException exception) {
                        DebugLog.Multiplayer.printException(exception, "Weapon load error", LogSeverity.Error);
                        this.item = InventoryItemFactory.CreateItem("Base.BareHands");
                    }
                }
            }
        } else {
            this.item = InventoryItemFactory.CreateItem("Base.BareHands");
        }
        if (isoLivingCharacter != null) {
            this.weapon = isoLivingCharacter.bareHands;
            if (this.item instanceof HandWeapon) {
                this.weapon = (HandWeapon)this.item;
            }
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        DebugLog.Multiplayer.error("Weapon.parse is not implemented");
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        if (this.item == null) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                this.item.save(byteBufferWriter.bb, false);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "Item write error", LogSeverity.Error);
            }
        }
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.weapon != null;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tWeapon [ weapon=" + (String)(this.weapon == null ? "?" : "\"" + this.weapon.getDisplayName() + "\"") + " ]";
    }

    HandWeapon getWeapon() {
        return this.weapon;
    }
}

