/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Fall;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.VehicleHit;
import zombie.network.packets.hit.VehicleHitPacket;
import zombie.network.packets.hit.Zombie;
import zombie.vehicles.BaseVehicle;

public class VehicleHitZombiePacket
extends VehicleHitPacket
implements INetworkPacket {
    protected final Zombie target = new Zombie();
    protected final VehicleHit vehicleHit = new VehicleHit();
    protected final Fall fall = new Fall();

    public VehicleHitZombiePacket() {
        super(HitCharacterPacket.HitType.VehicleHitZombie);
    }

    public void set(IsoPlayer isoPlayer, IsoZombie isoZombie, BaseVehicle baseVehicle, float f, boolean bl, int n, float f2, boolean bl2) {
        super.set(isoPlayer, baseVehicle, false);
        this.target.set(isoZombie, false);
        this.vehicleHit.set(false, f, isoZombie.getHitForce(), isoZombie.getHitDir().x, isoZombie.getHitDir().y, n, f2, bl2, bl);
        this.fall.set(isoZombie.getHitReactionNetworkAI());
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.target.parse(byteBuffer, udpConnection);
        this.vehicleHit.parse(byteBuffer, udpConnection);
        this.fall.parse(byteBuffer, udpConnection);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        this.target.write(byteBufferWriter);
        this.vehicleHit.write(byteBufferWriter);
        this.fall.write(byteBufferWriter);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.target.isConsistent() && this.vehicleHit.isConsistent();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tTarget " + this.target.getDescription() + "\n\tVehicleHit " + this.vehicleHit.getDescription() + "\n\tFall " + this.fall.getDescription();
    }

    @Override
    protected void preProcess() {
        super.preProcess();
        this.target.process();
    }

    @Override
    protected void process() {
        this.vehicleHit.process(this.wielder.getCharacter(), this.target.getCharacter(), this.vehicle.getVehicle());
        this.fall.process(this.target.getCharacter());
    }

    @Override
    protected void postProcess() {
        super.postProcess();
        this.target.process();
    }

    @Override
    protected void react() {
        this.target.react();
    }

    @Override
    protected void postpone() {
        this.target.getCharacter().getNetworkCharacterAI().setVehicleHit(this);
    }

    @Override
    public boolean validate(UdpConnection udpConnection) {
        if (!PacketValidator.checkSpeed(udpConnection, this.vehicleHit, VehicleHitZombiePacket.class.getSimpleName())) {
            return false;
        }
        if (!PacketValidator.checkShortDistance(udpConnection, this.wielder, this.target, VehicleHitZombiePacket.class.getSimpleName())) {
            return false;
        }
        return PacketValidator.checkDamage(udpConnection, this.vehicleHit, VehicleHitZombiePacket.class.getSimpleName());
    }
}

