/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Hit;
import zombie.network.packets.hit.IMovable;
import zombie.vehicles.BaseVehicle;

public class VehicleHit
extends Hit
implements IMovable,
INetworkPacket {
    public int vehicleDamage;
    public float vehicleSpeed;
    public boolean isVehicleHitFromBehind;
    public boolean isTargetHitFromBehind;

    public void set(boolean bl, float f, float f2, float f3, float f4, int n, float f5, boolean bl2, boolean bl3) {
        super.set(bl, f, f2, f3, f4);
        this.vehicleDamage = n;
        this.vehicleSpeed = f5;
        this.isVehicleHitFromBehind = bl2;
        this.isTargetHitFromBehind = bl3;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.vehicleDamage = byteBuffer.getInt();
        this.vehicleSpeed = byteBuffer.getFloat();
        this.isVehicleHitFromBehind = byteBuffer.get() != 0;
        this.isTargetHitFromBehind = byteBuffer.get() != 0;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putInt(this.vehicleDamage);
        byteBufferWriter.putFloat(this.vehicleSpeed);
        byteBufferWriter.putBoolean(this.isVehicleHitFromBehind);
        byteBufferWriter.putBoolean(this.isTargetHitFromBehind);
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tVehicle [ speed=" + this.vehicleSpeed + " | damage=" + this.vehicleDamage + " | target-hit=" + (this.isTargetHitFromBehind ? "FRONT" : "BEHIND") + " | vehicle-hit=" + (this.isVehicleHitFromBehind ? "FRONT" : "REAR") + " ]";
    }

    void process(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, BaseVehicle baseVehicle) {
        super.process(isoGameCharacter, isoGameCharacter2);
        if (GameServer.bServer) {
            if (this.vehicleDamage != 0) {
                if (this.isVehicleHitFromBehind) {
                    baseVehicle.addDamageFrontHitAChr(this.vehicleDamage);
                } else {
                    baseVehicle.addDamageRearHitAChr(this.vehicleDamage);
                }
                baseVehicle.transmitBlood();
            }
        } else if (GameClient.bClient) {
            if (isoGameCharacter2 instanceof IsoZombie) {
                ((IsoZombie)isoGameCharacter2).applyDamageFromVehicle(this.vehicleSpeed, this.damage);
            } else if (isoGameCharacter2 instanceof IsoPlayer) {
                ((IsoPlayer)isoGameCharacter2).getDamageFromHitByACar(this.vehicleSpeed);
                ((IsoPlayer)isoGameCharacter2).actionContext.reportEvent("washit");
                isoGameCharacter2.setVariable("hitpvp", false);
            }
        }
    }

    @Override
    public float getSpeed() {
        return this.vehicleSpeed;
    }

    @Override
    public boolean isVehicle() {
        return true;
    }
}

