/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Fall;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.PlayerHitPacket;
import zombie.network.packets.hit.WeaponHit;
import zombie.network.packets.hit.Zombie;

public class PlayerHitZombiePacket
extends PlayerHitPacket
implements INetworkPacket {
    protected final Zombie target = new Zombie();
    protected final WeaponHit hit = new WeaponHit();
    protected final Fall fall = new Fall();

    public PlayerHitZombiePacket() {
        super(HitCharacterPacket.HitType.PlayerHitZombie);
    }

    public void set(IsoPlayer isoPlayer, IsoZombie isoZombie, HandWeapon handWeapon, float f, boolean bl, float f2, boolean bl2, boolean bl3, boolean bl4) {
        super.set(isoPlayer, handWeapon, bl2);
        this.target.set(isoZombie, bl3);
        this.hit.set(bl, f, f2, isoZombie.getHitForce(), isoZombie.getHitDir().x, isoZombie.getHitDir().y, bl4);
        this.fall.set(isoZombie.getHitReactionNetworkAI());
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.target.parse(byteBuffer, udpConnection);
        this.hit.parse(byteBuffer, udpConnection);
        this.fall.parse(byteBuffer, udpConnection);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        this.target.write(byteBufferWriter);
        this.hit.write(byteBufferWriter);
        this.fall.write(byteBufferWriter);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.target.isConsistent() && this.hit.isConsistent();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tTarget " + this.target.getDescription() + "\n\tHit " + this.hit.getDescription() + "\n\tFall " + this.fall.getDescription();
    }

    @Override
    protected void preProcess() {
        super.preProcess();
        this.target.process();
    }

    @Override
    protected void process() {
        this.hit.process(this.wielder.getCharacter(), this.target.getCharacter(), this.weapon.getWeapon());
        this.fall.process(this.target.getCharacter());
    }

    @Override
    protected void postProcess() {
        super.postProcess();
        this.target.process();
    }

    @Override
    protected void react() {
        this.target.react(this.weapon.getWeapon());
    }

    @Override
    public boolean validate(UdpConnection udpConnection) {
        if (!PacketValidator.checkLongDistance(udpConnection, this.wielder, this.target, PlayerHitZombiePacket.class.getSimpleName())) {
            return false;
        }
        return PacketValidator.checkDamage(udpConnection, this.hit, PlayerHitZombiePacket.class.getSimpleName());
    }
}

