/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoMovingObject;
import zombie.iso.objects.IsoWindow;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.MovingObject;
import zombie.network.packets.hit.NetObject;

public class HitInfo
implements INetworkPacket {
    public MovingObject object = new MovingObject();
    public NetObject window = new NetObject();
    public float x;
    public float y;
    public float z;
    public float dot;
    public float distSq;
    public int chance = 0;

    public HitInfo init(IsoMovingObject isoMovingObject, float f, float f2, float f3, float f4, float f5) {
        this.object = new MovingObject();
        this.window = new NetObject();
        this.object.setMovingObject(isoMovingObject);
        this.window.setObject(null);
        this.x = f3;
        this.y = f4;
        this.z = f5;
        this.dot = f;
        this.distSq = f2;
        return this;
    }

    public HitInfo init(IsoWindow isoWindow, float f, float f2) {
        this.object = new MovingObject();
        this.window = new NetObject();
        this.object.setMovingObject(null);
        this.window.setObject(isoWindow);
        this.z = isoWindow.getZ();
        this.dot = f;
        this.distSq = f2;
        return this;
    }

    public IsoMovingObject getObject() {
        return this.object.getMovingObject();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.object.parse(byteBuffer, udpConnection);
        this.window.parse(byteBuffer, udpConnection);
        this.x = byteBuffer.getFloat();
        this.y = byteBuffer.getFloat();
        this.z = byteBuffer.getFloat();
        this.dot = byteBuffer.getFloat();
        this.distSq = byteBuffer.getFloat();
        this.chance = byteBuffer.getInt();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        this.object.write(byteBufferWriter);
        this.window.write(byteBufferWriter);
        byteBufferWriter.putFloat(this.x);
        byteBufferWriter.putFloat(this.y);
        byteBufferWriter.putFloat(this.z);
        byteBufferWriter.putFloat(this.dot);
        byteBufferWriter.putFloat(this.distSq);
        byteBufferWriter.putInt(this.chance);
    }

    @Override
    public int getPacketSizeBytes() {
        return 24 + this.object.getPacketSizeBytes() + this.window.getPacketSizeBytes();
    }

    @Override
    public String getDescription() {
        return "\n\tHitInfo [ x=" + this.x + " y=" + this.y + " z=" + this.z + " dot=" + this.dot + " distSq=" + this.distSq + " chance=" + this.chance + "\n\t Object: " + this.object.getDescription() + "\n\t Window: " + this.window.getDescription() + " ]";
    }
}

