/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.IsoGameCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.packets.INetworkPacket;

public class Fall
implements INetworkPacket {
    protected float dropPositionX;
    protected float dropPositionY;
    protected byte dropPositionZ;
    protected float dropDirection;

    public void set(HitReactionNetworkAI hitReactionNetworkAI) {
        this.dropPositionX = hitReactionNetworkAI.finalPosition.x;
        this.dropPositionY = hitReactionNetworkAI.finalPosition.y;
        this.dropPositionZ = hitReactionNetworkAI.finalPositionZ;
        this.dropDirection = hitReactionNetworkAI.finalDirection.getDirection();
    }

    public void set(float f, float f2, byte by, float f3) {
        this.dropPositionX = f;
        this.dropPositionY = f2;
        this.dropPositionZ = by;
        this.dropDirection = f3;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.dropPositionX = byteBuffer.getFloat();
        this.dropPositionY = byteBuffer.getFloat();
        this.dropPositionZ = byteBuffer.get();
        this.dropDirection = byteBuffer.getFloat();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putFloat(this.dropPositionX);
        byteBufferWriter.putFloat(this.dropPositionY);
        byteBufferWriter.putByte(this.dropPositionZ);
        byteBufferWriter.putFloat(this.dropDirection);
    }

    @Override
    public String getDescription() {
        return "\n\tFall [ direction=" + this.dropDirection + " | position=( " + this.dropPositionX + " ; " + this.dropPositionY + " ; " + this.dropPositionZ + " ) ]";
    }

    public void process(IsoGameCharacter isoGameCharacter) {
        if (this.isSetup() && isoGameCharacter.getHitReactionNetworkAI() != null) {
            isoGameCharacter.getHitReactionNetworkAI().process(this.dropPositionX, this.dropPositionY, this.dropPositionZ, this.dropDirection);
        }
    }

    boolean isSetup() {
        return this.dropPositionX != 0.0f && this.dropPositionY != 0.0f;
    }
}

