/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;

public class Bite
implements INetworkPacket {
    protected short flags;
    protected float hitDirection;

    public void set(IsoZombie isoZombie) {
        this.flags = 0;
        this.flags = (short)(this.flags | (short)(isoZombie.getEatBodyTarget() != null ? 1 : 0));
        this.flags = (short)(this.flags | (short)(isoZombie.getVariableBoolean("AttackDidDamage") ? 2 : 0));
        this.flags = (short)(this.flags | (short)("BiteDefended".equals(isoZombie.getHitReaction()) ? 4 : 0));
        this.flags = (short)(this.flags | (short)(isoZombie.scratch ? 8 : 0));
        this.flags = (short)(this.flags | (short)(isoZombie.laceration ? 16 : 0));
        this.hitDirection = isoZombie.getHitDir().getDirection();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.flags = byteBuffer.getShort();
        this.hitDirection = byteBuffer.getFloat();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.flags);
        byteBufferWriter.putFloat(this.hitDirection);
    }

    @Override
    public String getDescription() {
        return "\n\tBite [ eatBodyTarget=" + ((this.flags & 1) != 0) + " | attackDidDamage=" + ((this.flags & 2) != 0) + " | biteDefended=" + ((this.flags & 4) != 0) + " | scratch=" + ((this.flags & 8) != 0) + " | laceration=" + ((this.flags & 0x10) != 0) + " | hitDirection=" + this.hitDirection + " ]";
    }

    void process(IsoZombie isoZombie, IsoGameCharacter isoGameCharacter) {
        if ((this.flags & 4) == 0) {
            isoGameCharacter.setAttackedBy(isoZombie);
            if ((this.flags & 1) != 0 || isoGameCharacter.isDead()) {
                isoZombie.setEatBodyTarget(isoGameCharacter, true);
                isoZombie.setTarget(null);
            }
            if (isoGameCharacter.isAsleep()) {
                if (GameServer.bServer) {
                    isoGameCharacter.sendObjectChange("wakeUp");
                } else {
                    isoGameCharacter.forceAwake();
                }
            }
            if ((this.flags & 2) != 0) {
                isoGameCharacter.reportEvent("washit");
                isoGameCharacter.setVariable("hitpvp", false);
            }
            isoZombie.scratch = (this.flags & 8) != 0;
            isoZombie.laceration = (this.flags & 8) != 0;
        }
        isoZombie.getHitDir().setLengthAndDirection(this.hitDirection, 1.0f);
    }
}

