/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;
import zombie.radio.ZomboidRadio;

public class WaveSignal
implements INetworkPacket {
    int sourceX;
    int sourceY;
    int channel;
    String msg;
    String guid;
    String codes;
    float r;
    float g;
    float b;
    int signalStrength;
    boolean isTV;

    public void set(int n, int n2, int n3, String string, String string2, String string3, float f, float f2, float f3, int n4, boolean bl) {
        this.sourceX = n;
        this.sourceY = n2;
        this.channel = n3;
        this.msg = string;
        this.guid = string2;
        this.codes = string3;
        this.r = f;
        this.g = f2;
        this.b = f3;
        this.signalStrength = n4;
        this.isTV = bl;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.sourceX = byteBuffer.getInt();
        this.sourceY = byteBuffer.getInt();
        this.channel = byteBuffer.getInt();
        this.msg = null;
        if (byteBuffer.get() == 1) {
            this.msg = GameWindow.ReadString(byteBuffer);
        }
        this.guid = null;
        if (byteBuffer.get() == 1) {
            this.guid = GameWindow.ReadString(byteBuffer);
        }
        this.codes = null;
        if (byteBuffer.get() == 1) {
            this.codes = GameWindow.ReadString(byteBuffer);
        }
        this.r = byteBuffer.getFloat();
        this.g = byteBuffer.getFloat();
        this.b = byteBuffer.getFloat();
        this.signalStrength = byteBuffer.getInt();
        this.isTV = byteBuffer.get() == 1;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.sourceX);
        byteBufferWriter.putInt(this.sourceY);
        byteBufferWriter.putInt(this.channel);
        byteBufferWriter.putBoolean(this.msg != null);
        if (this.msg != null) {
            byteBufferWriter.putUTF(this.msg);
        }
        byteBufferWriter.putBoolean(this.guid != null);
        if (this.guid != null) {
            byteBufferWriter.putUTF(this.guid);
        }
        byteBufferWriter.putBoolean(this.codes != null);
        if (this.codes != null) {
            byteBufferWriter.putUTF(this.codes);
        }
        byteBufferWriter.putFloat(this.r);
        byteBufferWriter.putFloat(this.g);
        byteBufferWriter.putFloat(this.b);
        byteBufferWriter.putInt(this.signalStrength);
        byteBufferWriter.putBoolean(this.isTV);
    }

    public void process(UdpConnection udpConnection) {
        if (GameServer.bServer) {
            ZomboidRadio.getInstance().SendTransmission(udpConnection.getConnectedGUID(), this.sourceX, this.sourceY, this.channel, this.msg, this.guid, this.codes, this.r, this.g, this.b, this.signalStrength, this.isTV);
        } else {
            ZomboidRadio.getInstance().ReceiveTransmission(this.sourceX, this.sourceY, this.channel, this.msg, this.guid, this.codes, this.r, this.g, this.b, this.signalStrength, this.isTV);
        }
    }
}

