/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.CRC32;
import zombie.GameWindow;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.LogSeverity;
import zombie.gameStates.GameLoadingState;
import zombie.network.ConnectionManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Recipe;

public class ValidatePacket
implements INetworkPacket {
    private long checksum;
    private long checksumFromClient;
    private int salt;
    private byte flags;

    public void setSalt(int n, boolean bl, boolean bl2, boolean bl3) {
        this.salt = n;
        this.flags = 0;
        this.flags = (byte)(this.flags | (bl ? (byte)1 : 0));
        this.flags = (byte)(this.flags | (bl2 ? 2 : 0));
        this.flags = (byte)(this.flags | (bl3 ? 4 : 0));
    }

    public void process(UdpConnection udpConnection) {
        if (GameClient.bClient) {
            this.checksum = this.calculateChecksum(udpConnection, this.salt);
            GameClient.sendValidatePacket(this);
            if (DebugOptions.instance.MultiplayerFailChecksum.getValue() && (this.flags & 1) != 0) {
                ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
                Recipe recipe = arrayList.get(Rand.Next(arrayList.size()));
                recipe.TimeToMake = Rand.Next(Short.MAX_VALUE);
                DebugLog.Multiplayer.debugln("Failed recipe \"%s\"", recipe.getOriginalname());
            }
            if ((this.flags & 2) != 0) {
                GameLoadingState.Done();
            }
        } else if (GameServer.bServer) {
            this.salt = udpConnection.validator.getSalt();
            this.checksum = this.calculateChecksum(udpConnection, this.salt);
            if ((this.flags & 4) == 0) {
                if (this.checksumFromClient != this.checksum) {
                    udpConnection.validator.failChecksum();
                }
                if (udpConnection.validator.isFailed()) {
                    udpConnection.validator.sendChecksum(false, false, true);
                } else {
                    udpConnection.validator.successChecksum();
                    if ((this.flags & 1) != 0) {
                        udpConnection.validator.sendChecksum(false, true, false);
                    }
                }
            }
        }
    }

    private long calculateChecksum(UdpConnection udpConnection, int n) {
        if ((this.flags & 4) != 0) {
            udpConnection.validator.details.clear();
        }
        CRC32 cRC32 = new CRC32();
        CRC32 cRC322 = new CRC32();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        cRC32.update(n);
        ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
        for (Recipe recipe : arrayList) {
            cRC322.reset();
            byteBuffer.clear();
            cRC322.update(recipe.getOriginalname().getBytes());
            cRC322.update((int)recipe.TimeToMake);
            if (recipe.skillRequired != null) {
                for (Recipe.RequiredSkill requiredSkill : recipe.skillRequired) {
                    cRC322.update(requiredSkill.getPerk().index());
                    cRC322.update(requiredSkill.getLevel());
                }
            }
            for (Recipe.Source source : recipe.getSource()) {
                for (String string : source.getItems()) {
                    cRC322.update(string.getBytes());
                }
            }
            cRC322.update(recipe.getResult().getType().getBytes());
            cRC322.update(recipe.getResult().getModule().getBytes());
            cRC322.update(recipe.getResult().getCount());
            long l = cRC322.getValue();
            byteBuffer.putLong(l);
            byteBuffer.position(0);
            cRC32.update(byteBuffer);
            if ((this.flags & 4) == 0) continue;
            udpConnection.validator.details.put(recipe.getOriginalname(), new PacketValidator.RecipeDetails(recipe.getOriginalname(), l, (int)recipe.TimeToMake, recipe.skillRequired, recipe.getSource(), recipe.getResult().getType(), recipe.getResult().getModule(), recipe.getResult().getCount()));
        }
        return cRC32.getValue();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        try {
            this.flags = byteBuffer.get();
            if (GameClient.bClient) {
                this.salt = byteBuffer.getInt();
            } else if (GameServer.bServer) {
                this.checksumFromClient = byteBuffer.getLong();
                if ((this.flags & 4) != 0) {
                    udpConnection.validator.detailsFromClient.clear();
                    int n = byteBuffer.getInt();
                    for (int i = 0; i < n; ++i) {
                        udpConnection.validator.detailsFromClient.put(GameWindow.ReadString(byteBuffer), new PacketValidator.RecipeDetails(byteBuffer));
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "Parse error. Probably, \"" + udpConnection.username + "\" client is outdated", LogSeverity.Error);
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte(this.flags);
        if (GameServer.bServer) {
            byteBufferWriter.putInt(this.salt);
        } else if (GameClient.bClient) {
            byteBufferWriter.putLong(this.checksum);
            if ((this.flags & 4) != 0) {
                int n = GameClient.connection.validator.details.size();
                byteBufferWriter.putInt(n);
                for (Map.Entry<String, PacketValidator.RecipeDetails> entry : GameClient.connection.validator.details.entrySet()) {
                    byteBufferWriter.putUTF(entry.getKey());
                    entry.getValue().write(byteBufferWriter);
                }
            }
        }
    }

    @Override
    public void log(UdpConnection udpConnection, String string) {
        if (this.flags != 0) {
            ConnectionManager.log(string, String.format("checksum-packet-%d", this.flags), udpConnection);
        }
    }

    public static enum ValidateState {
        Request,
        Success;

    }
}

