/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;

public class SyncInjuriesPacket
implements INetworkPacket {
    public short id;
    public float strafeSpeed;
    public float walkSpeed;
    public float walkInjury;
    public IsoPlayer player;

    public boolean set(IsoPlayer isoPlayer) {
        if (GameClient.bClient) {
            this.id = (short)isoPlayer.getPlayerNum();
        } else if (GameServer.bServer) {
            this.id = isoPlayer.getOnlineID();
        }
        this.strafeSpeed = isoPlayer.getVariableFloat("StrafeSpeed", 1.0f);
        this.walkSpeed = isoPlayer.getVariableFloat("WalkSpeed", 1.0f);
        this.walkInjury = isoPlayer.getVariableFloat("WalkInjury", 0.0f);
        this.player = isoPlayer;
        return true;
    }

    public boolean process() {
        if (this.player != null && !this.player.isLocalPlayer()) {
            this.player.setVariable("StrafeSpeed", this.strafeSpeed);
            this.player.setVariable("WalkSpeed", this.walkSpeed);
            this.player.setVariable("WalkInjury", this.walkInjury);
            return true;
        }
        return false;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.id = byteBuffer.getShort();
        this.strafeSpeed = byteBuffer.getFloat();
        this.walkSpeed = byteBuffer.getFloat();
        this.walkInjury = byteBuffer.getFloat();
        this.player = GameServer.bServer ? GameServer.getPlayerFromConnection(udpConnection, this.id) : (GameClient.bClient ? GameClient.IDToPlayerMap.get(this.id) : null);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.id);
        byteBufferWriter.putFloat(this.strafeSpeed);
        byteBufferWriter.putFloat(this.walkSpeed);
        byteBufferWriter.putFloat(this.walkInjury);
    }

    @Override
    public int getPacketSizeBytes() {
        return 14;
    }

    @Override
    public String getDescription() {
        return "SyncInjuriesPacket: id=" + this.id + ", strafeSpeed=" + this.strafeSpeed + ", walkSpeed=" + this.walkSpeed + ", walkInjury=" + this.walkInjury;
    }
}

