/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.network.GameClient;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Player;
import zombie.network.packets.hit.PlayerBodyPart;
import zombie.network.packets.hit.PlayerItem;

public class Stitch
implements INetworkPacket {
    protected final Player wielder = new Player();
    protected final Player target = new Player();
    protected PlayerBodyPart bodyPart = new PlayerBodyPart();
    protected PlayerItem item = new PlayerItem();
    protected float stitchTime = 0.0f;
    protected boolean doIt = false;
    protected boolean infect = false;

    public void set(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, BodyPart bodyPart, InventoryItem inventoryItem, boolean bl) {
        this.wielder.set(isoGameCharacter);
        this.target.set(isoGameCharacter2);
        this.bodyPart.set(bodyPart);
        if (inventoryItem != null) {
            this.item.set(inventoryItem);
        }
        this.stitchTime = bodyPart.getStitchTime();
        this.doIt = bl;
        this.infect = bodyPart.isInfectedWound();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.wielder.parse(byteBuffer, udpConnection);
        this.wielder.parsePlayer(udpConnection);
        this.target.parse(byteBuffer, udpConnection);
        this.target.parsePlayer(null);
        this.bodyPart.parse(byteBuffer, this.target.getCharacter());
        this.item.parse(byteBuffer, udpConnection);
        this.stitchTime = byteBuffer.getFloat();
        this.doIt = byteBuffer.get() == 1;
        this.infect = byteBuffer.get() == 1;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        this.wielder.write(byteBufferWriter);
        this.target.write(byteBufferWriter);
        this.bodyPart.write(byteBufferWriter);
        this.item.write(byteBufferWriter);
        byteBufferWriter.putFloat(this.stitchTime);
        byteBufferWriter.putBoolean(this.doIt);
        byteBufferWriter.putBoolean(this.infect);
    }

    public void process() {
        int n = this.wielder.getCharacter().getPerkLevel(PerkFactory.Perks.Doctor);
        if (!this.wielder.getPlayer().isAccessLevel("None")) {
            n = 10;
        }
        int n2 = 20;
        if (this.doIt) {
            if (this.wielder.getCharacter().getInventory().contains("SutureNeedleHolder") || this.item.getItem().getType().equals("SutureNeedle")) {
                n2 = 10;
            }
        } else {
            n2 = 5;
        }
        if (this.wielder.getCharacter().getCharacterTraits().Hemophobic.isSet()) {
            this.wielder.getCharacter().getStats().setPanic(this.wielder.getCharacter().getStats().getPanic() + 50.0f);
        }
        if (this.item.getItem() != null) {
            this.item.getItem().Use();
        }
        if (this.bodyPart.getBodyPart().isGetStitchXp()) {
            this.wielder.getCharacter().getXp().AddXP(PerkFactory.Perks.Doctor, 15.0f);
        }
        this.bodyPart.getBodyPart().setStitched(this.doIt);
        int n3 = n2 - n * 1;
        if (n3 < 0) {
            n3 = 0;
        }
        if (!this.wielder.getPlayer().isAccessLevel("None")) {
            this.bodyPart.getBodyPart().setAdditionalPain(this.bodyPart.getBodyPart().getAdditionalPain() + (float)n3);
        }
        if (this.doIt) {
            this.bodyPart.getBodyPart().setStitchTime(this.stitchTime);
        }
        if (this.infect) {
            this.bodyPart.getBodyPart().setInfectedWound(true);
        }
    }

    @Override
    public boolean isConsistent() {
        return this.wielder.getCharacter() != null && this.wielder.getCharacter() instanceof IsoPlayer && this.target.getCharacter() != null && this.target.getCharacter() instanceof IsoPlayer && this.bodyPart.getBodyPart() != null && this.stitchTime < 50.0f && this.stitchTime >= 0.0f;
    }

    public boolean validate(UdpConnection udpConnection) {
        if (GameClient.bClient && this.doIt && (!this.bodyPart.getBodyPart().isDeepWounded() || this.bodyPart.getBodyPart().haveGlass())) {
            DebugLog.General.warn(this.getClass().getSimpleName() + ": Validate error: " + this.getDescription());
            return false;
        }
        if (GameClient.bClient && !this.doIt && !this.bodyPart.getBodyPart().stitched()) {
            DebugLog.General.warn(this.getClass().getSimpleName() + ": Validate error: " + this.getDescription());
            return false;
        }
        return PacketValidator.checkShortDistance(udpConnection, this.wielder, this.target, this.getClass().getSimpleName());
    }

    @Override
    public String getDescription() {
        String string = "\n\t" + this.getClass().getSimpleName() + " [";
        string = string + "wielder=" + this.wielder.getDescription() + " | ";
        string = string + "target=" + this.target.getDescription() + " | ";
        string = string + "bodyPart=" + this.bodyPart.getDescription() + " | ";
        string = string + "item=" + this.item.getDescription() + " | ";
        string = string + "stitchTime=" + this.stitchTime + " | ";
        string = string + "doIt=" + this.doIt + " | ";
        string = string + "infect=" + this.infect + "] ";
        return string;
    }
}

