/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.packets.INetworkPacket;

public class PlayerVariables
implements INetworkPacket {
    byte count = 0;
    NetworkPlayerVariable[] variables = new NetworkPlayerVariable[2];

    public PlayerVariables() {
        for (int n = 0; n < this.variables.length; n = (int)((byte)(n + 1))) {
            this.variables[n] = new NetworkPlayerVariable();
        }
    }

    public void set(IsoPlayer isoPlayer) {
        String string = isoPlayer.getActionStateName();
        if (string.equals("idle")) {
            this.variables[0].set(isoPlayer, NetworkPlayerVariableIDs.IdleSpeed);
            this.count = 1;
        } else if (string.equals("maskingleft") || string.equals("maskingright") || string.equals("movement") || string.equals("run") || string.equals("sprint")) {
            this.variables[0].set(isoPlayer, NetworkPlayerVariableIDs.WalkInjury);
            this.variables[1].set(isoPlayer, NetworkPlayerVariableIDs.WalkSpeed);
            this.count = (byte)2;
        }
    }

    public void apply(IsoPlayer isoPlayer) {
        for (byte by = 0; by < this.count; by = (byte)(by + 1)) {
            isoPlayer.setVariable(this.variables[by].id.name(), this.variables[by].value);
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.count = byteBuffer.get();
        for (byte by = 0; by < this.count; by = (byte)(by + 1)) {
            this.variables[by].id = NetworkPlayerVariableIDs.values()[byteBuffer.get()];
            this.variables[by].value = byteBuffer.getFloat();
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte(this.count);
        for (byte by = 0; by < this.count; by = (byte)(by + 1)) {
            byteBufferWriter.putByte((byte)this.variables[by].id.ordinal());
            byteBufferWriter.putFloat(this.variables[by].value);
        }
    }

    @Override
    public int getPacketSizeBytes() {
        return 1 + this.count * 5;
    }

    @Override
    public String getDescription() {
        Object object = "PlayerVariables: ";
        object = (String)object + "count=" + this.count + " | ";
        for (byte by = 0; by < this.count; by = (byte)(by + 1)) {
            object = (String)object + "id=" + this.variables[by].id.name() + ", ";
            object = (String)object + "value=" + this.variables[by].value + " | ";
        }
        return object;
    }

    public void copy(PlayerVariables playerVariables) {
        this.count = playerVariables.count;
        for (byte by = 0; by < this.count; by = (byte)(by + 1)) {
            this.variables[by].id = playerVariables.variables[by].id;
            this.variables[by].value = playerVariables.variables[by].value;
        }
    }

    private class NetworkPlayerVariable {
        NetworkPlayerVariableIDs id;
        float value;

        private NetworkPlayerVariable() {
        }

        public void set(IsoPlayer isoPlayer, NetworkPlayerVariableIDs networkPlayerVariableIDs) {
            this.id = networkPlayerVariableIDs;
            this.value = isoPlayer.getVariableFloat(networkPlayerVariableIDs.name(), 0.0f);
        }
    }

    private static enum NetworkPlayerVariableIDs {
        IdleSpeed,
        WalkInjury,
        WalkSpeed,
        DeltaX,
        DeltaY,
        AttackVariationX,
        AttackVariationY,
        targetDist,
        autoShootVarX,
        autoShootVarY,
        recoilVarX,
        recoilVarY,
        ShoveAimX,
        ShoveAimY;

    }
}

