/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;

public class PlayerDataRequestPacket
implements INetworkPacket {
    short playerId = (short)-1;

    public void set(short s) {
        this.playerId = s;
    }

    public void process(UdpConnection udpConnection) {
        IsoPlayer isoPlayer = GameServer.IDToPlayerMap.get(this.playerId);
        if (udpConnection.RelevantTo(isoPlayer.x, isoPlayer.y) && !isoPlayer.isInvisible() || udpConnection.accessLevel >= 1) {
            GameServer.sendPlayerConnect(isoPlayer, udpConnection);
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.playerId = byteBuffer.getShort();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.playerId);
    }
}

