/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.SoundManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.packets.INetworkPacket;

public class PlayWorldSoundPacket
implements INetworkPacket {
    String name;
    int x;
    int y;
    byte z;

    public void set(String string, int n, int n2, byte by) {
        this.name = string;
        this.x = n;
        this.y = n2;
        this.z = by;
    }

    public void process() {
        SoundManager.instance.PlayWorldSoundImpl(this.name, false, this.x, this.y, this.z, 1.0f, 20.0f, 2.0f, false);
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.x = byteBuffer.getInt();
        this.y = byteBuffer.getInt();
        this.z = byteBuffer.get();
        this.name = GameWindow.ReadString(byteBuffer);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putInt(this.x);
        byteBufferWriter.putInt(this.y);
        byteBufferWriter.putByte(this.z);
        byteBufferWriter.putUTF(this.name);
    }

    @Override
    public boolean isConsistent() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public int getPacketSizeBytes() {
        return 12 + this.name.length();
    }

    @Override
    public String getDescription() {
        return "\n\tPlayWorldSoundPacket [name=" + this.name + " | x=" + this.x + " | y=" + this.y + " | z=" + this.z + " ]";
    }
}

