/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.IsoGameCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.MovingObject;

public class PlaySoundPacket
implements INetworkPacket {
    String name;
    MovingObject object = new MovingObject();
    boolean loop;

    public void set(String string, boolean bl, IsoMovingObject isoMovingObject) {
        this.name = string;
        this.loop = bl;
        this.object.setMovingObject(isoMovingObject);
    }

    public void process() {
        IsoMovingObject isoMovingObject = this.object.getMovingObject();
        if (isoMovingObject instanceof IsoGameCharacter) {
            BaseCharacterSoundEmitter baseCharacterSoundEmitter = ((IsoGameCharacter)isoMovingObject).getEmitter();
            if (!this.loop) {
                baseCharacterSoundEmitter.playSoundImpl(this.name, null);
            }
        } else if (isoMovingObject != null) {
            BaseSoundEmitter baseSoundEmitter = isoMovingObject.emitter;
            if (baseSoundEmitter == null) {
                baseSoundEmitter = IsoWorld.instance.getFreeEmitter(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z);
                IsoWorld.instance.takeOwnershipOfEmitter(baseSoundEmitter);
                isoMovingObject.emitter = baseSoundEmitter;
            }
            if (!this.loop) {
                baseSoundEmitter.playSoundImpl(this.name, (IsoObject)null);
            } else {
                baseSoundEmitter.playSoundLoopedImpl(this.name);
            }
            baseSoundEmitter.tick();
        }
    }

    public String getName() {
        return this.name;
    }

    public IsoMovingObject getMovingObject() {
        return this.object.getMovingObject();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.object.parse(byteBuffer, udpConnection);
        this.name = GameWindow.ReadString(byteBuffer);
        this.loop = byteBuffer.get() == 1;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        this.object.write(byteBufferWriter);
        byteBufferWriter.putUTF(this.name);
        byteBufferWriter.putByte((byte)(this.loop ? 1 : 0));
    }

    @Override
    public boolean isConsistent() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public int getPacketSizeBytes() {
        return 12 + this.name.length();
    }

    @Override
    public String getDescription() {
        return "\n\tPlaySoundPacket [name=" + this.name + " | object=" + this.object.getDescription() + " | loop=" + this.loop + " ]";
    }
}

