/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import java.util.HashMap;
import zombie.GameWindow;
import zombie.ai.states.ClimbDownSheetRopeState;
import zombie.ai.states.ClimbSheetRopeState;
import zombie.ai.states.FishingState;
import zombie.ai.states.SmashWindowState;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.NetworkPlayerVariables;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;
import zombie.util.StringUtils;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleManager;
import zombie.vehicles.VehiclePart;
import zombie.vehicles.VehicleWindow;

public class EventPacket
implements INetworkPacket {
    public static final int MAX_PLAYER_EVENTS = 10;
    private static final long EVENT_TIMEOUT = 5000L;
    private static final short EVENT_FLAGS_VAULT_OVER_SPRINT = 1;
    private static final short EVENT_FLAGS_VAULT_OVER_RUN = 2;
    private static final short EVENT_FLAGS_BUMP_FALL = 4;
    private static final short EVENT_FLAGS_BUMP_STAGGERED = 8;
    private static final short EVENT_FLAGS_ACTIVATE_ITEM = 16;
    private static final short EVENT_FLAGS_CLIMB_SUCCESS = 32;
    private static final short EVENT_FLAGS_CLIMB_STRUGGLE = 64;
    private static final short EVENT_FLAGS_BUMP_FROM_BEHIND = 128;
    private static final short EVENT_FLAGS_BUMP_TARGET_TYPE = 256;
    private static final short EVENT_FLAGS_PRESSED_MOVEMENT = 512;
    private static final short EVENT_FLAGS_PRESSED_CANCEL_ACTION = 1024;
    private static final short EVENT_FLAGS_SMASH_CAR_WINDOW = 2048;
    private static final short EVENT_FLAGS_FITNESS_FINISHED = 4096;
    private short id;
    public float x;
    public float y;
    public float z;
    private byte eventID;
    private String type1;
    private String type2;
    private String type3;
    private String type4;
    private float strafeSpeed;
    private float walkSpeed;
    private float walkInjury;
    private int booleanVariables;
    private short flags;
    private IsoPlayer player;
    private EventType event;
    private long timestamp;

    @Override
    public String getDescription() {
        return "[ player=" + this.id + " \"" + (this.player == null ? "?" : this.player.getUsername()) + "\" | name=\"" + (this.event == null ? "?" : this.event.name()) + "\" | pos=( " + this.x + " ; " + this.y + " ; " + this.z + " ) | type1=\"" + this.type1 + "\" | type2=\"" + this.type2 + "\" | type3=\"" + this.type3 + "\" | type4=\"" + this.type4 + "\" | flags=" + this.flags + "\" | variables=" + this.booleanVariables + " ]";
    }

    @Override
    public boolean isConsistent() {
        boolean bl;
        boolean bl2 = bl = this.player != null && this.event != null;
        if (!bl && Core.bDebug) {
            DebugLog.log(DebugType.Multiplayer, "[Event] is not consistent " + this.getDescription());
        }
        return bl;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.id = byteBuffer.getShort();
        this.x = byteBuffer.getFloat();
        this.y = byteBuffer.getFloat();
        this.z = byteBuffer.getFloat();
        this.eventID = byteBuffer.get();
        this.type1 = GameWindow.ReadString(byteBuffer);
        this.type2 = GameWindow.ReadString(byteBuffer);
        this.type3 = GameWindow.ReadString(byteBuffer);
        this.type4 = GameWindow.ReadString(byteBuffer);
        this.strafeSpeed = byteBuffer.getFloat();
        this.walkSpeed = byteBuffer.getFloat();
        this.walkInjury = byteBuffer.getFloat();
        this.booleanVariables = byteBuffer.getInt();
        this.flags = byteBuffer.getShort();
        if (this.eventID >= 0 && this.eventID < EventType.values().length) {
            this.event = EventType.values()[this.eventID];
        } else {
            DebugLog.Multiplayer.warn("Unknown event=" + this.eventID);
            this.event = null;
        }
        this.player = GameServer.bServer ? GameServer.IDToPlayerMap.get(this.id) : (GameClient.bClient ? GameClient.IDToPlayerMap.get(this.id) : null);
        this.timestamp = System.currentTimeMillis() + 5000L;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.id);
        byteBufferWriter.putFloat(this.x);
        byteBufferWriter.putFloat(this.y);
        byteBufferWriter.putFloat(this.z);
        byteBufferWriter.putByte(this.eventID);
        byteBufferWriter.putUTF(this.type1);
        byteBufferWriter.putUTF(this.type2);
        byteBufferWriter.putUTF(this.type3);
        byteBufferWriter.putUTF(this.type4);
        byteBufferWriter.putFloat(this.strafeSpeed);
        byteBufferWriter.putFloat(this.walkSpeed);
        byteBufferWriter.putFloat(this.walkInjury);
        byteBufferWriter.putInt(this.booleanVariables);
        byteBufferWriter.putShort(this.flags);
    }

    public boolean isRelevant(UdpConnection udpConnection) {
        return udpConnection.RelevantTo(this.x, this.y);
    }

    public boolean isMovableEvent() {
        if (this.isConsistent()) {
            return EventType.EventClimbFence.equals((Object)this.event) || EventType.EventFallClimb.equals((Object)this.event);
        }
        return false;
    }

    private boolean requireNonMoving() {
        return this.isConsistent() && (EventType.EventClimbWindow.equals((Object)this.event) || EventType.EventClimbFence.equals((Object)this.event) || EventType.EventClimbDownRope.equals((Object)this.event) || EventType.EventClimbRope.equals((Object)this.event) || EventType.EventClimbWall.equals((Object)this.event));
    }

    private IsoWindow getWindow(IsoPlayer isoPlayer) {
        for (IsoDirections isoDirections : IsoDirections.values()) {
            IsoObject isoObject = isoPlayer.getContextDoorOrWindowOrWindowFrame(isoDirections);
            if (!(isoObject instanceof IsoWindow)) continue;
            return (IsoWindow)isoObject;
        }
        return null;
    }

    private IsoObject getObject(IsoPlayer isoPlayer) {
        for (IsoDirections isoDirections : IsoDirections.values()) {
            IsoObject isoObject = isoPlayer.getContextDoorOrWindowOrWindowFrame(isoDirections);
            if (!(isoObject instanceof IsoWindow) && !(isoObject instanceof IsoThumpable) && !IsoWindowFrame.isWindowFrame(isoObject)) continue;
            return isoObject;
        }
        return null;
    }

    private IsoDirections checkCurrentIsEventGridSquareFence(IsoPlayer isoPlayer) {
        IsoGridSquare isoGridSquare = isoPlayer.getCell().getGridSquare(this.x, this.y, this.z);
        IsoGridSquare isoGridSquare2 = isoPlayer.getCell().getGridSquare(this.x, this.y + 1.0f, this.z);
        IsoGridSquare isoGridSquare3 = isoPlayer.getCell().getGridSquare(this.x + 1.0f, this.y, this.z);
        IsoDirections isoDirections = isoGridSquare != null && isoGridSquare.Is(IsoFlagType.HoppableN) ? IsoDirections.N : (isoGridSquare != null && isoGridSquare.Is(IsoFlagType.HoppableW) ? IsoDirections.W : (isoGridSquare2 != null && isoGridSquare2.Is(IsoFlagType.HoppableN) ? IsoDirections.S : (isoGridSquare3 != null && isoGridSquare3.Is(IsoFlagType.HoppableW) ? IsoDirections.E : IsoDirections.Max)));
        return isoDirections;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.timestamp;
    }

    public void tryProcess() {
        if (this.isConsistent()) {
            if (this.player.networkAI.events.size() < 10) {
                this.player.networkAI.events.add(this);
            } else {
                DebugLog.Multiplayer.warn("Event skipped: " + this.getDescription());
            }
        }
    }

    public boolean process(IsoPlayer isoPlayer) {
        boolean bl = false;
        if (this.isConsistent()) {
            isoPlayer.overridePrimaryHandModel = null;
            isoPlayer.overrideSecondaryHandModel = null;
            if (isoPlayer.getCurrentSquare() == isoPlayer.getCell().getGridSquare(this.x, this.y, this.z) && !isoPlayer.isPlayerMoving() || !this.requireNonMoving()) {
                switch (this.event) {
                    case EventSetActivatedPrimary: {
                        if (isoPlayer.getPrimaryHandItem() == null || !isoPlayer.getPrimaryHandItem().canEmitLight()) break;
                        isoPlayer.getPrimaryHandItem().setActivatedRemote((this.flags & 0x10) != 0);
                        bl = true;
                        break;
                    }
                    case EventSetActivatedSecondary: {
                        if (isoPlayer.getSecondaryHandItem() == null || !isoPlayer.getSecondaryHandItem().canEmitLight()) break;
                        isoPlayer.getSecondaryHandItem().setActivatedRemote((this.flags & 0x10) != 0);
                        bl = true;
                        break;
                    }
                    case EventFallClimb: {
                        isoPlayer.setVariable("ClimbFenceOutcome", "fall");
                        isoPlayer.setVariable("BumpDone", true);
                        isoPlayer.setFallOnFront(true);
                        bl = true;
                        break;
                    }
                    case collideWithWall: {
                        isoPlayer.setCollideType(this.type1);
                        isoPlayer.actionContext.reportEvent("collideWithWall");
                        bl = true;
                        break;
                    }
                    case EventFishing: {
                        isoPlayer.setVariable("FishingStage", this.type1);
                        if (!FishingState.instance().equals(isoPlayer.getCurrentState())) {
                            isoPlayer.setVariable("forceGetUp", true);
                            isoPlayer.actionContext.reportEvent("EventFishing");
                        }
                        bl = true;
                        break;
                    }
                    case EventFitness: {
                        isoPlayer.setVariable("ExerciseType", this.type1);
                        isoPlayer.setVariable("FitnessFinished", false);
                        isoPlayer.actionContext.reportEvent("EventFitness");
                        bl = true;
                        break;
                    }
                    case EventUpdateFitness: {
                        isoPlayer.clearVariable("ExerciseHand");
                        isoPlayer.setVariable("ExerciseType", this.type2);
                        if (!StringUtils.isNullOrEmpty(this.type1)) {
                            isoPlayer.setVariable("ExerciseHand", this.type1);
                        }
                        isoPlayer.setFitnessSpeed();
                        if ((this.flags & 0x1000) != 0) {
                            isoPlayer.setVariable("ExerciseStarted", false);
                            isoPlayer.setVariable("ExerciseEnded", true);
                        }
                        isoPlayer.setPrimaryHandItem(null);
                        isoPlayer.setSecondaryHandItem(null);
                        isoPlayer.overridePrimaryHandModel = null;
                        isoPlayer.overrideSecondaryHandModel = null;
                        isoPlayer.overridePrimaryHandModel = this.type3;
                        isoPlayer.overrideSecondaryHandModel = this.type4;
                        isoPlayer.resetModelNextFrame();
                        bl = true;
                        break;
                    }
                    case EventEmote: {
                        isoPlayer.setVariable("emote", this.type1);
                        isoPlayer.actionContext.reportEvent("EventEmote");
                        bl = true;
                        break;
                    }
                    case EventSitOnGround: {
                        isoPlayer.actionContext.reportEvent("EventSitOnGround");
                        bl = true;
                        break;
                    }
                    case EventClimbRope: {
                        isoPlayer.climbSheetRope();
                        bl = true;
                        break;
                    }
                    case EventClimbDownRope: {
                        isoPlayer.climbDownSheetRope();
                        bl = true;
                        break;
                    }
                    case EventClimbFence: {
                        IsoDirections isoDirections = this.checkCurrentIsEventGridSquareFence(isoPlayer);
                        if (isoDirections == IsoDirections.Max) break;
                        isoPlayer.climbOverFence(isoDirections);
                        if (isoPlayer.isSprinting()) {
                            isoPlayer.setVariable("VaultOverSprint", true);
                        }
                        if (isoPlayer.isRunning()) {
                            isoPlayer.setVariable("VaultOverRun", true);
                        }
                        bl = true;
                        break;
                    }
                    case EventClimbWall: {
                        isoPlayer.setClimbOverWallStruggle((this.flags & 0x40) != 0);
                        isoPlayer.setClimbOverWallSuccess((this.flags & 0x20) != 0);
                        for (IsoDirections isoDirections : IsoDirections.values()) {
                            if (!isoPlayer.climbOverWall(isoDirections)) continue;
                            return true;
                        }
                        break;
                    }
                    case EventClimbWindow: {
                        IsoObject isoObject = this.getObject(isoPlayer);
                        if (isoObject instanceof IsoWindow) {
                            isoPlayer.climbThroughWindow((IsoWindow)isoObject);
                            bl = true;
                        } else if (isoObject instanceof IsoThumpable) {
                            isoPlayer.climbThroughWindow((IsoThumpable)isoObject);
                            bl = true;
                        }
                        if (!IsoWindowFrame.isWindowFrame(isoObject)) break;
                        isoPlayer.climbThroughWindowFrame(isoObject);
                        bl = true;
                        break;
                    }
                    case EventOpenWindow: {
                        IsoWindow isoWindow = this.getWindow(isoPlayer);
                        if (isoWindow == null) break;
                        isoPlayer.openWindow(isoWindow);
                        bl = true;
                        break;
                    }
                    case EventCloseWindow: {
                        IsoWindow isoWindow = this.getWindow(isoPlayer);
                        if (isoWindow == null) break;
                        isoPlayer.closeWindow(isoWindow);
                        bl = true;
                        break;
                    }
                    case EventSmashWindow: {
                        if ((this.flags & 0x800) != 0) {
                            VehicleWindow vehicleWindow;
                            VehiclePart vehiclePart;
                            BaseVehicle baseVehicle = VehicleManager.instance.getVehicleByID(Short.parseShort(this.type1));
                            if (baseVehicle == null || (vehiclePart = baseVehicle.getPartById(this.type2)) == null || (vehicleWindow = vehiclePart.getWindow()) == null) break;
                            isoPlayer.smashCarWindow(vehiclePart);
                            bl = true;
                            break;
                        }
                        IsoWindow isoWindow = this.getWindow(isoPlayer);
                        if (isoWindow == null) break;
                        isoPlayer.smashWindow(isoWindow);
                        bl = true;
                        break;
                    }
                    case wasBumped: {
                        isoPlayer.setBumpDone(false);
                        isoPlayer.setVariable("BumpFallAnimFinished", false);
                        isoPlayer.setBumpType(this.type1);
                        isoPlayer.setBumpFallType(this.type2);
                        isoPlayer.setBumpFall((this.flags & 4) != 0);
                        isoPlayer.setBumpStaggered((this.flags & 8) != 0);
                        isoPlayer.reportEvent("wasBumped");
                        if (!StringUtils.isNullOrEmpty(this.type3) && !StringUtils.isNullOrEmpty(this.type4)) {
                            IsoGameCharacter isoGameCharacter = null;
                            isoGameCharacter = (this.flags & 0x100) != 0 ? (IsoGameCharacter)GameClient.IDToZombieMap.get(Short.parseShort(this.type3)) : (IsoGameCharacter)GameClient.IDToPlayerMap.get(Short.parseShort(this.type3));
                            if (isoGameCharacter != null) {
                                isoGameCharacter.setBumpType(this.type4);
                                isoGameCharacter.setHitFromBehind((this.flags & 0x80) != 0);
                            }
                        }
                        bl = true;
                        break;
                    }
                    case EventOverrideItem: {
                        if (isoPlayer.getNetworkCharacterAI().getAction() != null) {
                            isoPlayer.getNetworkCharacterAI().setOverride(true, this.type1, this.type2);
                        }
                        bl = true;
                        break;
                    }
                    case ChargeSpearConnect: {
                        bl = true;
                        break;
                    }
                    case Update: {
                        isoPlayer.networkAI.setPressedMovement((this.flags & 0x200) != 0);
                        isoPlayer.networkAI.setPressedCancelAction((this.flags & 0x400) != 0);
                        bl = true;
                        break;
                    }
                    default: {
                        DebugLog.Multiplayer.warn("[Event] unknown: " + this.getDescription());
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public boolean set(IsoPlayer isoPlayer, String string) {
        boolean bl = false;
        this.player = isoPlayer;
        this.id = isoPlayer.getOnlineID();
        this.x = isoPlayer.getX();
        this.y = isoPlayer.getY();
        this.z = isoPlayer.getZ();
        this.type1 = null;
        this.type2 = null;
        this.type3 = null;
        this.type4 = null;
        this.booleanVariables = NetworkPlayerVariables.getBooleanVariables(isoPlayer);
        this.strafeSpeed = isoPlayer.getVariableFloat("StrafeSpeed", 1.0f);
        this.walkSpeed = isoPlayer.getVariableFloat("WalkSpeed", 1.0f);
        this.walkInjury = isoPlayer.getVariableFloat("WalkInjury", 0.0f);
        this.flags = 0;
        for (EventType eventType : EventType.values()) {
            if (!eventType.name().equals(string)) continue;
            this.event = eventType;
            this.eventID = (byte)eventType.ordinal();
            switch (eventType) {
                case EventSetActivatedSecondary: {
                    this.flags = (short)(this.flags | (isoPlayer.getSecondaryHandItem().isActivated() ? 16 : 0));
                    break;
                }
                case EventSetActivatedPrimary: {
                    this.flags = (short)(this.flags | (isoPlayer.getPrimaryHandItem().isActivated() ? 16 : 0));
                    break;
                }
                case EventClimbFence: {
                    if (isoPlayer.getVariableBoolean("VaultOverRun")) {
                        this.flags = (short)(this.flags | 2);
                    }
                    if (!isoPlayer.getVariableBoolean("VaultOverSprint")) break;
                    this.flags = (short)(this.flags | 1);
                    break;
                }
                case collideWithWall: {
                    this.type1 = isoPlayer.getCollideType();
                    break;
                }
                case EventEmote: {
                    this.type1 = isoPlayer.getVariableString("emote");
                    break;
                }
                case EventFishing: {
                    this.type1 = isoPlayer.getVariableString("FishingStage");
                    break;
                }
                case EventFitness: {
                    this.type1 = isoPlayer.getVariableString("ExerciseType");
                    break;
                }
                case EventUpdateFitness: {
                    this.type1 = isoPlayer.getVariableString("ExerciseHand");
                    this.type2 = isoPlayer.getVariableString("ExerciseType");
                    if (isoPlayer.getPrimaryHandItem() != null) {
                        this.type3 = isoPlayer.getPrimaryHandItem().getStaticModel();
                    }
                    if (isoPlayer.getSecondaryHandItem() != null && isoPlayer.getSecondaryHandItem() != isoPlayer.getPrimaryHandItem()) {
                        this.type4 = isoPlayer.getSecondaryHandItem().getStaticModel();
                    }
                    this.flags = (short)(this.flags | (isoPlayer.getVariableBoolean("FitnessFinished") ? 4096 : 0));
                    break;
                }
                case wasBumped: {
                    this.type1 = isoPlayer.getBumpType();
                    this.type2 = isoPlayer.getBumpFallType();
                    this.flags = (short)(this.flags | (isoPlayer.isBumpFall() ? 4 : 0));
                    this.flags = (short)(this.flags | (isoPlayer.isBumpStaggered() ? 8 : 0));
                    if (isoPlayer.getBumpedChr() == null) break;
                    this.type3 = String.valueOf(isoPlayer.getBumpedChr().getOnlineID());
                    this.type4 = isoPlayer.getBumpedChr().getBumpType();
                    this.flags = (short)(this.flags | (isoPlayer.isHitFromBehind() ? 128 : 0));
                    if (!(isoPlayer.getBumpedChr() instanceof IsoZombie)) break;
                    this.flags = (short)(this.flags | 0x100);
                    break;
                }
                case EventClimbWall: {
                    this.flags = (short)(this.flags | (isoPlayer.isClimbOverWallSuccess() ? 32 : 0));
                    this.flags = (short)(this.flags | (isoPlayer.isClimbOverWallStruggle() ? 64 : 0));
                    break;
                }
                case EventOverrideItem: {
                    Object object;
                    if (isoPlayer.getNetworkCharacterAI().getAction() != null) {
                        object = isoPlayer.getNetworkCharacterAI().getAction();
                        this.type1 = ((BaseAction)object).getPrimaryHandItem() == null ? ((BaseAction)object).getPrimaryHandMdl() : ((BaseAction)object).getPrimaryHandItem().getStaticModel();
                        this.type2 = ((BaseAction)object).getSecondaryHandItem() == null ? ((BaseAction)object).getSecondaryHandMdl() : ((BaseAction)object).getSecondaryHandItem().getStaticModel();
                        break;
                    }
                    return false;
                }
                case Update: {
                    this.flags = (short)(this.flags | (isoPlayer.networkAI.isPressedMovement() ? 512 : 0));
                    this.flags = (short)(this.flags | (isoPlayer.networkAI.isPressedCancelAction() ? 1024 : 0));
                    break;
                }
                case EventSmashWindow: {
                    Object object = isoPlayer.getStateMachineParams(SmashWindowState.instance());
                    if (!(((HashMap)object).get(1) instanceof BaseVehicle) || !(((HashMap)object).get(2) instanceof VehiclePart)) break;
                    BaseVehicle baseVehicle = (BaseVehicle)((HashMap)object).get(1);
                    VehiclePart vehiclePart = (VehiclePart)((HashMap)object).get(2);
                    this.flags = (short)(this.flags | 0x800);
                    this.type1 = String.valueOf(baseVehicle.getId());
                    this.type2 = vehiclePart.getId();
                    break;
                }
                case EventFallClimb: 
                case EventSitOnGround: 
                case EventClimbRope: 
                case EventClimbDownRope: 
                case EventClimbWindow: 
                case EventOpenWindow: 
                case EventCloseWindow: 
                case ChargeSpearConnect: {
                    break;
                }
                default: {
                    DebugLog.Multiplayer.warn("[Event] unknown " + this.getDescription());
                    return false;
                }
            }
            bl = !ClimbDownSheetRopeState.instance().equals(isoPlayer.getCurrentState()) && !ClimbSheetRopeState.instance().equals(isoPlayer.getCurrentState());
        }
        return bl;
    }

    public static enum EventType {
        EventSetActivatedPrimary,
        EventSetActivatedSecondary,
        EventFishing,
        EventFitness,
        EventEmote,
        EventClimbFence,
        EventClimbDownRope,
        EventClimbRope,
        EventClimbWall,
        EventClimbWindow,
        EventOpenWindow,
        EventCloseWindow,
        EventSmashWindow,
        EventSitOnGround,
        wasBumped,
        collideWithWall,
        EventUpdateFitness,
        EventFallClimb,
        EventOverrideItem,
        ChargeSpearConnect,
        Update,
        Unknown;

    }
}

