/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.IZomboidPacket;
import zombie.network.PacketTypes;

public class ZomboidNetData
implements IZomboidPacket {
    public PacketTypes.PacketType type;
    public short length;
    public ByteBuffer buffer;
    public long connection;
    public long time;

    public ZomboidNetData() {
        this.buffer = ByteBuffer.allocate(2048);
    }

    public ZomboidNetData(int n) {
        this.buffer = ByteBuffer.allocate(n);
    }

    public void reset() {
        this.type = null;
        this.length = 0;
        this.connection = 0L;
        this.buffer.clear();
    }

    public void read(short s, ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.type = PacketTypes.packetTypes.get(s);
        if (this.type == null) {
            DebugLog.Multiplayer.error("Received unknown packet id=%d", s);
        }
        this.connection = udpConnection.getConnectedGUID();
        this.buffer.put(byteBuffer);
        this.buffer.flip();
    }

    @Override
    public boolean isConnect() {
        return false;
    }

    @Override
    public boolean isDisconnect() {
        return false;
    }
}

