/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoDirections;

public final class TableNetworkUtils {
    private static final byte SBYT_NO_SAVE = -1;
    private static final byte SBYT_STRING = 0;
    private static final byte SBYT_DOUBLE = 1;
    private static final byte SBYT_TABLE = 2;
    private static final byte SBYT_BOOLEAN = 3;
    private static final byte SBYT_ITEM = 4;
    private static final byte SBYT_DIRECTION = 5;

    public static void save(KahluaTable kahluaTable, ByteBuffer byteBuffer) throws IOException {
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        int n = 0;
        while (kahluaTableIterator.advance()) {
            if (!TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
            ++n;
        }
        kahluaTableIterator = kahluaTable.iterator();
        byteBuffer.putInt(n);
        while (kahluaTableIterator.advance()) {
            byte by = TableNetworkUtils.getKeyByte(kahluaTableIterator.getKey());
            byte by2 = TableNetworkUtils.getValueByte(kahluaTableIterator.getValue());
            if (by == -1 || by2 == -1) continue;
            TableNetworkUtils.save(byteBuffer, by, kahluaTableIterator.getKey());
            TableNetworkUtils.save(byteBuffer, by2, kahluaTableIterator.getValue());
        }
    }

    public static void saveSome(KahluaTable kahluaTable, ByteBuffer byteBuffer, HashSet<? extends Object> hashSet) throws IOException {
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        int n = 0;
        while (kahluaTableIterator.advance()) {
            if (!hashSet.contains(kahluaTableIterator.getKey()) || !TableNetworkUtils.canSave(kahluaTableIterator.getKey(), kahluaTableIterator.getValue())) continue;
            ++n;
        }
        kahluaTableIterator = kahluaTable.iterator();
        byteBuffer.putInt(n);
        while (kahluaTableIterator.advance()) {
            if (!hashSet.contains(kahluaTableIterator.getKey())) continue;
            byte by = TableNetworkUtils.getKeyByte(kahluaTableIterator.getKey());
            byte by2 = TableNetworkUtils.getValueByte(kahluaTableIterator.getValue());
            if (by == -1 || by2 == -1) continue;
            TableNetworkUtils.save(byteBuffer, by, kahluaTableIterator.getKey());
            TableNetworkUtils.save(byteBuffer, by2, kahluaTableIterator.getValue());
        }
    }

    private static void save(ByteBuffer byteBuffer, byte by, Object object) throws IOException, RuntimeException {
        byteBuffer.put(by);
        if (by == 0) {
            GameWindow.WriteString(byteBuffer, (String)object);
        } else if (by == 1) {
            byteBuffer.putDouble((Double)object);
        } else if (by == 3) {
            byteBuffer.put((Boolean)object != false ? (byte)1 : 0);
        } else if (by == 2) {
            TableNetworkUtils.save((KahluaTable)object, byteBuffer);
        } else if (by == 4) {
            ((InventoryItem)object).saveWithSize(byteBuffer, false);
        } else if (by == 5) {
            byteBuffer.put((byte)((IsoDirections)((Object)object)).index());
        } else {
            throw new RuntimeException("invalid lua table type " + by);
        }
    }

    public static void load(KahluaTable kahluaTable, ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        kahluaTable.wipe();
        for (int i = 0; i < n; ++i) {
            byte by = byteBuffer.get();
            Object object = TableNetworkUtils.load(byteBuffer, by);
            byte by2 = byteBuffer.get();
            Object object2 = TableNetworkUtils.load(byteBuffer, by2);
            kahluaTable.rawset(object, object2);
        }
    }

    public static Object load(ByteBuffer byteBuffer, byte by) throws IOException, RuntimeException {
        if (by == 0) {
            return GameWindow.ReadString(byteBuffer);
        }
        if (by == 1) {
            return byteBuffer.getDouble();
        }
        if (by == 3) {
            return byteBuffer.get() == 1;
        }
        if (by == 2) {
            KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.platform.newTable();
            TableNetworkUtils.load((KahluaTable)kahluaTableImpl, byteBuffer);
            return kahluaTableImpl;
        }
        if (by == 4) {
            InventoryItem inventoryItem = null;
            try {
                inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return inventoryItem;
        }
        if (by == 5) {
            return IsoDirections.fromIndex(byteBuffer.get());
        }
        throw new RuntimeException("invalid lua table type " + by);
    }

    private static byte getKeyByte(Object object) {
        if (object instanceof String) {
            return 0;
        }
        if (object instanceof Double) {
            return 1;
        }
        return -1;
    }

    private static byte getValueByte(Object object) {
        if (object instanceof String) {
            return 0;
        }
        if (object instanceof Double) {
            return 1;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof KahluaTableImpl) {
            return 2;
        }
        if (object instanceof InventoryItem) {
            return 4;
        }
        if (object instanceof IsoDirections) {
            return 5;
        }
        return -1;
    }

    public static boolean canSave(Object object, Object object2) {
        return TableNetworkUtils.getKeyByte(object) != -1 && TableNetworkUtils.getValueByte(object2) != -1;
    }
}

