/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.CRC32;
import zombie.GameTime;
import zombie.ZomboidFileSystem;
import zombie.core.logger.LoggerManager;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.WorldReuserThread;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.ChunkChecksum;
import zombie.network.ClientChunkRequest;
import zombie.network.GameServer;
import zombie.network.MPStatistic;
import zombie.network.MPStatistics;
import zombie.network.ServerMap;

public class ServerChunkLoader {
    private long debugSlowMapLoadingDelay = 0L;
    private boolean MapLoading = false;
    private LoaderThread threadLoad;
    private SaveChunkThread threadSave;
    private final CRC32 crcSave = new CRC32();
    private RecalcAllThread threadRecalc;

    public ServerChunkLoader() {
        this.threadLoad = new LoaderThread();
        this.threadLoad.setName("LoadChunk");
        this.threadLoad.setDaemon(true);
        this.threadLoad.start();
        this.threadRecalc = new RecalcAllThread();
        this.threadRecalc.setName("RecalcAll");
        this.threadRecalc.setDaemon(true);
        this.threadRecalc.setPriority(10);
        this.threadRecalc.start();
        this.threadSave = new SaveChunkThread();
        this.threadSave.setName("SaveChunk");
        this.threadSave.setDaemon(true);
        this.threadSave.start();
    }

    public void addJob(ServerMap.ServerCell serverCell) {
        this.MapLoading = DebugType.Do(DebugType.MapLoading);
        this.threadLoad.toThread.add(serverCell);
        MPStatistic.getInstance().LoaderThreadTasks.Added();
    }

    public void getLoaded(ArrayList<ServerMap.ServerCell> arrayList) {
        this.threadLoad.fromThread.drainTo(arrayList);
    }

    public void quit() {
        this.threadLoad.quit();
        while (this.threadLoad.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadSave.quit();
        while (this.threadSave.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addSaveUnloadedJob(IsoChunk isoChunk) {
        this.threadSave.addUnloadedJob(isoChunk);
    }

    public void addSaveLoadedJob(IsoChunk isoChunk) {
        this.threadSave.addLoadedJob(isoChunk);
    }

    public void saveLater(GameTime gameTime) {
        this.threadSave.saveLater(gameTime);
    }

    public void updateSaved() {
        this.threadSave.update();
    }

    public void addRecalcJob(ServerMap.ServerCell serverCell) {
        this.threadRecalc.toThread.add(serverCell);
        MPStatistic.getInstance().RecalcThreadTasks.Added();
    }

    public void getRecalc(ArrayList<ServerMap.ServerCell> arrayList) {
        MPStatistic.getInstance().ServerMapLoaded2.Added(this.threadRecalc.fromThread.size());
        this.threadRecalc.fromThread.drainTo(arrayList);
        MPStatistic.getInstance().RecalcThreadTasks.Processed();
    }

    private class LoaderThread
    extends Thread {
        private final LinkedBlockingQueue<ServerMap.ServerCell> toThread = new LinkedBlockingQueue();
        private final LinkedBlockingQueue<ServerMap.ServerCell> fromThread = new LinkedBlockingQueue();
        ArrayDeque<IsoGridSquare> isoGridSquareCache = new ArrayDeque();

        private LoaderThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        MPStatistic.getInstance().LoaderThread.End();
                        ServerMap.ServerCell serverCell = this.toThread.take();
                        MPStatistic.getInstance().LoaderThread.Start();
                        if (this.isoGridSquareCache.size() < 10000) {
                            IsoGridSquare.getSquaresForThread(this.isoGridSquareCache, 10000);
                            IsoGridSquare.loadGridSquareCache = this.isoGridSquareCache;
                        }
                        if (serverCell.WX == -1 && serverCell.WY == -1) {
                            return;
                        }
                        if (serverCell.bCancelLoading) {
                            if (ServerChunkLoader.this.MapLoading) {
                                DebugLog.log(DebugType.MapLoading, "LoaderThread: cancelled " + serverCell.WX + "," + serverCell.WY);
                            }
                            serverCell.bLoadingWasCancelled = true;
                            continue;
                        }
                        long l = System.nanoTime();
                        for (int i = 0; i < 5; ++i) {
                            for (int j = 0; j < 5; ++j) {
                                int n = serverCell.WX * 5 + i;
                                int n2 = serverCell.WY * 5 + j;
                                if (!IsoWorld.instance.MetaGrid.isValidChunk(n, n2)) continue;
                                IsoChunk isoChunk = IsoChunkMap.chunkStore.poll();
                                if (isoChunk == null) {
                                    isoChunk = new IsoChunk(null);
                                } else {
                                    MPStatistics.decreaseStoredChunk();
                                }
                                ServerChunkLoader.this.threadSave.saveNow(n, n2);
                                try {
                                    if (isoChunk.LoadOrCreate(n, n2, null)) {
                                        isoChunk.bLoaded = true;
                                    } else {
                                        ChunkChecksum.setChecksum(n, n2, 0L);
                                        isoChunk.Blam(n, n2);
                                        if (isoChunk.LoadBrandNew(n, n2)) {
                                            isoChunk.bLoaded = true;
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    LoggerManager.getLogger("map").write(exception);
                                }
                                if (!isoChunk.bLoaded) continue;
                                serverCell.chunks[i][j] = isoChunk;
                            }
                        }
                        if (GameServer.bDebug && ServerChunkLoader.this.debugSlowMapLoadingDelay > 0L) {
                            Thread.sleep(ServerChunkLoader.this.debugSlowMapLoadingDelay);
                        }
                        float f = (float)(System.nanoTime() - l) / 1000000.0f;
                        MPStatistic.getInstance().IncrementLoadCellFromDisk();
                        this.fromThread.add(serverCell);
                        MPStatistic.getInstance().LoaderThreadTasks.Processed();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    LoggerManager.getLogger("map").write(exception);
                    continue;
                }
                break;
            }
        }

        public void quit() {
            ServerMap.ServerCell serverCell = new ServerMap.ServerCell();
            serverCell.WX = -1;
            serverCell.WY = -1;
            this.toThread.add(serverCell);
            MPStatistic.getInstance().LoaderThreadTasks.Added();
        }
    }

    private class RecalcAllThread
    extends Thread {
        private final LinkedBlockingQueue<ServerMap.ServerCell> toThread = new LinkedBlockingQueue();
        private final LinkedBlockingQueue<ServerMap.ServerCell> fromThread = new LinkedBlockingQueue();
        private final GetSquare serverCellGetSquare = new GetSquare();

        private RecalcAllThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.runInner();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void runInner() throws InterruptedException {
            IsoGridSquare isoGridSquare;
            int n;
            int n2;
            IsoChunk isoChunk;
            int n3;
            int n4;
            MPStatistic.getInstance().RecalcAllThread.End();
            ServerMap.ServerCell serverCell = this.toThread.take();
            MPStatistic.getInstance().RecalcAllThread.Start();
            if (serverCell.bCancelLoading && !this.hasAnyBrandNewChunks(serverCell)) {
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        IsoChunk isoChunk2 = serverCell.chunks[j][i];
                        if (isoChunk2 == null) continue;
                        serverCell.chunks[j][i] = null;
                        WorldReuserThread.instance.addReuseChunk(isoChunk2);
                    }
                }
                if (ServerChunkLoader.this.MapLoading) {
                    DebugLog.log(DebugType.MapLoading, "RecalcAllThread: cancelled " + serverCell.WX + "," + serverCell.WY);
                }
                serverCell.bLoadingWasCancelled = true;
                return;
            }
            long l = System.nanoTime();
            this.serverCellGetSquare.cell = serverCell;
            int n5 = serverCell.WX * 50;
            int n6 = serverCell.WY * 50;
            int n7 = n5 + 50;
            int n8 = n6 + 50;
            int n9 = 0;
            int n10 = 100;
            for (n4 = 0; n4 < 5; ++n4) {
                for (n3 = 0; n3 < 5; ++n3) {
                    isoChunk = serverCell.chunks[n4][n3];
                    if (isoChunk == null) continue;
                    isoChunk.bLoaded = false;
                    for (n2 = 0; n2 < n10; ++n2) {
                        for (n = 0; n <= isoChunk.maxLevel; ++n) {
                            isoGridSquare = isoChunk.squares[n][n2];
                            if (n == 0) {
                                if (isoGridSquare == null) {
                                    int n11 = isoChunk.wx * 10 + n2 % 10;
                                    int n12 = isoChunk.wy * 10 + n2 / 10;
                                    isoGridSquare = IsoGridSquare.getNew(IsoWorld.instance.CurrentCell, null, n11, n12, n);
                                    isoChunk.setSquare(n11 % 10, n12 % 10, n, isoGridSquare);
                                }
                                if (isoGridSquare.getFloor() == null) {
                                    DebugLog.log("ERROR: added floor at " + isoGridSquare.x + "," + isoGridSquare.y + "," + isoGridSquare.z + " because there wasn't one");
                                    IsoObject isoObject = IsoObject.getNew();
                                    isoObject.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, "carpentry_02_58", 0);
                                    isoObject.square = isoGridSquare;
                                    isoGridSquare.getObjects().add(0, isoObject);
                                }
                            }
                            if (isoGridSquare == null) continue;
                            isoGridSquare.RecalcProperties();
                        }
                    }
                    if (isoChunk.maxLevel <= n9) continue;
                    n9 = isoChunk.maxLevel;
                }
            }
            for (n4 = 0; n4 < 5; ++n4) {
                for (n3 = 0; n3 < 5; ++n3) {
                    isoChunk = serverCell.chunks[n4][n3];
                    if (isoChunk == null) continue;
                    for (n2 = 0; n2 < n10; ++n2) {
                        for (n = 0; n <= isoChunk.maxLevel; ++n) {
                            isoGridSquare = isoChunk.squares[n][n2];
                            if (isoGridSquare == null) continue;
                            if (n > 0 && !isoGridSquare.getObjects().isEmpty()) {
                                this.serverCellGetSquare.EnsureSurroundNotNull(isoGridSquare.x - n5, isoGridSquare.y - n6, n);
                            }
                            isoGridSquare.RecalcAllWithNeighbours(true, this.serverCellGetSquare);
                        }
                    }
                }
            }
            for (n4 = 0; n4 < 5; ++n4) {
                for (n3 = 0; n3 < 5; ++n3) {
                    isoChunk = serverCell.chunks[n4][n3];
                    if (isoChunk == null) continue;
                    block12: for (n2 = 0; n2 < n10; ++n2) {
                        for (n = isoChunk.maxLevel; n > 0; --n) {
                            isoGridSquare = isoChunk.squares[n][n2];
                            if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.solidfloor)) continue;
                            --n;
                            while (n >= 0) {
                                isoGridSquare = isoChunk.squares[n][n2];
                                if (isoGridSquare != null) {
                                    isoGridSquare.haveRoof = true;
                                    isoGridSquare.getProperties().UnSet(IsoFlagType.exterior);
                                }
                                --n;
                            }
                            continue block12;
                        }
                    }
                }
            }
            if (GameServer.bDebug && ServerChunkLoader.this.debugSlowMapLoadingDelay > 0L) {
                Thread.sleep(ServerChunkLoader.this.debugSlowMapLoadingDelay);
            }
            float f = (float)(System.nanoTime() - l) / 1000000.0f;
            if (ServerChunkLoader.this.MapLoading) {
                DebugLog.log(DebugType.MapLoading, "RecalcAll for cell " + serverCell.WX + "," + serverCell.WY + " ms=" + f);
            }
            this.fromThread.add(serverCell);
        }

        private boolean hasAnyBrandNewChunks(ServerMap.ServerCell serverCell) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IsoChunk isoChunk = serverCell.chunks[j][i];
                    if (isoChunk == null || isoChunk.getErosionData().init) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class SaveChunkThread
    extends Thread {
        private final LinkedBlockingQueue<SaveTask> toThread = new LinkedBlockingQueue();
        private final LinkedBlockingQueue<SaveTask> fromThread = new LinkedBlockingQueue();
        private boolean quit = false;
        private final CRC32 crc32 = new CRC32();
        private final ClientChunkRequest ccr = new ClientChunkRequest();
        private final ArrayList<SaveTask> toSaveChunk = new ArrayList();
        private final ArrayList<SaveTask> savedChunks = new ArrayList();

        private SaveChunkThread() {
        }

        @Override
        public void run() {
            do {
                SaveTask saveTask = null;
                try {
                    MPStatistic.getInstance().SaveThread.End();
                    saveTask = this.toThread.take();
                    MPStatistic.getInstance().SaveThread.Start();
                    MPStatistic.getInstance().IncrementSaveCellToDisk();
                    saveTask.save();
                    this.fromThread.add(saveTask);
                    MPStatistic.getInstance().SaveTasks.Processed();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (saveTask != null) {
                        LoggerManager.getLogger("map").write("Error saving chunk " + saveTask.wx() + "," + saveTask.wy());
                    }
                    LoggerManager.getLogger("map").write(exception);
                }
            } while (!this.quit || !this.toThread.isEmpty());
        }

        public void addUnloadedJob(IsoChunk isoChunk) {
            this.toThread.add(new SaveUnloadedTask(isoChunk));
            MPStatistic.getInstance().SaveTasks.SaveUnloadedTasksAdded();
        }

        public void addLoadedJob(IsoChunk isoChunk) {
            ClientChunkRequest.Chunk chunk = this.ccr.getChunk();
            chunk.wx = isoChunk.wx;
            chunk.wy = isoChunk.wy;
            this.ccr.getByteBuffer(chunk);
            try {
                isoChunk.SaveLoadedChunk(chunk, this.crc32);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LoggerManager.getLogger("map").write(exception);
                this.ccr.releaseChunk(chunk);
                return;
            }
            this.toThread.add(new SaveLoadedTask(this.ccr, chunk));
            MPStatistic.getInstance().SaveTasks.SaveLoadedTasksAdded();
        }

        public void saveLater(GameTime gameTime) {
            this.toThread.add(new SaveGameTimeTask(gameTime));
            MPStatistic.getInstance().SaveTasks.SaveGameTimeTasksAdded();
        }

        public void saveNow(int n, int n2) {
            this.toSaveChunk.clear();
            this.toThread.drainTo(this.toSaveChunk);
            for (int i = 0; i < this.toSaveChunk.size(); ++i) {
                SaveTask saveTask = this.toSaveChunk.get(i);
                if (saveTask.wx() != n || saveTask.wy() != n2) continue;
                try {
                    this.toSaveChunk.remove(i--);
                    saveTask.save();
                    MPStatistic.getInstance().IncrementServerChunkThreadSaveNow();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    LoggerManager.getLogger("map").write("Error saving chunk " + n + "," + n2);
                    LoggerManager.getLogger("map").write(exception);
                }
                MPStatistic.getInstance().SaveTasks.Processed();
                this.fromThread.add(saveTask);
            }
            this.toThread.addAll(this.toSaveChunk);
        }

        public void quit() {
            this.toThread.add(new QuitThreadTask());
            MPStatistic.getInstance().SaveTasks.QuitThreadTasksAdded();
        }

        public void update() {
            this.savedChunks.clear();
            this.fromThread.drainTo(this.savedChunks);
            for (int i = 0; i < this.savedChunks.size(); ++i) {
                this.savedChunks.get(i).release();
            }
            this.savedChunks.clear();
        }
    }

    private class GetSquare
    implements IsoGridSquare.GetSquare {
        ServerMap.ServerCell cell;

        private GetSquare() {
        }

        @Override
        public IsoGridSquare getGridSquare(int n, int n2, int n3) {
            n2 -= this.cell.WY * 50;
            if ((n -= this.cell.WX * 50) < 0 || n >= 50) {
                return null;
            }
            if (n2 < 0 || n2 >= 50) {
                return null;
            }
            IsoChunk isoChunk = this.cell.chunks[n / 10][n2 / 10];
            if (isoChunk == null) {
                return null;
            }
            return isoChunk.getGridSquare(n % 10, n2 % 10, n3);
        }

        public boolean contains(int n, int n2, int n3) {
            if (n < 0 || n >= 50) {
                return false;
            }
            return n2 >= 0 && n2 < 50;
        }

        public IsoChunk getChunkForSquare(int n, int n2) {
            n2 -= this.cell.WY * 50;
            if ((n -= this.cell.WX * 50) < 0 || n >= 50) {
                return null;
            }
            if (n2 < 0 || n2 >= 50) {
                return null;
            }
            return this.cell.chunks[n / 10][n2 / 10];
        }

        public void EnsureSurroundNotNull(int n, int n2, int n3) {
            int n4 = this.cell.WX * 50;
            int n5 = this.cell.WY * 50;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    IsoGridSquare isoGridSquare;
                    if (i == 0 && j == 0 || !this.contains(n + i, n2 + j, n3) || (isoGridSquare = this.getGridSquare(n4 + n + i, n5 + n2 + j, n3)) != null) continue;
                    isoGridSquare = IsoGridSquare.getNew(IsoWorld.instance.CurrentCell, null, n4 + n + i, n5 + n2 + j, n3);
                    int n6 = (n + i) / 10;
                    int n7 = (n2 + j) / 10;
                    int n8 = (n + i) % 10;
                    int n9 = (n2 + j) % 10;
                    if (this.cell.chunks[n6][n7] == null) continue;
                    this.cell.chunks[n6][n7].setSquare(n8, n9, n3, isoGridSquare);
                }
            }
        }
    }

    private class QuitThreadTask
    implements SaveTask {
        private QuitThreadTask() {
        }

        @Override
        public void save() throws Exception {
            ServerChunkLoader.this.threadSave.quit = true;
        }

        @Override
        public void release() {
        }

        @Override
        public int wx() {
            return 0;
        }

        @Override
        public int wy() {
            return 0;
        }
    }

    private class SaveGameTimeTask
    implements SaveTask {
        private byte[] bytes;

        public SaveGameTimeTask(GameTime gameTime) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
                 DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                gameTime.save(dataOutputStream);
                dataOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        @Override
        public void save() throws Exception {
            if (this.bytes != null) {
                File file = ZomboidFileSystem.instance.getFileInCurrentSave("map_t.bin");
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(this.bytes);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        }

        @Override
        public void release() {
        }

        @Override
        public int wx() {
            return 0;
        }

        @Override
        public int wy() {
            return 0;
        }
    }

    private class SaveLoadedTask
    implements SaveTask {
        private final ClientChunkRequest ccr;
        private final ClientChunkRequest.Chunk chunk;

        public SaveLoadedTask(ClientChunkRequest clientChunkRequest, ClientChunkRequest.Chunk chunk) {
            this.ccr = clientChunkRequest;
            this.chunk = chunk;
        }

        @Override
        public void save() throws Exception {
            long l = ChunkChecksum.getChecksumIfExists(this.chunk.wx, this.chunk.wy);
            ServerChunkLoader.this.crcSave.reset();
            ServerChunkLoader.this.crcSave.update(this.chunk.bb.array(), 0, this.chunk.bb.position());
            if (l != ServerChunkLoader.this.crcSave.getValue()) {
                ChunkChecksum.setChecksum(this.chunk.wx, this.chunk.wy, ServerChunkLoader.this.crcSave.getValue());
                IsoChunk.SafeWrite("map_", this.chunk.wx, this.chunk.wy, this.chunk.bb);
            }
        }

        @Override
        public void release() {
            this.ccr.releaseChunk(this.chunk);
        }

        @Override
        public int wx() {
            return this.chunk.wx;
        }

        @Override
        public int wy() {
            return this.chunk.wy;
        }
    }

    private class SaveUnloadedTask
    implements SaveTask {
        private final IsoChunk chunk;

        public SaveUnloadedTask(IsoChunk isoChunk) {
            this.chunk = isoChunk;
        }

        @Override
        public void save() throws Exception {
            this.chunk.Save(false);
        }

        @Override
        public void release() {
            WorldReuserThread.instance.addReuseChunk(this.chunk);
        }

        @Override
        public int wx() {
            return this.chunk.wx;
        }

        @Override
        public int wy() {
            return this.chunk.wy;
        }
    }

    private static interface SaveTask {
        public void save() throws Exception;

        public void release();

        public int wx();

        public int wy();
    }
}

