/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.packets.PlayerPacket;

public class ReplayManager {
    private static final int ReplayManagerVersion = 1;
    private State state = State.Stop;
    private IsoPlayer player = null;
    private ByteBuffer bbpp = ByteBuffer.allocate(43);
    private FileOutputStream outStream = null;
    private DataOutputStream output = null;
    private FileInputStream inStream = null;
    private DataInputStream input = null;
    private int inputVersion = 0;
    private long inputTimeShift = 0L;
    private PlayerPacket nextpp = null;
    private long nextppTime = 0L;

    public ReplayManager(IsoPlayer isoPlayer) {
        this.player = isoPlayer;
    }

    public State getState() {
        return this.state;
    }

    public boolean isPlay() {
        return this.state == State.Playing;
    }

    public void recordPlayerPacket(PlayerPacket playerPacket) {
        if (this.state != State.Recording || playerPacket.id != this.player.OnlineID) {
            return;
        }
        this.bbpp.position(0);
        ByteBufferWriter byteBufferWriter = new ByteBufferWriter(this.bbpp);
        playerPacket.write(byteBufferWriter);
        try {
            this.output.writeLong(GameTime.getServerTime());
            this.output.write(PacketTypes.PacketType.PlayerUpdate.getId());
            this.output.write(byteBufferWriter.bb.array());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean startRecordReplay(IsoPlayer isoPlayer, String string) {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave(string);
        if (this.player != null && this.state == State.Recording) {
            DebugLog.log("ReplayManager: record replay already active for " + this.player.getUsername() + " user");
            return false;
        }
        if (file.exists()) {
            DebugLog.log("ReplayManager: invalid filename \"" + string + "\"");
            return false;
        }
        try {
            this.outStream = new FileOutputStream(file);
            this.output = new DataOutputStream(this.outStream);
            this.output.write(1);
            this.output.writeLong(GameTime.getServerTime());
            this.player = isoPlayer;
            this.state = State.Recording;
            return true;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    public boolean stopRecordReplay() {
        if (this.state != State.Recording) {
            DebugLog.log("ReplayManager: record inactive");
            return false;
        }
        try {
            this.state = State.Stop;
            this.player = null;
            this.output.flush();
            this.output.close();
            this.outStream.close();
            this.output = null;
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean startPlayReplay(IsoPlayer isoPlayer, String string, UdpConnection udpConnection) {
        File file = ZomboidFileSystem.instance.getFileInCurrentSave(string);
        if (this.state == State.Playing) {
            DebugLog.log("ReplayManager: play replay already active for " + this.player.getUsername() + " user");
            return false;
        }
        if (!file.exists()) {
            DebugLog.log("ReplayManager: invalid filename \"" + string + "\"");
            return false;
        }
        try {
            this.inStream = new FileInputStream(file);
            this.input = new DataInputStream(this.inStream);
            this.inputVersion = this.input.read();
            this.inputTimeShift = GameTime.getServerTime() - this.input.readLong();
            this.nextppTime = this.input.readLong();
            int n = this.input.read();
            if (n == PacketTypes.PacketType.PlayerUpdate.getId() || n == PacketTypes.PacketType.PlayerUpdateReliable.getId()) {
                this.input.read(this.bbpp.array());
                this.bbpp.position(0);
                this.nextpp = new PlayerPacket();
                this.nextpp.parse(this.bbpp, udpConnection);
            }
            this.player = isoPlayer;
            this.state = State.Playing;
            return true;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            return false;
        }
    }

    public boolean stopPlayReplay() {
        if (this.state != State.Playing) {
            DebugLog.log("ReplayManager: play inactive");
            return false;
        }
        try {
            this.state = State.Stop;
            this.player = null;
            this.input.close();
            this.inStream.close();
            this.input = null;
            this.inputVersion = 0;
            this.inputTimeShift = 0L;
            this.nextpp = null;
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public void update() {
        if (this.state != State.Playing) {
            return;
        }
        if (GameTime.getServerTime() >= this.nextppTime + this.inputTimeShift) {
            int n;
            this.nextpp.id = this.player.OnlineID;
            this.nextpp.realt = (int)((long)this.nextpp.realt + this.inputTimeShift / 1000000L);
            IsoPlayer isoPlayer = GameServer.IDToPlayerMap.get(this.nextpp.id);
            UdpConnection udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
            try {
                if (isoPlayer == null) {
                    DebugLog.General.error("receivePlayerUpdate: Server received position for unknown player (id:" + this.nextpp.id + "). Server will ignore this data.");
                } else {
                    isoPlayer.networkAI.parse(this.nextpp);
                    udpConnection.ReleventPos[isoPlayer.PlayerIndex].x = this.nextpp.realx;
                    udpConnection.ReleventPos[isoPlayer.PlayerIndex].y = this.nextpp.realy;
                    udpConnection.ReleventPos[isoPlayer.PlayerIndex].z = this.nextpp.realz;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(n);
                if (udpConnection.getConnectedGUID() == udpConnection2.getConnectedGUID()) continue;
                ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                PacketTypes.PacketType.PlayerUpdate.doPacket(byteBufferWriter);
                this.nextpp.write(byteBufferWriter);
                PacketTypes.PacketType.PlayerUpdate.send(udpConnection2);
            }
            try {
                this.nextppTime = this.input.readLong();
                n = this.input.read();
                if (n == PacketTypes.PacketType.PlayerUpdate.getId() || n == PacketTypes.PacketType.PlayerUpdateReliable.getId()) {
                    this.bbpp.position(0);
                    this.input.read(this.bbpp.array());
                    this.bbpp.position(0);
                    this.nextpp = new PlayerPacket();
                    this.nextpp.parse(this.bbpp, udpConnection);
                }
            }
            catch (IOException iOException) {
                DebugLog.log("ReplayManager: stop playing replay");
                this.stopPlayReplay();
            }
        }
    }

    public static enum State {
        Stop,
        Recording,
        Playing;

    }
}

