/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import zombie.GameWindow;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.debug.LogSeverity;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerWorldDatabase;
import zombie.network.Userlog;
import zombie.scripting.ScriptManager;

public final class NetChecksum {
    public static final Checksummer checksummer = new Checksummer();
    public static final Comparer comparer = new Comparer();

    private static void noise(String string) {
        if (!Core.bDebug) {
            // empty if block
        }
        DebugLog.log("NetChecksum: " + string);
    }

    public static final class Checksummer {
        private MessageDigest md;
        private final byte[] fileBytes = new byte[1024];
        private final byte[] convertBytes = new byte[1024];
        private boolean convertLineEndings;

        public void reset(boolean bl) throws NoSuchAlgorithmException {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            this.convertLineEndings = bl;
            this.md.reset();
        }

        public void addFile(String string, String string2) throws NoSuchAlgorithmException {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("MD5");
            }
            try (FileInputStream fileInputStream = new FileInputStream(string2);){
                int n;
                GroupOfFiles.addFile(string, string2);
                while ((n = fileInputStream.read(this.fileBytes)) != -1) {
                    if (this.convertLineEndings) {
                        boolean bl = false;
                        int n2 = 0;
                        for (int i = 0; i < n - 1; ++i) {
                            if (this.fileBytes[i] == 13 && this.fileBytes[i + 1] == 10) {
                                this.convertBytes[n2++] = 10;
                                bl = true;
                                continue;
                            }
                            bl = false;
                            this.convertBytes[n2++] = this.fileBytes[i];
                        }
                        if (!bl) {
                            this.convertBytes[n2++] = this.fileBytes[n - 1];
                        }
                        this.md.update(this.convertBytes, 0, n2);
                        GroupOfFiles.updateFile(this.convertBytes, n2);
                        continue;
                    }
                    this.md.update(this.fileBytes, 0, n);
                    GroupOfFiles.updateFile(this.fileBytes, n);
                }
                GroupOfFiles.endFile();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }

        public String checksumToString() {
            byte[] byArray = this.md.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append(Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1));
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (GroupOfFiles groupOfFiles : GroupOfFiles.groups) {
                String string = groupOfFiles.toString();
                stringBuilder.append("\n").append(string);
                if (!GameClient.bClient) continue;
                comparer.sendError(GameClient.connection, string);
            }
            return stringBuilder.toString();
        }
    }

    public static final class Comparer {
        private static final short PacketTotalChecksum = 1;
        private static final short PacketGroupChecksum = 2;
        private static final short PacketFileChecksums = 3;
        private static final short PacketError = 4;
        private static final byte FileDifferent = 1;
        private static final byte FileNotOnServer = 2;
        private static final byte FileNotOnClient = 3;
        private static final short NUM_GROUPS_TO_SEND = 10;
        private State state = State.Init;
        private short currentIndex;
        private String error;
        private final byte[] checksum = new byte[64];

        public void beginCompare() {
            this.error = null;
            this.sendTotalChecksum();
        }

        private void sendTotalChecksum() {
            if (!GameClient.bClient) {
                return;
            }
            NetChecksum.noise("send total checksum");
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)1);
            byteBufferWriter.putUTF(GameClient.checksum);
            byteBufferWriter.putUTF(ScriptManager.instance.getChecksum());
            PacketTypes.PacketType.Checksum.send(GameClient.connection);
            this.state = State.SentTotalChecksum;
        }

        private void sendGroupChecksum() {
            if (!GameClient.bClient) {
                return;
            }
            if (this.currentIndex >= GroupOfFiles.groups.size()) {
                this.state = State.Success;
                return;
            }
            short s = (short)Math.min(this.currentIndex + 10 - 1, GroupOfFiles.groups.size() - 1);
            NetChecksum.noise("send group checksums " + this.currentIndex + "-" + s);
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)2);
            byteBufferWriter.putShort(this.currentIndex);
            byteBufferWriter.putShort(s);
            for (short s2 = this.currentIndex; s2 <= s; s2 = (short)(s2 + 1)) {
                GroupOfFiles groupOfFiles = GroupOfFiles.groups.get(s2);
                byteBufferWriter.putShort((short)groupOfFiles.totalChecksum.length);
                byteBufferWriter.bb.put(groupOfFiles.totalChecksum);
            }
            PacketTypes.PacketType.Checksum.send(GameClient.connection);
            this.state = State.SentGroupChecksum;
        }

        private void sendFileChecksums() {
            if (!GameClient.bClient) {
                return;
            }
            NetChecksum.noise("send file checksums " + this.currentIndex);
            GroupOfFiles groupOfFiles = GroupOfFiles.groups.get(this.currentIndex);
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)3);
            byteBufferWriter.bb.putShort(this.currentIndex);
            byteBufferWriter.putShort(groupOfFiles.fileCount);
            for (int i = 0; i < groupOfFiles.fileCount; ++i) {
                byteBufferWriter.putUTF(groupOfFiles.relPaths[i]);
                byteBufferWriter.putByte((byte)groupOfFiles.checksums[i].length);
                byteBufferWriter.bb.put(groupOfFiles.checksums[i]);
            }
            PacketTypes.PacketType.Checksum.send(GameClient.connection);
            this.state = State.SentFileChecksums;
        }

        public String getReason(byte by) {
            return switch (by) {
                case 1 -> "File doesn't match the one on the server";
                case 2 -> "File doesn't exist on the server";
                case 3 -> "File doesn't exist on the client";
                default -> "File status unknown";
            };
        }

        public void clientPacket(ByteBuffer byteBuffer) {
            if (!GameClient.bClient) {
                return;
            }
            short s = byteBuffer.getShort();
            switch (s) {
                case 1: {
                    if (this.state != State.SentTotalChecksum) {
                        this.error = "NetChecksum: received PacketTotalChecksum in state " + this.state;
                        this.state = State.Failed;
                        break;
                    }
                    boolean bl = byteBuffer.get() == 1;
                    boolean bl2 = byteBuffer.get() == 1;
                    NetChecksum.noise("total checksum lua=" + bl + " script=" + bl2);
                    if (bl && bl2) {
                        this.state = State.Success;
                        break;
                    }
                    this.currentIndex = 0;
                    this.sendGroupChecksum();
                    break;
                }
                case 2: {
                    boolean bl;
                    if (this.state != State.SentGroupChecksum) {
                        this.error = "NetChecksum: received PacketGroupChecksum in state " + this.state;
                        this.state = State.Failed;
                        break;
                    }
                    short s2 = byteBuffer.getShort();
                    boolean bl3 = bl = byteBuffer.get() == 1;
                    if (s2 < this.currentIndex || s2 >= this.currentIndex + 10) {
                        this.error = "NetChecksum: expected PacketGroupChecksum " + this.currentIndex + " but got " + s2;
                        this.state = State.Failed;
                        break;
                    }
                    NetChecksum.noise("group checksum " + s2 + " match=" + bl);
                    if (bl) {
                        this.currentIndex = (short)(this.currentIndex + 10);
                        this.sendGroupChecksum();
                        break;
                    }
                    this.currentIndex = s2;
                    this.sendFileChecksums();
                    break;
                }
                case 3: {
                    if (this.state != State.SentFileChecksums) {
                        this.error = "NetChecksum: received PacketFileChecksums in state " + this.state;
                        this.state = State.Failed;
                        break;
                    }
                    short s3 = byteBuffer.getShort();
                    String string = GameWindow.ReadStringUTF(byteBuffer);
                    String string2 = GameWindow.ReadStringUTF(byteBuffer);
                    byte by = byteBuffer.get();
                    if (s3 != this.currentIndex) {
                        this.error = "NetChecksum: expected PacketFileChecksums " + this.currentIndex + " but got " + s3;
                        this.state = State.Failed;
                        break;
                    }
                    this.error = this.getReason(by);
                    if (DebugLog.isLogEnabled(LogSeverity.Debug, DebugType.Checksum)) {
                        LoggerManager.getLogger("checksum").write(String.format("%s%s", this.error, checksummer));
                    }
                    this.error = this.error + ":\n" + string;
                    String string3 = ZomboidFileSystem.instance.getString(string);
                    if (!string3.equals(string)) {
                        this.error = this.error + "\nclient: " + string3;
                    }
                    if (!string2.equals(string)) {
                        this.error = this.error + "\nserver: " + string2;
                    }
                    this.state = State.Failed;
                    break;
                }
                case 4: {
                    this.error = GameWindow.ReadStringUTF(byteBuffer);
                    this.state = State.Failed;
                    break;
                }
                default: {
                    this.error = "NetChecksum: unhandled packet " + s;
                    this.state = State.Failed;
                }
            }
        }

        private boolean checksumEquals(byte[] byArray) {
            if (byArray == null) {
                return false;
            }
            if (this.checksum.length < byArray.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (this.checksum[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }

        private void sendFileMismatch(UdpConnection udpConnection, short s, String string, byte by) {
            if (!GameServer.bServer) {
                return;
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)3);
            byteBufferWriter.putShort(s);
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putUTF(ZomboidFileSystem.instance.getString(string));
            byteBufferWriter.putByte(by);
            PacketTypes.PacketType.Checksum.send(udpConnection);
            if (DebugLog.isLogEnabled(LogSeverity.Debug, DebugType.Checksum)) {
                LoggerManager.getLogger("checksum").write(String.format("%s%s", this.getReason(by), checksummer));
                LoggerManager.getLogger("checksum-" + udpConnection.idStr).write(this.getReason(by));
            }
        }

        private void sendError(UdpConnection udpConnection, String string) {
            NetChecksum.noise(string);
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)4);
            byteBufferWriter.putUTF(string);
            PacketTypes.PacketType.Checksum.send(udpConnection);
        }

        public void serverPacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
            if (!GameServer.bServer) {
                return;
            }
            short s = byteBuffer.getShort();
            switch (s) {
                case 1: {
                    Object object;
                    String string = GameWindow.ReadString(byteBuffer);
                    String string2 = GameWindow.ReadString(byteBuffer);
                    boolean bl = string.equals(GameServer.checksum);
                    boolean bl2 = string2.equals(ScriptManager.instance.getChecksum());
                    NetChecksum.noise("PacketTotalChecksum lua=" + bl + " script=" + bl2);
                    if (udpConnection.accessLevel == 32) {
                        bl2 = true;
                        bl = true;
                    }
                    udpConnection.checksumState = bl && bl2 ? UdpConnection.ChecksumState.Done : UdpConnection.ChecksumState.Different;
                    udpConnection.checksumTime = System.currentTimeMillis();
                    if (!bl || !bl2) {
                        DebugLog.log("user " + udpConnection.username + " will be kicked because Lua/script checksums do not match");
                        object = "";
                        if (!bl) {
                            object = (String)object + "Lua";
                        }
                        if (!bl2) {
                            object = (String)object + "Script";
                        }
                        ServerWorldDatabase.instance.addUserlog(udpConnection.username, Userlog.UserlogType.LuaChecksum, (String)object, this.getClass().getSimpleName(), 1);
                    }
                    object = udpConnection.startPacket();
                    PacketTypes.PacketType.Checksum.doPacket((ByteBufferWriter)object);
                    ((ByteBufferWriter)object).putShort((short)1);
                    ((ByteBufferWriter)object).putBoolean(bl);
                    ((ByteBufferWriter)object).putBoolean(bl2);
                    PacketTypes.PacketType.Checksum.send(udpConnection);
                    break;
                }
                case 2: {
                    short s2 = byteBuffer.getShort();
                    short s3 = byteBuffer.getShort();
                    if (s2 < 0 || s3 < s2 || s3 >= s2 + 10) {
                        this.sendError(udpConnection, "PacketGroupChecksum: firstIndex and/or lastIndex are invalid");
                        break;
                    }
                    for (short s4 = s2; s4 <= s3; s4 = (short)(s4 + 1)) {
                        Object object;
                        short s5 = byteBuffer.getShort();
                        if (s5 < 0 || s5 > this.checksum.length) {
                            this.sendError(udpConnection, "PacketGroupChecksum: numBytes is invalid");
                            return;
                        }
                        byteBuffer.get(this.checksum, 0, s5);
                        if (s4 < GroupOfFiles.groups.size()) {
                            object = GroupOfFiles.groups.get(s4);
                            if (this.checksumEquals(((GroupOfFiles)object).totalChecksum)) continue;
                        }
                        object = udpConnection.startPacket();
                        PacketTypes.PacketType.Checksum.doPacket((ByteBufferWriter)object);
                        ((ByteBufferWriter)object).putShort((short)2);
                        ((ByteBufferWriter)object).putShort(s4);
                        ((ByteBufferWriter)object).putBoolean(false);
                        PacketTypes.PacketType.Checksum.send(udpConnection);
                        return;
                    }
                    ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                    PacketTypes.PacketType.Checksum.doPacket(byteBufferWriter);
                    byteBufferWriter.putShort((short)2);
                    byteBufferWriter.putShort(s2);
                    byteBufferWriter.putBoolean(true);
                    PacketTypes.PacketType.Checksum.send(udpConnection);
                    break;
                }
                case 3: {
                    short s6 = byteBuffer.getShort();
                    short s7 = byteBuffer.getShort();
                    if (s6 < 0 || s7 <= 0 || s7 > 20) {
                        this.sendError(udpConnection, "PacketFileChecksums: groupIndex and/or fileCount are invalid");
                        return;
                    }
                    if (s6 >= GroupOfFiles.groups.size()) {
                        String string = GameWindow.ReadStringUTF(byteBuffer);
                        this.sendFileMismatch(udpConnection, s6, string, (byte)2);
                        return;
                    }
                    GroupOfFiles groupOfFiles = GroupOfFiles.groups.get(s6);
                    for (short s8 = 0; s8 < s7; s8 = (short)(s8 + 1)) {
                        String string = GameWindow.ReadStringUTF(byteBuffer);
                        byte by = byteBuffer.get();
                        if (by < 0 || by > this.checksum.length) {
                            this.sendError(udpConnection, "PacketFileChecksums: numBytes is invalid");
                            return;
                        }
                        if (s8 >= groupOfFiles.fileCount) {
                            this.sendFileMismatch(udpConnection, s6, string, (byte)2);
                            return;
                        }
                        if (!string.equals(groupOfFiles.relPaths[s8])) {
                            String string3 = ZomboidFileSystem.instance.getString(string);
                            if (string3.equals(string)) {
                                this.sendFileMismatch(udpConnection, s6, string, (byte)2);
                                return;
                            }
                            this.sendFileMismatch(udpConnection, s6, groupOfFiles.relPaths[s8], (byte)3);
                            return;
                        }
                        if (by > groupOfFiles.checksums[s8].length) {
                            this.sendFileMismatch(udpConnection, s6, groupOfFiles.relPaths[s8], (byte)1);
                            return;
                        }
                        byteBuffer.get(this.checksum, 0, by);
                        if (this.checksumEquals(groupOfFiles.checksums[s8])) continue;
                        this.sendFileMismatch(udpConnection, s6, groupOfFiles.relPaths[s8], (byte)1);
                        return;
                    }
                    if (groupOfFiles.fileCount > s7) {
                        this.sendFileMismatch(udpConnection, s6, groupOfFiles.relPaths[s7], (byte)3);
                        return;
                    }
                    this.sendError(udpConnection, "PacketFileChecksums: all checks passed when they shouldn't");
                    break;
                }
                case 4: {
                    String string = GameWindow.ReadStringUTF(byteBuffer);
                    if (!DebugLog.isLogEnabled(LogSeverity.Debug, DebugType.Checksum)) break;
                    LoggerManager.getLogger("checksum-" + udpConnection.idStr).write(string, null, true);
                    break;
                }
                default: {
                    this.sendError(udpConnection, "Unknown packet " + s);
                }
            }
        }

        private void gc() {
            GroupOfFiles.gc();
        }

        public void update() {
            switch (this.state) {
                case Init: {
                    break;
                }
                case SentTotalChecksum: {
                    break;
                }
                case SentGroupChecksum: {
                    break;
                }
                case SentFileChecksums: {
                    break;
                }
                case Success: {
                    this.gc();
                    GameClient.checksumValid = true;
                    break;
                }
                case Failed: {
                    this.gc();
                    GameClient.connection.forceDisconnect("checksum-" + this.error);
                    GameWindow.bServerDisconnected = true;
                    GameWindow.kickReason = this.error;
                }
            }
        }

        private static enum State {
            Init,
            SentTotalChecksum,
            SentGroupChecksum,
            SentFileChecksums,
            Success,
            Failed;

        }
    }

    public static final class GroupOfFiles {
        static final int MAX_FILES = 20;
        static MessageDigest mdTotal;
        static MessageDigest mdCurrentFile;
        static final ArrayList<GroupOfFiles> groups;
        static GroupOfFiles currentGroup;
        byte[] totalChecksum;
        short fileCount;
        final String[] relPaths = new String[20];
        final String[] absPaths = new String[20];
        final byte[][] checksums = new byte[20][];

        private GroupOfFiles() throws NoSuchAlgorithmException {
            if (mdTotal == null) {
                mdTotal = MessageDigest.getInstance("MD5");
                mdCurrentFile = MessageDigest.getInstance("MD5");
            }
            mdTotal.reset();
            groups.add(this);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append(this.fileCount).append(" files, ").append(this.absPaths.length).append("/").append(this.relPaths.length).append("/").append(this.checksums.length).append(" \"").append(Hex.encodeHexString((byte[])this.totalChecksum)).append("\"");
            for (int i = 0; i < 20; ++i) {
                stringBuilder.append("\n");
                if (i < this.relPaths.length) {
                    stringBuilder.append(" \"").append(this.relPaths[i]).append("\"");
                }
                if (i < this.checksums.length) {
                    if (this.checksums[i] == null) {
                        stringBuilder.append(" \"\"");
                    } else {
                        stringBuilder.append(" \"").append(Hex.encodeHexString((byte[])this.checksums[i])).append("\"");
                    }
                }
                if (i >= this.absPaths.length) continue;
                stringBuilder.append(" \"").append(this.absPaths[i]).append("\"");
            }
            return stringBuilder.toString();
        }

        private void gc_() {
            Arrays.fill(this.relPaths, null);
            Arrays.fill(this.absPaths, null);
            Arrays.fill((Object[])this.checksums, null);
        }

        public static void initChecksum() {
            groups.clear();
            currentGroup = null;
        }

        public static void finishChecksum() {
            if (currentGroup != null) {
                GroupOfFiles.currentGroup.totalChecksum = mdTotal.digest();
                currentGroup = null;
            }
        }

        private static void addFile(String string, String string2) throws NoSuchAlgorithmException {
            if (currentGroup == null) {
                currentGroup = new GroupOfFiles();
            }
            GroupOfFiles.currentGroup.relPaths[GroupOfFiles.currentGroup.fileCount] = string;
            GroupOfFiles.currentGroup.absPaths[GroupOfFiles.currentGroup.fileCount] = string2;
            mdCurrentFile.reset();
        }

        private static void updateFile(byte[] byArray, int n) {
            mdCurrentFile.update(byArray, 0, n);
            mdTotal.update(byArray, 0, n);
        }

        private static void endFile() {
            GroupOfFiles.currentGroup.checksums[GroupOfFiles.currentGroup.fileCount] = mdCurrentFile.digest();
            GroupOfFiles.currentGroup.fileCount = (short)(GroupOfFiles.currentGroup.fileCount + 1);
            if (GroupOfFiles.currentGroup.fileCount >= 20) {
                GroupOfFiles.currentGroup.totalChecksum = mdTotal.digest();
                currentGroup = null;
            }
        }

        public static void gc() {
            for (GroupOfFiles groupOfFiles : groups) {
                groupOfFiles.gc_();
            }
            groups.clear();
        }

        static {
            groups = new ArrayList();
        }
    }
}

