/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import zombie.core.Rand;
import zombie.core.raknet.UdpConnection;
import zombie.network.MPStatistics;
import zombie.network.ServerOptions;

public class MPStatisticsTest {
    private UdpConnection connection;
    private final long limit = 200L;

    @BeforeClass
    public static void init() {
        Rand.init();
        ServerOptions.instance.init();
    }

    @Before
    public void reset() {
        ServerOptions.instance.PingLimit.setValue(200);
        this.connection = new UdpConnection(null, 0L, 0);
        MPStatistics.pingIntervalCount = 10L;
        MPStatistics.pingLimitCount = 0L;
        MPStatistics.maxPingToSum = 400L;
    }

    @Test
    public void TestAveragePingIsGreaterThanLimit() {
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)l);
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestAveragePingIsLessThanLimit() {
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        this.connection.pingHistory.addFirst(199L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)199L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestAveragePingIsEqualToLimit() {
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)200L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestAveragePingIsSlightlyGreaterThanLimit() {
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(201L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)l);
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestAveragePingIsSlightlyLessThanLimit() {
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(199L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)200L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestNotEnoughPingIntervals() {
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 5L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)0L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestEnoughPingIntervals() {
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 5L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)l);
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestNotEnoughPingSpikes() {
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingLimitCount = 3L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)0L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestEnoughPingSpikes() {
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingLimitCount = 3L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)l);
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestSeveralHugeSpikesDoesNotExceedTheLimit() {
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(99L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)200L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestSeveralHugeSpikesEqualToLimit() {
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)200L, (long)l);
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestSeveralHugeSpikesExceedTheLimit() {
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(10000000L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(200L);
        this.connection.pingHistory.addFirst(201L);
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)l);
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestTheLatestDataIsUsedForCounting() {
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(100L);
        this.connection.pingHistory.addFirst(301L);
        this.connection.pingHistory.removeLast();
        MPStatistics.pingIntervalCount = 2L;
        MPStatistics.pingLimitCount = 1L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertTrue((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestKickWhileLoadingWhenKickIsDisabledViaMinValue() {
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        ServerOptions.instance.PingLimit.setValue((int)ServerOptions.instance.PingLimit.getMin());
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestKickWhileLoadingWhenConnectionIsPreferredInQueue() {
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        this.connection.preferredInQueue = true;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestKickWhileLoadingWhenConnectionIsAdmin() {
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        this.connection.accessLevel = (byte)32;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertFalse((boolean)MPStatistics.doKickWhileLoading(this.connection, l));
    }

    @Test
    public void TestKick() {
        this.connection.setFullyConnected();
        this.connection.connectionTimestamp -= 120000L;
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertTrue((boolean)MPStatistics.doKick(this.connection, l));
    }

    @Test
    public void TestKickGraceInterval() {
        this.connection.setFullyConnected();
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertFalse((boolean)MPStatistics.doKick(this.connection, l));
    }

    @Test
    public void TestKickIsNotFullyConnected() {
        this.connection.connectionTimestamp -= 120000L;
        this.connection.pingHistory.addFirst(201L);
        MPStatistics.pingIntervalCount = 1L;
        MPStatistics.pingLimitCount = 0L;
        long l = MPStatistics.checkLatest(this.connection, 200L);
        Assert.assertEquals((long)201L, (long)MPStatistics.checkLatest(this.connection, 200L));
        Assert.assertFalse((boolean)MPStatistics.doKick(this.connection, l));
    }
}

