/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

public class MPStatistic {
    public static MPStatistic instance;
    private static boolean doPrintStatistic;
    private static boolean doCSVStatistic;
    private static int Period;
    public TasksStatistic LoaderThreadTasks = new TasksStatistic();
    public TasksStatistic RecalcThreadTasks = new TasksStatistic();
    public SaveTasksStatistic SaveTasks = new SaveTasksStatistic();
    public ServerCellStatistic ServerMapToLoad = new ServerCellStatistic();
    public ServerCellStatistic ServerMapLoadedCells = new ServerCellStatistic();
    public ServerCellStatistic ServerMapLoaded2 = new ServerCellStatistic();
    private int countServerChunkThreadSaveNow = 0;
    public MainThreadStatistic Main = new MainThreadStatistic();
    public ThreadStatistic ServerLOS = new ThreadStatistic();
    public ThreadStatistic LoaderThread = new ThreadStatistic();
    public ThreadStatistic RecalcAllThread = new ThreadStatistic();
    public ThreadStatistic SaveThread = new ThreadStatistic();
    public ThreadStatistic PolyPathThread = new ThreadStatistic();
    public ThreadStatistic WorldReuser = new ThreadStatistic();
    public ThreadStatistic PlayerDownloadServer = new ThreadStatistic();
    public ThreadStatistic MapCollisionThread = new ThreadStatistic();
    public ProbeStatistic ChunkChecksum = new ProbeStatistic();
    public ProbeStatistic Bullet = new ProbeStatistic();
    public ProbeStatistic AnimationPlayerUpdate = new ProbeStatistic();
    public ProbeStatistic ServerMapPreupdate = new ProbeStatistic();
    public ProbeStatistic ServerMapPostupdate = new ProbeStatistic();
    public ProbeStatistic IngameStateUpdate = new ProbeStatistic();
    private long packetLength = 0L;
    private int countIncomePackets = 0;
    private int countOutcomePackets = 0;
    private int countIncomeBytes = 0;
    private int countOutcomeBytes = 0;
    private int maxIncomeBytesPerSecond = 0;
    private int maxOutcomeBytesPerSecond = 0;
    private int currentIncomeBytesPerSecond = 0;
    private int currentOutcomeBytesPerSecond = 0;
    private long lastCalculateBPS = 0L;
    private long lastReport = 0L;
    private long minUpdatePeriod = 9999L;
    private long maxUpdatePeriod = 0L;
    private long avgUpdatePeriod = 0L;
    private long currentAvgUpdatePeriod = 0L;
    private long teleports = 0L;
    private long counter1 = 0L;
    private long counter2 = 0L;
    private long counter3 = 0L;
    private long updatePeriods = 0L;
    private int loadCellFromDisk = 0;
    private int saveCellToDisk = 0;
    public static boolean clientStatisticEnable;
    private PrintStream csvStatisticFile = null;
    private PrintStream csvIncomePacketsFile = null;
    private PrintStream csvIncomeBytesFile = null;
    private PrintStream csvOutcomePacketsFile = null;
    private PrintStream csvOutcomeBytesFile = null;
    private PrintStream csvConnectionsFile = null;
    private final ArrayList<Integer> csvConnections = new ArrayList();
    private KahluaTable table = null;

    public static MPStatistic getInstance() {
        if (instance == null) {
            instance = new MPStatistic();
        }
        return instance;
    }

    public void IncrementServerChunkThreadSaveNow() {
        ++this.countServerChunkThreadSaveNow;
    }

    public void teleport() {
        ++this.teleports;
    }

    public void count1(long l) {
        this.counter1 += l;
    }

    public void count2(long l) {
        this.counter2 += l;
    }

    public void count3(long l) {
        this.counter3 += l;
    }

    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putLong(this.minUpdatePeriod);
        byteBufferWriter.putLong(this.maxUpdatePeriod);
        byteBufferWriter.putLong(this.currentAvgUpdatePeriod / this.updatePeriods);
        byteBufferWriter.putLong(this.updatePeriods / (long)Period);
        byteBufferWriter.putLong(this.teleports);
        byteBufferWriter.putLong(GameServer.udpEngine.connections.size());
        byteBufferWriter.putLong(this.counter1 / this.updatePeriods);
        byteBufferWriter.putLong(this.counter2 / this.updatePeriods);
        byteBufferWriter.putLong(this.counter3 / this.updatePeriods);
    }

    public void setPacketsLength(long l) {
        this.packetLength = l;
    }

    public void addIncomePacket(PacketTypes.PacketType packetType, int n) {
        if (packetType != null) {
            ++packetType.incomePackets;
            ++this.countIncomePackets;
            packetType.incomeBytes += n;
            this.countIncomeBytes += n;
            this.currentIncomeBytesPerSecond += n;
            this.calculateMaxBPS();
        }
    }

    public void addOutcomePacket(short s, int n) {
        PacketTypes.PacketType packetType = PacketTypes.packetTypes.get(s);
        if (packetType != null) {
            ++packetType.outcomePackets;
            ++this.countOutcomePackets;
            packetType.outcomeBytes += n;
            this.countOutcomeBytes += n;
            this.currentOutcomeBytesPerSecond += n;
            this.calculateMaxBPS();
        }
    }

    void calculateMaxBPS() {
        if (System.currentTimeMillis() - this.lastCalculateBPS > 1000L) {
            this.lastCalculateBPS = System.currentTimeMillis();
            if (this.currentIncomeBytesPerSecond > this.maxIncomeBytesPerSecond) {
                this.maxIncomeBytesPerSecond = this.currentIncomeBytesPerSecond;
            }
            if (this.currentOutcomeBytesPerSecond > this.maxOutcomeBytesPerSecond) {
                this.maxOutcomeBytesPerSecond = this.currentOutcomeBytesPerSecond;
            }
            this.currentIncomeBytesPerSecond = 0;
            this.currentOutcomeBytesPerSecond = 0;
        }
    }

    public void IncrementLoadCellFromDisk() {
        ++this.loadCellFromDisk;
    }

    public void IncrementSaveCellToDisk() {
        ++this.saveCellToDisk;
    }

    /*
     * WARNING - void declaration
     */
    public void process(long l) {
        Object object2;
        if (l > this.maxUpdatePeriod) {
            this.maxUpdatePeriod = l;
        }
        if (l < this.minUpdatePeriod) {
            this.minUpdatePeriod = l;
        }
        this.avgUpdatePeriod = (long)((float)this.avgUpdatePeriod + (float)(l - this.avgUpdatePeriod) * 0.05f);
        this.currentAvgUpdatePeriod += l;
        ++this.updatePeriods;
        if (Period == 0 || System.currentTimeMillis() - this.lastReport < (long)Period * 1000L) {
            return;
        }
        this.lastReport = System.currentTimeMillis();
        this.printStatistic();
        this.printCSVStatistic();
        GameServer.sendShortStatistic();
        this.table = LuaManager.platform.newTable();
        this.table.rawset((Object)"lastReport", (Object)this.lastReport);
        this.table.rawset((Object)"period", (Object)Period);
        this.table.rawset((Object)"minUpdatePeriod", (Object)this.minUpdatePeriod);
        this.table.rawset((Object)"maxUpdatePeriod", (Object)this.maxUpdatePeriod);
        this.table.rawset((Object)"avgUpdatePeriod", (Object)this.avgUpdatePeriod);
        this.maxUpdatePeriod = 0L;
        this.minUpdatePeriod = 9999L;
        this.currentAvgUpdatePeriod = 0L;
        this.updatePeriods = 0L;
        this.teleports = 0L;
        this.counter1 = 0L;
        this.counter2 = 0L;
        this.counter3 = 0L;
        this.table.rawset((Object)"loadCellFromDisk", (Object)this.loadCellFromDisk);
        this.table.rawset((Object)"saveCellToDisk", (Object)this.saveCellToDisk);
        this.loadCellFromDisk = 0;
        this.saveCellToDisk = 0;
        this.table.rawset((Object)"usedMemory", (Object)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        this.table.rawset((Object)"totalMemory", (Object)Runtime.getRuntime().totalMemory());
        this.table.rawset((Object)"freeMemory", (Object)Runtime.getRuntime().freeMemory());
        this.table.rawset((Object)"countConnections", (Object)GameServer.udpEngine.connections.size());
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
            void var8_14;
            KahluaTable kahluaTable2 = LuaManager.platform.newTable();
            object2 = GameServer.udpEngine.connections.get(i);
            kahluaTable2.rawset((Object)"ip", (Object)((UdpConnection)object2).ip);
            kahluaTable2.rawset((Object)"username", (Object)((UdpConnection)object2).username);
            kahluaTable2.rawset((Object)"accessLevel", (Object)((UdpConnection)object2).accessLevel);
            KahluaTable object3 = LuaManager.platform.newTable();
            boolean bl = false;
            while (var8_14 < ((UdpConnection)object2).players.length) {
                if (((UdpConnection)object2).players[var8_14] != null) {
                    KahluaTable kahluaTable3 = LuaManager.platform.newTable();
                    kahluaTable3.rawset((Object)"username", (Object)((UdpConnection)object2).players[var8_14].username);
                    kahluaTable3.rawset((Object)"x", (Object)((UdpConnection)object2).players[var8_14].x);
                    kahluaTable3.rawset((Object)"y", (Object)((UdpConnection)object2).players[var8_14].y);
                    kahluaTable3.rawset((Object)"z", (Object)((UdpConnection)object2).players[var8_14].z);
                    object3.rawset((int)var8_14, (Object)kahluaTable3);
                }
                ++var8_14;
            }
            kahluaTable2.rawset((Object)"users", (Object)object3);
            kahluaTable2.rawset((Object)"diff", (Object)((UdpConnection)object2).statistic.diff);
            kahluaTable2.rawset((Object)"pingAVG", (Object)((UdpConnection)object2).statistic.pingAVG);
            kahluaTable2.rawset((Object)"remotePlayersCount", (Object)((UdpConnection)object2).statistic.remotePlayersCount);
            kahluaTable2.rawset((Object)"remotePlayersDesyncAVG", (Object)((UdpConnection)object2).statistic.remotePlayersDesyncAVG);
            kahluaTable2.rawset((Object)"remotePlayersDesyncMax", (Object)((UdpConnection)object2).statistic.remotePlayersDesyncMax);
            kahluaTable2.rawset((Object)"remotePlayersTeleports", (Object)((UdpConnection)object2).statistic.remotePlayersTeleports);
            kahluaTable2.rawset((Object)"zombiesCount", (Object)((UdpConnection)object2).statistic.zombiesCount);
            kahluaTable2.rawset((Object)"zombiesLocalOwnership", (Object)((UdpConnection)object2).statistic.zombiesLocalOwnership);
            kahluaTable2.rawset((Object)"zombiesDesyncAVG", (Object)((UdpConnection)object2).statistic.zombiesDesyncAVG);
            kahluaTable2.rawset((Object)"zombiesDesyncMax", (Object)((UdpConnection)object2).statistic.zombiesDesyncMax);
            kahluaTable2.rawset((Object)"zombiesTeleports", (Object)((UdpConnection)object2).statistic.zombiesTeleports);
            kahluaTable2.rawset((Object)"FPS", (Object)((UdpConnection)object2).statistic.FPS);
            kahluaTable2.rawset((Object)"FPSMin", (Object)((UdpConnection)object2).statistic.FPSMin);
            kahluaTable2.rawset((Object)"FPSAvg", (Object)((UdpConnection)object2).statistic.FPSAvg);
            kahluaTable2.rawset((Object)"FPSMax", (Object)((UdpConnection)object2).statistic.FPSMax);
            KahluaTable kahluaTable4 = LuaManager.platform.newTable();
            short s = 0;
            for (int j = 0; j < 32; ++j) {
                kahluaTable4.rawset(j, (Object)((UdpConnection)object2).statistic.FPSHistogramm[j]);
                if (s >= ((UdpConnection)object2).statistic.FPSHistogramm[j]) continue;
                s = ((UdpConnection)object2).statistic.FPSHistogramm[j];
            }
            kahluaTable2.rawset((Object)"FPSHistogram", (Object)kahluaTable4);
            kahluaTable2.rawset((Object)"FPSHistogramMax", (Object)s);
            kahluaTable.rawset(i, (Object)kahluaTable2);
        }
        this.table.rawset((Object)"connections", (Object)kahluaTable);
        this.table.rawset((Object)"packetLength", (Object)this.packetLength);
        this.table.rawset((Object)"countIncomePackets", (Object)this.countIncomePackets);
        this.table.rawset((Object)"countIncomeBytes", (Object)this.countIncomeBytes);
        this.table.rawset((Object)"maxIncomeBytesPerSecound", (Object)this.maxIncomeBytesPerSecond);
        KahluaTable kahluaTable4 = LuaManager.platform.newTable();
        int n = -1;
        for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
            if (packetType.incomePackets > 0) {
                KahluaTable kahluaTable5 = LuaManager.platform.newTable();
                kahluaTable5.rawset((Object)"name", (Object)packetType.name());
                kahluaTable5.rawset((Object)"count", (Object)packetType.incomePackets);
                kahluaTable5.rawset((Object)"bytes", (Object)packetType.incomeBytes);
                kahluaTable4.rawset(n, (Object)kahluaTable5);
            }
            packetType.incomePackets = 0;
            packetType.incomeBytes = 0;
        }
        this.table.rawset((Object)"incomePacketsTable", (Object)kahluaTable4);
        this.countIncomePackets = 0;
        this.countIncomeBytes = 0;
        this.maxIncomeBytesPerSecond = 0;
        this.table.rawset((Object)"countOutcomePackets", (Object)this.countOutcomePackets);
        this.table.rawset((Object)"countOutcomeBytes", (Object)this.countOutcomeBytes);
        this.table.rawset((Object)"maxOutcomeBytesPerSecound", (Object)this.maxOutcomeBytesPerSecond);
        object2 = LuaManager.platform.newTable();
        n = -1;
        for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
            if (packetType.outcomePackets > 0) {
                KahluaTable kahluaTable6 = LuaManager.platform.newTable();
                kahluaTable6.rawset((Object)"name", (Object)packetType.name());
                kahluaTable6.rawset((Object)"count", (Object)packetType.outcomePackets);
                kahluaTable6.rawset((Object)"bytes", (Object)packetType.outcomeBytes);
                object2.rawset(n++, (Object)kahluaTable6);
            }
            packetType.outcomePackets = 0;
            packetType.outcomeBytes = 0;
        }
        this.table.rawset((Object)"outcomePacketsTable", object2);
        this.countOutcomePackets = 0;
        this.countOutcomeBytes = 0;
        this.maxOutcomeBytesPerSecond = 0;
        this.LoaderThreadTasks.Clear();
        this.RecalcThreadTasks.Clear();
        this.SaveTasks.Clear();
        this.ServerMapToLoad.Clear();
        this.ServerMapLoadedCells.Clear();
        this.ServerMapLoaded2.Clear();
        this.countServerChunkThreadSaveNow = 0;
        this.Main.Clear();
        this.ServerLOS.Clear();
        this.LoaderThread.Clear();
        this.RecalcAllThread.Clear();
        this.SaveThread.Clear();
        this.PolyPathThread.Clear();
        this.WorldReuser.Clear();
        this.PlayerDownloadServer.Clear();
        this.MapCollisionThread.Clear();
        this.ChunkChecksum.Clear();
        this.Bullet.Clear();
        this.AnimationPlayerUpdate.Clear();
        this.ServerMapPreupdate.Clear();
        this.ServerMapPostupdate.Clear();
        this.IngameStateUpdate.Clear();
        GameServer.getStatisticFromClients();
        GameServer.sendStatistic();
    }

    private void printStatistic() {
        if (doPrintStatistic) {
            DebugLog.Statistic.println("=== STATISTICS ===");
            DebugLog.Statistic.println("UpdatePeriod (mils) min:" + this.minUpdatePeriod + " max:" + this.maxUpdatePeriod + " avg:" + this.avgUpdatePeriod);
            DebugLog.Statistic.println("Server cell disk operations load:" + this.loadCellFromDisk + " save:" + this.saveCellToDisk);
            DebugLog.Statistic.println("Memory (bytes):" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) + " of " + Runtime.getRuntime().totalMemory());
            DebugLog.Statistic.println("== Connections:" + GameServer.udpEngine.connections.size() + " ==");
            for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                UdpConnection object = GameServer.udpEngine.connections.get(i);
                DebugLog.Statistic.println("Connection " + i + " " + object.ip + " " + object.username + " " + object.accessLevel);
                for (int j = 0; j < object.players.length; ++j) {
                    if (object.players[j] == null) continue;
                    DebugLog.Statistic.println("  User " + object.players[j].username + " (" + object.players[j].x + ", " + object.players[j].y + ", " + object.players[j].z + ")");
                }
                DebugLog.Statistic.println("  Ping:" + object.statistic.diff / 2 + " AVG:" + object.statistic.pingAVG);
                DebugLog.Statistic.println("  Players count:" + object.statistic.remotePlayersCount + " desyncAVG:" + object.statistic.remotePlayersDesyncAVG + " desyncMAX:" + object.statistic.remotePlayersDesyncMax + " teleports:" + object.statistic.remotePlayersTeleports);
                DebugLog.Statistic.println("  Zombies count:" + object.statistic.zombiesCount + " LocalOwnership:" + object.statistic.zombiesLocalOwnership + " desyncAVG:" + object.statistic.zombiesDesyncAVG + " desyncMAX:" + object.statistic.zombiesDesyncMax + " teleports:" + object.statistic.zombiesTeleports);
                DebugLog.Statistic.println("  FPS:" + object.statistic.FPS + " Min:" + object.statistic.FPSMin + " Avg:" + object.statistic.FPSAvg + " Max:" + object.statistic.FPSMax);
            }
            DebugLog.Statistic.println("== Income Packets ==");
            DebugLog.Statistic.println("length of packet queue:" + this.packetLength);
            DebugLog.Statistic.println("count packets:" + this.countIncomePackets);
            DebugLog.Statistic.println("count bytes:" + this.countIncomeBytes);
            DebugLog.Statistic.println("max bps:" + this.maxIncomeBytesPerSecond);
            for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                if (packetType.incomePackets <= 0) continue;
                DebugLog.Statistic.println(packetType.name() + "(" + packetType.getId() + ") count:" + packetType.incomePackets + " bytes:" + packetType.incomeBytes);
            }
            DebugLog.Statistic.println("== Outcome Packets ==");
            DebugLog.Statistic.println("count packets:" + this.countOutcomePackets);
            DebugLog.Statistic.println("count bytes:" + this.countOutcomeBytes);
            DebugLog.Statistic.println("max bps:" + this.maxOutcomeBytesPerSecond);
            for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                if (packetType.outcomePackets <= 0) continue;
                DebugLog.Statistic.println(packetType.name() + "(" + packetType.getId() + ") count:" + packetType.outcomePackets + " bytes:" + packetType.outcomeBytes);
            }
            DebugLog.Statistic.println("=== END STATISTICS ===");
        }
    }

    public static String getStatisticDir() {
        String string = ZomboidFileSystem.instance.getCacheDirSub("Statistic");
        ZomboidFileSystem.ensureFolderExists(string);
        File file = new File(string);
        return file.getAbsolutePath();
    }

    private void removeCSVStatistics() {
        File file;
        String string = MPStatistic.getStatisticDir();
        try {
            file = new File(string + File.separator + "Statistic.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: Statistic.csv", LogSeverity.Error);
        }
        try {
            file = new File(string + File.separator + "Connections.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: Connections.csv", LogSeverity.Error);
        }
        try {
            file = new File(string + File.separator + "IncomePackets.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: IncomePackets.csv", LogSeverity.Error);
        }
        try {
            file = new File(string + File.separator + "IncomeBytes.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: IncomeBytes.csv", LogSeverity.Error);
        }
        try {
            file = new File(string + File.separator + "OutcomePackets.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: OutcomePackets.csv", LogSeverity.Error);
        }
        try {
            file = new File(string + File.separator + "OutcomeBytes.csv");
            file.delete();
        }
        catch (Exception exception) {
            DebugLog.Statistic.printException(exception, "Delete file failed: OutcomeBytes.csv", LogSeverity.Error);
        }
    }

    private void closeCSVStatistics() {
        if (this.csvStatisticFile != null) {
            this.csvStatisticFile.close();
        }
        this.csvStatisticFile = null;
        if (this.csvConnectionsFile != null) {
            this.csvConnectionsFile.close();
        }
        this.csvConnectionsFile = null;
        if (this.csvIncomePacketsFile != null) {
            this.csvIncomePacketsFile.close();
        }
        this.csvIncomePacketsFile = null;
        if (this.csvIncomeBytesFile != null) {
            this.csvIncomeBytesFile.close();
        }
        this.csvIncomeBytesFile = null;
        if (this.csvOutcomePacketsFile != null) {
            this.csvOutcomePacketsFile.close();
        }
        this.csvOutcomePacketsFile = null;
        if (this.csvOutcomeBytesFile != null) {
            this.csvOutcomeBytesFile.close();
        }
        this.csvOutcomeBytesFile = null;
    }

    private void openCSVStatistic() {
        if (doCSVStatistic) {
            File file;
            String string = MPStatistic.getStatisticDir();
            try {
                file = new File(string + File.separator + "Statistic.csv");
                if (file.exists()) {
                    this.csvStatisticFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvStatisticFile = new PrintStream(file);
                    this.csvStatisticFile.println("lastReport; minUpdatePeriod; maxUpdatePeriod; avgUpdatePeriod; loadCellFromDisk; saveCellToDisk; countLoaderThreadTasksAdded; countLoaderThreadTasksProcessed; countRecalcThreadTasksAdded; countRecalcThreadTasksProcessed; countSaveUnloadedTasksAdded; countSaveLoadedTasksAdded; countSaveGameTimeTasksAdded; countQuitThreadTasksAdded; countSaveThreadTasksProcessed; countServerMapToLoadAdded; countServerMapToLoadCanceled; countServerMapLoadedCellsAdded; countServerMapLoadedCellsCanceled; countServerMapLoaded2Added; countServerMapLoaded2Canceled; countServerChunkThreadSaveNow; " + this.Main.PrintTitle("MainThread") + this.ServerLOS.PrintTitle("ServerLOS") + this.LoaderThread.PrintTitle("LoaderThread") + this.RecalcAllThread.PrintTitle("RecalcAllThread") + this.SaveThread.PrintTitle("SaveThread") + this.PolyPathThread.PrintTitle("PolyPathThread") + this.WorldReuser.PrintTitle("WorldReuser") + this.PlayerDownloadServer.PrintTitle("WorldReuser") + this.MapCollisionThread.PrintTitle("MapCollisionThread") + this.ChunkChecksum.PrintTitle("ChunkChecksum") + this.Bullet.PrintTitle("Bullet") + this.AnimationPlayerUpdate.PrintTitle("AnimationPlayerUpdate") + this.ServerMapPreupdate.PrintTitle("ServerMapPreupdate") + this.ServerMapPostupdate.PrintTitle("ServerMapPostupdate") + this.IngameStateUpdate.PrintTitle("IngameStateUpdate") + "totalMemory; freeMemory; countConnections; packetLength; countIncomePackets; countIncomeBytes; maxIncomeBytesPerSecound; countOutcomePackets; countOutcomeBytes; maxOutcomeBytesPerSecound");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: Statistic.csv", LogSeverity.Error);
                if (this.csvStatisticFile != null) {
                    this.csvStatisticFile.close();
                }
                this.csvStatisticFile = null;
            }
            try {
                file = new File(string + File.separator + "Connections.csv");
                if (file.exists()) {
                    this.csvConnectionsFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvConnectionsFile = new PrintStream(file);
                    this.csvConnectionsFile.print("ip; ");
                    this.csvConnectionsFile.print("username; ");
                    this.csvConnectionsFile.print("accessLevel; ");
                    this.csvConnectionsFile.print("players.length; ");
                    this.csvConnectionsFile.print("ping; ");
                    this.csvConnectionsFile.print("pingAVG; ");
                    this.csvConnectionsFile.print("remotePlayersCount; ");
                    this.csvConnectionsFile.print("remotePlayersDesyncAVG; ");
                    this.csvConnectionsFile.print("remotePlayersDesyncMax; ");
                    this.csvConnectionsFile.print("remotePlayersTeleports; ");
                    this.csvConnectionsFile.print("zombiesCount; ");
                    this.csvConnectionsFile.print("zombiesLocalOwnership; ");
                    this.csvConnectionsFile.print("zombiesDesyncAVG; ");
                    this.csvConnectionsFile.print("zombiesDesyncMax; ");
                    this.csvConnectionsFile.print("zombiesTeleports; ");
                    this.csvConnectionsFile.print("FPS; ");
                    this.csvConnectionsFile.print("FPSMin; ");
                    this.csvConnectionsFile.print("FPSAvg; ");
                    this.csvConnectionsFile.print("FPSMax; ");
                    for (int i = 0; i < 32; ++i) {
                        this.csvConnectionsFile.print("FPSHistogramm[" + i + "]; ");
                    }
                    this.csvConnectionsFile.println();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: Connections.csv", LogSeverity.Error);
                if (this.csvConnectionsFile != null) {
                    this.csvConnectionsFile.close();
                }
                this.csvConnectionsFile = null;
            }
            try {
                file = new File(string + File.separator + "IncomePackets.csv");
                if (file.exists()) {
                    this.csvIncomePacketsFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvIncomePacketsFile = new PrintStream(file);
                    for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                        this.csvIncomePacketsFile.print(packetType.name() + "(" + packetType.getId() + "); ");
                    }
                    this.csvIncomePacketsFile.println();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: IncomePackets.csv", LogSeverity.Error);
                if (this.csvIncomePacketsFile != null) {
                    this.csvIncomePacketsFile.close();
                }
                this.csvIncomePacketsFile = null;
            }
            try {
                file = new File(string + File.separator + "IncomeBytes.csv");
                if (file.exists()) {
                    this.csvIncomeBytesFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvIncomeBytesFile = new PrintStream(file);
                    for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                        this.csvIncomeBytesFile.print(packetType.name() + "(" + packetType.getId() + "); ");
                    }
                    this.csvIncomeBytesFile.println();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: IncomeBytes.csv", LogSeverity.Error);
                if (this.csvIncomeBytesFile != null) {
                    this.csvIncomeBytesFile.close();
                }
                this.csvIncomeBytesFile = null;
            }
            try {
                file = new File(string + File.separator + "OutcomePackets.csv");
                if (file.exists()) {
                    this.csvOutcomePacketsFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvOutcomePacketsFile = new PrintStream(file);
                    for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                        this.csvOutcomePacketsFile.print(packetType.name() + "(" + packetType.getId() + "); ");
                    }
                    this.csvOutcomePacketsFile.println();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: OutcomePackets.csv", LogSeverity.Error);
                if (this.csvOutcomePacketsFile != null) {
                    this.csvOutcomePacketsFile.close();
                }
                this.csvOutcomePacketsFile = null;
            }
            try {
                file = new File(string + File.separator + "OutcomeBytes.csv");
                if (file.exists()) {
                    this.csvOutcomeBytesFile = new PrintStream(new FileOutputStream(file, true));
                } else {
                    this.csvOutcomeBytesFile = new PrintStream(file);
                    for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                        this.csvOutcomeBytesFile.print(packetType.name() + "(" + packetType.getId() + "); ");
                    }
                    this.csvOutcomeBytesFile.println();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                DebugLog.Statistic.printException(fileNotFoundException, "Open file failed: OutcomeBytes.csv", LogSeverity.Error);
                if (this.csvOutcomeBytesFile != null) {
                    this.csvOutcomeBytesFile.close();
                }
                this.csvOutcomeBytesFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void printCSVStatistic() {
        if (doCSVStatistic) {
            try {
                this.openCSVStatistic();
                if (this.csvStatisticFile != null) {
                    this.csvStatisticFile.print(System.currentTimeMillis() + ";");
                    this.csvStatisticFile.print(this.minUpdatePeriod + ";");
                    this.csvStatisticFile.print(this.maxUpdatePeriod + ";");
                    this.csvStatisticFile.print(this.avgUpdatePeriod + ";");
                    this.csvStatisticFile.print(this.loadCellFromDisk + ";");
                    this.csvStatisticFile.print(this.saveCellToDisk + ";");
                    this.csvStatisticFile.print(this.LoaderThreadTasks.Print());
                    this.csvStatisticFile.print(this.RecalcThreadTasks.Print());
                    this.csvStatisticFile.print(this.SaveTasks.Print());
                    this.csvStatisticFile.print(this.ServerMapToLoad.Print());
                    this.csvStatisticFile.print(this.ServerMapLoadedCells.Print());
                    this.csvStatisticFile.print(this.ServerMapLoaded2.Print());
                    this.csvStatisticFile.print(this.countServerChunkThreadSaveNow + ";");
                    this.csvStatisticFile.print(this.Main.Print());
                    this.csvStatisticFile.print(this.ServerLOS.Print());
                    this.csvStatisticFile.print(this.LoaderThread.Print());
                    this.csvStatisticFile.print(this.RecalcAllThread.Print());
                    this.csvStatisticFile.print(this.SaveThread.Print());
                    this.csvStatisticFile.print(this.PolyPathThread.Print());
                    this.csvStatisticFile.print(this.WorldReuser.Print());
                    this.csvStatisticFile.print(this.PlayerDownloadServer.Print());
                    this.csvStatisticFile.print(this.MapCollisionThread.Print());
                    this.csvStatisticFile.print(this.ChunkChecksum.Print());
                    this.csvStatisticFile.print(this.Bullet.Print());
                    this.csvStatisticFile.print(this.AnimationPlayerUpdate.Print());
                    this.csvStatisticFile.print(this.ServerMapPreupdate.Print());
                    this.csvStatisticFile.print(this.ServerMapPostupdate.Print());
                    this.csvStatisticFile.print(this.IngameStateUpdate.Print());
                    this.csvStatisticFile.print(Runtime.getRuntime().totalMemory() + ";");
                    this.csvStatisticFile.print(Runtime.getRuntime().freeMemory() + ";");
                    this.csvStatisticFile.print(GameServer.udpEngine.connections.size() + ";");
                    this.csvStatisticFile.print(this.packetLength + ";");
                    this.csvStatisticFile.print(this.countIncomePackets + ";");
                    this.csvStatisticFile.print(this.countIncomeBytes + ";");
                    this.csvStatisticFile.print(this.maxIncomeBytesPerSecond + ";");
                    this.csvStatisticFile.print(this.countOutcomePackets + ";");
                    this.csvStatisticFile.print(this.countOutcomeBytes + ";");
                    this.csvStatisticFile.println(this.maxOutcomeBytesPerSecond + ";");
                    this.csvStatisticFile.flush();
                }
                if (this.csvConnectionsFile != null) {
                    int n;
                    for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                        UdpConnection object = GameServer.udpEngine.connections.get(n);
                        try {
                            if (object == null || object.username == null || this.csvConnections.contains(object.username.hashCode())) continue;
                            this.csvConnections.add(object.username.hashCode());
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                            this.closeCSVStatistics();
                            return;
                        }
                    }
                    for (n = 0; n < this.csvConnections.size(); ++n) {
                        void var2_7;
                        int n2;
                        Object var2_6 = null;
                        for (n2 = 0; n2 < GameServer.udpEngine.connections.size(); ++n2) {
                            UdpConnection udpConnection = GameServer.udpEngine.connections.get(n2);
                            if (udpConnection == null || udpConnection.username == null || udpConnection.username.hashCode() != this.csvConnections.get(n).intValue()) continue;
                            UdpConnection udpConnection2 = udpConnection;
                        }
                        if (var2_7 == null) {
                            for (n2 = 0; n2 < 51; ++n2) {
                                this.csvConnectionsFile.print("; ");
                            }
                        } else {
                            this.csvConnectionsFile.print(var2_7.ip + "; ");
                            this.csvConnectionsFile.print(var2_7.username + "; ");
                            this.csvConnectionsFile.print(var2_7.accessLevel + "; ");
                            this.csvConnectionsFile.print(var2_7.players.length + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.diff / 2 + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.pingAVG + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.remotePlayersCount + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.remotePlayersDesyncAVG + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.remotePlayersDesyncMax + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.remotePlayersTeleports + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.zombiesCount + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.zombiesLocalOwnership + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.zombiesDesyncAVG + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.zombiesDesyncMax + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.zombiesTeleports + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.FPS + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.FPSMin + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.FPSAvg + "; ");
                            this.csvConnectionsFile.print(var2_7.statistic.FPSMax + "; ");
                            for (n2 = 0; n2 < 32; ++n2) {
                                this.csvConnectionsFile.print(var2_7.statistic.FPSHistogramm[n2] + "; ");
                            }
                        }
                        this.csvConnectionsFile.println();
                    }
                    this.csvConnectionsFile.flush();
                }
                if (this.csvIncomePacketsFile != null && this.csvOutcomePacketsFile != null && this.csvIncomeBytesFile != null && this.csvOutcomeBytesFile != null) {
                    for (PacketTypes.PacketType packetType : PacketTypes.packetTypes.values()) {
                        this.csvIncomePacketsFile.print(packetType.incomePackets + ";");
                        this.csvIncomeBytesFile.print(packetType.incomeBytes + ";");
                        this.csvOutcomePacketsFile.print(packetType.outcomePackets + ";");
                        this.csvOutcomeBytesFile.print(packetType.outcomeBytes + ";");
                    }
                    this.csvIncomePacketsFile.println();
                    this.csvIncomeBytesFile.println();
                    this.csvOutcomePacketsFile.println();
                    this.csvOutcomeBytesFile.println();
                    this.csvIncomePacketsFile.flush();
                    this.csvIncomeBytesFile.flush();
                    this.csvOutcomePacketsFile.flush();
                    this.csvOutcomeBytesFile.flush();
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            finally {
                this.closeCSVStatistics();
            }
        }
    }

    public void getStatisticTable(ByteBuffer byteBuffer) throws IOException {
        if (this.table != null) {
            this.table.save(byteBuffer);
        }
    }

    public void setStatisticTable(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() == 0) {
            return;
        }
        this.table = LuaManager.platform.newTable();
        try {
            this.table.load(byteBuffer, 195);
            this.table.rawset((Object)"lastReportTime", (Object)System.currentTimeMillis());
        }
        catch (Exception exception) {
            this.table = null;
            ExceptionLogger.logException(exception);
        }
    }

    public KahluaTable getStatisticTableForLua() {
        return this.table;
    }

    public void printEnabled(boolean bl) {
        doPrintStatistic = bl;
    }

    public void writeEnabled(boolean bl) {
        doCSVStatistic = bl;
        if (bl) {
            this.removeCSVStatistics();
        }
    }

    public void setPeriod(int n) {
        Period = Math.max(n, 0);
        if (this.table != null) {
            this.table.rawset((Object)"period", (Object)Period);
        }
    }

    static {
        doPrintStatistic = false;
        doCSVStatistic = false;
        Period = 0;
        clientStatisticEnable = false;
    }

    public static class TasksStatistic {
        protected long added = 0L;
        protected long processed = 0L;

        public void Clear() {
            this.added = 0L;
            this.processed = 0L;
        }

        public String PrintTitle(String string) {
            return string + "Added; " + string + "Processed; ";
        }

        public String Print() {
            return this.added + "; " + this.processed + "; ";
        }

        public void Added() {
            ++this.added;
        }

        public void Processed() {
            ++this.processed;
        }
    }

    public static class SaveTasksStatistic
    extends TasksStatistic {
        private int SaveUnloadedTasksAdded = 0;
        private int SaveLoadedTasksAdded = 0;
        private int SaveGameTimeTasksAdded = 0;
        private int QuitThreadTasksAdded = 0;

        @Override
        public void Clear() {
            super.Clear();
            this.SaveUnloadedTasksAdded = 0;
            this.SaveLoadedTasksAdded = 0;
            this.SaveGameTimeTasksAdded = 0;
            this.QuitThreadTasksAdded = 0;
        }

        @Override
        public String PrintTitle(String string) {
            return string + "SaveUnloadedAdded; " + string + "SaveLoadedAdded; " + string + "SaveGameTimeAdded; " + string + "QuitThreadAdded; " + string + "Processed; ";
        }

        @Override
        public String Print() {
            return this.SaveUnloadedTasksAdded + "; " + this.SaveLoadedTasksAdded + "; " + this.SaveGameTimeTasksAdded + "; " + this.QuitThreadTasksAdded + "; " + this.processed + "; ";
        }

        public void SaveUnloadedTasksAdded() {
            ++this.SaveUnloadedTasksAdded;
        }

        public void SaveLoadedTasksAdded() {
            ++this.SaveLoadedTasksAdded;
        }

        public void SaveGameTimeTasksAdded() {
            ++this.SaveGameTimeTasksAdded;
        }

        public void QuitThreadTasksAdded() {
            ++this.QuitThreadTasksAdded;
        }
    }

    public static class ServerCellStatistic {
        protected long added = 0L;
        protected long canceled = 0L;

        public void Clear() {
            this.added = 0L;
            this.canceled = 0L;
        }

        public String PrintTitle(String string) {
            return string + "Added; " + string + "Canceled; ";
        }

        public String Print() {
            return this.added + "; " + this.canceled + "; ";
        }

        public void Added() {
            ++this.added;
        }

        public void Added(int n) {
            this.added += (long)n;
        }

        public void Canceled() {
            ++this.canceled;
        }
    }

    public class MainThreadStatistic
    extends ThreadStatistic {
        private long timeStartSleep = 0L;

        @Override
        public void Start() {
            if (this.timeStart == 0L) {
                this.timeStart = System.currentTimeMillis();
                return;
            }
            long l = System.currentTimeMillis() - this.timeStart;
            this.timeStart = System.currentTimeMillis();
            this.timeWork += l;
            if (this.timeMax < l) {
                this.timeMax = l;
            }
            ++this.timeCount;
        }

        @Override
        public void End() {
        }

        public void StartSleep() {
            this.timeStartSleep = System.currentTimeMillis();
        }

        public void EndSleep() {
            long l = System.currentTimeMillis() - this.timeStartSleep;
            this.timeSleep += l;
            this.timeStart += l;
        }
    }

    public static class ThreadStatistic {
        protected boolean started = false;
        protected long timeStart = 0L;
        protected long timeWork = 0L;
        protected long timeMax = 0L;
        protected long timeSleep = 0L;
        protected long timeCount = 0L;

        public void Clear() {
            this.timeWork = 0L;
            this.timeMax = 0L;
            this.timeSleep = 0L;
            this.timeCount = 0L;
        }

        public String PrintTitle(String string) {
            return string + "Work; " + string + "Max; " + string + "Sleep; " + string + "Count;";
        }

        public String Print() {
            return this.timeWork + "; " + this.timeMax + "; " + this.timeSleep + "; " + this.timeCount + "; ";
        }

        public void Start() {
            if (this.started) {
                this.End();
            }
            if (this.timeStart != 0L) {
                this.timeSleep += System.currentTimeMillis() - this.timeStart;
            }
            this.timeStart = System.currentTimeMillis();
            ++this.timeCount;
            this.started = true;
        }

        public void End() {
            if (this.timeStart == 0L || !this.started) {
                return;
            }
            long l = System.currentTimeMillis() - this.timeStart;
            this.timeStart = System.currentTimeMillis();
            this.timeWork += l;
            if (this.timeMax < l) {
                this.timeMax = l;
            }
            this.started = false;
        }
    }

    public static class ProbeStatistic {
        protected boolean started = false;
        protected long timeStart = 0L;
        protected long timeWork = 0L;
        protected long timeMax = 0L;
        protected long timeCount = 0L;

        public void Clear() {
            this.timeWork = 0L;
            this.timeMax = 0L;
            this.timeCount = 0L;
        }

        public String PrintTitle(String string) {
            return string + "Work; " + string + "Max; " + string + "Count;";
        }

        public String Print() {
            return this.timeWork / 1000000L + "; " + this.timeMax / 1000000L + "; " + this.timeCount + "; ";
        }

        public void Start() {
            this.timeStart = System.nanoTime();
            ++this.timeCount;
            this.started = true;
        }

        public void End() {
            if (!this.started) {
                return;
            }
            long l = System.nanoTime() - this.timeStart;
            this.timeWork += l;
            if (this.timeMax < l) {
                this.timeMax = l;
            }
            this.started = false;
        }
    }
}

