/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.Lua.LuaEventManager;
import zombie.core.Core;
import zombie.core.logger.LoggerManager;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.gameStates.LoadingQueueState;
import zombie.network.ConnectionManager;
import zombie.network.PacketTypes;
import zombie.network.ServerOptions;

public class LoginQueue {
    private static ArrayList<UdpConnection> LoginQueue = new ArrayList();
    private static ArrayList<UdpConnection> PreferredLoginQueue = new ArrayList();
    private static UdpConnection currentLoginQueue;
    private static UpdateLimit UpdateLimit;
    private static UpdateLimit LoginQueueTimeout;

    public static void receiveClientLoginQueueRequest(ByteBuffer byteBuffer, short s) {
        byte by = byteBuffer.get();
        if (by == LoginQueueMessageType.ConnectionImmediate.ordinal()) {
            LoadingQueueState.onConnectionImmediate();
        } else if (by == LoginQueueMessageType.PlaceInQueue.ordinal()) {
            int n = byteBuffer.getInt();
            LoadingQueueState.onPlaceInQueue(n);
            LuaEventManager.triggerEvent("OnConnectionStateChanged", "FormatMessage", "PlaceInQueue", n);
        }
        ConnectionManager.log("receive-packet", "login-queue-request", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveLoginQueueDone(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        long l = byteBuffer.getLong();
        LoggerManager.getLogger("user").write("player " + udpConnection.username + " loading time was: " + l + " ms");
        ArrayList<UdpConnection> arrayList = LoginQueue;
        synchronized (arrayList) {
            if (currentLoginQueue == udpConnection) {
                currentLoginQueue = null;
            }
            zombie.network.LoginQueue.loadNextPlayer();
        }
        ConnectionManager.log("receive-packet", "login-queue-done", udpConnection);
        udpConnection.validator.sendChecksum(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveServerLoginQueueRequest(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        LoggerManager.getLogger("user").write(udpConnection.idStr + " \"" + udpConnection.username + "\" attempting to join used " + (udpConnection.preferredInQueue ? "preferred " : "") + "queue");
        ArrayList<UdpConnection> arrayList = LoginQueue;
        synchronized (arrayList) {
            if (!ServerOptions.getInstance().LoginQueueEnabled.getValue() || !udpConnection.preferredInQueue && currentLoginQueue == null && PreferredLoginQueue.isEmpty() && LoginQueue.isEmpty() || udpConnection.preferredInQueue && currentLoginQueue == null && PreferredLoginQueue.isEmpty()) {
                if (Core.bDebug) {
                    DebugLog.log("receiveServerLoginQueueRequest: ConnectionImmediate (ip:" + udpConnection.ip + ")");
                }
                currentLoginQueue = udpConnection;
                zombie.network.LoginQueue.currentLoginQueue.wasInLoadingQueue = true;
                LoginQueueTimeout.Reset(ServerOptions.getInstance().LoginQueueConnectTimeout.getValue() * 1000);
                ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                PacketTypes.PacketType.LoginQueueRequest2.doPacket(byteBufferWriter);
                byteBufferWriter.putByte((byte)LoginQueueMessageType.ConnectionImmediate.ordinal());
                PacketTypes.PacketType.LoginQueueRequest2.send(udpConnection);
            } else {
                if (Core.bDebug) {
                    DebugLog.log("receiveServerLoginQueueRequest: PlaceInQueue (ip:" + udpConnection.ip + " preferredInQueue:" + udpConnection.preferredInQueue + ")");
                }
                if (udpConnection.preferredInQueue) {
                    if (!PreferredLoginQueue.contains(udpConnection)) {
                        PreferredLoginQueue.add(udpConnection);
                    }
                } else if (!LoginQueue.contains(udpConnection)) {
                    LoginQueue.add(udpConnection);
                }
                zombie.network.LoginQueue.sendPlaceInTheQueue();
            }
        }
        ConnectionManager.log("receive-packet", "login-queue-request", udpConnection);
    }

    private static void sendAccessDenied(UdpConnection udpConnection, String string) {
        if (Core.bDebug) {
            DebugLog.log("sendAccessDenied: (ip:" + udpConnection.ip + " message:" + string + ")");
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.AccessDenied.doPacket(byteBufferWriter);
        byteBufferWriter.putUTF(string);
        PacketTypes.PacketType.AccessDenied.send(udpConnection);
        ConnectionManager.log("access-denied", "invalid-queue", udpConnection);
        udpConnection.forceDisconnect("queue-" + string);
    }

    private static void sendPlaceInTheQueue() {
        ByteBufferWriter byteBufferWriter;
        for (UdpConnection udpConnection : PreferredLoginQueue) {
            byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.LoginQueueRequest2.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)LoginQueueMessageType.PlaceInQueue.ordinal());
            byteBufferWriter.putInt(PreferredLoginQueue.indexOf(udpConnection) + 1);
            PacketTypes.PacketType.LoginQueueRequest2.send(udpConnection);
        }
        for (UdpConnection udpConnection : LoginQueue) {
            byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.LoginQueueRequest2.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)LoginQueueMessageType.PlaceInQueue.ordinal());
            byteBufferWriter.putInt(PreferredLoginQueue.size() + LoginQueue.indexOf(udpConnection) + 1);
            PacketTypes.PacketType.LoginQueueRequest2.send(udpConnection);
        }
    }

    private static void sendConnectRequest(UdpConnection udpConnection) {
        if (Core.bDebug) {
            DebugLog.log("sendApplyRequest: (ip:" + udpConnection.ip + ")");
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.LoginQueueRequest2.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)LoginQueueMessageType.ConnectionImmediate.ordinal());
        PacketTypes.PacketType.LoginQueueRequest2.send(udpConnection);
        ConnectionManager.log("send-packet", "login-queue-request", udpConnection);
    }

    public static boolean receiveLogin(UdpConnection udpConnection) {
        if (!ServerOptions.getInstance().LoginQueueEnabled.getValue()) {
            return true;
        }
        if (Core.bDebug) {
            DebugLog.log("receiveLogin: (ip:" + udpConnection.ip + ")");
        }
        if (udpConnection != currentLoginQueue) {
            zombie.network.LoginQueue.sendAccessDenied(currentLoginQueue, "QueueNotFound");
            if (Core.bDebug) {
                DebugLog.log("receiveLogin: error");
            }
            return false;
        }
        if (Core.bDebug) {
            DebugLog.log("receiveLogin: ok");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect(UdpConnection udpConnection) {
        if (Core.bDebug) {
            DebugLog.log("disconnect: (ip:" + udpConnection.ip + ")");
        }
        ArrayList<UdpConnection> arrayList = LoginQueue;
        synchronized (arrayList) {
            if (udpConnection == currentLoginQueue) {
                currentLoginQueue = null;
            } else {
                if (LoginQueue.contains(udpConnection)) {
                    LoginQueue.remove(udpConnection);
                }
                if (PreferredLoginQueue.contains(udpConnection)) {
                    PreferredLoginQueue.remove(udpConnection);
                }
            }
            zombie.network.LoginQueue.sendPlaceInTheQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInTheQueue(UdpConnection udpConnection) {
        if (!ServerOptions.getInstance().LoginQueueEnabled.getValue()) {
            return false;
        }
        ArrayList<UdpConnection> arrayList = LoginQueue;
        synchronized (arrayList) {
            return udpConnection == currentLoginQueue || LoginQueue.contains(udpConnection) || PreferredLoginQueue.contains(udpConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        if (ServerOptions.getInstance().LoginQueueEnabled.getValue() && UpdateLimit.Check()) {
            ArrayList<UdpConnection> arrayList = LoginQueue;
            synchronized (arrayList) {
                if (currentLoginQueue != null) {
                    if (currentLoginQueue.isFullyConnected()) {
                        if (Core.bDebug) {
                            DebugLog.log("update: isFullyConnected (ip:" + zombie.network.LoginQueue.currentLoginQueue.ip + ")");
                        }
                        currentLoginQueue = null;
                    } else if (LoginQueueTimeout.Check()) {
                        if (Core.bDebug) {
                            DebugLog.log("update: timeout (ip:" + zombie.network.LoginQueue.currentLoginQueue.ip + ")");
                        }
                        currentLoginQueue = null;
                    }
                }
                zombie.network.LoginQueue.loadNextPlayer();
            }
        }
    }

    private static void loadNextPlayer() {
        if (!PreferredLoginQueue.isEmpty() && currentLoginQueue == null) {
            currentLoginQueue = PreferredLoginQueue.remove(0);
            zombie.network.LoginQueue.currentLoginQueue.wasInLoadingQueue = true;
            if (Core.bDebug) {
                DebugLog.log("update: Next player from the preferred queue to connect (ip:" + zombie.network.LoginQueue.currentLoginQueue.ip + ")");
            }
            LoginQueueTimeout.Reset(ServerOptions.getInstance().LoginQueueConnectTimeout.getValue() * 1000);
            zombie.network.LoginQueue.sendConnectRequest(currentLoginQueue);
            zombie.network.LoginQueue.sendPlaceInTheQueue();
        }
        if (!LoginQueue.isEmpty() && currentLoginQueue == null) {
            currentLoginQueue = LoginQueue.remove(0);
            zombie.network.LoginQueue.currentLoginQueue.wasInLoadingQueue = true;
            if (Core.bDebug) {
                DebugLog.log("update: Next player to connect (ip:" + zombie.network.LoginQueue.currentLoginQueue.ip + ")");
            }
            LoginQueueTimeout.Reset(ServerOptions.getInstance().LoginQueueConnectTimeout.getValue() * 1000);
            zombie.network.LoginQueue.sendConnectRequest(currentLoginQueue);
            zombie.network.LoginQueue.sendPlaceInTheQueue();
        }
    }

    public static String getDescription() {
        return "queue=[" + LoginQueue.size() + "/" + PreferredLoginQueue.size() + "/\"" + (Serializable)(currentLoginQueue == null ? "" : Long.valueOf(currentLoginQueue.getConnectedGUID())) + "\"]";
    }

    static {
        UpdateLimit = new UpdateLimit(3050L);
        LoginQueueTimeout = new UpdateLimit(15000L);
    }

    public static enum LoginQueueMessageType {
        ConnectionImmediate,
        PlaceInQueue;

    }
}

