/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.HashSet;
import zombie.GameTime;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

public class ItemTransactionManager {
    private static final HashSet<ItemRequest> requests = new HashSet();

    public static void update() {
        requests.removeIf(ItemRequest::isTimeout);
    }

    public static boolean isConsistent(int n, int n2, int n3) {
        boolean bl = requests.stream().filter(itemRequest -> n == itemRequest.itemID || n2 == itemRequest.itemID || n3 == itemRequest.itemID || n == itemRequest.srcID || n == itemRequest.dstID).noneMatch(itemRequest -> itemRequest.state == 1);
        return bl;
    }

    public static void receiveOnClient(ByteBuffer byteBuffer, short s) {
        try {
            byte by = byteBuffer.get();
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            DebugLog.Multiplayer.debugln("%d [ %d : %d => %d ]", by, n, n2, n3);
            requests.stream().filter(itemRequest -> n == itemRequest.itemID && n2 == itemRequest.srcID && n3 == itemRequest.dstID).forEach(itemRequest -> itemRequest.setState(by));
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveOnClient: failed", LogSeverity.Error);
        }
    }

    public static void receiveOnServer(ByteBuffer byteBuffer, UdpConnection udpConnection, short s) {
        try {
            byte by = byteBuffer.get();
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            if (0 == by) {
                if (ItemTransactionManager.isConsistent(n, n2, n3)) {
                    requests.add(new ItemRequest(n, n2, n3));
                    ItemTransactionManager.sendItemTransaction(udpConnection, (byte)2, n, n2, n3);
                    DebugLog.Multiplayer.trace("set accepted [ %d : %d => %d ]", n, n2, n3);
                } else {
                    ItemTransactionManager.sendItemTransaction(udpConnection, (byte)1, n, n2, n3);
                    DebugLog.Multiplayer.trace("set rejected [ %d : %d => %d ]", n, n2, n3);
                }
            } else {
                requests.removeIf(itemRequest -> n == itemRequest.itemID && n2 == itemRequest.srcID && n3 == itemRequest.dstID);
                DebugLog.Multiplayer.trace("remove processed [ %d : %d => %d ]", n, n2, n3);
            }
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "ReceiveOnClient: failed", LogSeverity.Error);
        }
    }

    public static void createItemTransaction(int n, int n2, int n3) {
        if (ItemTransactionManager.isConsistent(n, n2, n3)) {
            requests.add(new ItemRequest(n, n2, n3));
            ItemTransactionManager.sendItemTransaction(GameClient.connection, (byte)0, n, n2, n3);
        }
    }

    public static void removeItemTransaction(int n, int n2, int n3) {
        if (requests.removeIf(itemRequest -> n == itemRequest.itemID && n2 == itemRequest.srcID && n3 == itemRequest.dstID)) {
            ItemTransactionManager.sendItemTransaction(GameClient.connection, (byte)2, n, n2, n3);
        }
    }

    private static void sendItemTransaction(UdpConnection udpConnection, byte by, int n, int n2, int n3) {
        if (udpConnection != null) {
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            try {
                PacketTypes.PacketType.ItemTransaction.doPacket(byteBufferWriter);
                byteBufferWriter.putByte(by);
                byteBufferWriter.putInt(n);
                byteBufferWriter.putInt(n2);
                byteBufferWriter.putInt(n3);
                PacketTypes.PacketType.ItemTransaction.send(udpConnection);
            }
            catch (Exception exception) {
                udpConnection.cancelPacket();
                DebugLog.Multiplayer.printException(exception, "SendItemTransaction: failed", LogSeverity.Error);
            }
        }
    }

    private static class ItemRequest {
        private static final byte StateUnknown = 0;
        private static final byte StateRejected = 1;
        private static final byte StateAccepted = 2;
        private final int itemID;
        private final int srcID;
        private final int dstID;
        private final long timestamp;
        private byte state;

        private ItemRequest(int n, int n2, int n3) {
            this.itemID = n;
            this.srcID = n2;
            this.dstID = n3;
            this.timestamp = GameTime.getServerTimeMills() + 5000L;
            this.state = GameServer.bServer ? (byte)1 : 0;
        }

        private void setState(byte by) {
            this.state = by;
        }

        private boolean isTimeout() {
            return GameTime.getServerTimeMills() > this.timestamp;
        }
    }
}

