/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import com.google.common.util.concurrent.FutureCallback;
import de.btobastian.javacord.DiscordAPI;
import de.btobastian.javacord.Javacord;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.listener.message.MessageCreateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.network.DiscordSender;

public class DiscordBot {
    private DiscordAPI api;
    private Collection<Channel> channels;
    private Channel current;
    private String currentChannelName;
    private String currentChannelID;
    private String name;
    private DiscordSender sender;

    public DiscordBot(String string, DiscordSender discordSender) {
        this.name = string;
        this.sender = discordSender;
        this.current = null;
    }

    public void connect(boolean bl, String string, String string2, String string3) {
        if (string == null || string.isEmpty()) {
            DebugLog.log(DebugType.Network, "DISCORD: token not configured");
            bl = false;
        }
        if (!bl) {
            DebugLog.log(DebugType.Network, "*** DISCORD DISABLED ****");
            this.current = null;
            return;
        }
        this.api = Javacord.getApi((String)string, (boolean)true);
        this.api.connect((FutureCallback)new Connector());
        DebugLog.log(DebugType.Network, "*** DISCORD ENABLED ****");
        this.currentChannelName = string2;
        this.currentChannelID = string3;
    }

    private void setChannel(String string, String string2) {
        Collection<String> collection = this.getChannelNames();
        if ((string == null || string.isEmpty()) && !collection.isEmpty()) {
            string = collection.iterator().next();
            DebugLog.log(DebugType.Network, "DISCORD: set default channel name = \"" + string + "\"");
        }
        if (string2 != null && !string2.isEmpty()) {
            this.setChannelByID(string2);
            return;
        }
        if (string != null) {
            this.setChannelByName(string);
        }
    }

    public void sendMessage(String string, String string2) {
        if (this.current != null) {
            this.current.sendMessage(string + ": " + string2);
            DebugLog.log(DebugType.Network, "DISCORD: User '" + string + "' send message: '" + string2 + "'");
        }
    }

    private Collection<String> getChannelNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.channels = this.api.getChannels();
        for (Channel channel : this.channels) {
            arrayList.add(channel.getName());
        }
        return arrayList;
    }

    private void setChannelByName(String string) {
        this.current = null;
        for (Channel channel : this.channels) {
            if (!channel.getName().equals(string)) continue;
            if (this.current != null) {
                DebugLog.log(DebugType.Network, "Discord server has few channels with name '" + string + "'. Please, use channel ID instead");
                this.current = null;
                return;
            }
            this.current = channel;
        }
        if (this.current == null) {
            DebugLog.log(DebugType.Network, "DISCORD: channel \"" + string + "\" is not found. Try to use channel ID instead");
        } else {
            DebugLog.log(DebugType.Network, "Discord enabled on channel: " + string);
        }
    }

    private void setChannelByID(String string) {
        this.current = null;
        for (Channel channel : this.channels) {
            if (!channel.getId().equals(string)) continue;
            DebugLog.log(DebugType.Network, "Discord enabled on channel with ID: " + string);
            this.current = channel;
            break;
        }
        if (this.current == null) {
            DebugLog.log(DebugType.Network, "DISCORD: channel with ID \"" + string + "\" not found");
        }
    }

    class Connector
    implements FutureCallback<DiscordAPI> {
        Connector() {
        }

        public void onSuccess(DiscordAPI discordAPI) {
            DebugLog.log(DebugType.Network, "*** DISCORD API CONNECTED ****");
            DiscordBot.this.setChannel(DiscordBot.this.currentChannelName, DiscordBot.this.currentChannelID);
            discordAPI.registerListener((de.btobastian.javacord.listener.Listener)new Listener());
            discordAPI.updateUsername(DiscordBot.this.name);
            if (DiscordBot.this.current != null) {
                DebugLog.log(DebugType.Network, "*** DISCORD INITIALIZATION SUCCEEDED ****");
            } else {
                DebugLog.log(DebugType.Network, "*** DISCORD INITIALIZATION FAILED ****");
            }
        }

        public void onFailure(Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    class Listener
    implements MessageCreateListener {
        Listener() {
        }

        public void onMessageCreate(DiscordAPI discordAPI, Message message) {
            if (DiscordBot.this.current == null) {
                return;
            }
            if (discordAPI.getYourself().getId().equals(message.getAuthor().getId())) {
                return;
            }
            if (message.getChannelReceiver().getId().equals(DiscordBot.this.current.getId())) {
                DebugLog.log(DebugType.Network, "DISCORD: get message on current channel");
                DebugLog.log(DebugType.Network, "DISCORD: send message = \"" + message.getContent() + "\" for " + message.getAuthor().getName() + ")");
                String string = this.replaceChannelIDByItsName(discordAPI, message);
                string = this.removeSmilesAndImages(string);
                if (!string.isEmpty() && !string.matches("^\\s$")) {
                    DiscordBot.this.sender.sendMessageFromDiscord(message.getAuthor().getName(), string);
                }
            }
        }

        private String replaceChannelIDByItsName(DiscordAPI discordAPI, Message message) {
            String string = message.getContent();
            Pattern pattern = Pattern.compile("<#(\\d+)>");
            Matcher matcher = pattern.matcher(message.getContent());
            if (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    Channel channel = discordAPI.getChannelById(matcher.group(i));
                    if (channel == null) continue;
                    string = string.replaceAll("<#" + matcher.group(i) + ">", "#" + channel.getName());
                }
            }
            return string;
        }

        private String removeSmilesAndImages(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (Character.isLowSurrogate(c.charValue()) || Character.isHighSurrogate(c.charValue())) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }
}

