/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.raknet.UdpConnection;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionMain;
import zombie.gameStates.ChooseGameInfo;
import zombie.gameStates.ConnectToServerState;
import zombie.gameStates.MainScreenState;
import zombie.globalObjects.SGlobalObjects;
import zombie.iso.Vector3;
import zombie.network.ConnectionManager;
import zombie.network.CoopSlave;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.network.ServerWorldDatabase;
import zombie.world.WorldDictionary;

public class ConnectionDetails {
    public static void write(UdpConnection udpConnection, ServerWorldDatabase.LogonResult logonResult, ByteBuffer byteBuffer) {
        try {
            ConnectionDetails.writeServerDetails(byteBuffer, udpConnection, logonResult);
            ConnectionDetails.writeGameMap(byteBuffer);
            if (SteamUtils.isSteamModeEnabled()) {
                ConnectionDetails.writeWorkshopItems(byteBuffer);
            }
            ConnectionDetails.writeMods(byteBuffer);
            ConnectionDetails.writeStartLocation(byteBuffer);
            ConnectionDetails.writeServerOptions(byteBuffer);
            ConnectionDetails.writeSandboxOptions(byteBuffer);
            ConnectionDetails.writeGameTime(byteBuffer);
            ConnectionDetails.writeErosionMain(byteBuffer);
            ConnectionDetails.writeGlobalObjects(byteBuffer);
            ConnectionDetails.writeResetID(byteBuffer);
            ConnectionDetails.writeBerries(byteBuffer);
            ConnectionDetails.writeWorldDictionary(byteBuffer);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void parse(ByteBuffer byteBuffer) {
        ConnectionManager.log("receive-packet", "connection-details", null);
        Calendar calendar = Calendar.getInstance();
        ConnectToServerState connectToServerState = new ConnectToServerState(byteBuffer);
        connectToServerState.enter();
        MainScreenState.getInstance().setConnectToServerState(connectToServerState);
        DebugLog.General.println("LOGGED INTO : %d millisecond", calendar.getTimeInMillis() - GameClient.startAuth.getTimeInMillis());
    }

    private static void writeServerDetails(ByteBuffer byteBuffer, UdpConnection udpConnection, ServerWorldDatabase.LogonResult logonResult) {
        byteBuffer.put((byte)(udpConnection.isCoopHost ? 1 : 0));
        byteBuffer.putInt(ServerOptions.getInstance().getMaxPlayers());
        if (SteamUtils.isSteamModeEnabled() && CoopSlave.instance != null && !udpConnection.isCoopHost) {
            byteBuffer.put((byte)1);
            byteBuffer.putLong(CoopSlave.instance.hostSteamID);
            GameWindow.WriteString(byteBuffer, GameServer.ServerName);
        } else {
            byteBuffer.put((byte)0);
        }
        int n = udpConnection.playerIDs[0] / 4;
        byteBuffer.put((byte)n);
        GameWindow.WriteString(byteBuffer, logonResult.accessLevel);
    }

    private static void writeGameMap(ByteBuffer byteBuffer) {
        GameWindow.WriteString(byteBuffer, GameServer.GameMap);
    }

    private static void writeWorkshopItems(ByteBuffer byteBuffer) {
        byteBuffer.putShort((short)GameServer.WorkshopItems.size());
        for (int i = 0; i < GameServer.WorkshopItems.size(); ++i) {
            byteBuffer.putLong(GameServer.WorkshopItems.get(i));
            byteBuffer.putLong(GameServer.WorkshopTimeStamps[i]);
        }
    }

    private static void writeMods(ByteBuffer byteBuffer) {
        ArrayList<ChooseGameInfo.Mod> arrayList = new ArrayList<ChooseGameInfo.Mod>();
        for (String object : GameServer.ServerMods) {
            ChooseGameInfo.Mod mod;
            String string = ZomboidFileSystem.instance.getModDir(object);
            if (string != null) {
                try {
                    mod = ChooseGameInfo.readModInfo(string);
                }
                catch (Exception exception) {
                    ExceptionLogger.logException(exception);
                    mod = new ChooseGameInfo.Mod(object);
                    mod.setId(object);
                    mod.setName(object);
                }
            } else {
                mod = new ChooseGameInfo.Mod(object);
                mod.setId(object);
                mod.setName(object);
            }
            arrayList.add(mod);
        }
        byteBuffer.putInt(arrayList.size());
        for (ChooseGameInfo.Mod mod : arrayList) {
            GameWindow.WriteString(byteBuffer, mod.getId());
            GameWindow.WriteString(byteBuffer, mod.getUrl());
            GameWindow.WriteString(byteBuffer, mod.getName());
        }
    }

    private static void writeStartLocation(ByteBuffer byteBuffer) {
        ServerWorldDatabase.LogonResult logonResult = null;
        Vector3 vector3 = ServerMap.instance.getStartLocation(logonResult);
        byteBuffer.putInt((int)vector3.x);
        byteBuffer.putInt((int)vector3.y);
        byteBuffer.putInt((int)vector3.z);
    }

    private static void writeServerOptions(ByteBuffer byteBuffer) {
        byteBuffer.putInt(ServerOptions.instance.getPublicOptions().size());
        for (String string : ServerOptions.instance.getPublicOptions()) {
            GameWindow.WriteString(byteBuffer, string);
            GameWindow.WriteString(byteBuffer, ServerOptions.instance.getOption(string));
        }
    }

    private static void writeSandboxOptions(ByteBuffer byteBuffer) throws IOException {
        SandboxOptions.instance.save(byteBuffer);
    }

    private static void writeGameTime(ByteBuffer byteBuffer) throws IOException {
        GameTime.getInstance().saveToPacket(byteBuffer);
    }

    private static void writeErosionMain(ByteBuffer byteBuffer) {
        ErosionMain.getInstance().getConfig().save(byteBuffer);
    }

    private static void writeGlobalObjects(ByteBuffer byteBuffer) throws IOException {
        SGlobalObjects.saveInitialStateForClient(byteBuffer);
    }

    private static void writeResetID(ByteBuffer byteBuffer) {
        byteBuffer.putInt(GameServer.ResetID);
    }

    private static void writeBerries(ByteBuffer byteBuffer) {
        GameWindow.WriteString(byteBuffer, Core.getInstance().getPoisonousBerry());
        GameWindow.WriteString(byteBuffer, Core.getInstance().getPoisonousMushroom());
    }

    private static void writeWorldDictionary(ByteBuffer byteBuffer) throws IOException {
        WorldDictionary.saveDataForClient(byteBuffer);
    }
}

