/*
 * Decompiled with CFR 0.152.
 */
package zombie.network;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

public class BodyDamageSync {
    public static final byte BD_Health = 1;
    public static final byte BD_bandaged = 2;
    public static final byte BD_bitten = 3;
    public static final byte BD_bleeding = 4;
    public static final byte BD_IsBleedingStemmed = 5;
    public static final byte BD_IsCortorised = 6;
    public static final byte BD_scratched = 7;
    public static final byte BD_stitched = 8;
    public static final byte BD_deepWounded = 9;
    public static final byte BD_IsInfected = 10;
    public static final byte BD_IsFakeInfected = 11;
    public static final byte BD_bandageLife = 12;
    public static final byte BD_scratchTime = 13;
    public static final byte BD_biteTime = 14;
    public static final byte BD_alcoholicBandage = 15;
    public static final byte BD_woundInfectionLevel = 16;
    public static final byte BD_infectedWound = 17;
    public static final byte BD_bleedingTime = 18;
    public static final byte BD_deepWoundTime = 19;
    public static final byte BD_haveGlass = 20;
    public static final byte BD_stitchTime = 21;
    public static final byte BD_alcoholLevel = 22;
    public static final byte BD_additionalPain = 23;
    public static final byte BD_bandageType = 24;
    public static final byte BD_getBandageXp = 25;
    public static final byte BD_getStitchXp = 26;
    public static final byte BD_getSplintXp = 27;
    public static final byte BD_fractureTime = 28;
    public static final byte BD_splint = 29;
    public static final byte BD_splintFactor = 30;
    public static final byte BD_haveBullet = 31;
    public static final byte BD_burnTime = 32;
    public static final byte BD_needBurnWash = 33;
    public static final byte BD_lastTimeBurnWash = 34;
    public static final byte BD_splintItem = 35;
    public static final byte BD_plantainFactor = 36;
    public static final byte BD_comfreyFactor = 37;
    public static final byte BD_garlicFactor = 38;
    public static final byte BD_cut = 39;
    public static final byte BD_cutTime = 40;
    public static final byte BD_stiffness = 41;
    public static final byte BD_BodyDamage = 50;
    private static final byte BD_START = 64;
    private static final byte BD_END = 65;
    private static final byte PKT_START_UPDATING = 1;
    private static final byte PKT_STOP_UPDATING = 2;
    private static final byte PKT_UPDATE = 3;
    public static BodyDamageSync instance = new BodyDamageSync();
    private ArrayList<Updater> updaters = new ArrayList();

    private static void noise(String string) {
        if (Core.bDebug || GameServer.bServer && GameServer.bDebug) {
            DebugLog.log("BodyDamage: " + string);
        }
    }

    public void startSendingUpdates(short s, short s2) {
        Updater updater;
        if (!GameClient.bClient) {
            return;
        }
        BodyDamageSync.noise("start sending updates to " + s2);
        for (int i = 0; i < this.updaters.size(); ++i) {
            updater = this.updaters.get(i);
            if (updater.localIndex != s || updater.remoteID != s2) continue;
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[s];
        updater = new Updater();
        updater.localIndex = s;
        updater.remoteID = s2;
        updater.bdLocal = isoPlayer.getBodyDamage();
        updater.bdSent = new BodyDamage(null);
        this.updaters.add(updater);
    }

    public void stopSendingUpdates(short s, short s2) {
        if (!GameClient.bClient) {
            return;
        }
        BodyDamageSync.noise("stop sending updates to " + s2);
        for (int i = 0; i < this.updaters.size(); ++i) {
            Updater updater = this.updaters.get(i);
            if (updater.localIndex != s || updater.remoteID != s2) continue;
            this.updaters.remove(i);
            return;
        }
    }

    public void startReceivingUpdates(short s) {
        if (!GameClient.bClient) {
            return;
        }
        BodyDamageSync.noise("start receiving updates from " + s + " to " + IsoPlayer.players[0].getOnlineID());
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putShort(IsoPlayer.players[0].getOnlineID());
        byteBufferWriter.putShort(s);
        PacketTypes.PacketType.BodyDamageUpdate.send(GameClient.connection);
    }

    public void stopReceivingUpdates(short s) {
        if (!GameClient.bClient) {
            return;
        }
        BodyDamageSync.noise("stop receiving updates from " + s + " to " + IsoPlayer.players[0].getOnlineID());
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)2);
        byteBufferWriter.putShort(IsoPlayer.players[0].getOnlineID());
        byteBufferWriter.putShort(s);
        PacketTypes.PacketType.BodyDamageUpdate.send(GameClient.connection);
    }

    public void update() {
        if (!GameClient.bClient) {
            return;
        }
        for (int i = 0; i < this.updaters.size(); ++i) {
            Updater updater = this.updaters.get(i);
            updater.update();
        }
    }

    public void serverPacket(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 1) {
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            Long l = GameServer.IDToAddressMap.get(s2);
            if (l == null) {
                return;
            }
            UdpConnection udpConnection = GameServer.udpEngine.getActiveConnection(l);
            if (udpConnection == null) {
                return;
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putShort(s);
            byteBufferWriter.putShort(s2);
            PacketTypes.PacketType.BodyDamageUpdate.send(udpConnection);
            return;
        }
        if (by == 2) {
            short s = byteBuffer.getShort();
            short s3 = byteBuffer.getShort();
            Long l = GameServer.IDToAddressMap.get(s3);
            if (l == null) {
                return;
            }
            UdpConnection udpConnection = GameServer.udpEngine.getActiveConnection(l);
            if (udpConnection == null) {
                return;
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)2);
            byteBufferWriter.putShort(s);
            byteBufferWriter.putShort(s3);
            PacketTypes.PacketType.BodyDamageUpdate.send(udpConnection);
            return;
        }
        if (by == 3) {
            short s = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            Long l = GameServer.IDToAddressMap.get(s4);
            if (l == null) {
                return;
            }
            UdpConnection udpConnection = GameServer.udpEngine.getActiveConnection(l);
            if (udpConnection == null) {
                return;
            }
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)3);
            byteBufferWriter.putShort(s);
            byteBufferWriter.putShort(s4);
            byteBufferWriter.bb.put(byteBuffer);
            PacketTypes.PacketType.BodyDamageUpdate.send(udpConnection);
            return;
        }
    }

    public void clientPacket(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by == 1) {
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            for (short s3 = 0; s3 < IsoPlayer.numPlayers; s3 = (short)((short)(s3 + 1))) {
                IsoPlayer isoPlayer = IsoPlayer.players[s3];
                BodyDamageSync.noise("looking for " + s2 + " testing player ID=" + isoPlayer.getOnlineID());
                if (isoPlayer == null || !isoPlayer.isAlive() || isoPlayer.getOnlineID() != s2) continue;
                this.startSendingUpdates(s3, s);
                break;
            }
            return;
        }
        if (by == 2) {
            short s = byteBuffer.getShort();
            short s4 = byteBuffer.getShort();
            for (short s5 = 0; s5 < IsoPlayer.numPlayers; s5 = (short)((short)(s5 + 1))) {
                IsoPlayer isoPlayer = IsoPlayer.players[s5];
                if (isoPlayer == null || isoPlayer.getOnlineID() != s4) continue;
                this.stopSendingUpdates(s5, s);
                break;
            }
            return;
        }
        if (by == 3) {
            short s = byteBuffer.getShort();
            short s6 = byteBuffer.getShort();
            IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(s);
            if (isoPlayer == null) {
                return;
            }
            BodyDamage bodyDamage = isoPlayer.getBodyDamageRemote();
            byte by2 = byteBuffer.get();
            if (by2 == 50) {
                bodyDamage.setOverallBodyHealth(byteBuffer.getFloat());
                bodyDamage.setRemotePainLevel(byteBuffer.get());
                bodyDamage.IsFakeInfected = byteBuffer.get() == 1;
                bodyDamage.InfectionLevel = byteBuffer.getFloat();
                by2 = byteBuffer.get();
            }
            while (by2 == 64) {
                byte by3 = byteBuffer.get();
                BodyPart bodyPart = bodyDamage.BodyParts.get(by3);
                byte by4 = byteBuffer.get();
                while (by4 != 65) {
                    bodyPart.sync(byteBuffer, by4);
                    by4 = byteBuffer.get();
                }
                by2 = byteBuffer.get();
            }
            return;
        }
    }

    public static final class Updater {
        static ByteBuffer bb = ByteBuffer.allocate(1024);
        short localIndex;
        short remoteID;
        BodyDamage bdLocal;
        BodyDamage bdSent;
        boolean partStarted;
        byte partIndex;
        long sendTime;

        void update() {
            long l = System.currentTimeMillis();
            if (l - this.sendTime < 500L) {
                return;
            }
            this.sendTime = l;
            bb.clear();
            int n = this.bdLocal.getParentChar().getMoodles().getMoodleLevel(MoodleType.Pain);
            if (this.compareFloats(this.bdLocal.getOverallBodyHealth(), (int)this.bdSent.getOverallBodyHealth()) || n != this.bdSent.getRemotePainLevel() || this.bdLocal.IsFakeInfected != this.bdSent.IsFakeInfected || this.compareFloats(this.bdLocal.InfectionLevel, this.bdSent.InfectionLevel)) {
                bb.put((byte)50);
                bb.putFloat(this.bdLocal.getOverallBodyHealth());
                bb.put((byte)n);
                bb.put((byte)(this.bdLocal.IsFakeInfected ? 1 : 0));
                bb.putFloat(this.bdLocal.InfectionLevel);
                this.bdSent.setOverallBodyHealth(this.bdLocal.getOverallBodyHealth());
                this.bdSent.setRemotePainLevel(n);
                this.bdSent.IsFakeInfected = this.bdLocal.IsFakeInfected;
                this.bdSent.InfectionLevel = this.bdLocal.InfectionLevel;
            }
            for (int i = 0; i < this.bdLocal.BodyParts.size(); ++i) {
                this.updatePart(i);
            }
            if (bb.position() > 0) {
                bb.put((byte)65);
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.BodyDamageUpdate.doPacket(byteBufferWriter);
                byteBufferWriter.putByte((byte)3);
                byteBufferWriter.putShort(IsoPlayer.players[this.localIndex].getOnlineID());
                byteBufferWriter.putShort(this.remoteID);
                byteBufferWriter.bb.put(bb.array(), 0, bb.position());
                PacketTypes.PacketType.BodyDamageUpdate.send(GameClient.connection);
            }
        }

        void updatePart(int n) {
            BodyPart bodyPart = this.bdLocal.BodyParts.get(n);
            BodyPart bodyPart2 = this.bdSent.BodyParts.get(n);
            this.partStarted = false;
            this.partIndex = (byte)n;
            bodyPart.sync(bodyPart2, this);
            if (this.partStarted) {
                bb.put((byte)65);
            }
        }

        public void updateField(byte by, boolean bl) {
            if (!this.partStarted) {
                bb.put((byte)64);
                bb.put(this.partIndex);
                this.partStarted = true;
            }
            bb.put(by);
            bb.put(bl ? (byte)1 : 0);
        }

        private boolean compareFloats(float f, float f2) {
            if (Float.compare(f, 0.0f) != Float.compare(f2, 0.0f)) {
                return true;
            }
            return (int)f != (int)f2;
        }

        public boolean updateField(byte by, float f, float f2) {
            if (!this.compareFloats(f, f2)) {
                return false;
            }
            if (!this.partStarted) {
                bb.put((byte)64);
                bb.put(this.partIndex);
                this.partStarted = true;
            }
            bb.put(by);
            bb.putFloat(f);
            return true;
        }

        public void updateField(byte by, String string) {
            if (!this.partStarted) {
                bb.put((byte)64);
                bb.put(this.partIndex);
                this.partStarted = true;
            }
            bb.put(by);
            GameWindow.WriteStringUTF(bb, string);
        }
    }
}

