/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import org.lwjgl.util.Rectangle;
import zombie.core.Color;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.iso.IsoCamera;
import zombie.iso.Vector2;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.ParticleRectangle;
import zombie.iso.weather.fx.SteppedUpdateFloat;

public abstract class WeatherParticle {
    protected ParticleRectangle parent;
    protected Rectangle bounds;
    protected Texture texture;
    protected Color color = Color.white;
    protected Vector2 position = new Vector2(0.0f, 0.0f);
    protected Vector2 velocity = new Vector2(0.0f, 0.0f);
    protected float alpha = 1.0f;
    protected float speed = 0.0f;
    protected SteppedUpdateFloat alphaFadeMod = new SteppedUpdateFloat(0.0f, 0.1f, 0.0f, 1.0f);
    protected float renderAlpha = 0.0f;
    protected float oWidth;
    protected float oHeight;
    protected float zoomMultiW = 0.0f;
    protected float zoomMultiH = 0.0f;
    protected boolean recalcSizeOnZoom = false;
    protected float lastZoomMod = -1.0f;

    public WeatherParticle(Texture texture) {
        this.texture = texture;
        this.bounds = new Rectangle(0, 0, texture.getWidth(), texture.getHeight());
        this.oWidth = this.bounds.getWidth();
        this.oHeight = this.bounds.getHeight();
    }

    public WeatherParticle(Texture texture, int n, int n2) {
        this.texture = texture;
        this.bounds = new Rectangle(0, 0, n, n2);
        this.oWidth = this.bounds.getWidth();
        this.oHeight = this.bounds.getHeight();
    }

    protected void setParent(ParticleRectangle particleRectangle) {
        this.parent = particleRectangle;
    }

    public void update(float f) {
        this.update(f, true);
    }

    public void update(float f, boolean bl) {
        this.alphaFadeMod.update(f);
        if (this.position.x > (float)this.parent.getWidth()) {
            this.position.x -= (float)((int)(this.position.x / (float)this.parent.getWidth()) * this.parent.getWidth());
        } else if (this.position.x < 0.0f) {
            this.position.x -= (float)((int)((this.position.x - (float)this.parent.getWidth()) / (float)this.parent.getWidth()) * this.parent.getWidth());
        }
        if (this.position.y > (float)this.parent.getHeight()) {
            this.position.y -= (float)((int)(this.position.y / (float)this.parent.getHeight()) * this.parent.getHeight());
        } else if (this.position.y < 0.0f) {
            this.position.y -= (float)((int)((this.position.y - (float)this.parent.getHeight()) / (float)this.parent.getHeight()) * this.parent.getHeight());
        }
        if (bl) {
            this.bounds.setLocation((int)this.position.x - this.bounds.getWidth() / 2, (int)this.position.y - this.bounds.getHeight() / 2);
        }
    }

    protected boolean updateZoomSize() {
        if (this.recalcSizeOnZoom && this.lastZoomMod != IsoWeatherFX.ZoomMod) {
            this.lastZoomMod = IsoWeatherFX.ZoomMod;
            this.oWidth = this.bounds.getWidth();
            this.oHeight = this.bounds.getHeight();
            if (this.lastZoomMod > 0.0f) {
                this.oWidth *= 1.0f + IsoWeatherFX.ZoomMod * this.zoomMultiW;
                this.oHeight *= 1.0f + IsoWeatherFX.ZoomMod * this.zoomMultiH;
            }
            return true;
        }
        return false;
    }

    public boolean isOnScreen(float f, float f2) {
        int n = IsoCamera.frameState.OffscreenWidth;
        int n2 = IsoCamera.frameState.OffscreenHeight;
        float f3 = f + (float)this.bounds.getX();
        float f4 = f2 + (float)this.bounds.getY();
        float f5 = f3 + this.oWidth;
        float f6 = f4 + this.oHeight;
        if (f3 >= (float)n || f5 <= 0.0f) {
            return false;
        }
        return !(f4 >= (float)n2) && !(f6 <= 0.0f);
    }

    public void render(float f, float f2) {
        SpriteRenderer.instance.render(this.texture, f + (float)this.bounds.getX(), f2 + (float)this.bounds.getY(), this.oWidth, this.oHeight, this.color.r, this.color.g, this.color.b, this.renderAlpha, null);
    }
}

