/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import zombie.core.Rand;
import zombie.core.textures.Texture;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.WeatherParticle;

public class SnowParticle
extends WeatherParticle {
    private double angleRadians = 0.0;
    private float lastAngle = -1.0f;
    private float lastIntensity = -1.0f;
    protected float angleOffset = 0.0f;
    private float alphaMod = 0.0f;
    private float incarnateAlpha = 1.0f;
    private float life = 0.0f;
    private float fadeTime = 80.0f;
    private float tmpAngle = 0.0f;

    public SnowParticle(Texture texture) {
        super(texture);
        this.recalcSizeOnZoom = true;
        this.zoomMultiW = 1.0f;
        this.zoomMultiH = 1.0f;
    }

    protected void setLife() {
        this.life = this.fadeTime + (float)Rand.Next(60, 500);
    }

    @Override
    public void update(float f) {
        if (this.lastAngle != IsoWeatherFX.instance.windAngle || this.lastIntensity != IsoWeatherFX.instance.windPrecipIntensity.value()) {
            this.tmpAngle = IsoWeatherFX.instance.windAngle + (this.angleOffset - this.angleOffset * 0.5f * IsoWeatherFX.instance.windPrecipIntensity.value());
            if (this.tmpAngle > 360.0f) {
                this.tmpAngle -= 360.0f;
            }
            if (this.tmpAngle < 0.0f) {
                this.tmpAngle += 360.0f;
            }
            this.angleRadians = Math.toRadians(this.tmpAngle);
            this.velocity.set((float)Math.cos(this.angleRadians) * this.speed, (float)Math.sin(this.angleRadians) * this.speed);
            this.lastAngle = IsoWeatherFX.instance.windAngle;
        }
        if (this.life >= this.fadeTime) {
            this.position.x += this.velocity.x * IsoWeatherFX.instance.windSpeed * f;
            this.position.y += this.velocity.y * IsoWeatherFX.instance.windSpeed * f;
        } else {
            this.incarnateAlpha = this.life / this.fadeTime;
        }
        this.life -= 1.0f;
        if (this.life < 0.0f) {
            this.setLife();
            this.incarnateAlpha = 0.0f;
            this.position.set(Rand.Next(0, this.parent.getWidth()), Rand.Next(0, this.parent.getHeight()));
        }
        if (this.incarnateAlpha < 1.0f) {
            this.incarnateAlpha += 0.05f;
            if (this.incarnateAlpha > 1.0f) {
                this.incarnateAlpha = 1.0f;
            }
        }
        super.update(f);
        this.updateZoomSize();
        this.alphaMod = 1.0f - 0.2f * IsoWeatherFX.instance.windIntensity.value();
        this.renderAlpha = this.alpha * this.alphaMod * this.alphaFadeMod.value() * IsoWeatherFX.instance.indoorsAlphaMod.value() * this.incarnateAlpha;
        this.renderAlpha *= 0.7f;
    }

    @Override
    public void render(float f, float f2) {
        super.render(f, f2);
    }
}

