/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import zombie.debug.LineDrawer;
import zombie.iso.IsoCamera;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.WeatherParticle;

public class ParticleRectangle {
    protected boolean DEBUG_BOUNDS = false;
    private int width;
    private int height;
    private WeatherParticle[] particles;
    private int particlesToRender;
    private int particlesReqUpdCnt = 0;

    public ParticleRectangle(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void SetParticles(WeatherParticle[] weatherParticleArray) {
        for (int i = 0; i < weatherParticleArray.length; ++i) {
            weatherParticleArray[i].setParent(this);
        }
        this.particles = weatherParticleArray;
        this.particlesToRender = weatherParticleArray.length;
    }

    public void SetParticlesStrength(float f) {
        this.particlesToRender = (int)((float)this.particles.length * f);
    }

    public boolean requiresUpdate() {
        return this.particlesToRender > 0 || this.particlesReqUpdCnt > 0;
    }

    public void update(float f) {
        this.particlesReqUpdCnt = 0;
        for (int i = 0; i < this.particles.length; ++i) {
            WeatherParticle weatherParticle = this.particles[i];
            if (i < this.particlesToRender) {
                weatherParticle.alphaFadeMod.setTarget(1.0f);
            } else if (i >= this.particlesToRender) {
                weatherParticle.alphaFadeMod.setTarget(0.0f);
            }
            weatherParticle.update(f);
            if (!(weatherParticle.renderAlpha > 0.0f)) continue;
            ++this.particlesReqUpdCnt;
        }
    }

    public void render() {
        int n = IsoCamera.frameState.playerIndex;
        int n2 = IsoCamera.frameState.OffscreenWidth;
        int n3 = IsoCamera.frameState.OffscreenHeight;
        int n4 = (int)Math.ceil(n2 / this.width) + 2;
        int n5 = (int)Math.ceil(n3 / this.height) + 2;
        int n6 = IsoCamera.frameState.OffX >= 0.0f ? (int)IsoCamera.frameState.OffX % this.width : this.width - (int)Math.abs(IsoCamera.frameState.OffX) % this.width;
        int n7 = IsoCamera.frameState.OffY >= 0.0f ? (int)IsoCamera.frameState.OffY % this.height : this.height - (int)Math.abs(IsoCamera.frameState.OffY) % this.height;
        int n8 = -n6;
        int n9 = -n7;
        for (int i = -1; i < n5; ++i) {
            for (int j = -1; j < n4; ++j) {
                int n10 = n8 + j * this.width;
                int n11 = n9 + i * this.height;
                if (this.DEBUG_BOUNDS || IsoWeatherFX.DEBUG_BOUNDS) {
                    LineDrawer.drawRect(n10, n11, this.width, this.height, 0.0f, 1.0f, 0.0f, 1.0f, 1);
                }
                for (int k = 0; k < this.particles.length; ++k) {
                    WeatherParticle weatherParticle = this.particles[k];
                    if (weatherParticle.renderAlpha <= 0.0f || !weatherParticle.isOnScreen(n10, n11)) continue;
                    weatherParticle.render(n10, n11);
                    if (!this.DEBUG_BOUNDS && !IsoWeatherFX.DEBUG_BOUNDS) continue;
                    LineDrawer.drawRect(n10 + weatherParticle.bounds.getX(), n11 + weatherParticle.bounds.getY(), weatherParticle.bounds.getWidth(), weatherParticle.bounds.getHeight(), 0.0f, 0.0f, 1.0f, 0.5f, 1);
                }
            }
        }
    }
}

