/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fx;

import zombie.core.textures.Texture;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.WeatherParticle;

public class FogParticle
extends WeatherParticle {
    private double angleRadians = 0.0;
    private float lastAngle = -1.0f;
    private float lastIntensity = -1.0f;
    protected float angleOffset = 0.0f;
    private float alphaMod = 0.0f;
    private float tmpAngle = 0.0f;

    public FogParticle(Texture texture, int n, int n2) {
        super(texture, n, n2);
    }

    @Override
    public void update(float f) {
        if (this.lastAngle != IsoWeatherFX.instance.windAngle || this.lastIntensity != IsoWeatherFX.instance.windIntensity.value()) {
            this.tmpAngle = IsoWeatherFX.instance.windAngle + (this.angleOffset - this.angleOffset * 1.0f * IsoWeatherFX.instance.windIntensity.value());
            if (this.tmpAngle > 360.0f) {
                this.tmpAngle -= 360.0f;
            }
            if (this.tmpAngle < 0.0f) {
                this.tmpAngle += 360.0f;
            }
            this.angleRadians = Math.toRadians(this.tmpAngle);
            this.velocity.set((float)Math.cos(this.angleRadians) * this.speed, (float)Math.sin(this.angleRadians) * this.speed);
            this.lastAngle = IsoWeatherFX.instance.windAngle;
        }
        this.position.x += this.velocity.x * IsoWeatherFX.instance.windSpeedFog * f;
        this.position.y += this.velocity.y * IsoWeatherFX.instance.windSpeedFog * f;
        super.update(f);
        this.alphaMod = IsoWeatherFX.instance.fogIntensity.value();
        this.renderAlpha = this.alpha * this.alphaMod * this.alphaFadeMod.value() * IsoWeatherFX.instance.indoorsAlphaMod.value();
    }
}

