/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.fog;

import org.joml.Vector2i;
import zombie.GameTime;
import zombie.IndieGL;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.input.GameKeyboard;
import zombie.iso.IsoCamera;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.PlayerCamera;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.fog.FogShader;
import zombie.iso.weather.fx.SteppedUpdateFloat;

public class ImprovedFog {
    private static final RectangleIterator rectangleIter = new RectangleIterator();
    private static final Vector2i rectangleMatrixPos = new Vector2i();
    private static IsoChunkMap chunkMap;
    private static int minY;
    private static int maxY;
    private static int minX;
    private static int maxX;
    private static int zLayer;
    private static Vector2i lastIterPos;
    private static FogRectangle fogRectangle;
    private static boolean drawingThisLayer;
    private static float ZOOM;
    private static int PlayerIndex;
    private static int playerRow;
    private static float screenWidth;
    private static float screenHeight;
    private static float worldOffsetX;
    private static float worldOffsetY;
    private static float topAlphaHeight;
    private static float bottomAlphaHeight;
    private static float secondLayerAlpha;
    private static float scalingX;
    private static float scalingY;
    private static float colorR;
    private static float colorG;
    private static float colorB;
    private static boolean drawDebugColors;
    private static float octaves;
    private static boolean highQuality;
    private static boolean enableEditing;
    private static float alphaCircleAlpha;
    private static float alphaCircleRad;
    private static int lastRow;
    private static ClimateManager climateManager;
    private static Texture noiseTexture;
    private static boolean renderOnlyOneRow;
    private static float baseAlpha;
    private static int renderEveryXRow;
    private static int renderXRowsFromCenter;
    private static boolean renderCurrentLayerOnly;
    private static float rightClickOffX;
    private static float rightClickOffY;
    private static float cameraOffscreenLeft;
    private static float cameraOffscreenTop;
    private static float cameraZoom;
    private static int minXOffset;
    private static int maxXOffset;
    private static int maxYOffset;
    private static boolean renderEndOnly;
    private static final SteppedUpdateFloat fogIntensity;
    private static int keyPause;
    private static final float[] offsets;

    public static int getMinXOffset() {
        return minXOffset;
    }

    public static void setMinXOffset(int n) {
        minXOffset = n;
    }

    public static int getMaxXOffset() {
        return maxXOffset;
    }

    public static void setMaxXOffset(int n) {
        maxXOffset = n;
    }

    public static int getMaxYOffset() {
        return maxYOffset;
    }

    public static void setMaxYOffset(int n) {
        maxYOffset = n;
    }

    public static boolean isRenderEndOnly() {
        return renderEndOnly;
    }

    public static void setRenderEndOnly(boolean bl) {
        renderEndOnly = bl;
    }

    public static float getAlphaCircleAlpha() {
        return alphaCircleAlpha;
    }

    public static void setAlphaCircleAlpha(float f) {
        alphaCircleAlpha = f;
    }

    public static float getAlphaCircleRad() {
        return alphaCircleRad;
    }

    public static void setAlphaCircleRad(float f) {
        alphaCircleRad = f;
    }

    public static boolean isHighQuality() {
        return highQuality;
    }

    public static void setHighQuality(boolean bl) {
        highQuality = bl;
    }

    public static boolean isEnableEditing() {
        return enableEditing;
    }

    public static void setEnableEditing(boolean bl) {
        enableEditing = bl;
    }

    public static float getTopAlphaHeight() {
        return topAlphaHeight;
    }

    public static void setTopAlphaHeight(float f) {
        topAlphaHeight = f;
    }

    public static float getBottomAlphaHeight() {
        return bottomAlphaHeight;
    }

    public static void setBottomAlphaHeight(float f) {
        bottomAlphaHeight = f;
    }

    public static boolean isDrawDebugColors() {
        return drawDebugColors;
    }

    public static void setDrawDebugColors(boolean bl) {
        drawDebugColors = bl;
    }

    public static float getOctaves() {
        return octaves;
    }

    public static void setOctaves(float f) {
        octaves = f;
    }

    public static float getColorR() {
        return colorR;
    }

    public static void setColorR(float f) {
        colorR = f;
    }

    public static float getColorG() {
        return colorG;
    }

    public static void setColorG(float f) {
        colorG = f;
    }

    public static float getColorB() {
        return colorB;
    }

    public static void setColorB(float f) {
        colorB = f;
    }

    public static float getSecondLayerAlpha() {
        return secondLayerAlpha;
    }

    public static void setSecondLayerAlpha(float f) {
        secondLayerAlpha = f;
    }

    public static float getScalingX() {
        return scalingX;
    }

    public static void setScalingX(float f) {
        scalingX = f;
    }

    public static float getScalingY() {
        return scalingY;
    }

    public static void setScalingY(float f) {
        scalingY = f;
    }

    public static boolean isRenderOnlyOneRow() {
        return renderOnlyOneRow;
    }

    public static void setRenderOnlyOneRow(boolean bl) {
        renderOnlyOneRow = bl;
    }

    public static float getBaseAlpha() {
        return baseAlpha;
    }

    public static void setBaseAlpha(float f) {
        baseAlpha = f;
    }

    public static int getRenderEveryXRow() {
        return renderEveryXRow;
    }

    public static void setRenderEveryXRow(int n) {
        renderEveryXRow = n;
    }

    public static boolean isRenderCurrentLayerOnly() {
        return renderCurrentLayerOnly;
    }

    public static void setRenderCurrentLayerOnly(boolean bl) {
        renderCurrentLayerOnly = bl;
    }

    public static int getRenderXRowsFromCenter() {
        return renderXRowsFromCenter;
    }

    public static void setRenderXRowsFromCenter(int n) {
        renderXRowsFromCenter = n;
    }

    public static void update() {
        ImprovedFog.updateKeys();
        if (noiseTexture == null) {
            noiseTexture = Texture.getSharedTexture("media/textures/weather/fognew/fog_noise.png");
        }
        climateManager = ClimateManager.getInstance();
        if (!enableEditing) {
            highQuality = PerformanceSettings.FogQuality == 0;
            fogIntensity.setTarget(climateManager.getFogIntensity());
            fogIntensity.update(GameTime.getInstance().getMultiplier());
            baseAlpha = fogIntensity.value();
            if (highQuality) {
                renderEveryXRow = 1;
                topAlphaHeight = 0.38f;
                bottomAlphaHeight = 0.24f;
                octaves = 6.0f;
                secondLayerAlpha = 0.5f;
            } else {
                renderEveryXRow = 2;
                topAlphaHeight = 0.32f;
                bottomAlphaHeight = 0.32f;
                octaves = 3.0f;
                secondLayerAlpha = 1.0f;
            }
            colorR = ImprovedFog.climateManager.getColorNewFog().getExterior().r;
            colorG = ImprovedFog.climateManager.getColorNewFog().getExterior().g;
            colorB = ImprovedFog.climateManager.getColorNewFog().getExterior().b;
        }
        if (baseAlpha <= 0.0f) {
            scalingX = 0.0f;
            scalingY = 0.0f;
        } else {
            double d = climateManager.getWindAngleRadians();
            d -= 2.356194490192345;
            d = Math.PI - d;
            float f = (float)Math.cos(d);
            float f2 = (float)Math.sin(d);
            scalingX += f * climateManager.getWindIntensity() * GameTime.getInstance().getMultiplier();
            scalingY += f2 * climateManager.getWindIntensity() * GameTime.getInstance().getMultiplier();
        }
    }

    public static void startRender(int n, int n2) {
        int n3;
        climateManager = ClimateManager.getInstance();
        if (n2 >= 2 || baseAlpha <= 0.0f || PerformanceSettings.FogQuality == 2) {
            drawingThisLayer = false;
            return;
        }
        drawingThisLayer = true;
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (renderCurrentLayerOnly && isoPlayer.getZ() != (float)n2) {
            drawingThisLayer = false;
            return;
        }
        if (isoPlayer.isInARoom() && n2 > 0) {
            drawingThisLayer = false;
            return;
        }
        playerRow = (int)isoPlayer.getX() + (int)isoPlayer.getY();
        ZOOM = Core.getInstance().getZoom(n);
        zLayer = n2;
        PlayerIndex = n;
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        screenWidth = IsoCamera.getOffscreenWidth(n);
        screenHeight = IsoCamera.getOffscreenHeight(n);
        worldOffsetX = playerCamera.getOffX() - (float)IsoCamera.getOffscreenLeft(PlayerIndex) * ZOOM;
        worldOffsetY = playerCamera.getOffY() + (float)IsoCamera.getOffscreenTop(PlayerIndex) * ZOOM;
        rightClickOffX = playerCamera.RightClickX;
        rightClickOffY = playerCamera.RightClickY;
        cameraOffscreenLeft = IsoCamera.getOffscreenLeft(n);
        cameraOffscreenTop = IsoCamera.getOffscreenTop(n);
        cameraZoom = ZOOM;
        if (!enableEditing) {
            if (isoPlayer.getVehicle() != null) {
                alphaCircleAlpha = 0.0f;
                alphaCircleRad = highQuality ? 2.0f : 2.6f;
            } else if (isoPlayer.isInARoom()) {
                alphaCircleAlpha = 0.0f;
                alphaCircleRad = highQuality ? 1.25f : 1.5f;
            } else {
                alphaCircleAlpha = highQuality ? 0.1f : 0.16f;
                float f = alphaCircleRad = highQuality ? 2.5f : 3.0f;
                if (climateManager.getWeatherPeriod().isRunning() && (climateManager.getWeatherPeriod().isTropicalStorm() || climateManager.getWeatherPeriod().isThunderStorm())) {
                    alphaCircleRad *= 0.6f;
                }
            }
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = n4 + IsoCamera.getOffscreenWidth(n);
        int n7 = n5 + IsoCamera.getOffscreenHeight(n);
        float f = IsoUtils.XToIso(n4, n5, zLayer);
        float f2 = IsoUtils.YToIso(n4, n5, zLayer);
        float f3 = IsoUtils.XToIso(n6, n7, zLayer);
        float f4 = IsoUtils.YToIso(n6, n7, zLayer);
        float f5 = IsoUtils.YToIso(n4, n7, zLayer);
        minY = (int)f2;
        maxY = (int)f4;
        minX = (int)f;
        maxX = (int)f3;
        if (IsoPlayer.numPlayers > 1) {
            maxX = Math.max(maxX, IsoWorld.instance.CurrentCell.getMaxX());
            maxY = Math.max(maxY, IsoWorld.instance.CurrentCell.getMaxY());
        }
        int n8 = n3 = (maxX += maxXOffset) - (minX += minXOffset);
        if (minY != (maxY += maxYOffset)) {
            n8 = (int)((float)n8 + PZMath.abs(minY - maxY));
        }
        rectangleIter.reset(n3, n8);
        lastRow = -1;
        ImprovedFog.fogRectangle.hasStarted = false;
        chunkMap = IsoWorld.instance.getCell().getChunkMap(n);
    }

    public static void renderRowsBehind(IsoGridSquare isoGridSquare) {
        if (!drawingThisLayer) {
            return;
        }
        int n = -1;
        if (isoGridSquare != null && (n = isoGridSquare.getX() + isoGridSquare.getY()) < minX + minY) {
            return;
        }
        if (lastRow >= 0 && lastRow == n) {
            return;
        }
        Vector2i vector2i = rectangleMatrixPos;
        while (rectangleIter.next(vector2i)) {
            if (vector2i == null) continue;
            int n2 = vector2i.x + minX;
            int n3 = vector2i.y + minY;
            int n4 = n2 + n3;
            if (n4 != lastRow) {
                if (!(lastRow < 0 || renderEndOnly && isoGridSquare != null)) {
                    ImprovedFog.endFogRectangle(ImprovedFog.lastIterPos.x, ImprovedFog.lastIterPos.y, zLayer);
                }
                lastRow = n4;
            }
            IsoGridSquare isoGridSquare2 = chunkMap.getGridSquare(n2, n3, zLayer);
            boolean bl = true;
            if (isoGridSquare2 != null && (!isoGridSquare2.isExteriorCache || isoGridSquare2.isInARoom())) {
                bl = false;
            }
            if (bl) {
                if (!renderEndOnly || isoGridSquare == null) {
                    ImprovedFog.startFogRectangle(n2, n3, zLayer);
                }
            } else if (!renderEndOnly || isoGridSquare == null) {
                ImprovedFog.endFogRectangle(ImprovedFog.lastIterPos.x, ImprovedFog.lastIterPos.y, zLayer);
            }
            lastIterPos.set(n2, n3);
            if (n == -1 || n4 != n) continue;
            break;
        }
    }

    public static void endRender() {
        if (!drawingThisLayer) {
            return;
        }
        ImprovedFog.renderRowsBehind(null);
        if (ImprovedFog.fogRectangle.hasStarted) {
            ImprovedFog.endFogRectangle(ImprovedFog.lastIterPos.x, ImprovedFog.lastIterPos.y, zLayer);
        }
    }

    private static void startFogRectangle(int n, int n2, int n3) {
        if (!ImprovedFog.fogRectangle.hasStarted) {
            ImprovedFog.fogRectangle.hasStarted = true;
            ImprovedFog.fogRectangle.startX = n;
            ImprovedFog.fogRectangle.startY = n2;
            ImprovedFog.fogRectangle.Z = n3;
        }
    }

    private static void endFogRectangle(int n, int n2, int n3) {
        if (ImprovedFog.fogRectangle.hasStarted) {
            ImprovedFog.fogRectangle.hasStarted = false;
            ImprovedFog.fogRectangle.endX = n;
            ImprovedFog.fogRectangle.endY = n2;
            ImprovedFog.fogRectangle.Z = n3;
            ImprovedFog.renderFogSegment();
        }
    }

    private static void renderFogSegment() {
        int n = ImprovedFog.fogRectangle.startX + ImprovedFog.fogRectangle.startY;
        int n2 = ImprovedFog.fogRectangle.endX + ImprovedFog.fogRectangle.endY;
        if (Core.bDebug && n != n2) {
            DebugLog.log("ROWS NOT EQUAL");
        }
        if (renderOnlyOneRow ? n != playerRow : n % renderEveryXRow != 0) {
            return;
        }
        if (Core.bDebug && renderXRowsFromCenter >= 1 && (n < playerRow - renderXRowsFromCenter || n > playerRow + renderXRowsFromCenter)) {
            return;
        }
        float f = baseAlpha;
        FogRectangle fogRectangle = ImprovedFog.fogRectangle;
        float f2 = IsoUtils.XToScreenExact(fogRectangle.startX, fogRectangle.startY, fogRectangle.Z, 0);
        float f3 = IsoUtils.YToScreenExact(fogRectangle.startX, fogRectangle.startY, fogRectangle.Z, 0);
        float f4 = IsoUtils.XToScreenExact(fogRectangle.endX, fogRectangle.endY, fogRectangle.Z, 0);
        float f5 = IsoUtils.YToScreenExact(fogRectangle.endX, fogRectangle.endY, fogRectangle.Z, 0);
        f3 -= 80.0f * (float)Core.TileScale;
        float f6 = 96.0f * (float)Core.TileScale;
        float f7 = ((f4 += 32.0f * (float)Core.TileScale) - (f2 -= 32.0f * (float)Core.TileScale)) / (64.0f * (float)Core.TileScale);
        float f8 = (float)fogRectangle.startX % 6.0f;
        float f9 = f8 / 6.0f;
        float f10 = f7 / 6.0f;
        float f11 = f9;
        float f12 = f10 + f9;
        if (FogShader.instance.StartShader()) {
            FogShader.instance.setScreenInfo(screenWidth, screenHeight, ZOOM, zLayer > 0 ? secondLayerAlpha : 1.0f);
            FogShader.instance.setTextureInfo(drawDebugColors ? 1.0f : 0.0f, octaves, f, Core.TileScale);
            FogShader.instance.setRectangleInfo((int)f2, (int)f3, (int)(f4 - f2), (int)f6);
            FogShader.instance.setWorldOffset(worldOffsetX, worldOffsetY, rightClickOffX, rightClickOffY);
            FogShader.instance.setScalingInfo(scalingX, scalingY, zLayer, highQuality ? 0.0f : 1.0f);
            FogShader.instance.setColorInfo(colorR, colorG, colorB, 1.0f);
            FogShader.instance.setParamInfo(topAlphaHeight, bottomAlphaHeight, alphaCircleAlpha, alphaCircleRad);
            FogShader.instance.setCameraInfo(cameraOffscreenLeft, cameraOffscreenTop, cameraZoom, offsets[n % offsets.length]);
            SpriteRenderer.instance.render(noiseTexture, (int)f2, (int)f3, (int)(f4 - f2), (int)f6, 1.0f, 1.0f, 1.0f, f, f11, 0.0f, f12, 0.0f, f12, 1.0f, f11, 1.0f);
            IndieGL.EndShader();
        }
    }

    public static void DrawSubTextureRGBA(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        if (texture == null || d3 <= 0.0 || d4 <= 0.0 || d7 <= 0.0 || d8 <= 0.0) {
            return;
        }
        double d13 = d5;
        double d14 = d6;
        d13 += (double)texture.offsetX;
        if ((d14 += (double)texture.offsetY) + d8 < 0.0 || d14 > 4096.0) {
            return;
        }
        float f = PZMath.clamp((float)d, 0.0f, (float)texture.getWidth());
        float f2 = PZMath.clamp((float)d2, 0.0f, (float)texture.getHeight());
        float f3 = PZMath.clamp((float)((double)f + d3), 0.0f, (float)texture.getWidth()) - f;
        float f4 = PZMath.clamp((float)((double)f2 + d4), 0.0f, (float)texture.getHeight()) - f2;
        float f5 = f / (float)texture.getWidth();
        float f6 = f2 / (float)texture.getHeight();
        float f7 = (f + f3) / (float)texture.getWidth();
        float f8 = (f2 + f4) / (float)texture.getHeight();
        float f9 = texture.getXEnd() - texture.getXStart();
        float f10 = texture.getYEnd() - texture.getYStart();
        f5 = texture.getXStart() + f5 * f9;
        f7 = texture.getXStart() + f7 * f9;
        f6 = texture.getYStart() + f6 * f10;
        f8 = texture.getYStart() + f8 * f10;
        SpriteRenderer.instance.render(texture, (float)d13, (float)d14, (float)d7, (float)d8, (float)d9, (float)d10, (float)d11, (float)d12, f5, f6, f7, f6, f7, f8, f5, f8);
    }

    public static void updateKeys() {
        if (!Core.bDebug) {
            return;
        }
        if (keyPause > 0) {
            --keyPause;
        }
        if (keyPause <= 0 && GameKeyboard.isKeyDown(72)) {
            DebugLog.log("Reloading fog shader...");
            keyPause = 30;
            FogShader.instance.reloadShader();
        }
    }

    public static void init() {
        climateManager = ClimateManager.getInstance();
        fogIntensity.setTarget(climateManager.getFogIntensity());
        fogIntensity.overrideCurrentValue(climateManager.getFogIntensity());
        baseAlpha = fogIntensity.value();
    }

    static {
        lastIterPos = new Vector2i();
        fogRectangle = new FogRectangle();
        drawingThisLayer = false;
        ZOOM = 1.0f;
        topAlphaHeight = 0.38f;
        bottomAlphaHeight = 0.24f;
        secondLayerAlpha = 0.5f;
        scalingX = 1.0f;
        scalingY = 1.0f;
        colorR = 1.0f;
        colorG = 1.0f;
        colorB = 1.0f;
        drawDebugColors = false;
        octaves = 6.0f;
        highQuality = true;
        enableEditing = false;
        alphaCircleAlpha = 0.3f;
        alphaCircleRad = 2.25f;
        lastRow = -1;
        renderOnlyOneRow = false;
        baseAlpha = 0.0f;
        renderEveryXRow = 1;
        renderXRowsFromCenter = 0;
        renderCurrentLayerOnly = false;
        rightClickOffX = 0.0f;
        rightClickOffY = 0.0f;
        cameraOffscreenLeft = 0.0f;
        cameraOffscreenTop = 0.0f;
        cameraZoom = 0.0f;
        minXOffset = -2;
        maxXOffset = 12;
        maxYOffset = -5;
        renderEndOnly = false;
        fogIntensity = new SteppedUpdateFloat(0.0f, 0.005f, 0.0f, 1.0f);
        keyPause = 0;
        offsets = new float[]{0.3f, 0.8f, 0.0f, 0.6f, 0.3f, 0.1f, 0.5f, 0.9f, 0.2f, 0.0f, 0.7f, 0.1f, 0.4f, 0.2f, 0.5f, 0.3f, 0.8f, 0.4f, 0.9f, 0.5f, 0.8f, 0.4f, 0.7f, 0.2f, 0.0f, 0.6f, 0.1f, 0.6f, 0.9f, 0.7f};
    }

    private static class RectangleIterator {
        private int curX = 0;
        private int curY = 0;
        private int sX;
        private int sY;
        private int rowLen = 0;
        private boolean altRow = false;
        private int curRow = 0;
        private int rowIndex = 0;
        private int maxRows = 0;

        private RectangleIterator() {
        }

        public void reset(int n, int n2) {
            this.sX = 0;
            this.sY = 0;
            this.curX = 0;
            this.curY = 0;
            this.curRow = 0;
            this.altRow = false;
            this.rowIndex = 0;
            this.rowLen = (int)PZMath.ceil((float)n2 / 2.0f);
            this.maxRows = n;
        }

        public boolean next(Vector2i vector2i) {
            if (this.rowLen <= 0 || this.maxRows <= 0 || this.curRow >= this.maxRows) {
                vector2i.set(0, 0);
                return false;
            }
            vector2i.set(this.curX, this.curY);
            ++this.rowIndex;
            if (this.rowIndex == this.rowLen) {
                this.rowLen = this.altRow ? this.rowLen - 1 : this.rowLen + 1;
                this.rowIndex = 0;
                this.sX = this.altRow ? this.sX + 1 : this.sX;
                this.sY = this.altRow ? this.sY : this.sY + 1;
                this.altRow = !this.altRow;
                this.curX = this.sX;
                this.curY = this.sY;
                ++this.curRow;
                return this.curRow != this.maxRows;
            }
            ++this.curX;
            --this.curY;
            return true;
        }
    }

    private static class FogRectangle {
        int startX;
        int startY;
        int endX;
        int endY;
        int Z;
        boolean hasStarted = false;

        private FogRectangle() {
        }
    }
}

