/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather.dbg;

import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import zombie.GameTime;
import zombie.SandboxOptions;
import zombie.ZomboidFileSystem;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.erosion.season.ErosionSeason;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.SimplexNoise;
import zombie.iso.weather.WeatherPeriod;
import zombie.network.GameClient;

public class ClimMngrDebug
extends ClimateManager {
    private GregorianCalendar calendar;
    private double worldAgeHours = 0.0;
    private double worldAgeHoursStart = 0.0;
    private double weatherPeriodTime = 0.0;
    private double simplexOffsetA;
    private ClimateManager.AirFront currentFront;
    private WeatherPeriod weatherPeriod;
    private boolean tickIsDayChange = false;
    public ArrayList<RunInfo> runs = new ArrayList();
    private RunInfo currentRun;
    private ErosionSeason season;
    private int TotalDaysPeriodIndexMod = 5;
    private boolean DoOverrideSandboxRainMod = false;
    private int SandboxRainModOverride = 3;
    private int durDays = 0;
    private static final int WEATHER_NORMAL = 0;
    private static final int WEATHER_STORM = 1;
    private static final int WEATHER_TROPICAL = 2;
    private static final int WEATHER_BLIZZARD = 3;
    private FileWriter writer;

    public ClimMngrDebug() {
        this.currentFront = new ClimateManager.AirFront();
        this.weatherPeriod = new WeatherPeriod(this, null);
        this.weatherPeriod.setPrintStuff(false);
    }

    public void setRainModOverride(int n) {
        this.DoOverrideSandboxRainMod = true;
        this.SandboxRainModOverride = n;
    }

    public void unsetRainModOverride() {
        this.DoOverrideSandboxRainMod = false;
        this.SandboxRainModOverride = 3;
    }

    public void SimulateDays(int n, int n2) {
        this.durDays = n;
        DebugLog.log("Starting " + n2 + " simulations of " + n + " days per run...");
        int n3 = 0;
        int n4 = 0;
        DebugLog.log("Year: " + GameTime.instance.getYear() + ", Month: " + n3 + ", Day: " + n4);
        for (int i = 0; i < n2; ++i) {
            this.calendar = new GregorianCalendar(GameTime.instance.getYear(), n3, n4, 0, 0);
            this.season = ClimateManager.getInstance().getSeason().clone();
            this.season.init(this.season.getLat(), this.season.getTempMax(), this.season.getTempMin(), this.season.getTempDiff(), this.season.getSeasonLag(), this.season.getHighNoon(), Rand.Next(0, 255), Rand.Next(0, 255), Rand.Next(0, 255));
            this.simplexOffsetA = Rand.Next(0, 8000);
            this.weatherPeriodTime = this.worldAgeHours = 250.0;
            this.worldAgeHoursStart = this.worldAgeHours;
            double d = this.getAirMassNoiseFrequencyMod(SandboxOptions.instance.getRainModifier());
            float f = (float)SimplexNoise.noise(this.simplexOffsetA, this.worldAgeHours / d);
            int n5 = f < 0.0f ? -1 : 1;
            this.currentFront.setFrontType(n5);
            this.weatherPeriod.stopWeatherPeriod();
            double d2 = this.worldAgeHours + 24.0;
            int n6 = n * 24;
            this.currentRun = new RunInfo();
            this.currentRun.durationDays = n;
            this.currentRun.durationHours = n6;
            this.currentRun.seedA = this.simplexOffsetA;
            this.runs.add(this.currentRun);
            for (int j = 0; j < n6; ++j) {
                this.tickIsDayChange = false;
                this.worldAgeHours += 1.0;
                if (this.worldAgeHours >= d2) {
                    this.tickIsDayChange = true;
                    d2 += 24.0;
                    this.calendar.add(5, 1);
                    int n7 = this.calendar.get(5);
                    int n8 = this.calendar.get(2);
                    int n9 = this.calendar.get(1);
                    this.season.setDay(n7, n8, n9);
                }
                this.update_sim();
            }
        }
        this.saveData();
    }

    private void update_sim() {
        int n;
        double d = this.getAirMassNoiseFrequencyMod(SandboxOptions.instance.getRainModifier());
        float f = (float)SimplexNoise.noise(this.simplexOffsetA, this.worldAgeHours / d);
        int n2 = n = f < 0.0f ? -1 : 1;
        if (this.currentFront.getType() != n) {
            if (this.worldAgeHours > this.weatherPeriodTime) {
                this.weatherPeriod.initSimulationDebug(this.currentFront, this.worldAgeHours);
                this.recordAndCloseWeatherPeriod();
            }
            this.currentFront.setFrontType(n);
        }
        if (!WINTER_IS_COMING && !THE_DESCENDING_FOG && this.worldAgeHours >= this.worldAgeHoursStart + 72.0 && this.worldAgeHours <= this.worldAgeHoursStart + 96.0 && !this.weatherPeriod.isRunning() && this.worldAgeHours > this.weatherPeriodTime && Rand.Next(0, 1000) < 50) {
            this.triggerCustomWeatherStage(3, 10.0f);
        }
        if (this.tickIsDayChange) {
            double d2 = Math.floor(this.worldAgeHours) + 12.0;
            float f2 = (float)SimplexNoise.noise(this.simplexOffsetA, d2 / d);
            float f3 = f2;
            int n3 = n = f3 < 0.0f ? -1 : 1;
            if (n == this.currentFront.getType()) {
                this.currentFront.addDaySample(f3);
            }
        }
    }

    private void recordAndCloseWeatherPeriod() {
        if (this.weatherPeriod.isRunning()) {
            if (this.worldAgeHours - this.weatherPeriodTime > 0.0) {
                this.currentRun.addRecord(this.worldAgeHours - this.weatherPeriodTime);
            }
            this.weatherPeriodTime = this.worldAgeHours + Math.ceil(this.weatherPeriod.getDuration());
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (WeatherPeriod.WeatherStage weatherStage : this.weatherPeriod.getWeatherStages()) {
                if (weatherStage.getStageID() == 3) {
                    bl = true;
                }
                if (weatherStage.getStageID() == 8) {
                    bl2 = true;
                }
                if (weatherStage.getStageID() != 7) continue;
                bl3 = true;
            }
            this.currentRun.addRecord(this.currentFront.getType(), this.weatherPeriod.getDuration(), this.weatherPeriod.getFrontCache().getStrength(), bl, bl2, bl3);
        }
        this.weatherPeriod.stopWeatherPeriod();
    }

    @Override
    public boolean triggerCustomWeatherStage(int n, float f) {
        if (!GameClient.bClient && !this.weatherPeriod.isRunning()) {
            ClimateManager.AirFront airFront = new ClimateManager.AirFront();
            airFront.setFrontType(1);
            airFront.setStrength(0.95f);
            this.weatherPeriod.initSimulationDebug(airFront, this.worldAgeHours, n, f);
            this.recordAndCloseWeatherPeriod();
            return true;
        }
        return false;
    }

    @Override
    protected double getAirMassNoiseFrequencyMod(int n) {
        if (this.DoOverrideSandboxRainMod) {
            return super.getAirMassNoiseFrequencyMod(this.SandboxRainModOverride);
        }
        return super.getAirMassNoiseFrequencyMod(n);
    }

    @Override
    protected float getRainTimeMultiplierMod(int n) {
        if (this.DoOverrideSandboxRainMod) {
            return super.getRainTimeMultiplierMod(this.SandboxRainModOverride);
        }
        return super.getRainTimeMultiplierMod(n);
    }

    @Override
    public ErosionSeason getSeason() {
        return this.season;
    }

    @Override
    public float getDayMeanTemperature() {
        return this.season.getDayMeanTemperature();
    }

    @Override
    public void resetOverrides() {
    }

    private RunInfo calculateTotal() {
        RunInfo runInfo = new RunInfo();
        runInfo.totalDaysPeriod = new int[50];
        double d = 0.0;
        double d2 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (RunInfo runInfo2 : this.runs) {
            int n;
            if (runInfo2.totalPeriodDuration < runInfo.mostDryPeriod) {
                runInfo.mostDryPeriod = runInfo2.totalPeriodDuration;
            }
            if (runInfo2.totalPeriodDuration > runInfo.mostWetPeriod) {
                runInfo.mostWetPeriod = runInfo2.totalPeriodDuration;
            }
            runInfo.totalPeriodDuration += runInfo2.totalPeriodDuration;
            if (runInfo2.longestPeriod > runInfo.longestPeriod) {
                runInfo.longestPeriod = runInfo2.longestPeriod;
            }
            if (runInfo2.shortestPeriod < runInfo.shortestPeriod) {
                runInfo.shortestPeriod = runInfo2.shortestPeriod;
            }
            runInfo.totalPeriods += runInfo2.totalPeriods;
            runInfo.averagePeriod += runInfo2.averagePeriod;
            if (runInfo2.longestEmpty > runInfo.longestEmpty) {
                runInfo.longestEmpty = runInfo2.longestEmpty;
            }
            if (runInfo2.shortestEmpty < runInfo.shortestEmpty) {
                runInfo.shortestEmpty = runInfo2.shortestEmpty;
            }
            runInfo.totalEmpty += runInfo2.totalEmpty;
            runInfo.averageEmpty += runInfo2.averageEmpty;
            if (runInfo2.highestStrength > runInfo.highestStrength) {
                runInfo.highestStrength = runInfo2.highestStrength;
            }
            if (runInfo2.lowestStrength < runInfo.lowestStrength) {
                runInfo.lowestStrength = runInfo2.lowestStrength;
            }
            runInfo.averageStrength += runInfo2.averageStrength;
            if (runInfo2.highestWarmStrength > runInfo.highestWarmStrength) {
                runInfo.highestWarmStrength = runInfo2.highestWarmStrength;
            }
            if (runInfo2.lowestWarmStrength < runInfo.lowestWarmStrength) {
                runInfo.lowestWarmStrength = runInfo2.lowestWarmStrength;
            }
            runInfo.averageWarmStrength += runInfo2.averageWarmStrength;
            if (runInfo2.highestColdStrength > runInfo.highestColdStrength) {
                runInfo.highestColdStrength = runInfo2.highestColdStrength;
            }
            if (runInfo2.lowestColdStrength < runInfo.lowestColdStrength) {
                runInfo.lowestColdStrength = runInfo2.lowestColdStrength;
            }
            runInfo.averageColdStrength += runInfo2.averageColdStrength;
            runInfo.countNormalWarm += runInfo2.countNormalWarm;
            runInfo.countNormalCold += runInfo2.countNormalCold;
            runInfo.countStorm += runInfo2.countStorm;
            runInfo.countTropical += runInfo2.countTropical;
            runInfo.countBlizzard += runInfo2.countBlizzard;
            for (n = 0; n < runInfo2.dayCountPeriod.length; ++n) {
                int n2 = n;
                runInfo.dayCountPeriod[n2] = runInfo.dayCountPeriod[n2] + runInfo2.dayCountPeriod[n];
            }
            for (n = 0; n < runInfo2.dayCountWarmPeriod.length; ++n) {
                int n3 = n;
                runInfo.dayCountWarmPeriod[n3] = runInfo.dayCountWarmPeriod[n3] + runInfo2.dayCountWarmPeriod[n];
            }
            for (n = 0; n < runInfo2.dayCountColdPeriod.length; ++n) {
                int n4 = n;
                runInfo.dayCountColdPeriod[n4] = runInfo.dayCountColdPeriod[n4] + runInfo2.dayCountColdPeriod[n];
            }
            for (n = 0; n < runInfo2.dayCountEmpty.length; ++n) {
                int n5 = n;
                runInfo.dayCountEmpty[n5] = runInfo.dayCountEmpty[n5] + runInfo2.dayCountEmpty[n];
            }
            for (n = 0; n < runInfo2.exceedingPeriods.size(); ++n) {
                runInfo.exceedingPeriods.add(runInfo2.exceedingPeriods.get(n));
            }
            for (n = 0; n < runInfo2.exceedingEmpties.size(); ++n) {
                runInfo.exceedingEmpties.add(runInfo2.exceedingEmpties.get(n));
            }
            n = (int)(runInfo2.totalPeriodDuration / (double)(this.TotalDaysPeriodIndexMod * 24));
            if (n < runInfo.totalDaysPeriod.length) {
                int n6 = n;
                runInfo.totalDaysPeriod[n6] = runInfo.totalDaysPeriod[n6] + 1;
                continue;
            }
            DebugLog.log("Total days Period is longer than allowed array, days = " + n * this.TotalDaysPeriodIndexMod);
        }
        if (this.runs.size() > 0) {
            int n = this.runs.size();
            runInfo.totalPeriodDuration /= (double)n;
            runInfo.averagePeriod /= (double)n;
            runInfo.averageEmpty /= (double)n;
            runInfo.averageStrength /= (float)n;
            runInfo.averageWarmStrength /= (float)n;
            runInfo.averageColdStrength /= (float)n;
        }
        return runInfo;
    }

    private void saveData() {
        block31: {
            if (this.runs.size() <= 0) {
                return;
            }
            try {
                FileWriter exception;
                for (RunInfo object2 : this.runs) {
                    object2.calculate();
                }
                RunInfo runInfo = this.calculateTotal();
                String string = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                ZomboidFileSystem.instance.getFileInCurrentSave("climate").mkdirs();
                File file = ZomboidFileSystem.instance.getFileInCurrentSave("climate");
                if (!file.exists() || !file.isDirectory()) break block31;
                String string2 = ZomboidFileSystem.instance.getFileNameInCurrentSave("climate", string + ".txt");
                DebugLog.log("Attempting to save test data to: " + string2);
                File file2 = new File(string2);
                DebugLog.log("Saving climate test data: " + string2);
                try {
                    exception = new FileWriter(file2, false);
                    try {
                        this.writer = exception;
                        int n = this.runs.size();
                        this.write("Simulation results." + System.lineSeparator());
                        this.write("Runs: " + this.runs.size() + ", days per cycle: " + this.durDays);
                        if (this.DoOverrideSandboxRainMod) {
                            this.write("RainModifier used: " + this.SandboxRainModOverride);
                        } else {
                            this.write("RainModifier used: " + SandboxOptions.instance.getRainModifier());
                        }
                        this.write("");
                        this.write("===================================================================");
                        this.write(" TOTALS OVERVIEW");
                        this.write("===================================================================");
                        this.write("");
                        this.write("Total weather periods: " + runInfo.totalPeriods + ", average per cycle: " + runInfo.totalPeriods / n);
                        this.write("Longest weather: " + this.formatDuration(runInfo.longestPeriod));
                        this.write("Shortest weather: " + this.formatDuration(runInfo.shortestPeriod));
                        this.write("Average weather: " + this.formatDuration(runInfo.averagePeriod));
                        this.write("");
                        this.write("Average total weather days per cycle: " + this.formatDuration(runInfo.totalPeriodDuration));
                        this.write("");
                        this.write("Driest cycle total weather days: " + this.formatDuration(runInfo.mostDryPeriod));
                        this.write("Wettest cycle total weather days: " + this.formatDuration(runInfo.mostWetPeriod));
                        this.write("");
                        this.write("Total clear periods: " + runInfo.totalEmpty + ", average per cycle: " + runInfo.totalEmpty / n);
                        this.write("Longest clear: " + this.formatDuration(runInfo.longestEmpty));
                        this.write("Shortest clear: " + this.formatDuration(runInfo.shortestEmpty));
                        this.write("Average clear: " + this.formatDuration(runInfo.averageEmpty));
                        this.write("");
                        this.write("Highest Front strength: " + runInfo.highestStrength);
                        this.write("Lowest Front strength: " + runInfo.lowestStrength);
                        this.write("Average Front strength: " + runInfo.averageStrength);
                        this.write("");
                        this.write("Highest WarmFront strength: " + runInfo.highestWarmStrength);
                        this.write("Lowest WarmFront strength: " + runInfo.lowestWarmStrength);
                        this.write("Average WarmFront strength: " + runInfo.averageWarmStrength);
                        this.write("");
                        this.write("Highest ColdFront strength: " + runInfo.highestColdStrength);
                        this.write("Lowest ColdFront strength: " + runInfo.lowestColdStrength);
                        this.write("Average ColdFront strength: " + runInfo.averageColdStrength);
                        this.write("");
                        this.write("Weather period types:");
                        double d = n;
                        this.write("Normal warm: " + runInfo.countNormalWarm + ", average: " + this.round((double)runInfo.countNormalWarm / d));
                        this.write("Normal cold: " + runInfo.countNormalCold + ", average: " + this.round((double)runInfo.countNormalCold / d));
                        this.write("Normal storm: " + runInfo.countStorm + ", average: " + this.round((double)runInfo.countStorm / (double)n));
                        this.write("Normal tropical: " + runInfo.countTropical + ", average: " + this.round((double)runInfo.countTropical / d));
                        this.write("Normal blizzard: " + runInfo.countBlizzard + ", average: " + this.round((double)runInfo.countBlizzard / d));
                        this.write("");
                        this.write("Distribution duration in days (total periods)");
                        this.printCountTable(exception, runInfo.dayCountPeriod);
                        this.write("");
                        this.write("Distribution duration in days (WARM periods)");
                        this.printCountTable(exception, runInfo.dayCountWarmPeriod);
                        this.write("");
                        this.write("Distribution duration in days (COLD periods)");
                        this.printCountTable(exception, runInfo.dayCountColdPeriod);
                        this.write("");
                        this.write("Distribution duration in days (clear periods)");
                        this.printCountTable(exception, runInfo.dayCountEmpty);
                        this.write("");
                        this.write("Amount of weather periods exceeding threshold: " + runInfo.exceedingPeriods.size());
                        if (runInfo.exceedingPeriods.size() > 0) {
                            for (Integer n2 : runInfo.exceedingPeriods) {
                                this.writer.write(n2 + " days, ");
                            }
                        }
                        this.write("");
                        this.write("");
                        this.write("Amount of clear periods exceeding threshold: " + runInfo.exceedingEmpties.size());
                        if (runInfo.exceedingEmpties.size() > 0) {
                            for (Integer n2 : runInfo.exceedingEmpties) {
                                this.writer.write(n2 + " days, ");
                            }
                        }
                        this.write("");
                        this.write("");
                        this.write("Distribution duration total weather days:");
                        this.printCountTable(this.writer, runInfo.totalDaysPeriod, this.TotalDaysPeriodIndexMod);
                        this.writeDataExtremes();
                        this.writer = null;
                    }
                    finally {
                        exception.close();
                    }
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                file2 = ZomboidFileSystem.instance.getFileInCurrentSave("climate", string + "_DATA.txt");
                try {
                    exception = new FileWriter(file2, false);
                    try {
                        this.writer = exception;
                        this.writeData();
                        this.writer = null;
                    }
                    finally {
                        exception.close();
                    }
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
                file2 = ZomboidFileSystem.instance.getFileInCurrentSave("climate", string + "_PATTERNS.txt");
                try {
                    exception = new FileWriter(file2, false);
                    try {
                        this.writer = exception;
                        this.writePatterns();
                        this.writer = null;
                    }
                    finally {
                        exception.close();
                    }
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private double round(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    private void writeRunInfo(RunInfo runInfo, int n) throws Exception {
        this.write("===================================================================");
        this.write(" RUN NR: " + n);
        this.write("===================================================================");
        this.write("");
        this.write("Total weather periods: " + runInfo.totalPeriods);
        this.write("Longest weather: " + this.formatDuration(runInfo.longestPeriod));
        this.write("Shortest weather: " + this.formatDuration(runInfo.shortestPeriod));
        this.write("Average weather: " + this.formatDuration(runInfo.averagePeriod));
        this.write("");
        this.write("Total weather days for cycle: " + this.formatDuration(runInfo.totalPeriodDuration));
        this.write("");
        this.write("Total clear periods: " + runInfo.totalEmpty);
        this.write("Longest clear: " + this.formatDuration(runInfo.longestEmpty));
        this.write("Shortest clear: " + this.formatDuration(runInfo.shortestEmpty));
        this.write("Average clear: " + this.formatDuration(runInfo.averageEmpty));
        this.write("");
        this.write("Highest Front strength: " + runInfo.highestStrength);
        this.write("Lowest Front strength: " + runInfo.lowestStrength);
        this.write("Average Front strength: " + runInfo.averageStrength);
        this.write("");
        this.write("Highest WarmFront strength: " + runInfo.highestWarmStrength);
        this.write("Lowest WarmFront strength: " + runInfo.lowestWarmStrength);
        this.write("Average WarmFront strength: " + runInfo.averageWarmStrength);
        this.write("");
        this.write("Highest ColdFront strength: " + runInfo.highestColdStrength);
        this.write("Lowest ColdFront strength: " + runInfo.lowestColdStrength);
        this.write("Average ColdFront strength: " + runInfo.averageColdStrength);
        this.write("");
        this.write("Weather period types:");
        this.write("Normal warm: " + runInfo.countNormalWarm);
        this.write("Normal cold: " + runInfo.countNormalCold);
        this.write("Normal storm: " + runInfo.countStorm);
        this.write("Normal tropical: " + runInfo.countTropical);
        this.write("Normal blizzard: " + runInfo.countBlizzard);
        this.write("");
        this.write("Distribution duration in days (total periods)");
        this.printCountTable(this.writer, runInfo.dayCountPeriod);
        this.write("");
        this.write("Distribution duration in days (WARM periods)");
        this.printCountTable(this.writer, runInfo.dayCountWarmPeriod);
        this.write("");
        this.write("Distribution duration in days (COLD periods)");
        this.printCountTable(this.writer, runInfo.dayCountColdPeriod);
        this.write("");
        this.write("Distribution duration in days (clear periods)");
        this.printCountTable(this.writer, runInfo.dayCountEmpty);
        this.write("");
        this.write("Amount of weather periods exceeding threshold: " + runInfo.exceedingPeriods.size());
        if (runInfo.exceedingPeriods.size() > 0) {
            for (Integer n2 : runInfo.exceedingPeriods) {
                this.write(n2 + " days.");
            }
        }
        this.write("");
        this.write("Amount of clear periods exceeding threshold: " + runInfo.exceedingEmpties.size());
        if (runInfo.exceedingEmpties.size() > 0) {
            for (Integer n2 : runInfo.exceedingEmpties) {
                this.write(n2 + " days.");
            }
        }
    }

    private void write(String string) throws Exception {
        this.writer.write(string + System.lineSeparator());
    }

    private void writeDataExtremes() throws Exception {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        RunInfo runInfo = null;
        RunInfo runInfo2 = null;
        for (RunInfo runInfo3 : this.runs) {
            ++n;
            if (runInfo == null || runInfo3.totalPeriodDuration < runInfo.totalPeriodDuration) {
                runInfo = runInfo3;
                n2 = n;
            }
            if (runInfo2 != null && !(runInfo3.totalPeriodDuration > runInfo2.totalPeriodDuration)) continue;
            runInfo2 = runInfo3;
            n3 = n;
        }
        this.write("");
        this.write("MOST DRY RUN:");
        if (runInfo != null) {
            this.writeRunInfo(runInfo, n2);
        }
        this.write("");
        this.write("MOST WET RUN:");
        if (runInfo2 != null) {
            this.writeRunInfo(runInfo2, n3);
        }
    }

    private void writeData() throws Exception {
        int n = 0;
        for (RunInfo runInfo : this.runs) {
            this.writeRunInfo(runInfo, ++n);
        }
    }

    private void writePatterns() throws Exception {
        String string = "-";
        String string2 = "#";
        String string3 = "S";
        String string4 = "T";
        String string5 = "B";
        int n = 0;
        int n2 = 0;
        for (RunInfo runInfo : this.runs) {
            n2 = 0;
            for (RecordInfo recordInfo : runInfo.records) {
                n = (int)Math.ceil(recordInfo.durationHours / 24.0);
                String string6 = recordInfo.isWeather && recordInfo.weatherType == 1 ? new String(new char[n]).replace("\u0000", string3) : (recordInfo.isWeather && recordInfo.weatherType == 2 ? new String(new char[n]).replace("\u0000", string4) : (recordInfo.isWeather && recordInfo.weatherType == 3 ? new String(new char[n]).replace("\u0000", string5) : (n2 == 0 && !recordInfo.isWeather && n >= 2 ? new String(new char[n - 1]).replace("\u0000", string) : new String(new char[n]).replace("\u0000", recordInfo.isWeather ? string2 : string))));
                this.writer.write(string6);
                ++n2;
            }
            this.writer.write(System.lineSeparator());
        }
    }

    private void printCountTable(FileWriter fileWriter, int[] nArray) throws Exception {
        this.printCountTable(fileWriter, nArray, 1);
    }

    private void printCountTable(FileWriter fileWriter, int[] nArray, int n) throws Exception {
        if (nArray == null || nArray.length <= 0) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        this.write("    DAYS   COUNT GRAPH");
        float f = 50.0f / (float)n2;
        if (n2 > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                Object object = "";
                object = (String)object + String.format("%1$8s", i * n + "-" + (i * n + n));
                int n3 = nArray[i];
                object = (String)object + String.format("%1$8s", n3);
                object = (String)object + " ";
                int n4 = (int)((float)n3 * f);
                if (n4 > 0) {
                    object = (String)object + new String(new char[n4]).replace("\u0000", "#");
                } else if (n3 > 0) {
                    object = (String)object + "*";
                }
                this.write((String)object);
            }
        }
    }

    private String formatDuration(double d) {
        int n = (int)(d / 24.0);
        int n2 = (int)(d - (double)(n * 24));
        return n + " days, " + n2 + " hours.";
    }

    private class RunInfo {
        public double seedA;
        public int durationDays;
        public double durationHours;
        public ArrayList<RecordInfo> records = new ArrayList();
        public double totalPeriodDuration = 0.0;
        public double longestPeriod = 0.0;
        public double shortestPeriod = 9.99999999E8;
        public int totalPeriods = 0;
        public double averagePeriod = 0.0;
        public double longestEmpty = 0.0;
        public double shortestEmpty = 9.99999999E8;
        public int totalEmpty = 0;
        public double averageEmpty = 0.0;
        public float highestStrength = 0.0f;
        public float lowestStrength = 1.0f;
        public float averageStrength = 0.0f;
        public float highestWarmStrength = 0.0f;
        public float lowestWarmStrength = 1.0f;
        public float averageWarmStrength = 0.0f;
        public float highestColdStrength = 0.0f;
        public float lowestColdStrength = 1.0f;
        public float averageColdStrength = 0.0f;
        public int countNormalWarm = 0;
        public int countNormalCold = 0;
        public int countStorm = 0;
        public int countTropical = 0;
        public int countBlizzard = 0;
        public int[] dayCountPeriod = new int[16];
        public int[] dayCountWarmPeriod = new int[16];
        public int[] dayCountColdPeriod = new int[16];
        public int[] dayCountEmpty = new int[75];
        public ArrayList<Integer> exceedingPeriods = new ArrayList();
        public ArrayList<Integer> exceedingEmpties = new ArrayList();
        public double mostWetPeriod = 0.0;
        public double mostDryPeriod = 9.99999999E8;
        public int[] totalDaysPeriod;

        private RunInfo() {
        }

        public RecordInfo addRecord(double d) {
            RecordInfo recordInfo = new RecordInfo();
            recordInfo.durationHours = d;
            recordInfo.isWeather = false;
            this.records.add(recordInfo);
            return recordInfo;
        }

        public RecordInfo addRecord(int n, double d, float f, boolean bl, boolean bl2, boolean bl3) {
            RecordInfo recordInfo = new RecordInfo();
            recordInfo.durationHours = d;
            recordInfo.isWeather = true;
            recordInfo.airType = n;
            recordInfo.strength = f;
            recordInfo.weatherType = 0;
            if (bl) {
                recordInfo.weatherType = 1;
            } else if (bl2) {
                recordInfo.weatherType = 2;
            } else if (bl3) {
                recordInfo.weatherType = 3;
            }
            this.records.add(recordInfo);
            return recordInfo;
        }

        public void calculate() {
            double d = 0.0;
            double d2 = 0.0;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = 0;
            int n2 = 0;
            for (RecordInfo recordInfo : this.records) {
                int n3 = (int)(recordInfo.durationHours / 24.0);
                if (recordInfo.isWeather) {
                    this.totalPeriodDuration += recordInfo.durationHours;
                    if (recordInfo.durationHours > this.longestPeriod) {
                        this.longestPeriod = recordInfo.durationHours;
                    }
                    if (recordInfo.durationHours < this.shortestPeriod) {
                        this.shortestPeriod = recordInfo.durationHours;
                    }
                    ++this.totalPeriods;
                    d += recordInfo.durationHours;
                    if (recordInfo.strength > this.highestStrength) {
                        this.highestStrength = recordInfo.strength;
                    }
                    if (recordInfo.strength < this.lowestStrength) {
                        this.lowestStrength = recordInfo.strength;
                    }
                    f += recordInfo.strength;
                    if (recordInfo.airType == 1) {
                        ++n;
                        if (recordInfo.strength > this.highestWarmStrength) {
                            this.highestWarmStrength = recordInfo.strength;
                        }
                        if (recordInfo.strength < this.lowestWarmStrength) {
                            this.lowestWarmStrength = recordInfo.strength;
                        }
                        f2 += recordInfo.strength;
                        if (recordInfo.weatherType == 1) {
                            ++this.countStorm;
                        } else if (recordInfo.weatherType == 2) {
                            ++this.countTropical;
                        } else if (recordInfo.weatherType == 3) {
                            ++this.countBlizzard;
                        } else {
                            ++this.countNormalWarm;
                        }
                        if (n3 < this.dayCountWarmPeriod.length) {
                            int n4 = n3;
                            this.dayCountWarmPeriod[n4] = this.dayCountWarmPeriod[n4] + 1;
                        }
                    } else {
                        ++n2;
                        if (recordInfo.strength > this.highestColdStrength) {
                            this.highestColdStrength = recordInfo.strength;
                        }
                        if (recordInfo.strength < this.lowestColdStrength) {
                            this.lowestColdStrength = recordInfo.strength;
                        }
                        f3 += recordInfo.strength;
                        ++this.countNormalCold;
                        if (n3 < this.dayCountColdPeriod.length) {
                            int n5 = n3;
                            this.dayCountColdPeriod[n5] = this.dayCountColdPeriod[n5] + 1;
                        }
                    }
                    if (n3 < this.dayCountPeriod.length) {
                        int n6 = n3;
                        this.dayCountPeriod[n6] = this.dayCountPeriod[n6] + 1;
                        continue;
                    }
                    DebugLog.log("Period is longer than allowed array, days = " + n3);
                    this.exceedingPeriods.add(n3);
                    continue;
                }
                if (recordInfo.durationHours > this.longestEmpty) {
                    this.longestEmpty = recordInfo.durationHours;
                }
                if (recordInfo.durationHours < this.shortestEmpty) {
                    this.shortestEmpty = recordInfo.durationHours;
                }
                ++this.totalEmpty;
                d2 += recordInfo.durationHours;
                if (n3 < this.dayCountEmpty.length) {
                    int n7 = n3;
                    this.dayCountEmpty[n7] = this.dayCountEmpty[n7] + 1;
                    continue;
                }
                DebugLog.log("No-Weather period is longer than allowed array, days = " + n3);
                this.exceedingEmpties.add(n3);
            }
            if (this.totalPeriods > 0) {
                this.averagePeriod = d / (double)this.totalPeriods;
                this.averageStrength = f / (float)this.totalPeriods;
                if (n > 0) {
                    this.averageWarmStrength = f2 / (float)n;
                }
                if (n2 > 0) {
                    this.averageColdStrength = f3 / (float)n2;
                }
            }
            if (this.totalEmpty > 0) {
                this.averageEmpty = d2 / (double)this.totalEmpty;
            }
        }
    }

    private class RecordInfo {
        public boolean isWeather;
        public float strength;
        public int airType;
        public double durationHours;
        public int weatherType = 0;

        private RecordInfo() {
        }
    }
}

