/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import org.lwjgl.opengl.ARBShaderObjects;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.opengl.RenderSettings;
import zombie.core.opengl.Shader;
import zombie.core.opengl.ShaderProgram;
import zombie.core.textures.TextureDraw;
import zombie.iso.IsoCamera;
import zombie.iso.PlayerCamera;
import zombie.iso.SearchMode;

public class WeatherShader
extends Shader {
    public int timeOfDay = 0;
    private int PixelOffset;
    private int PixelSize;
    private int bloom;
    private int timer;
    private int BlurStrength;
    private int TextureSize;
    private int Zoom;
    private int Light;
    private int LightIntensity;
    private int NightValue;
    private int Exterior;
    private int NightVisionGoggles;
    private int DesaturationVal;
    private int FogMod;
    private int SearchModeID;
    private int ScreenInfo;
    private int ParamInfo;
    private int VarInfo;
    private int timerVal;
    private boolean bAlt = false;
    private static final int texdVarsSize = 22;
    private static float[][] floatArrs = new float[5][];

    public WeatherShader(String string) {
        super(string);
    }

    @Override
    public void startMainThread(TextureDraw textureDraw, int n) {
        if (n < 0 || n >= 4) {
            return;
        }
        RenderSettings.PlayerRenderSettings playerRenderSettings = RenderSettings.getInstance().getPlayerSettings(n);
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        boolean bl = playerRenderSettings.isExterior();
        float f = GameTime.instance.TimeOfDay / 12.0f - 1.0f;
        if (Math.abs(f) > 0.8f && isoPlayer != null && isoPlayer.Traits.NightVision.isSet() && !isoPlayer.isWearingNightVisionGoggles()) {
            f *= 0.8f;
        }
        int n2 = Core.getInstance().getOffscreenWidth(n);
        int n3 = Core.getInstance().getOffscreenHeight(n);
        if (textureDraw.vars == null) {
            textureDraw.vars = WeatherShader.getFreeFloatArray();
            if (textureDraw.vars == null) {
                textureDraw.vars = new float[22];
            }
        }
        textureDraw.vars[0] = playerRenderSettings.getBlendColor().r;
        textureDraw.vars[1] = playerRenderSettings.getBlendColor().g;
        textureDraw.vars[2] = playerRenderSettings.getBlendColor().b;
        textureDraw.vars[3] = playerRenderSettings.getBlendIntensity();
        textureDraw.vars[4] = playerRenderSettings.getDesaturation();
        textureDraw.vars[5] = playerRenderSettings.isApplyNightVisionGoggles() ? 1.0f : 0.0f;
        SearchMode.PlayerSearchMode playerSearchMode = SearchMode.getInstance().getSearchModeForPlayer(n);
        textureDraw.vars[6] = playerSearchMode.getShaderBlur();
        textureDraw.vars[7] = playerSearchMode.getShaderRadius();
        textureDraw.vars[8] = IsoCamera.getOffscreenLeft(n);
        textureDraw.vars[9] = IsoCamera.getOffscreenTop(n);
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        textureDraw.vars[10] = IsoCamera.getOffscreenWidth(n);
        textureDraw.vars[11] = IsoCamera.getOffscreenHeight(n);
        textureDraw.vars[12] = playerCamera.RightClickX;
        textureDraw.vars[13] = playerCamera.RightClickY;
        textureDraw.vars[14] = Core.getInstance().getZoom(n);
        textureDraw.vars[15] = Core.TileScale == 2 ? 64.0f : 32.0f;
        textureDraw.vars[16] = playerSearchMode.getShaderGradientWidth() * textureDraw.vars[15] / 2.0f;
        textureDraw.vars[17] = playerSearchMode.getShaderDesat();
        textureDraw.vars[18] = playerSearchMode.isShaderEnabled() ? 1.0f : 0.0f;
        textureDraw.vars[19] = playerSearchMode.getShaderDarkness();
        textureDraw.flipped = playerRenderSettings.isExterior();
        textureDraw.f1 = playerRenderSettings.getDarkness();
        textureDraw.col0 = n2;
        textureDraw.col1 = n3;
        textureDraw.col2 = Core.getInstance().getOffscreenTrueWidth();
        textureDraw.col3 = Core.getInstance().getOffscreenTrueHeight();
        textureDraw.bSingleCol = Core.getInstance().getZoom(n) > 2.0f || (double)Core.getInstance().getZoom(n) < 2.0 && Core.getInstance().getZoom(n) >= 1.75f;
    }

    @Override
    public void startRenderThread(TextureDraw textureDraw) {
        float f = textureDraw.f1;
        boolean bl = textureDraw.flipped;
        int n = textureDraw.col0;
        int n2 = textureDraw.col1;
        int n3 = textureDraw.col2;
        int n4 = textureDraw.col3;
        float f2 = textureDraw.bSingleCol ? 1.0f : 0.0f;
        ARBShaderObjects.glUniform1fARB((int)this.width, (float)n);
        ARBShaderObjects.glUniform1fARB((int)this.height, (float)n2);
        ARBShaderObjects.glUniform3fARB((int)this.Light, (float)textureDraw.vars[0], (float)textureDraw.vars[1], (float)textureDraw.vars[2]);
        ARBShaderObjects.glUniform1fARB((int)this.LightIntensity, (float)textureDraw.vars[3]);
        ARBShaderObjects.glUniform1fARB((int)this.NightValue, (float)f);
        ARBShaderObjects.glUniform1fARB((int)this.DesaturationVal, (float)textureDraw.vars[4]);
        ARBShaderObjects.glUniform1fARB((int)this.NightVisionGoggles, (float)textureDraw.vars[5]);
        ARBShaderObjects.glUniform1fARB((int)this.Exterior, (float)(bl ? 1.0f : 0.0f));
        ARBShaderObjects.glUniform1fARB((int)this.timer, (float)(this.timerVal / 2));
        if (PerformanceSettings.getLockFPS() >= 60) {
            if (this.bAlt) {
                ++this.timerVal;
            }
            this.bAlt = !this.bAlt;
        } else {
            this.timerVal += 2;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 1.0f / (float)n;
        float f6 = 1.0f / (float)n2;
        ARBShaderObjects.glUniform2fARB((int)this.TextureSize, (float)n3, (float)n4);
        ARBShaderObjects.glUniform1fARB((int)this.Zoom, (float)f2);
        ARBShaderObjects.glUniform4fARB((int)this.SearchModeID, (float)textureDraw.vars[6], (float)textureDraw.vars[7], (float)textureDraw.vars[8], (float)textureDraw.vars[9]);
        ARBShaderObjects.glUniform4fARB((int)this.ScreenInfo, (float)textureDraw.vars[10], (float)textureDraw.vars[11], (float)textureDraw.vars[12], (float)textureDraw.vars[13]);
        ARBShaderObjects.glUniform4fARB((int)this.ParamInfo, (float)textureDraw.vars[14], (float)textureDraw.vars[15], (float)textureDraw.vars[16], (float)textureDraw.vars[17]);
        ARBShaderObjects.glUniform4fARB((int)this.VarInfo, (float)textureDraw.vars[18], (float)textureDraw.vars[19], (float)textureDraw.vars[20], (float)textureDraw.vars[21]);
    }

    @Override
    public void onCompileSuccess(ShaderProgram shaderProgram) {
        int n = this.getID();
        this.timeOfDay = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TimeOfDay");
        this.bloom = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"BloomVal");
        this.PixelOffset = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"PixelOffset");
        this.PixelSize = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"PixelSize");
        this.BlurStrength = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"BlurStrength");
        this.width = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"bgl_RenderedTextureWidth");
        this.height = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"bgl_RenderedTextureHeight");
        this.timer = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"timer");
        this.TextureSize = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"TextureSize");
        this.Zoom = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Zoom");
        this.Light = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Light");
        this.LightIntensity = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"LightIntensity");
        this.NightValue = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"NightValue");
        this.Exterior = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"Exterior");
        this.NightVisionGoggles = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"NightVisionGoggles");
        this.DesaturationVal = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"DesaturationVal");
        this.FogMod = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"FogMod");
        this.SearchModeID = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"SearchMode");
        this.ScreenInfo = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"ScreenInfo");
        this.ParamInfo = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"ParamInfo");
        this.VarInfo = ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)"VarInfo");
    }

    @Override
    public void postRender(TextureDraw textureDraw) {
        if (textureDraw.vars != null) {
            WeatherShader.returnFloatArray(textureDraw.vars);
            textureDraw.vars = null;
        }
    }

    private static float[] getFreeFloatArray() {
        for (int i = 0; i < floatArrs.length; ++i) {
            if (floatArrs[i] == null) continue;
            float[] fArray = floatArrs[i];
            WeatherShader.floatArrs[i] = null;
            return fArray;
        }
        return new float[22];
    }

    private static void returnFloatArray(float[] fArray) {
        for (int i = 0; i < floatArrs.length; ++i) {
            if (floatArrs[i] != null) continue;
            WeatherShader.floatArrs[i] = fArray;
            break;
        }
    }
}

