/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.SandboxOptions;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.erosion.season.ErosionSeason;
import zombie.iso.IsoWorld;
import zombie.iso.weather.ClimateColorInfo;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.ClimateValues;
import zombie.iso.weather.SimplexNoise;
import zombie.iso.weather.ThunderStorm;
import zombie.network.GameClient;
import zombie.network.GameServer;

public class WeatherPeriod {
    public static final int STAGE_START = 0;
    public static final int STAGE_SHOWERS = 1;
    public static final int STAGE_HEAVY_PRECIP = 2;
    public static final int STAGE_STORM = 3;
    public static final int STAGE_CLEARING = 4;
    public static final int STAGE_MODERATE = 5;
    public static final int STAGE_DRIZZLE = 6;
    public static final int STAGE_BLIZZARD = 7;
    public static final int STAGE_TROPICAL_STORM = 8;
    public static final int STAGE_INTERMEZZO = 9;
    public static final int STAGE_MODDED = 10;
    public static final int STAGE_KATEBOB_STORM = 11;
    public static final int STAGE_MAX = 12;
    public static final float FRONT_STRENGTH_THRESHOLD = 0.1f;
    private ClimateManager climateManager;
    private ClimateManager.AirFront frontCache = new ClimateManager.AirFront();
    private double startTime;
    private double duration;
    private double currentTime;
    private WeatherStage currentStage;
    private ArrayList<WeatherStage> weatherStages = new ArrayList(20);
    private int weatherStageIndex = 0;
    private Stack<WeatherStage> stagesPool = new Stack();
    private boolean isRunning = false;
    private float totalProgress = 0.0f;
    private float stageProgress = 0.0f;
    private float weatherNoise;
    private static float maxTemperatureInfluence = 7.0f;
    private float temperatureInfluence = 0.0f;
    private float currentStrength;
    private float rainThreshold;
    private float windAngleDirMod = 1.0f;
    private boolean isThunderStorm = false;
    private boolean isTropicalStorm = false;
    private boolean isBlizzard = false;
    private float precipitationFinal = 0.0f;
    private ThunderStorm thunderStorm;
    private ClimateColorInfo cloudColor = new ClimateColorInfo(0.4f, 0.2f, 0.2f, 0.4f);
    private ClimateColorInfo cloudColorReddish = new ClimateColorInfo(0.66f, 0.12f, 0.12f, 0.4f);
    private ClimateColorInfo cloudColorGreenish = new ClimateColorInfo(0.32f, 0.48f, 0.12f, 0.4f);
    private ClimateColorInfo cloudColorBlueish = new ClimateColorInfo(0.16f, 0.48f, 0.48f, 0.4f);
    private ClimateColorInfo cloudColorPurplish = new ClimateColorInfo(0.66f, 0.12f, 0.66f, 0.4f);
    private ClimateColorInfo cloudColorTropical = new ClimateColorInfo(0.4f, 0.2f, 0.2f, 0.4f);
    private ClimateColorInfo cloudColorBlizzard = new ClimateColorInfo(0.12f, 0.13f, 0.21f, 0.5f, 0.38f, 0.4f, 0.5f, 0.8f);
    private static boolean PRINT_STUFF = false;
    private static float kateBobStormProgress = 0.45f;
    private int kateBobStormX = 2000;
    private int kateBobStormY = 2000;
    private Random seededRandom;
    private ClimateValues climateValues;
    private boolean isDummy = false;
    private boolean hasStartedInit = false;
    private static final HashMap<Integer, StrLerpVal> cache = new HashMap();

    public WeatherPeriod(ClimateManager climateManager, ThunderStorm thunderStorm) {
        this.climateManager = climateManager;
        this.thunderStorm = thunderStorm;
        for (int i = 0; i < 30; ++i) {
            this.stagesPool.push(new WeatherStage());
        }
        PRINT_STUFF = true;
        this.seededRandom = new Random(1984L);
        this.climateValues = climateManager.getClimateValuesCopy();
    }

    public void setDummy(boolean bl) {
        this.isDummy = bl;
    }

    public static float getMaxTemperatureInfluence() {
        return maxTemperatureInfluence;
    }

    public void setKateBobStormProgress(float f) {
        kateBobStormProgress = PZMath.clamp_01(f);
    }

    public void setKateBobStormCoords(int n, int n2) {
        this.kateBobStormX = n;
        this.kateBobStormY = n2;
    }

    public ClimateColorInfo getCloudColorReddish() {
        return this.cloudColorReddish;
    }

    public ClimateColorInfo getCloudColorGreenish() {
        return this.cloudColorGreenish;
    }

    public ClimateColorInfo getCloudColorBlueish() {
        return this.cloudColorBlueish;
    }

    public ClimateColorInfo getCloudColorPurplish() {
        return this.cloudColorPurplish;
    }

    public ClimateColorInfo getCloudColorTropical() {
        return this.cloudColorTropical;
    }

    public ClimateColorInfo getCloudColorBlizzard() {
        return this.cloudColorBlizzard;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public double getDuration() {
        return this.duration;
    }

    public ClimateManager.AirFront getFrontCache() {
        return this.frontCache;
    }

    public int getCurrentStageID() {
        return this.currentStage != null ? this.currentStage.stageID : -1;
    }

    public WeatherStage getCurrentStage() {
        return this.currentStage;
    }

    public double getWeatherNoise() {
        return this.weatherNoise;
    }

    public float getCurrentStrength() {
        return this.currentStrength;
    }

    public float getRainThreshold() {
        return this.rainThreshold;
    }

    public boolean isThunderStorm() {
        return this.isThunderStorm;
    }

    public boolean isTropicalStorm() {
        return this.isTropicalStorm;
    }

    public boolean isBlizzard() {
        return this.isBlizzard;
    }

    public float getPrecipitationFinal() {
        return this.precipitationFinal;
    }

    public ClimateColorInfo getCloudColor() {
        return this.cloudColor;
    }

    public void setCloudColor(ClimateColorInfo climateColorInfo) {
        this.cloudColor = climateColorInfo;
    }

    public float getTotalProgress() {
        return this.totalProgress;
    }

    public float getStageProgress() {
        return this.stageProgress;
    }

    public boolean hasTropical() {
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            if (this.weatherStages.get(i).getStageID() != 8) continue;
            return true;
        }
        return false;
    }

    public boolean hasStorm() {
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            if (this.weatherStages.get(i).getStageID() != 3) continue;
            return true;
        }
        return false;
    }

    public boolean hasBlizzard() {
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            if (this.weatherStages.get(i).getStageID() != 7) continue;
            return true;
        }
        return false;
    }

    public boolean hasHeavyRain() {
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            if (this.weatherStages.get(i).getStageID() != 2) continue;
            return true;
        }
        return false;
    }

    public float getTotalStrength() {
        return this.frontCache.getStrength();
    }

    public WeatherStage getStageForWorldAge(double d) {
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            if (!(d >= this.weatherStages.get(i).getStageStart()) || !(d < this.weatherStages.get(i).getStageEnd())) continue;
            return this.weatherStages.get(i);
        }
        return null;
    }

    public float getWindAngleDegrees() {
        return this.frontCache.getAngleDegrees();
    }

    public int getFrontType() {
        return this.frontCache.getType();
    }

    private void print(String string) {
        if (PRINT_STUFF && !this.isDummy) {
            DebugLog.log(string);
        }
    }

    public void setPrintStuff(boolean bl) {
        PRINT_STUFF = bl;
    }

    public boolean getPrintStuff() {
        return PRINT_STUFF;
    }

    public void initSimulationDebug(ClimateManager.AirFront airFront, double d) {
        GameTime gameTime = GameTime.getInstance();
        this.init(airFront, d, gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne(), -1, -1.0f);
    }

    public void initSimulationDebug(ClimateManager.AirFront airFront, double d, int n, float f) {
        GameTime gameTime = GameTime.getInstance();
        this.init(airFront, d, gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne(), n, f);
    }

    protected void init(ClimateManager.AirFront airFront, double d, int n, int n2, int n3) {
        this.init(airFront, d, n, n2, n3, -1, -1.0f);
    }

    protected void init(ClimateManager.AirFront airFront, double d, int n, int n2, int n3, int n4, float f) {
        this.climateValues.pollDate(n, n2, n3);
        this.reseed(n, n2, n3);
        this.hasStartedInit = false;
        if (!this.startInit(airFront, d)) {
            return;
        }
        if (n4 >= 0 && n4 < 12) {
            this.createSingleStage(n4, f);
        } else {
            this.createWeatherPattern();
        }
        LuaEventManager.triggerEvent("OnWeatherPeriodStart", this);
        this.endInit();
    }

    protected void reseed(int n, int n2, int n3) {
        int n4 = (int)this.climateManager.getSimplexOffsetA();
        int n5 = (int)this.climateManager.getSimplexOffsetB();
        long l = (n - 1990) * 100000;
        l += (long)(n2 * n3 * 1234);
        l += (long)((n - 1990) * n2 * 10000);
        this.print("Reseeding weather period, new seed: " + (l += (long)((n5 - n4) * n3)));
        this.seededRandom.setSeed(l);
    }

    private float RandNext(float f, float f2) {
        if (f == f2) {
            return f;
        }
        if (f > f2) {
            float f3 = f;
            f2 = f = f2;
        }
        return f + this.seededRandom.nextFloat() * (f2 - f);
    }

    private float RandNext(float f) {
        return this.seededRandom.nextFloat() * f;
    }

    private int RandNext(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (n > n2) {
            int n3 = n;
            n2 = n = n2;
        }
        return n + this.seededRandom.nextInt(n2 - n);
    }

    private int RandNext(int n) {
        return this.seededRandom.nextInt(n);
    }

    public boolean startCreateModdedPeriod(boolean bl, float f, float f2) {
        double d = GameTime.getInstance().getWorldAgeHours();
        ClimateManager.AirFront airFront = new ClimateManager.AirFront();
        float f3 = ClimateManager.clamp(0.0f, 360.0f, f2);
        airFront.setFrontType(bl ? 1 : -1);
        airFront.setFrontWind(f3);
        airFront.setStrength(ClimateManager.clamp01(f));
        GameTime gameTime = GameTime.getInstance();
        this.reseed(gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne());
        this.hasStartedInit = false;
        if (!this.startInit(airFront, d)) {
            return false;
        }
        this.print("WeatherPeriod: Creating MODDED weather pattern with strength = " + this.frontCache.getStrength());
        this.clearCurrentWeatherStages();
        return true;
    }

    public boolean endCreateModdedPeriod() {
        if (!this.endInit()) {
            return false;
        }
        this.linkWeatherStages();
        this.duration = 0.0;
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            this.duration += this.weatherStages.get((int)i).stageDuration;
        }
        this.print("WeatherPeriod: Duration = " + this.duration + ".");
        this.weatherStageIndex = 0;
        this.currentStage = this.weatherStages.get(this.weatherStageIndex).startStage(this.startTime);
        this.print("WeatherPeriod: PATTERN GENERATION FINISHED.");
        return true;
    }

    private boolean startInit(ClimateManager.AirFront airFront, double d) {
        if (this.isRunning || GameClient.bClient || airFront.getStrength() < 0.1f) {
            return false;
        }
        this.startTime = d;
        this.frontCache.copyFrom(airFront);
        this.windAngleDirMod = this.frontCache.getAngleDegrees() >= 90.0f && this.frontCache.getAngleDegrees() < 270.0f ? 1.0f : -1.0f;
        this.hasStartedInit = true;
        return true;
    }

    private boolean endInit() {
        if (this.hasStartedInit && !this.isRunning && !GameClient.bClient && this.weatherStages.size() > 0) {
            this.currentStrength = 0.0f;
            this.totalProgress = 0.0f;
            this.stageProgress = 0.0f;
            this.isRunning = true;
            if (GameServer.bServer && !this.isDummy) {
                this.climateManager.transmitClimatePacket(ClimateManager.ClimateNetAuth.ServerOnly, (byte)1, null);
            }
            this.hasStartedInit = false;
            return true;
        }
        this.hasStartedInit = false;
        return false;
    }

    public void stopWeatherPeriod() {
        this.clearCurrentWeatherStages();
        this.currentStage = null;
        this.resetClimateManagerOverrides();
        this.isRunning = false;
        this.totalProgress = 0.0f;
        this.stageProgress = 0.0f;
        LuaEventManager.triggerEvent("OnWeatherPeriodStop", this);
    }

    public void writeNetWeatherData(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.put(this.isRunning ? (byte)1 : 0);
        if (this.isRunning) {
            byteBuffer.put(this.isThunderStorm ? (byte)1 : 0);
            byteBuffer.put(this.isTropicalStorm ? (byte)1 : 0);
            byteBuffer.put(this.isBlizzard ? (byte)1 : 0);
            byteBuffer.putFloat(this.currentStrength);
            byteBuffer.putDouble(this.duration);
            byteBuffer.putFloat(this.totalProgress);
            byteBuffer.putFloat(this.stageProgress);
        }
    }

    public void readNetWeatherData(ByteBuffer byteBuffer) throws IOException {
        boolean bl = this.isRunning = byteBuffer.get() == 1;
        if (this.isRunning) {
            this.isThunderStorm = byteBuffer.get() == 1;
            this.isTropicalStorm = byteBuffer.get() == 1;
            this.isBlizzard = byteBuffer.get() == 1;
            this.currentStrength = byteBuffer.getFloat();
            this.duration = byteBuffer.getDouble();
            this.totalProgress = byteBuffer.getFloat();
            this.stageProgress = byteBuffer.getFloat();
        } else {
            this.isThunderStorm = false;
            this.isTropicalStorm = false;
            this.isBlizzard = false;
            this.currentStrength = 0.0f;
            this.duration = 0.0;
            this.totalProgress = 0.0f;
            this.stageProgress = 0.0f;
        }
    }

    public ArrayList<WeatherStage> getWeatherStages() {
        return this.weatherStages;
    }

    private void linkWeatherStages() {
        WeatherStage weatherStage = null;
        WeatherStage weatherStage2 = null;
        WeatherStage weatherStage3 = null;
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            weatherStage3 = this.weatherStages.get(i);
            weatherStage2 = null;
            if (i + 1 < this.weatherStages.size()) {
                weatherStage2 = this.weatherStages.get(i + 1);
            }
            weatherStage3.previousStage = weatherStage;
            weatherStage3.nextStage = weatherStage2;
            weatherStage3.creationFinished = true;
            weatherStage = weatherStage3;
        }
    }

    private void clearCurrentWeatherStages() {
        this.print("WeatherPeriod: Clearing existing stages...");
        for (WeatherStage weatherStage : this.weatherStages) {
            weatherStage.reset();
            this.stagesPool.push(weatherStage);
        }
        this.weatherStages.clear();
    }

    private void createSingleStage(int n, float f) {
        this.print("WeatherPeriod: Creating single stage weather pattern with strength = " + this.frontCache.getStrength());
        if (n == 8) {
            this.cloudColor = this.cloudColorTropical;
        } else if (n == 7) {
            this.cloudColor = this.cloudColorBlizzard;
        }
        this.clearCurrentWeatherStages();
        this.createAndAddStage(0, 1.0);
        this.createAndAddStage(n, f);
        this.createAndAddStage(4, 1.0);
        this.linkWeatherStages();
        this.duration = 0.0;
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            this.duration += this.weatherStages.get((int)i).stageDuration;
        }
        this.print("WeatherPeriod: Duration = " + f + ".");
        this.weatherStageIndex = 0;
        this.currentStage = this.weatherStages.get(this.weatherStageIndex).startStage(this.startTime);
        this.print("WeatherPeriod: PATTERN GENERATION FINISHED.");
    }

    private void createWeatherPattern() {
        int n;
        this.print("WeatherPeriod: Creating weather pattern with strength = " + this.frontCache.getStrength());
        this.clearCurrentWeatherStages();
        ErosionSeason erosionSeason = this.climateManager.getSeason();
        float f = this.climateValues.getDayMeanTemperature();
        this.print("WeatherPeriod: Day mean temperature = " + f + " C.");
        this.print("WeatherPeriod: season = " + erosionSeason.getSeasonName());
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = this.RandNext(0.0f, 100.0f);
        int n2 = erosionSeason.getSeason();
        boolean bl = IsoWorld.instance.getGameMode().equals("Winter is Coming");
        if (bl) {
            n2 = 5;
        }
        switch (n2) {
            case 5: {
                this.cloudColor = f6 < 45.0f ? this.cloudColorPurplish : this.cloudColorBlueish;
                f2 = 10.0f;
                f3 = 0.0f;
                if (f < 5.5f) {
                    f4 = ClimateManager.clamp(0.0f, 85.0f, (5.5f - f) * 3.0f);
                    f4 += 25.0f;
                    if (f < 2.5f) {
                        f4 += 55.0f;
                    } else if (f < 0.0f) {
                        f4 += 75.0f;
                    }
                    if (f4 > 95.0f) {
                        f4 = 95.0f;
                    }
                } else {
                    f4 = 0.0f;
                }
                if (!bl) break;
                f4 = this.frontCache.getStrength() > 0.75f ? 100.0f : 75.0f;
                if (!(this.frontCache.getStrength() > 0.5f)) break;
                f5 = 1.45f;
                break;
            }
            case 1: {
                this.cloudColor = f6 < 75.0f ? this.cloudColorGreenish : this.cloudColorBlueish;
                f2 = 75.0f;
                f3 = 10.0f;
                f4 = 0.0f;
                f5 = 1.25f;
                break;
            }
            case 2: {
                this.cloudColor = f6 < 25.0f ? this.cloudColorGreenish : this.cloudColorReddish;
                f2 = 60.0f;
                f3 = 55.0f;
                f4 = 0.0f;
                break;
            }
            case 3: {
                this.cloudColor = this.cloudColorReddish;
                f2 = 75.0f;
                f3 = 80.0f;
                f4 = 0.0f;
                f5 = 1.15f;
                break;
            }
            case 4: {
                this.cloudColor = f6 < 50.0f ? this.cloudColorReddish : (f6 < 75.0f ? this.cloudColorPurplish : this.cloudColorBlueish);
                f2 = 100.0f;
                f3 = 25.0f;
                f4 = 0.0f;
                f5 = 1.35f;
            }
        }
        this.print("WeatherPeriod: cloudColor r=" + this.cloudColor.getExterior().r + ", g=" + this.cloudColor.getExterior().g + ", b=" + this.cloudColor.getExterior().b);
        this.print("WeatherPeriod: chances, storm=" + f2 + ", tropical=" + f3 + ", blizzard=" + f4 + ". rainTimeMulti=" + (f5 *= this.climateManager.getRainTimeMultiplierMod(SandboxOptions.instance.getRainModifier())));
        ArrayList<WeatherStage> arrayList = new ArrayList<WeatherStage>();
        WeatherStage weatherStage = null;
        if (this.frontCache.getType() == 1) {
            this.print("WeatherPeriod: Warm to cold front selected.");
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (this.frontCache.getStrength() > 0.75f) {
                if (f3 > 0.0f && this.RandNext(0.0f, 100.0f) < f3) {
                    this.print("WeatherPeriod: tropical storm triggered.");
                    bl3 = true;
                } else if (f4 > 0.0f && this.RandNext(0.0f, 100.0f) < f4) {
                    this.print("WeatherPeriod: blizzard triggered.");
                    bl2 = true;
                }
            }
            if (!bl2 && !bl3 && this.frontCache.getStrength() > 0.5f && f2 > 0.0f && this.RandNext(0.0f, 100.0f) < f2) {
                this.print("WeatherPeriod: storm triggered.");
                bl4 = true;
            }
            float f7 = this.RandNext(24.0f, 48.0f) * this.frontCache.getStrength();
            float f8 = 0.0f;
            if (bl3) {
                arrayList.add(this.createStage(8, 8.0f + this.RandNext(0.0f, 16.0f * this.frontCache.getStrength())));
                this.cloudColor = this.cloudColorTropical;
                if (this.RandNext(0.0f, 100.0f) < 60.0f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 5.0f + this.RandNext(0.0f, 5.0f * this.frontCache.getStrength())));
                }
                if (this.RandNext(0.0f, 100.0f) < 30.0f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 5.0f + this.RandNext(0.0f, 5.0f * this.frontCache.getStrength())));
                }
            } else if (bl2) {
                arrayList.add(this.createStage(7, 24.0f + this.RandNext(0.0f, 24.0f * this.frontCache.getStrength())));
                this.cloudColor = this.cloudColorBlizzard;
            } else if (bl4) {
                arrayList.add(this.createStage(3, 5.0f + this.RandNext(0.0f, 5.0f * this.frontCache.getStrength())));
                if (this.RandNext(0.0f, 100.0f) < 70.0f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 4.0f + this.RandNext(0.0f, 4.0f * this.frontCache.getStrength())));
                }
                if (this.RandNext(0.0f, 100.0f) < 50.0f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 4.0f + this.RandNext(0.0f, 4.0f * this.frontCache.getStrength())));
                }
                if (this.RandNext(0.0f, 100.0f) < 25.0f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 4.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength())));
                }
                if (this.RandNext(0.0f, 100.0f) < 12.5f * this.frontCache.getStrength()) {
                    arrayList.add(this.createStage(3, 4.0f + this.RandNext(0.0f, 2.0f * this.frontCache.getStrength())));
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                f8 = (float)((double)f8 + ((WeatherStage)arrayList.get(i)).getStageDuration());
            }
            while (f8 < f7) {
                switch (this.RandNext(0, 10)) {
                    case 0: {
                        weatherStage = this.createStage(5, 1.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength()));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        weatherStage = this.createStage(1, 2.0f + this.RandNext(0.0f, 4.0f * this.frontCache.getStrength()));
                        break;
                    }
                    default: {
                        weatherStage = this.createStage(2, 2.0f + this.RandNext(0.0f, 4.0f * this.frontCache.getStrength()));
                    }
                }
                f8 = (float)((double)f8 + weatherStage.getStageDuration());
                arrayList.add(weatherStage);
            }
        } else {
            this.print("WeatherPeriod: Cold to warm front selected.");
            if (this.cloudColor == this.cloudColorReddish) {
                f6 = this.RandNext(0.0f, 100.0f);
                this.cloudColor = f6 < 50.0f ? this.cloudColorBlueish : this.cloudColorPurplish;
            }
            float f9 = this.RandNext(12.0f, 24.0f) * this.frontCache.getStrength();
            float f10 = 0.0f;
            while (f10 < f9) {
                switch (this.RandNext(0, 10)) {
                    case 0: {
                        weatherStage = this.createStage(1, 2.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength()));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        weatherStage = this.createStage(6, 2.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength()));
                        break;
                    }
                    default: {
                        weatherStage = this.createStage(5, 2.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength()));
                    }
                }
                f10 = (float)((double)f10 + weatherStage.getStageDuration());
                arrayList.add(weatherStage);
            }
        }
        Collections.shuffle(arrayList, this.seededRandom);
        float f11 = this.RandNext(30.0f, 60.0f);
        this.weatherStages.add(this.createStage(0, 1.0f + this.RandNext(0.0f, 2.0f * this.frontCache.getStrength())));
        for (n = 0; n < arrayList.size(); ++n) {
            this.weatherStages.add((WeatherStage)arrayList.get(n));
            if (n >= arrayList.size() - 1 || !(this.RandNext(0.0f, 100.0f) < f11)) continue;
            this.weatherStages.add(this.createStage(4, 1.0f + this.RandNext(0.0f, 2.0f * this.frontCache.getStrength())));
            this.weatherStages.add(this.createStage(9, 1.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength())));
            f11 = this.RandNext(30.0f, 60.0f);
        }
        if (this.weatherStages.get(this.weatherStages.size() - 1).getStageID() != 9) {
            this.weatherStages.add(this.createStage(4, 2.0f + this.RandNext(0.0f, 3.0f * this.frontCache.getStrength())));
        }
        for (n = 0; n < this.weatherStages.size(); ++n) {
            this.weatherStages.get((int)n).stageDuration *= (double)f5;
        }
        this.linkWeatherStages();
        this.duration = 0.0;
        for (n = 0; n < this.weatherStages.size(); ++n) {
            this.duration += this.weatherStages.get((int)n).stageDuration;
        }
        this.print("WeatherPeriod: Duration = " + this.duration + ".");
        double d = this.startTime;
        for (int i = 0; i < this.weatherStages.size(); ++i) {
            d = this.weatherStages.get(i).setStageStart(d);
        }
        this.weatherStageIndex = 0;
        this.currentStage = this.weatherStages.get(this.weatherStageIndex).startStage(this.startTime);
        this.print("WeatherPeriod: PATTERN GENERATION FINISHED.");
    }

    public WeatherStage createAndAddModdedStage(String string, double d) {
        WeatherStage weatherStage = this.createAndAddStage(10, d, string);
        return weatherStage;
    }

    public WeatherStage createAndAddStage(int n, double d) {
        return this.createAndAddStage(n, d, null);
    }

    private WeatherStage createAndAddStage(int n, double d, String string) {
        if (this.isRunning || !this.hasStartedInit || n == 10 && string == null) {
            return null;
        }
        WeatherStage weatherStage = this.createStage(n, d, string);
        this.weatherStages.add(weatherStage);
        return weatherStage;
    }

    private WeatherStage createStage(int n, double d) {
        return this.createStage(n, d, null);
    }

    private WeatherStage createStage(int n, double d, String string) {
        WeatherStage weatherStage = null;
        weatherStage = !this.stagesPool.isEmpty() ? this.stagesPool.pop() : new WeatherStage();
        weatherStage.stageID = n;
        weatherStage.modID = string;
        weatherStage.setStageDuration(d);
        switch (n) {
            case 0: {
                this.print("WeatherPeriod: Adding stage 'START' with duration: " + d + "%.");
                weatherStage.lerpEntryTo(StrLerpVal.NextTarget);
                break;
            }
            case 1: {
                this.print("WeatherPeriod: Adding stage 'SHOWERS' with duration: " + d + "%.");
                weatherStage.targetStrength = this.frontCache.getStrength() * 0.5f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.NextTarget);
                break;
            }
            case 2: {
                this.print("WeatherPeriod: Adding stage 'HEAVY_PRECIP' with duration: " + d + "%.");
                weatherStage.targetStrength = this.frontCache.getStrength();
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.Target);
                break;
            }
            case 8: {
                this.print("WeatherPeriod: Adding stage 'TROPICAL_STORM' with duration: " + d + "%.");
                weatherStage.targetStrength = 1.0f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.Target);
                weatherStage.fogStrength = 0.6f + this.RandNext(0.0f, 0.4f);
                break;
            }
            case 3: 
            case 11: {
                this.print("WeatherPeriod: Adding stage 'STORM' with duration: " + d + "%.");
                if (n == 11) {
                    this.print("WeatherPeriod: this storm is a kate and bob storm...");
                }
                weatherStage.targetStrength = this.frontCache.getStrength();
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.Target);
                if (this.RandNext(0, 100) >= 33) break;
                weatherStage.fogStrength = 0.1f + this.RandNext(0.0f, 0.4f);
                break;
            }
            case 4: {
                this.print("WeatherPeriod: Adding stage 'CLEARING' with duration: " + d + "%.");
                weatherStage.targetStrength = this.frontCache.getStrength() * 0.25f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.None);
                break;
            }
            case 5: {
                this.print("WeatherPeriod: Adding stage 'MODERATE' with duration: " + d + "%.");
                weatherStage.targetStrength = this.frontCache.getStrength() * 0.5f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.NextTarget);
                break;
            }
            case 6: {
                this.print("WeatherPeriod: Adding stage 'DRIZZLE' with duration: " + d + "%.");
                weatherStage.targetStrength = this.frontCache.getStrength() * 0.25f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.NextTarget);
                break;
            }
            case 7: {
                this.print("WeatherPeriod: Adding stage 'BLIZZARD' with duration: " + d + "%.");
                weatherStage.targetStrength = 1.0f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.Target);
                weatherStage.fogStrength = 0.55f + this.RandNext(0.0f, 0.2f);
                break;
            }
            case 9: {
                this.print("WeatherPeriod: Adding stage 'INTERMEZZO' with duration: " + d + "%.");
                weatherStage.targetStrength = 0.0f;
                weatherStage.lerpEntryTo(StrLerpVal.Target, StrLerpVal.NextTarget);
                break;
            }
            case 10: {
                this.print("WeatherPeriod: Adding stage 'MODDED' with duration: " + d + "%.");
                LuaEventManager.triggerEvent("OnInitModdedWeatherStage", this, weatherStage, Float.valueOf(this.frontCache.getStrength()));
                break;
            }
            default: {
                this.print("WeatherPeriod Warning: trying to _INIT_ state that is not recognized, state id=" + n);
            }
        }
        return weatherStage;
    }

    private void updateCurrentStage() {
        if (this.isDummy) {
            return;
        }
        this.isBlizzard = false;
        this.isThunderStorm = false;
        this.isTropicalStorm = false;
        switch (this.currentStage.stageID) {
            case 0: {
                this.rainThreshold = 0.35f - this.frontCache.getStrength() * 0.2f;
                this.climateManager.fogIntensity.setOverride(0.0f, this.currentStage.linearT);
                break;
            }
            case 1: {
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                float f = ClimateManager.clamp01(this.currentStage.parabolicT * 3.0f);
                this.climateManager.windIntensity.setOverride(0.1f * this.weatherNoise, f);
                this.climateManager.windAngleIntensity.setOverride(0.0f, f);
                break;
            }
            case 2: {
                float f = this.frontCache.getStrength() * 0.5f;
                if (this.currentStage.linearT < 0.1f) {
                    f = ClimateManager.clerp((float)((this.currentTime - this.currentStage.stageStart) / (this.currentStage.stageDuration * 0.1)), 0.0f, this.frontCache.getStrength() * 0.5f);
                } else if (this.currentStage.linearT > 0.9f) {
                    f = ClimateManager.clerp(1.0f - (float)((this.currentStage.stageEnd - this.currentTime) / (this.currentStage.stageDuration * 0.1)), this.frontCache.getStrength() * 0.5f, 0.0f);
                }
                this.weatherNoise = f + this.weatherNoise * (1.0f - f);
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                float f2 = ClimateManager.clamp01(this.currentStage.parabolicT * 3.0f);
                this.climateManager.windIntensity.setOverride(0.5f * this.weatherNoise, f2);
                this.climateManager.windAngleIntensity.setOverride(0.7f * this.weatherNoise * this.windAngleDirMod, f2);
                break;
            }
            case 8: {
                this.isTropicalStorm = true;
            }
            case 3: 
            case 11: {
                boolean bl = this.isThunderStorm = !this.isTropicalStorm;
                if (!this.currentStage.hasStartedCloud) {
                    float f = this.frontCache.getAngleDegrees();
                    float f3 = this.frontCache.getStrength();
                    float f4 = 8000.0f * f3;
                    float f5 = f3;
                    float f6 = 0.6f * f3;
                    double d = this.currentStage.stageDuration;
                    boolean bl2 = (double)f3 > 0.7;
                    int n = Rand.Next(1, 3);
                    if (this.currentStage.stageID == 8) {
                        n = 1;
                        f4 = 15000.0f;
                        f6 = 0.8f;
                        bl2 = true;
                        f3 = 1.0f;
                    }
                    for (int i = 0; i < n; ++i) {
                        ThunderStorm.ThunderCloud thunderCloud = this.thunderStorm.startThunderCloud(f3, f, f4, f5, f6, d, bl2, this.currentStage.stageID == 11 ? kateBobStormProgress : 0.0f);
                        if (this.currentStage.stageID == 11 && bl2 && thunderCloud != null) {
                            thunderCloud.setCenter(this.kateBobStormX, this.kateBobStormY, f);
                        }
                        bl2 = false;
                    }
                    this.currentStage.hasStartedCloud = true;
                }
                float f = this.frontCache.getStrength() * 0.5f;
                if (this.currentStage.linearT < 0.1f) {
                    f = ClimateManager.clerp((float)((this.currentTime - this.currentStage.stageStart) / (this.currentStage.stageDuration * 0.1)), 0.0f, this.frontCache.getStrength() * 0.5f);
                } else if (this.currentStage.linearT > 0.9f) {
                    f = ClimateManager.clerp(1.0f - (float)((this.currentStage.stageEnd - this.currentTime) / (this.currentStage.stageDuration * 0.1)), this.frontCache.getStrength() * 0.5f, 0.0f);
                }
                this.weatherNoise = f + this.weatherNoise * (1.0f - f);
                float f7 = ClimateManager.clamp01(this.currentStage.parabolicT * 3.0f);
                if (this.currentStage.stageID == 8) {
                    this.climateManager.windIntensity.setOverride(0.4f + 0.6f * this.weatherNoise, f7);
                } else {
                    this.climateManager.windIntensity.setOverride(0.2f + 0.5f * this.weatherNoise, f7);
                }
                this.climateManager.windAngleIntensity.setOverride(0.7f * this.weatherNoise * this.windAngleDirMod, f7);
                if (PerformanceSettings.FogQuality == 2) break;
                if (this.currentStage.fogStrength > 0.0f) {
                    this.climateManager.fogIntensity.setOverride(this.currentStage.fogStrength, f7);
                    if (this.currentStage.stageID == 8) {
                        this.climateManager.colorNewFog.setOverride(this.climateManager.getFogTintTropical(), f7);
                        break;
                    }
                    this.climateManager.colorNewFog.setOverride(this.climateManager.getFogTintStorm(), f7);
                    break;
                }
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                break;
            }
            case 4: {
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f - this.currentStage.linearT);
                break;
            }
            case 5: {
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                break;
            }
            case 6: {
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                break;
            }
            case 7: {
                this.isBlizzard = true;
                float f = this.frontCache.getStrength() * 0.5f;
                if (this.currentStage.linearT < 0.1f) {
                    f = ClimateManager.clerp((float)((this.currentTime - this.currentStage.stageStart) / (this.currentStage.stageDuration * 0.1)), 0.0f, this.frontCache.getStrength() * 0.5f);
                } else if (this.currentStage.linearT > 0.9f) {
                    f = ClimateManager.clerp(1.0f - (float)((this.currentStage.stageEnd - this.currentTime) / (this.currentStage.stageDuration * 0.1)), this.frontCache.getStrength() * 0.5f, 0.0f);
                }
                this.weatherNoise = f + this.weatherNoise * (1.0f - f);
                float f8 = ClimateManager.clamp01(this.currentStage.parabolicT * 3.0f);
                this.climateManager.windIntensity.setOverride(0.75f + 0.25f * this.weatherNoise, f8);
                this.climateManager.windAngleIntensity.setOverride(0.7f * this.weatherNoise * this.windAngleDirMod, f8);
                if (PerformanceSettings.FogQuality == 2) break;
                if (this.currentStage.fogStrength > 0.0f) {
                    this.climateManager.fogIntensity.setOverride(this.currentStage.fogStrength, f8);
                    break;
                }
                this.climateManager.fogIntensity.setOverride(1.0f, f8);
                break;
            }
            case 9: {
                this.climateManager.fogIntensity.setOverride(0.0f, 1.0f);
                break;
            }
            case 10: {
                LuaEventManager.triggerEvent("OnUpdateModdedWeatherStage", this, this.currentStage, Float.valueOf(this.frontCache.getStrength()));
                break;
            }
            default: {
                this.print("WeatherPeriod Warning: trying to _UPDATE_ state that is not recognized, state id=" + this.currentStage.stageID);
                this.resetClimateManagerOverrides();
                this.isRunning = false;
                if (!GameServer.bServer) break;
                this.climateManager.transmitClimatePacket(ClimateManager.ClimateNetAuth.ServerOnly, (byte)1, null);
            }
        }
    }

    public void update(double d) {
        if (GameClient.bClient || this.isDummy) {
            return;
        }
        if (!this.isRunning || this.currentStage == null || this.weatherStageIndex < 0 || this.weatherStages.size() == 0) {
            if (this.isRunning) {
                this.resetClimateManagerOverrides();
                this.isRunning = false;
                LuaEventManager.triggerEvent("OnWeatherPeriodComplete", this);
                if (GameServer.bServer) {
                    this.climateManager.transmitClimatePacket(ClimateManager.ClimateNetAuth.ServerOnly, (byte)1, null);
                }
            }
            return;
        }
        if (this.currentTime > this.currentStage.stageEnd) {
            ++this.weatherStageIndex;
            LuaEventManager.triggerEvent("OnWeatherPeriodStage", this);
            if (this.weatherStageIndex >= this.weatherStages.size()) {
                this.isRunning = false;
                this.currentStage = null;
                this.resetClimateManagerOverrides();
                if (GameServer.bServer) {
                    this.climateManager.transmitClimatePacket(ClimateManager.ClimateNetAuth.ServerOnly, (byte)1, null);
                }
                return;
            }
            if (this.currentStage != null) {
                this.currentStage.exitStrength = this.currentStrength;
            }
            this.currentStage = this.weatherStages.get(this.weatherStageIndex);
            this.currentStage.entryStrength = this.currentStrength;
            this.currentStage.startStage(d);
        }
        this.currentTime = d;
        this.weatherNoise = 0.3f * this.frontCache.getStrength() + (float)SimplexNoise.noise(d, 24000.0) * (1.0f - 0.3f * this.frontCache.getStrength());
        this.weatherNoise = (this.weatherNoise + 1.0f) * 0.5f;
        this.currentStage.updateT(this.currentTime);
        this.stageProgress = this.currentStage.linearT;
        this.totalProgress = (float)(this.currentTime - this.weatherStages.get((int)0).stageStart) / (float)this.duration;
        this.totalProgress = ClimateManager.clamp01(this.totalProgress);
        this.currentStrength = this.currentStage.getStageCurrentStrength();
        this.updateCurrentStage();
        float f = ClimateManager.clamp(-1.0f, 1.0f, this.currentStrength * 2.0f) * maxTemperatureInfluence;
        this.temperatureInfluence = this.frontCache.getType() == 1 ? this.climateManager.temperature.internalValue - f : this.climateManager.temperature.internalValue + f;
        if (this.isRunning) {
            if (this.weatherNoise > this.rainThreshold) {
                this.precipitationFinal = (this.weatherNoise - this.rainThreshold) / (1.0f - this.rainThreshold);
                this.precipitationFinal *= this.currentStrength;
            } else {
                this.precipitationFinal = 0.0f;
            }
            float f2 = this.precipitationFinal;
            float f3 = f2 * (1.0f - this.climateManager.nightStrength.internalValue);
            float f4 = 0.5f;
            f4 += 0.5f * (1.0f - this.climateManager.nightStrength.internalValue);
            f4 = Math.max(f4, this.climateManager.cloudIntensity.internalValue);
            float f5 = 0.55f;
            if (PerformanceSettings.FogQuality != 2 && this.currentStage.stageID == 8) {
                f5 += 0.35f * this.currentStage.parabolicT;
            }
            float f6 = 1.0f - f5 * f2;
            f6 = Math.min(f6, 1.0f - this.climateManager.nightStrength.internalValue);
            if (PerformanceSettings.FogQuality != 2 && this.currentStage.stageID == 7) {
                float f7 = 1.0f - 0.75f * this.currentStage.parabolicT;
                f4 *= f7;
            }
            this.climateManager.cloudIntensity.setOverride(f4, this.currentStrength);
            this.climateManager.precipitationIntensity.setOverride(this.precipitationFinal, 1.0f);
            this.climateManager.globalLight.setOverride(this.cloudColor, f3);
            this.climateManager.globalLightIntensity.setOverride(0.4f, f3);
            this.climateManager.desaturation.setOverride(0.3f, this.currentStrength);
            this.climateManager.temperature.setOverride(this.temperatureInfluence, this.currentStrength);
            this.climateManager.ambient.setOverride(f6, f2);
            this.climateManager.dayLightStrength.setOverride(f6, f2);
            if (this.climateManager.getTemperature() < 0.0f && this.climateManager.getSeason().isSeason(5) || ClimateManager.WINTER_IS_COMING) {
                this.climateManager.precipitationIsSnow.setOverride(true);
            } else {
                this.climateManager.precipitationIsSnow.setEnableOverride(false);
            }
        }
    }

    private void resetClimateManagerOverrides() {
        if (this.climateManager != null && !this.isDummy) {
            this.climateManager.resetOverrides();
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (!GameClient.bClient || GameServer.bServer) {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeBoolean(this.isRunning);
            if (this.isRunning) {
                dataOutputStream.writeInt(this.weatherStageIndex);
                dataOutputStream.writeFloat(this.currentStrength);
                dataOutputStream.writeFloat(this.rainThreshold);
                dataOutputStream.writeBoolean(this.isThunderStorm);
                dataOutputStream.writeBoolean(this.isTropicalStorm);
                dataOutputStream.writeBoolean(this.isBlizzard);
                this.frontCache.save(dataOutputStream);
                dataOutputStream.writeInt(this.weatherStages.size());
                for (int i = 0; i < this.weatherStages.size(); ++i) {
                    WeatherStage weatherStage = this.weatherStages.get(i);
                    dataOutputStream.writeInt(weatherStage.stageID);
                    dataOutputStream.writeDouble(weatherStage.stageDuration);
                    weatherStage.save(dataOutputStream);
                }
                this.cloudColor.save(dataOutputStream);
            }
        } else {
            dataOutputStream.writeByte(0);
        }
    }

    public void load(DataInputStream dataInputStream, int n) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 1) {
            this.isRunning = dataInputStream.readBoolean();
            if (this.isRunning) {
                int n2;
                this.weatherStageIndex = dataInputStream.readInt();
                this.currentStrength = dataInputStream.readFloat();
                this.rainThreshold = dataInputStream.readFloat();
                this.isThunderStorm = dataInputStream.readBoolean();
                this.isTropicalStorm = dataInputStream.readBoolean();
                this.isBlizzard = dataInputStream.readBoolean();
                this.frontCache.load(dataInputStream);
                this.windAngleDirMod = this.frontCache.getAngleDegrees() >= 90.0f && this.frontCache.getAngleDegrees() < 270.0f ? 1.0f : -1.0f;
                this.print("WeatherPeriod: Loading weather pattern with strength = " + this.frontCache.getStrength());
                this.clearCurrentWeatherStages();
                int n3 = dataInputStream.readInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    int n4 = dataInputStream.readInt();
                    double d = dataInputStream.readDouble();
                    WeatherStage weatherStage = !this.stagesPool.isEmpty() ? this.stagesPool.pop() : new WeatherStage();
                    weatherStage.stageID = n4;
                    weatherStage.setStageDuration(d);
                    weatherStage.load(dataInputStream, n);
                    this.weatherStages.add(weatherStage);
                }
                if (n >= 170) {
                    this.cloudColor.load(dataInputStream, n);
                }
                this.linkWeatherStages();
                this.duration = 0.0;
                for (n2 = 0; n2 < this.weatherStages.size(); ++n2) {
                    this.duration += this.weatherStages.get((int)n2).stageDuration;
                }
                if (this.weatherStageIndex >= 0 && this.weatherStageIndex < this.weatherStages.size()) {
                    this.currentStage = this.weatherStages.get(this.weatherStageIndex);
                    this.print("WeatherPeriod: Pattern loaded!");
                } else {
                    this.print("WeatherPeriod: Couldnt load stages correctly.");
                    this.isRunning = false;
                }
            }
        }
    }

    public static class WeatherStage {
        protected WeatherStage previousStage;
        protected WeatherStage nextStage;
        private double stageStart;
        private double stageEnd;
        private double stageDuration;
        protected int stageID;
        protected float entryStrength;
        protected float exitStrength;
        protected float targetStrength;
        protected StrLerpVal lerpMidVal;
        protected StrLerpVal lerpEndVal;
        protected boolean hasStartedCloud = false;
        protected float fogStrength = 0.0f;
        protected float linearT;
        protected float parabolicT;
        protected boolean isCycleFirstHalf = true;
        protected boolean creationFinished = false;
        protected String modID;
        private float m;
        private float e;

        public WeatherStage() {
        }

        public WeatherStage(int n) {
            this.stageID = n;
        }

        public void setStageID(int n) {
            this.stageID = n;
        }

        public double getStageStart() {
            return this.stageStart;
        }

        public double getStageEnd() {
            return this.stageEnd;
        }

        public double getStageDuration() {
            return this.stageDuration;
        }

        public int getStageID() {
            return this.stageID;
        }

        public String getModID() {
            return this.modID;
        }

        public float getLinearT() {
            return this.linearT;
        }

        public float getParabolicT() {
            return this.parabolicT;
        }

        public void setTargetStrength(float f) {
            this.targetStrength = f;
        }

        public boolean getHasStartedCloud() {
            return this.hasStartedCloud;
        }

        public void setHasStartedCloud(boolean bl) {
            this.hasStartedCloud = true;
        }

        public void save(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeDouble(this.stageStart);
            dataOutputStream.writeFloat(this.entryStrength);
            dataOutputStream.writeFloat(this.exitStrength);
            dataOutputStream.writeFloat(this.targetStrength);
            dataOutputStream.writeInt(this.lerpMidVal.getValue());
            dataOutputStream.writeInt(this.lerpEndVal.getValue());
            dataOutputStream.writeBoolean(this.hasStartedCloud);
            dataOutputStream.writeByte(this.modID != null ? 1 : 0);
            if (this.modID != null) {
                GameWindow.WriteString(dataOutputStream, this.modID);
            }
            dataOutputStream.writeFloat(this.fogStrength);
        }

        public void load(DataInputStream dataInputStream, int n) throws IOException {
            this.stageStart = dataInputStream.readDouble();
            this.stageEnd = this.stageStart + this.stageDuration;
            this.entryStrength = dataInputStream.readFloat();
            this.exitStrength = dataInputStream.readFloat();
            this.targetStrength = dataInputStream.readFloat();
            this.lerpMidVal = StrLerpVal.fromValue(dataInputStream.readInt());
            this.lerpEndVal = StrLerpVal.fromValue(dataInputStream.readInt());
            this.hasStartedCloud = dataInputStream.readBoolean();
            if (n >= 141 && dataInputStream.readByte() == 1) {
                this.modID = GameWindow.ReadString(dataInputStream);
            }
            if (n >= 170) {
                this.fogStrength = dataInputStream.readFloat();
            }
        }

        protected void reset() {
            this.previousStage = null;
            this.nextStage = null;
            this.isCycleFirstHalf = true;
            this.hasStartedCloud = false;
            this.lerpMidVal = StrLerpVal.None;
            this.lerpEndVal = StrLerpVal.None;
            this.entryStrength = 0.0f;
            this.exitStrength = 0.0f;
            this.modID = null;
            this.creationFinished = false;
            this.fogStrength = 0.0f;
        }

        protected WeatherStage startStage(double d) {
            this.stageStart = d;
            this.stageEnd = d + this.stageDuration;
            this.hasStartedCloud = false;
            return this;
        }

        protected double setStageStart(double d) {
            this.stageStart = d;
            this.stageEnd = d + this.stageDuration;
            return this.stageEnd;
        }

        protected WeatherStage setStageDuration(double d) {
            this.stageDuration = d;
            if (this.stageDuration < 1.0) {
                this.stageDuration = 1.0;
            }
            return this;
        }

        protected WeatherStage overrideStageDuration(double d) {
            this.stageDuration = d;
            return this;
        }

        public void lerpEntryTo(int n, int n2) {
            if (!this.creationFinished) {
                this.lerpEntryTo(StrLerpVal.fromValue(n), StrLerpVal.fromValue(n2));
            }
        }

        protected void lerpEntryTo(StrLerpVal strLerpVal) {
            this.lerpEntryTo(StrLerpVal.None, strLerpVal);
        }

        protected void lerpEntryTo(StrLerpVal strLerpVal, StrLerpVal strLerpVal2) {
            if (!this.creationFinished) {
                this.lerpMidVal = strLerpVal;
                this.lerpEndVal = strLerpVal2;
            }
        }

        public float getStageCurrentStrength() {
            this.m = this.getLerpValue(this.lerpMidVal);
            this.e = this.getLerpValue(this.lerpEndVal);
            if (this.lerpMidVal == StrLerpVal.None) {
                return ClimateManager.clerp(this.linearT, this.entryStrength, this.e);
            }
            if (this.isCycleFirstHalf) {
                return ClimateManager.clerp(this.parabolicT, this.entryStrength, this.m);
            }
            return ClimateManager.clerp(this.parabolicT, this.e, this.m);
        }

        private float getLerpValue(StrLerpVal strLerpVal) {
            switch (strLerpVal) {
                case Entry: {
                    return this.entryStrength;
                }
                case Target: {
                    return this.targetStrength;
                }
                case NextTarget: {
                    return this.nextStage != null ? this.nextStage.targetStrength : 0.0f;
                }
                case None: {
                    return 0.0f;
                }
            }
            return 0.0f;
        }

        private WeatherStage updateT(double d) {
            this.linearT = this.getPeriodLerpT(d);
            if (this.stageID == 11) {
                this.linearT = kateBobStormProgress + (1.0f - kateBobStormProgress) * this.linearT;
            }
            if (this.linearT < 0.5f) {
                this.parabolicT = this.linearT * 2.0f;
                this.isCycleFirstHalf = true;
            } else {
                this.parabolicT = 2.0f - this.linearT * 2.0f;
                this.isCycleFirstHalf = false;
            }
            return this;
        }

        private float getPeriodLerpT(double d) {
            if (d < this.stageStart) {
                return 0.0f;
            }
            if (d > this.stageEnd) {
                return 1.0f;
            }
            return (float)((d - this.stageStart) / this.stageDuration);
        }
    }

    public static enum StrLerpVal {
        Entry(1),
        Target(2),
        NextTarget(3),
        None(0);

        private final int value;

        private StrLerpVal(int n2) {
            this.value = n2;
            if (cache.containsKey(n2)) {
                DebugLog.log("StrLerpVal WARNING: trying to add id twice. id=" + n2);
            }
            cache.put(n2, this);
        }

        public int getValue() {
            return this.value;
        }

        public static StrLerpVal fromValue(int n) {
            if (cache.containsKey(n)) {
                return cache.get(n);
            }
            DebugLog.log("StrLerpVal, trying to get from invalid id: " + n);
            return None;
        }
    }
}

