/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import fmod.fmod.FMODManager;
import fmod.javafmod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameSounds;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderSettings;
import zombie.debug.DebugLog;
import zombie.iso.weather.ClimateColorInfo;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.SpeedControls;
import zombie.ui.UIManager;

public class ThunderStorm {
    public static int MAP_MIN_X = -3000;
    public static int MAP_MIN_Y = -3000;
    public static int MAP_MAX_X = 25000;
    public static int MAP_MAX_Y = 20000;
    private boolean hasActiveThunderClouds = false;
    private float cloudMaxRadius = 20000.0f;
    private ThunderEvent[] events = new ThunderEvent[30];
    private ThunderCloud[] clouds = new ThunderCloud[3];
    private ClimateManager climateManager;
    private ArrayList<ThunderCloud> cloudCache;
    private boolean donoise = false;
    private int strikeRadius = 4000;
    private final PlayerLightningInfo[] lightningInfos = new PlayerLightningInfo[4];
    private ThunderEvent networkThunderEvent = new ThunderEvent();
    private ThunderCloud dummyCloud;

    public ArrayList<ThunderCloud> getClouds() {
        if (this.cloudCache == null) {
            this.cloudCache = new ArrayList(this.clouds.length);
            for (int i = 0; i < this.clouds.length; ++i) {
                this.cloudCache.add(this.clouds[i]);
            }
        }
        return this.cloudCache;
    }

    public ThunderStorm(ClimateManager climateManager) {
        int n;
        this.climateManager = climateManager;
        for (n = 0; n < this.events.length; ++n) {
            this.events[n] = new ThunderEvent();
        }
        for (n = 0; n < this.clouds.length; ++n) {
            this.clouds[n] = new ThunderCloud();
        }
        for (n = 0; n < 4; ++n) {
            this.lightningInfos[n] = new PlayerLightningInfo();
        }
    }

    private ThunderEvent getFreeEvent() {
        for (int i = 0; i < this.events.length; ++i) {
            if (this.events[i].isRunning) continue;
            return this.events[i];
        }
        return null;
    }

    private ThunderCloud getFreeCloud() {
        for (int i = 0; i < this.clouds.length; ++i) {
            if (this.clouds[i].isRunning) continue;
            return this.clouds[i];
        }
        return null;
    }

    private ThunderCloud getCloud(int n) {
        int n2 = 0;
        if (n2 < this.clouds.length) {
            return this.clouds[n2];
        }
        return null;
    }

    public boolean HasActiveThunderClouds() {
        return this.hasActiveThunderClouds;
    }

    public void noise(String string) {
        if (this.donoise && (Core.bDebug || GameServer.bServer && GameServer.bDebug)) {
            DebugLog.log("thunderstorm: " + string);
        }
    }

    public void stopAllClouds() {
        for (int i = 0; i < this.clouds.length; ++i) {
            this.stopCloud(i);
        }
    }

    public void stopCloud(int n) {
        ThunderCloud thunderCloud = this.getCloud(n);
        if (thunderCloud != null) {
            thunderCloud.isRunning = false;
        }
    }

    private static float addToAngle(float f, float f2) {
        if ((f += f2) > 360.0f) {
            f -= 360.0f;
        } else if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static int getMapDiagonal() {
        int n = MAP_MAX_X - MAP_MIN_X;
        int n2 = MAP_MAX_Y - MAP_MIN_Y;
        int n3 = (int)Math.sqrt(Math.pow(n, 2.0) + Math.pow(n2, 2.0));
        return n3 /= 2;
    }

    public void startThunderCloud(float f, float f2, float f3, float f4, float f5, double d, boolean bl) {
        this.startThunderCloud(f, f2, f3, f4, f5, d, bl);
    }

    public ThunderCloud startThunderCloud(float f, float f2, float f3, float f4, float f5, double d, boolean bl, float f6) {
        if (GameClient.bClient) {
            return null;
        }
        ThunderCloud thunderCloud = this.getFreeCloud();
        if (thunderCloud != null) {
            f2 = ThunderStorm.addToAngle(f2, Rand.Next(-10.0f, 10.0f));
            thunderCloud.startTime = GameTime.instance.getWorldAgeHours();
            thunderCloud.endTime = thunderCloud.startTime + d;
            thunderCloud.duration = d;
            thunderCloud.strength = ClimateManager.clamp01(f);
            thunderCloud.angle = f2;
            thunderCloud.radius = f3;
            if (thunderCloud.radius > this.cloudMaxRadius) {
                thunderCloud.radius = this.cloudMaxRadius;
            }
            thunderCloud.eventFrequency = f4;
            thunderCloud.thunderRatio = ClimateManager.clamp01(f5);
            thunderCloud.percentageOffset = PZMath.clamp_01(f6);
            float f7 = ThunderStorm.addToAngle(f2, 180.0f);
            int n = MAP_MAX_X - MAP_MIN_X;
            int n2 = MAP_MAX_Y - MAP_MIN_Y;
            int n3 = Rand.Next(MAP_MIN_X + n / 5, MAP_MAX_X - n / 5);
            int n4 = Rand.Next(MAP_MIN_Y + n2 / 5, MAP_MAX_Y - n2 / 5);
            if (bl) {
                if (!GameServer.bServer) {
                    IsoPlayer isoPlayer = IsoPlayer.getInstance();
                    if (isoPlayer != null) {
                        n3 = (int)isoPlayer.getX();
                        n4 = (int)isoPlayer.getY();
                    }
                } else if (!GameServer.Players.isEmpty()) {
                    ArrayList<IsoPlayer> arrayList = GameServer.getPlayers();
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        if (arrayList.get(i).getCurrentSquare() != null) continue;
                        arrayList.remove(i);
                    }
                    if (!arrayList.isEmpty()) {
                        IsoPlayer isoPlayer = arrayList.get(Rand.Next(arrayList.size()));
                        n3 = isoPlayer.getCurrentSquare().getX();
                        n4 = isoPlayer.getCurrentSquare().getY();
                    }
                } else {
                    DebugLog.log("Thundercloud couldnt target player...");
                    return null;
                }
            }
            thunderCloud.setCenter(n3, n4, f2);
            thunderCloud.isRunning = true;
            thunderCloud.suspendTimer.init(3);
            return thunderCloud;
        }
        return null;
    }

    public void update(double d) {
        Object object;
        int n;
        if (!GameClient.bClient || GameServer.bServer) {
            this.hasActiveThunderClouds = false;
            for (n = 0; n < this.clouds.length; ++n) {
                object = this.clouds[n];
                if (!((ThunderCloud)object).isRunning) continue;
                if (d < ((ThunderCloud)object).endTime) {
                    float f = (float)((d - ((ThunderCloud)object).startTime) / ((ThunderCloud)object).duration);
                    if (((ThunderCloud)object).percentageOffset > 0.0f) {
                        f = ((ThunderCloud)object).percentageOffset + (1.0f - ((ThunderCloud)object).percentageOffset) * f;
                    }
                    ((ThunderCloud)object).currentX = (int)ClimateManager.lerp(f, ((ThunderCloud)object).startX, ((ThunderCloud)object).endX);
                    ((ThunderCloud)object).currentY = (int)ClimateManager.lerp(f, ((ThunderCloud)object).startY, ((ThunderCloud)object).endY);
                    ((ThunderCloud)object).suspendTimer.update();
                    this.hasActiveThunderClouds = true;
                    if (!((ThunderCloud)object).suspendTimer.finished()) continue;
                    float f2 = Rand.Next(3.5f - 3.0f * ((ThunderCloud)object).strength, 24.0f - 20.0f * ((ThunderCloud)object).strength);
                    ((ThunderCloud)object).suspendTimer.init((int)(f2 * 60.0f));
                    float f3 = Rand.Next(0.0f, 1.0f);
                    this.strikeRadius = f3 < 0.6f ? (int)(((ThunderCloud)object).radius / 2.0f) / 3 : (f3 < 0.9f ? (int)(((ThunderCloud)object).radius / 2.0f) / 4 * 3 : (int)(((ThunderCloud)object).radius / 2.0f));
                    if (Rand.Next(0.0f, 1.0f) < ((ThunderCloud)object).thunderRatio) {
                        this.noise("trigger thunder event");
                        this.triggerThunderEvent(Rand.Next(((ThunderCloud)object).currentX - this.strikeRadius, ((ThunderCloud)object).currentX + this.strikeRadius), Rand.Next(((ThunderCloud)object).currentY - this.strikeRadius, ((ThunderCloud)object).currentY + this.strikeRadius), true, true, Rand.Next(0.0f, 1.0f) > 0.4f);
                        continue;
                    }
                    this.triggerThunderEvent(Rand.Next(((ThunderCloud)object).currentX - this.strikeRadius, ((ThunderCloud)object).currentX + this.strikeRadius), Rand.Next(((ThunderCloud)object).currentY - this.strikeRadius, ((ThunderCloud)object).currentY + this.strikeRadius), false, false, true);
                    this.noise("trigger rumble event");
                    continue;
                }
                ((ThunderCloud)object).isRunning = false;
            }
        }
        if (GameClient.bClient || !GameServer.bServer) {
            for (n = 0; n < 4; ++n) {
                object = this.lightningInfos[n];
                if (((PlayerLightningInfo)object).lightningState != LightningState.ApplyLightning) continue;
                ((PlayerLightningInfo)object).timer.update();
                if (!((PlayerLightningInfo)object).timer.finished()) {
                    ((PlayerLightningInfo)object).lightningMod = ClimateManager.clamp01(((PlayerLightningInfo)object).timer.ratio());
                    this.climateManager.dayLightStrength.finalValue += (1.0f - this.climateManager.dayLightStrength.finalValue) * (1.0f - ((PlayerLightningInfo)object).lightningMod);
                    IsoPlayer isoPlayer = IsoPlayer.players[n];
                    if (isoPlayer == null) continue;
                    isoPlayer.dirtyRecalcGridStackTime = 1.0f;
                    continue;
                }
                this.noise("apply lightning done.");
                ((PlayerLightningInfo)object).timer.init(2);
                ((PlayerLightningInfo)object).lightningStrength = 0.0f;
                ((PlayerLightningInfo)object).lightningState = LightningState.Idle;
            }
            n = SpeedControls.instance.getCurrentGameSpeed() > 1 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.events.length; ++i) {
                ThunderEvent thunderEvent = this.events[i];
                if (!thunderEvent.isRunning) continue;
                thunderEvent.soundDelay.update();
                if (thunderEvent.soundDelay.finished()) {
                    long l;
                    long l2;
                    GameSoundClip gameSoundClip;
                    GameSound gameSound;
                    thunderEvent.isRunning = false;
                    boolean bl3 = true;
                    if (UIManager.getSpeedControls() != null && UIManager.getSpeedControls().getCurrentGameSpeed() > 1) {
                        bl3 = false;
                    }
                    if (!bl3 || Core.SoundDisabled || FMODManager.instance.getNumListeners() <= 0) continue;
                    if (thunderEvent.doStrike && (n == 0 || !bl)) {
                        this.noise("thunder sound");
                        gameSound = GameSounds.getSound("Thunder");
                        GameSoundClip gameSoundClip2 = gameSoundClip = gameSound == null ? null : gameSound.getRandomClip();
                        if (gameSoundClip != null && gameSoundClip.eventDescription != null) {
                            l2 = gameSoundClip.eventDescription.address;
                            l = javafmod.FMOD_Studio_System_CreateEventInstance((long)l2);
                            javafmod.FMOD_Studio_EventInstance3D((long)l, (float)thunderEvent.eventX, (float)thunderEvent.eventY, (float)100.0f);
                            javafmod.FMOD_Studio_EventInstance_SetVolume((long)l, (float)gameSoundClip.getEffectiveVolume());
                            javafmod.FMOD_Studio_StartEvent((long)l);
                            javafmod.FMOD_Studio_ReleaseEventInstance((long)l);
                        }
                    }
                    if (!thunderEvent.doRumble || n != 0 && bl2) continue;
                    this.noise("rumble sound");
                    gameSound = GameSounds.getSound("RumbleThunder");
                    GameSoundClip gameSoundClip3 = gameSoundClip = gameSound == null ? null : gameSound.getRandomClip();
                    if (gameSoundClip == null || gameSoundClip.eventDescription == null) continue;
                    l2 = gameSoundClip.eventDescription.address;
                    l = javafmod.FMOD_Studio_System_CreateEventInstance((long)l2);
                    javafmod.FMOD_Studio_EventInstance3D((long)l, (float)thunderEvent.eventX, (float)thunderEvent.eventY, (float)200.0f);
                    javafmod.FMOD_Studio_EventInstance_SetVolume((long)l, (float)gameSoundClip.getEffectiveVolume());
                    javafmod.FMOD_Studio_StartEvent((long)l);
                    javafmod.FMOD_Studio_ReleaseEventInstance((long)l);
                    continue;
                }
                bl = bl || thunderEvent.doStrike;
                bl2 = bl2 || thunderEvent.doRumble;
            }
        }
    }

    public void applyLightningForPlayer(RenderSettings.PlayerRenderSettings playerRenderSettings, int n, IsoPlayer isoPlayer) {
        PlayerLightningInfo playerLightningInfo = this.lightningInfos[n];
        if (playerLightningInfo.lightningState == LightningState.ApplyLightning) {
            ClimateColorInfo climateColorInfo = playerRenderSettings.CM_GlobalLight;
            playerLightningInfo.lightningColor.getExterior().r = climateColorInfo.getExterior().r + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getExterior().r);
            playerLightningInfo.lightningColor.getExterior().g = climateColorInfo.getExterior().g + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getExterior().g);
            playerLightningInfo.lightningColor.getExterior().b = climateColorInfo.getExterior().b + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getExterior().b);
            playerLightningInfo.lightningColor.getInterior().r = climateColorInfo.getInterior().r + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getInterior().r);
            playerLightningInfo.lightningColor.getInterior().g = climateColorInfo.getInterior().g + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getInterior().g);
            playerLightningInfo.lightningColor.getInterior().b = climateColorInfo.getInterior().b + playerLightningInfo.lightningStrength * (1.0f - climateColorInfo.getInterior().b);
            playerLightningInfo.lightningColor.interp(playerRenderSettings.CM_GlobalLight, playerLightningInfo.lightningMod, playerLightningInfo.outColor);
            playerRenderSettings.CM_GlobalLight.getExterior().r = playerLightningInfo.outColor.getExterior().r;
            playerRenderSettings.CM_GlobalLight.getExterior().g = playerLightningInfo.outColor.getExterior().g;
            playerRenderSettings.CM_GlobalLight.getExterior().b = playerLightningInfo.outColor.getExterior().b;
            playerRenderSettings.CM_GlobalLight.getInterior().r = playerLightningInfo.outColor.getInterior().r;
            playerRenderSettings.CM_GlobalLight.getInterior().g = playerLightningInfo.outColor.getInterior().g;
            playerRenderSettings.CM_GlobalLight.getInterior().b = playerLightningInfo.outColor.getInterior().b;
            playerRenderSettings.CM_Ambient = ClimateManager.lerp(playerLightningInfo.lightningMod, 1.0f, playerRenderSettings.CM_Ambient);
            playerRenderSettings.CM_DayLightStrength = ClimateManager.lerp(playerLightningInfo.lightningMod, 1.0f, playerRenderSettings.CM_DayLightStrength);
            playerRenderSettings.CM_Desaturation = ClimateManager.lerp(playerLightningInfo.lightningMod, 0.0f, playerRenderSettings.CM_Desaturation);
            playerRenderSettings.CM_GlobalLightIntensity = Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null ? ClimateManager.lerp(playerLightningInfo.lightningMod, 1.0f, playerRenderSettings.CM_GlobalLightIntensity) : ClimateManager.lerp(playerLightningInfo.lightningMod, 0.0f, playerRenderSettings.CM_GlobalLightIntensity);
        }
    }

    public boolean isModifyingNight() {
        return false;
    }

    public void triggerThunderEvent(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (GameServer.bServer) {
            this.networkThunderEvent.eventX = n;
            this.networkThunderEvent.eventY = n2;
            this.networkThunderEvent.doStrike = bl;
            this.networkThunderEvent.doLightning = bl2;
            this.networkThunderEvent.doRumble = bl3;
            this.climateManager.transmitClimatePacket(ClimateManager.ClimateNetAuth.ServerOnly, (byte)2, null);
        } else if (!GameClient.bClient) {
            this.enqueueThunderEvent(n, n2, bl, bl2, bl3);
        }
    }

    public void writeNetThunderEvent(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(this.networkThunderEvent.eventX);
        byteBuffer.putInt(this.networkThunderEvent.eventY);
        byteBuffer.put(this.networkThunderEvent.doStrike ? (byte)1 : 0);
        byteBuffer.put(this.networkThunderEvent.doLightning ? (byte)1 : 0);
        byteBuffer.put(this.networkThunderEvent.doRumble ? (byte)1 : 0);
    }

    public void readNetThunderEvent(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        boolean bl = byteBuffer.get() == 1;
        boolean bl2 = byteBuffer.get() == 1;
        boolean bl3 = byteBuffer.get() == 1;
        this.enqueueThunderEvent(n, n2, bl, bl2, bl3);
    }

    public void enqueueThunderEvent(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        LuaEventManager.triggerEvent("OnThunderEvent", n, n2, bl, bl2, bl3);
        if (bl || bl3) {
            ThunderEvent thunderEvent;
            int n3 = 9999999;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null) continue;
                int n4 = this.GetDistance((int)isoPlayer.getX(), (int)isoPlayer.getY(), n, n2);
                if (n4 < n3) {
                    n3 = n4;
                }
                if (!bl2) continue;
                this.lightningInfos[i].distance = n4;
                this.lightningInfos[i].x = n;
                this.lightningInfos[i].y = n2;
            }
            this.noise("dist to player = " + n3);
            if (n3 < 10000 && (thunderEvent = this.getFreeEvent()) != null) {
                thunderEvent.doRumble = bl3;
                thunderEvent.doStrike = bl;
                thunderEvent.eventX = n;
                thunderEvent.eventY = n2;
                thunderEvent.isRunning = true;
                thunderEvent.soundDelay.init((int)((float)n3 / 300.0f * 60.0f));
                if (bl2) {
                    for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                        IsoPlayer isoPlayer = IsoPlayer.players[i];
                        if (isoPlayer == null || !((float)this.lightningInfos[i].distance < 7500.0f)) continue;
                        float f = 1.0f - (float)this.lightningInfos[i].distance / 7500.0f;
                        this.lightningInfos[i].lightningState = LightningState.ApplyLightning;
                        if (!(f > this.lightningInfos[i].lightningStrength)) continue;
                        this.lightningInfos[i].lightningStrength = f;
                        this.lightningInfos[i].timer.init(20 + (int)(80.0f * this.lightningInfos[i].lightningStrength));
                    }
                }
            }
        }
    }

    private int GetDistance(int n, int n2, int n3, int n4) {
        return (int)Math.sqrt(Math.pow(n - n3, 2.0) + Math.pow(n2 - n4, 2.0));
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (!GameClient.bClient || GameServer.bServer) {
            dataOutputStream.writeByte(this.clouds.length);
            for (int i = 0; i < this.clouds.length; ++i) {
                ThunderCloud thunderCloud = this.clouds[i];
                dataOutputStream.writeBoolean(thunderCloud.isRunning);
                if (!thunderCloud.isRunning) continue;
                dataOutputStream.writeInt(thunderCloud.startX);
                dataOutputStream.writeInt(thunderCloud.startY);
                dataOutputStream.writeInt(thunderCloud.endX);
                dataOutputStream.writeInt(thunderCloud.endY);
                dataOutputStream.writeFloat(thunderCloud.radius);
                dataOutputStream.writeFloat(thunderCloud.angle);
                dataOutputStream.writeFloat(thunderCloud.strength);
                dataOutputStream.writeFloat(thunderCloud.thunderRatio);
                dataOutputStream.writeDouble(thunderCloud.startTime);
                dataOutputStream.writeDouble(thunderCloud.endTime);
                dataOutputStream.writeDouble(thunderCloud.duration);
                dataOutputStream.writeFloat(thunderCloud.percentageOffset);
            }
        } else {
            dataOutputStream.writeByte(0);
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte();
        if (n == 0) {
            return;
        }
        if (n > this.clouds.length && this.dummyCloud == null) {
            this.dummyCloud = new ThunderCloud();
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = dataInputStream.readBoolean();
            ThunderCloud thunderCloud = i >= this.clouds.length ? this.dummyCloud : this.clouds[i];
            thunderCloud.isRunning = bl;
            if (!bl) continue;
            thunderCloud.startX = dataInputStream.readInt();
            thunderCloud.startY = dataInputStream.readInt();
            thunderCloud.endX = dataInputStream.readInt();
            thunderCloud.endY = dataInputStream.readInt();
            thunderCloud.radius = dataInputStream.readFloat();
            thunderCloud.angle = dataInputStream.readFloat();
            thunderCloud.strength = dataInputStream.readFloat();
            thunderCloud.thunderRatio = dataInputStream.readFloat();
            thunderCloud.startTime = dataInputStream.readDouble();
            thunderCloud.endTime = dataInputStream.readDouble();
            thunderCloud.duration = dataInputStream.readDouble();
            thunderCloud.percentageOffset = dataInputStream.readFloat();
        }
    }

    public static class ThunderCloud {
        private int currentX;
        private int currentY;
        private int startX;
        private int startY;
        private int endX;
        private int endY;
        private double startTime;
        private double endTime;
        private double duration;
        private float strength;
        private float angle;
        private float radius;
        private float eventFrequency;
        private float thunderRatio;
        private float percentageOffset;
        private boolean isRunning = false;
        private GameTime.AnimTimer suspendTimer = new GameTime.AnimTimer();

        public int getCurrentX() {
            return this.currentX;
        }

        public int getCurrentY() {
            return this.currentY;
        }

        public float getRadius() {
            return this.radius;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public float getStrength() {
            return this.strength;
        }

        public double lifeTime() {
            return (this.startTime - this.endTime) / this.duration;
        }

        public void setCenter(int n, int n2, float f) {
            int n3 = ThunderStorm.getMapDiagonal();
            float f2 = ThunderStorm.addToAngle(f, 180.0f);
            int n4 = n3 + Rand.Next(1500, 7500);
            int n5 = (int)((double)n + (double)n4 * Math.cos(Math.toRadians(f2)));
            int n6 = (int)((double)n2 + (double)n4 * Math.sin(Math.toRadians(f2)));
            n4 = n3 + Rand.Next(1500, 7500);
            int n7 = (int)((double)n + (double)n4 * Math.cos(Math.toRadians(f)));
            int n8 = (int)((double)n2 + (double)n4 * Math.sin(Math.toRadians(f)));
            this.startX = n5;
            this.startY = n6;
            this.endX = n7;
            this.endY = n8;
            this.currentX = n5;
            this.currentY = n6;
        }
    }

    private static class ThunderEvent {
        private int eventX;
        private int eventY;
        private boolean doLightning = false;
        private boolean doRumble = false;
        private boolean doStrike = false;
        private GameTime.AnimTimer soundDelay = new GameTime.AnimTimer();
        private boolean isRunning = false;

        private ThunderEvent() {
        }
    }

    private class PlayerLightningInfo {
        public LightningState lightningState = LightningState.Idle;
        public GameTime.AnimTimer timer = new GameTime.AnimTimer();
        public float lightningStrength = 1.0f;
        public float lightningMod = 0.0f;
        public ClimateColorInfo lightningColor = new ClimateColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
        public ClimateColorInfo outColor = new ClimateColorInfo(1.0f, 1.0f, 1.0f, 1.0f);
        public int x = 0;
        public int y = 0;
        public int distance = 0;

        private PlayerLightningInfo() {
        }
    }

    private static enum LightningState {
        Idle,
        ApplyLightning;

    }
}

