/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import zombie.SandboxOptions;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.iso.weather.ClimateManager;

public class Temperature {
    public static boolean DO_DEFAULT_BASE = false;
    public static boolean DO_DAYLEN_MOD = true;
    public static String CELSIUS_POSTFIX = "\u00b0C";
    public static String FAHRENHEIT_POSTFIX = "\u00b0F";
    public static final float skinCelciusMin = 20.0f;
    public static final float skinCelciusFavorable = 33.0f;
    public static final float skinCelciusMax = 42.0f;
    public static final float homeostasisDefault = 37.0f;
    public static final float FavorableNakedTemp = 27.0f;
    public static final float FavorableRoomTemp = 22.0f;
    public static final float coreCelciusMin = 20.0f;
    public static final float coreCelciusMax = 42.0f;
    public static final float neutralZone = 27.0f;
    public static final float Hypothermia_1 = 36.5f;
    public static final float Hypothermia_2 = 35.0f;
    public static final float Hypothermia_3 = 30.0f;
    public static final float Hypothermia_4 = 25.0f;
    public static final float Hyperthermia_1 = 37.5f;
    public static final float Hyperthermia_2 = 39.0f;
    public static final float Hyperthermia_3 = 40.0f;
    public static final float Hyperthermia_4 = 41.0f;
    public static final float TrueInsulationMultiplier = 2.0f;
    public static final float TrueWindresistMultiplier = 1.0f;
    public static final float BodyMinTemp = 20.0f;
    public static final float BodyMaxTemp = 42.0f;
    private static String cacheTempString = "";
    private static float cacheTemp = -9000.0f;
    private static Color tempColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private static Color col_0 = new Color(29, 34, 237);
    private static Color col_25 = new Color(0, 255, 234);
    private static Color col_50 = new Color(84, 255, 55);
    private static Color col_75 = new Color(255, 246, 0);
    private static Color col_100 = new Color(255, 0, 0);

    public static String getCelsiusPostfix() {
        return CELSIUS_POSTFIX;
    }

    public static String getFahrenheitPostfix() {
        return FAHRENHEIT_POSTFIX;
    }

    public static String getTemperaturePostfix() {
        return Core.OptionTemperatureDisplayCelsius ? CELSIUS_POSTFIX : FAHRENHEIT_POSTFIX;
    }

    public static String getTemperatureString(float f) {
        float f2 = Core.OptionTemperatureDisplayCelsius ? f : Temperature.CelsiusToFahrenheit(f);
        if (cacheTemp != (f2 = (float)Math.round(f2 * 10.0f) / 10.0f)) {
            cacheTemp = f2;
            cacheTempString = f2 + " " + Temperature.getTemperaturePostfix();
        }
        return cacheTempString;
    }

    public static float CelsiusToFahrenheit(float f) {
        return f * 1.8f + 32.0f;
    }

    public static float FahrenheitToCelsius(float f) {
        return (f - 32.0f) / 1.8f;
    }

    public static float WindchillCelsiusKph(float f, float f2) {
        float f3 = 13.12f + 0.6215f * f - 11.37f * (float)Math.pow(f2, 0.16f) + 0.3965f * f * (float)Math.pow(f2, 0.16f);
        return f3 < f ? f3 : f;
    }

    public static float getTrueInsulationValue(float f) {
        return f * 2.0f + 0.5f * f * f * f;
    }

    public static float getTrueWindresistanceValue(float f) {
        return f * 1.0f + 0.5f * f * f;
    }

    public static void reset() {
    }

    public static float getFractionForRealTimeRatePerMin(float f) {
        if (DO_DEFAULT_BASE) {
            return f / (1440.0f / (float)SandboxOptions.instance.getDayLengthMinutesDefault());
        }
        if (!DO_DAYLEN_MOD) {
            return f / (1440.0f / (float)SandboxOptions.instance.getDayLengthMinutes());
        }
        float f2 = (float)SandboxOptions.instance.getDayLengthMinutes() / (float)SandboxOptions.instance.getDayLengthMinutesDefault();
        if (f2 < 1.0f) {
            f2 = 0.5f + 0.5f * f2;
        } else if (f2 > 1.0f) {
            f2 = 1.0f + f2 / 16.0f;
        }
        return f / (1440.0f / (float)SandboxOptions.instance.getDayLengthMinutes()) * f2;
    }

    public static Color getValueColor(float f) {
        f = ClimateManager.clamp(0.0f, 1.0f, f);
        tempColor.set(0.0f, 0.0f, 0.0f, 1.0f);
        float f2 = 0.0f;
        if (f < 0.25f) {
            f2 = f / 0.25f;
            col_0.interp(col_25, f2, tempColor);
        } else if (f < 0.5f) {
            f2 = (f - 0.25f) / 0.25f;
            col_25.interp(col_50, f2, tempColor);
        } else if (f < 0.75f) {
            f2 = (f - 0.5f) / 0.25f;
            col_50.interp(col_75, f2, tempColor);
        } else {
            f2 = (f - 0.75f) / 0.25f;
            col_75.interp(col_100, f2, tempColor);
        }
        return tempColor;
    }

    public static float getWindChillAmountForPlayer(IsoPlayer isoPlayer) {
        if (isoPlayer.getVehicle() != null || isoPlayer.getSquare() != null && isoPlayer.getSquare().isInARoom()) {
            return 0.0f;
        }
        ClimateManager climateManager = ClimateManager.getInstance();
        float f = climateManager.getAirTemperatureForCharacter(isoPlayer, true);
        float f2 = 0.0f;
        if (f < climateManager.getTemperature()) {
            f2 = climateManager.getTemperature() - f;
        }
        return f2;
    }
}

