/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.erosion.ErosionMain;
import zombie.erosion.season.ErosionIceQueen;
import zombie.erosion.season.ErosionSeason;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWater;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.SkyBox;
import zombie.iso.weather.ClimateColorInfo;
import zombie.iso.weather.ClimateForecaster;
import zombie.iso.weather.ClimateHistory;
import zombie.iso.weather.ClimateMoon;
import zombie.iso.weather.ClimateValues;
import zombie.iso.weather.SimplexNoise;
import zombie.iso.weather.Temperature;
import zombie.iso.weather.ThunderStorm;
import zombie.iso.weather.WeatherPeriod;
import zombie.iso.weather.WorldFlares;
import zombie.iso.weather.dbg.ClimMngrDebug;
import zombie.iso.weather.fx.IsoWeatherFX;
import zombie.iso.weather.fx.SteppedUpdateFloat;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.vehicles.BaseVehicle;

public class ClimateManager {
    private boolean DISABLE_SIMULATION = false;
    private boolean DISABLE_FX_UPDATE = false;
    private boolean DISABLE_WEATHER_GENERATION = false;
    public static final int FRONT_COLD = -1;
    public static final int FRONT_STATIONARY = 0;
    public static final int FRONT_WARM = 1;
    public static final float MAX_WINDSPEED_KPH = 120.0f;
    public static final float MAX_WINDSPEED_MPH = 74.5645f;
    private ErosionSeason season;
    private long lastMinuteStamp = -1L;
    private KahluaTable modDataTable = null;
    private float airMass;
    private float airMassDaily;
    private float airMassTemperature;
    private float baseTemperature;
    private float snowFall = 0.0f;
    private float snowStrength = 0.0f;
    private float snowMeltStrength = 0.0f;
    private float snowFracNow = 0.0f;
    boolean canDoWinterSprites = false;
    private float windPower = 0.0f;
    private WeatherPeriod weatherPeriod;
    private ThunderStorm thunderStorm;
    private double simplexOffsetA = 0.0;
    private double simplexOffsetB = 0.0;
    private double simplexOffsetC = 0.0;
    private double simplexOffsetD = 0.0;
    private boolean dayDoFog = false;
    private float dayFogStrength = 0.0f;
    private GameTime gt;
    private double worldAgeHours;
    private boolean tickIsClimateTick = false;
    private boolean tickIsDayChange = false;
    private int lastHourStamp = -1;
    private boolean tickIsHourChange = false;
    private boolean tickIsTenMins = false;
    private AirFront currentFront = new AirFront();
    private ClimateColorInfo colDay;
    private ClimateColorInfo colDusk;
    private ClimateColorInfo colDawn;
    private ClimateColorInfo colNight;
    private ClimateColorInfo colNightNoMoon;
    private ClimateColorInfo colNightMoon;
    private ClimateColorInfo colTemp;
    private ClimateColorInfo colFog;
    private ClimateColorInfo colFogLegacy;
    private ClimateColorInfo colFogNew;
    private ClimateColorInfo fogTintStorm;
    private ClimateColorInfo fogTintTropical;
    private static ClimateManager instance = new ClimateManager();
    public static boolean WINTER_IS_COMING = false;
    public static boolean THE_DESCENDING_FOG = false;
    public static boolean A_STORM_IS_COMING = false;
    private ClimateValues climateValues;
    private ClimateForecaster climateForecaster;
    private ClimateHistory climateHistory;
    float dayLightLagged = 0.0f;
    float nightLagged = 0.0f;
    protected ClimateFloat desaturation;
    protected ClimateFloat globalLightIntensity;
    protected ClimateFloat nightStrength;
    protected ClimateFloat precipitationIntensity;
    protected ClimateFloat temperature;
    protected ClimateFloat fogIntensity;
    protected ClimateFloat windIntensity;
    protected ClimateFloat windAngleIntensity;
    protected ClimateFloat cloudIntensity;
    protected ClimateFloat ambient;
    protected ClimateFloat viewDistance;
    protected ClimateFloat dayLightStrength;
    protected ClimateFloat humidity;
    protected ClimateColor globalLight;
    protected ClimateColor colorNewFog;
    protected ClimateBool precipitationIsSnow;
    public static final int FLOAT_DESATURATION = 0;
    public static final int FLOAT_GLOBAL_LIGHT_INTENSITY = 1;
    public static final int FLOAT_NIGHT_STRENGTH = 2;
    public static final int FLOAT_PRECIPITATION_INTENSITY = 3;
    public static final int FLOAT_TEMPERATURE = 4;
    public static final int FLOAT_FOG_INTENSITY = 5;
    public static final int FLOAT_WIND_INTENSITY = 6;
    public static final int FLOAT_WIND_ANGLE_INTENSITY = 7;
    public static final int FLOAT_CLOUD_INTENSITY = 8;
    public static final int FLOAT_AMBIENT = 9;
    public static final int FLOAT_VIEW_DISTANCE = 10;
    public static final int FLOAT_DAYLIGHT_STRENGTH = 11;
    public static final int FLOAT_HUMIDITY = 12;
    public static final int FLOAT_MAX = 13;
    private final ClimateFloat[] climateFloats = new ClimateFloat[13];
    public static final int COLOR_GLOBAL_LIGHT = 0;
    public static final int COLOR_NEW_FOG = 1;
    public static final int COLOR_MAX = 2;
    private final ClimateColor[] climateColors = new ClimateColor[2];
    public static final int BOOL_IS_SNOW = 0;
    public static final int BOOL_MAX = 1;
    private final ClimateBool[] climateBooleans = new ClimateBool[1];
    public static final float AVG_FAV_AIR_TEMPERATURE = 22.0f;
    private static double windNoiseOffset = 0.0;
    private static double windNoiseBase = 0.0;
    private static double windNoiseFinal = 0.0;
    private static double windTickFinal = 0.0;
    private ClimateColorInfo colFlare = new ClimateColorInfo(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
    private boolean flareLaunched = false;
    private SteppedUpdateFloat flareIntensity = new SteppedUpdateFloat(0.0f, 0.01f, 0.0f, 1.0f);
    private float flareIntens;
    private float flareMaxLifeTime;
    private float flareLifeTime;
    private int nextRandomTargetIntens = 10;
    float fogLerpValue = 0.0f;
    private SeasonColor seasonColorDawn;
    private SeasonColor seasonColorDay;
    private SeasonColor seasonColorDusk;
    private DayInfo previousDay;
    private DayInfo currentDay;
    private DayInfo nextDay;
    public static final byte PacketUpdateClimateVars = 0;
    public static final byte PacketWeatherUpdate = 1;
    public static final byte PacketThunderEvent = 2;
    public static final byte PacketFlare = 3;
    public static final byte PacketAdminVarsUpdate = 4;
    public static final byte PacketRequestAdminVars = 5;
    public static final byte PacketClientChangedAdminVars = 6;
    public static final byte PacketClientChangedWeather = 7;
    private float networkLerp = 0.0f;
    private long networkUpdateStamp = 0L;
    private float networkLerpTime = 5000.0f;
    private float networkLerpTimeBase = 5000.0f;
    private float networkAdjustVal = 0.0f;
    private boolean networkPrint = false;
    private ClimateNetInfo netInfo = new ClimateNetInfo();
    private ClimateValues climateValuesFronts;
    private static float[] windAngles = new float[]{22.5f, 67.5f, 112.5f, 157.5f, 202.5f, 247.5f, 292.5f, 337.5f, 382.5f};
    private static String[] windAngleStr = new String[]{"SE", "S", "SW", "W", "NW", "N", "NE", "E", "SE"};

    public float getMaxWindspeedKph() {
        return 120.0f;
    }

    public float getMaxWindspeedMph() {
        return 74.5645f;
    }

    public static float ToKph(float f) {
        return f * 120.0f;
    }

    public static float ToMph(float f) {
        return f * 74.5645f;
    }

    public static ClimateManager getInstance() {
        return instance;
    }

    public static void setInstance(ClimateManager climateManager) {
        instance = climateManager;
    }

    public ClimateManager() {
        this.colDay = new ClimateColorInfo();
        this.colDawn = new ClimateColorInfo();
        this.colDusk = new ClimateColorInfo();
        this.colNight = new ClimateColorInfo();
        this.colNightMoon = new ClimateColorInfo();
        this.colFog = new ClimateColorInfo();
        this.colTemp = new ClimateColorInfo();
        this.colDay = new ClimateColorInfo();
        this.colDawn = new ClimateColorInfo();
        this.colDusk = new ClimateColorInfo();
        this.colNight = new ClimateColorInfo(0.33f, 0.33f, 1.0f, 0.4f, 0.33f, 0.33f, 1.0f, 0.4f);
        this.colNightNoMoon = new ClimateColorInfo(0.33f, 0.33f, 1.0f, 0.4f, 0.33f, 0.33f, 1.0f, 0.4f);
        this.colNightMoon = new ClimateColorInfo(0.33f, 0.33f, 1.0f, 0.4f, 0.33f, 0.33f, 1.0f, 0.4f);
        this.colFog = new ClimateColorInfo(0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, 0.4f, 0.8f);
        this.colFogLegacy = new ClimateColorInfo(0.3f, 0.3f, 0.3f, 0.8f, 0.3f, 0.3f, 0.3f, 0.8f);
        this.colFogNew = new ClimateColorInfo(0.5f, 0.5f, 0.55f, 0.4f, 0.5f, 0.5f, 0.55f, 0.8f);
        this.fogTintStorm = new ClimateColorInfo(0.5f, 0.45f, 0.4f, 1.0f, 0.5f, 0.45f, 0.4f, 1.0f);
        this.fogTintTropical = new ClimateColorInfo(0.8f, 0.75f, 0.55f, 1.0f, 0.8f, 0.75f, 0.55f, 1.0f);
        this.colTemp = new ClimateColorInfo();
        this.simplexOffsetA = Rand.Next(0, 8000);
        this.simplexOffsetB = Rand.Next(8000, 16000);
        this.simplexOffsetC = Rand.Next(0, -8000);
        this.simplexOffsetD = Rand.Next(-8000, -16000);
        this.initSeasonColors();
        this.setup();
        this.climateValues = new ClimateValues(this);
        this.thunderStorm = new ThunderStorm(this);
        this.weatherPeriod = new WeatherPeriod(this, this.thunderStorm);
        this.climateForecaster = new ClimateForecaster();
        this.climateHistory = new ClimateHistory();
        try {
            LuaEventManager.triggerEvent("OnClimateManagerInit", this);
        }
        catch (Exception exception) {
            System.out.print(exception.getMessage());
            System.out.print(exception.getStackTrace());
        }
    }

    public ClimateColorInfo getColNight() {
        return this.colNight;
    }

    public ClimateColorInfo getColNightNoMoon() {
        return this.colNightNoMoon;
    }

    public ClimateColorInfo getColNightMoon() {
        return this.colNightMoon;
    }

    public ClimateColorInfo getColFog() {
        return this.colFog;
    }

    public ClimateColorInfo getColFogLegacy() {
        return this.colFogLegacy;
    }

    public ClimateColorInfo getColFogNew() {
        return this.colFogNew;
    }

    public ClimateColorInfo getFogTintStorm() {
        return this.fogTintStorm;
    }

    public ClimateColorInfo getFogTintTropical() {
        return this.fogTintTropical;
    }

    private void setup() {
        int n;
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n] = new ClimateFloat();
        }
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n] = new ClimateColor();
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n] = new ClimateBool();
        }
        this.desaturation = this.initClimateFloat(0, "DESATURATION");
        this.globalLightIntensity = this.initClimateFloat(1, "GLOBAL_LIGHT_INTENSITY");
        this.nightStrength = this.initClimateFloat(2, "NIGHT_STRENGTH");
        this.precipitationIntensity = this.initClimateFloat(3, "PRECIPITATION_INTENSITY");
        this.temperature = this.initClimateFloat(4, "TEMPERATURE");
        this.temperature.min = -80.0f;
        this.temperature.max = 80.0f;
        this.fogIntensity = this.initClimateFloat(5, "FOG_INTENSITY");
        this.windIntensity = this.initClimateFloat(6, "WIND_INTENSITY");
        this.windAngleIntensity = this.initClimateFloat(7, "WIND_ANGLE_INTENSITY");
        this.windAngleIntensity.min = -1.0f;
        this.cloudIntensity = this.initClimateFloat(8, "CLOUD_INTENSITY");
        this.ambient = this.initClimateFloat(9, "AMBIENT");
        this.viewDistance = this.initClimateFloat(10, "VIEW_DISTANCE");
        this.viewDistance.min = 0.0f;
        this.viewDistance.max = 100.0f;
        this.dayLightStrength = this.initClimateFloat(11, "DAYLIGHT_STRENGTH");
        this.humidity = this.initClimateFloat(12, "HUMIDITY");
        this.globalLight = this.initClimateColor(0, "GLOBAL_LIGHT");
        this.colorNewFog = this.initClimateColor(1, "COLOR_NEW_FOG");
        this.colorNewFog.internalValue.setExterior(0.9f, 0.9f, 0.95f, 1.0f);
        this.colorNewFog.internalValue.setInterior(0.9f, 0.9f, 0.95f, 1.0f);
        this.precipitationIsSnow = this.initClimateBool(0, "IS_SNOW");
    }

    public int getFloatMax() {
        return 13;
    }

    private ClimateFloat initClimateFloat(int n, String string) {
        if (n >= 0 && n < 13) {
            return this.climateFloats[n].init(n, string);
        }
        DebugLog.log("Climate: cannot get float override id.");
        return null;
    }

    public ClimateFloat getClimateFloat(int n) {
        if (n >= 0 && n < 13) {
            return this.climateFloats[n];
        }
        DebugLog.log("Climate: cannot get float override id.");
        return null;
    }

    public int getColorMax() {
        return 2;
    }

    private ClimateColor initClimateColor(int n, String string) {
        if (n >= 0 && n < 2) {
            return this.climateColors[n].init(n, string);
        }
        DebugLog.log("Climate: cannot get float override id.");
        return null;
    }

    public ClimateColor getClimateColor(int n) {
        if (n >= 0 && n < 2) {
            return this.climateColors[n];
        }
        DebugLog.log("Climate: cannot get float override id.");
        return null;
    }

    public int getBoolMax() {
        return 1;
    }

    private ClimateBool initClimateBool(int n, String string) {
        if (n >= 0 && n < 1) {
            return this.climateBooleans[n].init(n, string);
        }
        DebugLog.log("Climate: cannot get boolean id.");
        return null;
    }

    public ClimateBool getClimateBool(int n) {
        if (n >= 0 && n < 1) {
            return this.climateBooleans[n];
        }
        DebugLog.log("Climate: cannot get boolean id.");
        return null;
    }

    public void setEnabledSimulation(boolean bl) {
        this.DISABLE_SIMULATION = !GameClient.bClient && !GameServer.bServer ? !bl : false;
    }

    public boolean getEnabledSimulation() {
        return !this.DISABLE_SIMULATION;
    }

    public boolean getEnabledFxUpdate() {
        return !this.DISABLE_FX_UPDATE;
    }

    public void setEnabledFxUpdate(boolean bl) {
        this.DISABLE_FX_UPDATE = !GameClient.bClient && !GameServer.bServer ? !bl : false;
    }

    public boolean getEnabledWeatherGeneration() {
        return this.DISABLE_WEATHER_GENERATION;
    }

    public void setEnabledWeatherGeneration(boolean bl) {
        this.DISABLE_WEATHER_GENERATION = !bl;
    }

    public Color getGlobalLightInternal() {
        return this.globalLight.internalValue.getExterior();
    }

    public ClimateColorInfo getGlobalLight() {
        return this.globalLight.finalValue;
    }

    public float getGlobalLightIntensity() {
        return this.globalLightIntensity.finalValue;
    }

    public ClimateColorInfo getColorNewFog() {
        return this.colorNewFog.finalValue;
    }

    public void setNightStrength(float f) {
        this.nightStrength.finalValue = ClimateManager.clamp(0.0f, 1.0f, f);
    }

    public float getDesaturation() {
        return this.desaturation.finalValue;
    }

    public void setDesaturation(float f) {
        this.desaturation.finalValue = f;
    }

    public float getAirMass() {
        return this.airMass;
    }

    public float getAirMassDaily() {
        return this.airMassDaily;
    }

    public float getAirMassTemperature() {
        return this.airMassTemperature;
    }

    public float getDayLightStrength() {
        return this.dayLightStrength.finalValue;
    }

    public float getNightStrength() {
        return this.nightStrength.finalValue;
    }

    public float getDayMeanTemperature() {
        return this.currentDay.season.getDayMeanTemperature();
    }

    public float getTemperature() {
        return this.temperature.finalValue;
    }

    public float getBaseTemperature() {
        return this.baseTemperature;
    }

    public float getSnowStrength() {
        return this.snowStrength;
    }

    public boolean getPrecipitationIsSnow() {
        return this.precipitationIsSnow.finalValue;
    }

    public float getPrecipitationIntensity() {
        return this.precipitationIntensity.finalValue;
    }

    public float getFogIntensity() {
        return this.fogIntensity.finalValue;
    }

    public float getWindIntensity() {
        return this.windIntensity.finalValue;
    }

    public float getWindAngleIntensity() {
        return this.windAngleIntensity.finalValue;
    }

    public float getCorrectedWindAngleIntensity() {
        return (this.windAngleIntensity.finalValue + 1.0f) * 0.5f;
    }

    public float getWindPower() {
        return this.windPower;
    }

    public float getWindspeedKph() {
        return this.windPower * 120.0f;
    }

    public float getCloudIntensity() {
        return this.cloudIntensity.finalValue;
    }

    public float getAmbient() {
        return this.ambient.finalValue;
    }

    public float getViewDistance() {
        return this.viewDistance.finalValue;
    }

    public float getHumidity() {
        return this.humidity.finalValue;
    }

    public float getWindAngleDegrees() {
        float f = this.windAngleIntensity.finalValue > 0.0f ? ClimateManager.lerp(this.windAngleIntensity.finalValue, 45.0f, 225.0f) : (this.windAngleIntensity.finalValue > -0.25f ? ClimateManager.lerp(Math.abs(this.windAngleIntensity.finalValue), 45.0f, 0.0f) : ClimateManager.lerp(Math.abs(this.windAngleIntensity.finalValue) - 0.25f, 360.0f, 180.0f));
        if (f > 360.0f) {
            f -= 360.0f;
        }
        if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public float getWindAngleRadians() {
        return (float)Math.toRadians(this.getWindAngleDegrees());
    }

    public float getWindSpeedMovement() {
        float f = this.getWindIntensity();
        f = f < 0.15f ? 0.0f : (f - 0.15f) / 0.85f;
        return f;
    }

    public float getWindForceMovement(IsoGameCharacter isoGameCharacter, float f) {
        if (isoGameCharacter.square != null && !isoGameCharacter.square.isInARoom()) {
            float f2 = f - this.getWindAngleRadians();
            if ((double)f2 > Math.PI * 2) {
                f2 = (float)((double)f2 - Math.PI * 2);
            }
            if (f2 < 0.0f) {
                f2 = (float)((double)f2 + Math.PI * 2);
            }
            if ((double)f2 > Math.PI) {
                f2 = (float)(Math.PI - ((double)f2 - Math.PI));
            }
            f2 = (float)((double)f2 / Math.PI);
            return f2;
        }
        return 0.0f;
    }

    public boolean isRaining() {
        return this.getPrecipitationIntensity() > 0.0f && !this.getPrecipitationIsSnow();
    }

    public float getRainIntensity() {
        return this.isRaining() ? this.getPrecipitationIntensity() : 0.0f;
    }

    public boolean isSnowing() {
        return this.getPrecipitationIntensity() > 0.0f && this.getPrecipitationIsSnow();
    }

    public float getSnowIntensity() {
        return this.isSnowing() ? this.getPrecipitationIntensity() : 0.0f;
    }

    public void setAmbient(float f) {
        this.ambient.finalValue = f;
    }

    public void setViewDistance(float f) {
        this.viewDistance.finalValue = f;
    }

    public void setDayLightStrength(float f) {
        this.dayLightStrength.finalValue = f;
    }

    public void setPrecipitationIsSnow(boolean bl) {
        this.precipitationIsSnow.finalValue = bl;
    }

    public DayInfo getCurrentDay() {
        return this.currentDay;
    }

    public DayInfo getPreviousDay() {
        return this.previousDay;
    }

    public DayInfo getNextDay() {
        return this.nextDay;
    }

    public ErosionSeason getSeason() {
        return this.currentDay != null && this.currentDay.getSeason() != null ? this.currentDay.getSeason() : this.season;
    }

    public float getFrontStrength() {
        if (this.currentFront == null) {
            return 0.0f;
        }
        if (Core.bDebug) {
            this.CalculateWeatherFrontStrength(this.gt.getYear(), this.gt.getMonth(), this.gt.getDayPlusOne(), this.currentFront);
        }
        return this.currentFront.strength;
    }

    public void stopWeatherAndThunder() {
        if (GameClient.bClient) {
            return;
        }
        this.weatherPeriod.stopWeatherPeriod();
        this.thunderStorm.stopAllClouds();
        if (GameServer.bServer) {
            this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)1, null);
        }
    }

    public ThunderStorm getThunderStorm() {
        return this.thunderStorm;
    }

    public WeatherPeriod getWeatherPeriod() {
        return this.weatherPeriod;
    }

    public boolean getIsThunderStorming() {
        return this.weatherPeriod.isRunning() && (this.weatherPeriod.isThunderStorm() || this.weatherPeriod.isTropicalStorm());
    }

    public float getWeatherInterference() {
        if (this.weatherPeriod.isRunning()) {
            if (this.weatherPeriod.isThunderStorm() || this.weatherPeriod.isTropicalStorm() || this.weatherPeriod.isBlizzard()) {
                return 0.7f * this.weatherPeriod.getCurrentStrength();
            }
            return 0.35f * this.weatherPeriod.getCurrentStrength();
        }
        return 0.0f;
    }

    public KahluaTable getModData() {
        if (this.modDataTable == null) {
            this.modDataTable = LuaManager.platform.newTable();
        }
        return this.modDataTable;
    }

    public float getAirTemperatureForCharacter(IsoGameCharacter isoGameCharacter) {
        return this.getAirTemperatureForCharacter(isoGameCharacter, false);
    }

    public float getAirTemperatureForCharacter(IsoGameCharacter isoGameCharacter, boolean bl) {
        if (isoGameCharacter.square != null) {
            if (isoGameCharacter.getVehicle() != null) {
                return this.getAirTemperatureForSquare(isoGameCharacter.square, isoGameCharacter.getVehicle(), bl);
            }
            return this.getAirTemperatureForSquare(isoGameCharacter.square, null, bl);
        }
        return this.getTemperature();
    }

    public float getAirTemperatureForSquare(IsoGridSquare isoGridSquare) {
        return this.getAirTemperatureForSquare(isoGridSquare, null);
    }

    public float getAirTemperatureForSquare(IsoGridSquare isoGridSquare, BaseVehicle baseVehicle) {
        return this.getAirTemperatureForSquare(isoGridSquare, baseVehicle, false);
    }

    public float getAirTemperatureForSquare(IsoGridSquare isoGridSquare, BaseVehicle baseVehicle, boolean bl) {
        float f = this.getTemperature();
        if (isoGridSquare != null) {
            boolean bl2 = isoGridSquare.isInARoom();
            if (bl2 || baseVehicle != null) {
                boolean bl3 = IsoWorld.instance.isHydroPowerOn();
                if (f <= 22.0f) {
                    float f2 = (22.0f - f) / 8.0f;
                    if (baseVehicle == null) {
                        if (bl2 && bl3) {
                            f = 22.0f;
                        }
                        f2 = 22.0f - f;
                        if (isoGridSquare.getZ() < 1) {
                            f += f2 * (0.4f + 0.2f * this.dayLightLagged);
                        } else {
                            f2 = (float)((double)f2 * 0.85);
                            f += f2 * (0.4f + 0.2f * this.dayLightLagged);
                        }
                    }
                } else {
                    float f3 = (f - 22.0f) / 3.5f;
                    if (baseVehicle == null) {
                        if (bl2 && bl3) {
                            f = 22.0f;
                        }
                        f3 = f - 22.0f;
                        if (isoGridSquare.getZ() < 1) {
                            f3 = (float)((double)f3 * 0.85);
                            f -= f3 * (0.4f + 0.2f * this.dayLightLagged);
                        } else {
                            f -= f3 * (0.4f + 0.2f * this.dayLightLagged + 0.2f * this.nightLagged);
                        }
                    } else {
                        f = f + f3 + f3 * this.dayLightLagged;
                    }
                }
            } else if (bl) {
                f = Temperature.WindchillCelsiusKph(f, this.getWindspeedKph());
            }
            float f4 = IsoWorld.instance.getCell().getHeatSourceHighestTemperature(f, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
            if (f4 > f) {
                f = f4;
            }
            if (baseVehicle != null) {
                f += baseVehicle.getInsideTemperature();
            }
        }
        return f;
    }

    public String getSeasonName() {
        return this.season.getSeasonName();
    }

    public float getSeasonProgression() {
        return this.season.getSeasonProgression();
    }

    public float getSeasonStrength() {
        return this.season.getSeasonStrength();
    }

    public void init(IsoMetaGrid isoMetaGrid) {
        WorldFlares.Clear();
        this.season = ErosionMain.getInstance().getSeasons();
        ThunderStorm.MAP_MIN_X = isoMetaGrid.minX * 300 - 4000;
        ThunderStorm.MAP_MAX_X = isoMetaGrid.maxX * 300 + 4000;
        ThunderStorm.MAP_MIN_Y = isoMetaGrid.minY * 300 - 4000;
        ThunderStorm.MAP_MAX_Y = isoMetaGrid.maxY * 300 + 4000;
        windNoiseOffset = 0.0;
        WINTER_IS_COMING = IsoWorld.instance.getGameMode().equals("Winter is Coming");
        THE_DESCENDING_FOG = IsoWorld.instance.getGameMode().equals("The Descending Fog");
        A_STORM_IS_COMING = IsoWorld.instance.getGameMode().equals("A Storm is Coming");
        this.climateForecaster.init(this);
        this.climateHistory.init(this);
    }

    public void updateEveryTenMins() {
        this.tickIsTenMins = true;
    }

    public void update() {
        int n;
        this.tickIsClimateTick = false;
        this.tickIsHourChange = false;
        this.tickIsDayChange = false;
        this.gt = GameTime.getInstance();
        this.worldAgeHours = this.gt.getWorldAgeHours();
        if (this.lastMinuteStamp != this.gt.getMinutesStamp()) {
            this.lastMinuteStamp = this.gt.getMinutesStamp();
            this.tickIsClimateTick = true;
            this.updateDayInfo(this.gt.getDayPlusOne(), this.gt.getMonth(), this.gt.getYear());
            this.currentDay.hour = this.gt.getHour();
            this.currentDay.minutes = this.gt.getMinutes();
            if (this.gt.getHour() != this.lastHourStamp) {
                this.tickIsHourChange = true;
                this.lastHourStamp = this.gt.getHour();
            }
            if (this.gt.getTimeOfDay() > 12.0f) {
                ClimateMoon.updatePhase(this.currentDay.getYear(), this.currentDay.getMonth(), this.currentDay.getDay());
            }
        }
        if (this.DISABLE_SIMULATION) {
            IsoPlayer[] isoPlayerArray = IsoPlayer.players;
            for (int i = 0; i < isoPlayerArray.length; ++i) {
                IsoPlayer isoPlayer = isoPlayerArray[i];
                if (isoPlayer == null) continue;
                isoPlayer.dirtyRecalcGridStackTime = 1.0f;
            }
            return;
        }
        if (this.tickIsDayChange && !GameClient.bClient) {
            this.climateForecaster.updateDayChange(this);
            this.climateHistory.updateDayChange(this);
        }
        if (GameClient.bClient) {
            int n2;
            this.networkLerp = 1.0f;
            long l = System.currentTimeMillis();
            if ((float)l < (float)this.networkUpdateStamp + this.networkLerpTime) {
                this.networkLerp = (float)(l - this.networkUpdateStamp) / this.networkLerpTime;
                if (this.networkLerp < 0.0f) {
                    this.networkLerp = 0.0f;
                }
            }
            for (n2 = 0; n2 < this.climateFloats.length; ++n2) {
                this.climateFloats[n2].interpolate = this.networkLerp;
            }
            for (n2 = 0; n2 < this.climateColors.length; ++n2) {
                this.climateColors[n2].interpolate = this.networkLerp;
            }
        }
        if (this.tickIsClimateTick && !GameClient.bClient) {
            this.updateValues();
            this.weatherPeriod.update(this.worldAgeHours);
        }
        if (this.tickIsClimateTick) {
            LuaEventManager.triggerEvent("OnClimateTick", this);
        }
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n].calculate();
        }
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n].calculate();
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n].calculate();
        }
        this.windPower = this.windIntensity.finalValue;
        this.updateWindTick();
        if (this.tickIsClimateTick) {
            // empty if block
        }
        this.updateTestFlare();
        this.thunderStorm.update(this.worldAgeHours);
        if (GameClient.bClient) {
            this.updateSnow();
        } else if (this.tickIsClimateTick && !GameClient.bClient) {
            this.updateSnow();
        }
        if (!GameClient.bClient) {
            this.updateViewDistance();
        }
        if (this.tickIsClimateTick && Core.bDebug && !GameServer.bServer) {
            LuaEventManager.triggerEvent("OnClimateTickDebug", this);
        }
        if (this.tickIsClimateTick && GameServer.bServer && this.tickIsTenMins) {
            this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
            this.tickIsTenMins = false;
        }
        if (!this.DISABLE_FX_UPDATE) {
            this.updateFx();
        }
    }

    public static double getWindNoiseBase() {
        return windNoiseBase;
    }

    public static double getWindNoiseFinal() {
        return windNoiseFinal;
    }

    public static double getWindTickFinal() {
        return windTickFinal;
    }

    private void updateWindTick() {
        if (GameServer.bServer) {
            return;
        }
        float f = this.windIntensity.finalValue;
        windNoiseBase = SimplexNoise.noise(0.0, windNoiseOffset += (4.0E-4 + 6.0E-4 * (double)f) * (double)GameTime.getInstance().getMultiplier());
        windNoiseFinal = windNoiseBase;
        windNoiseFinal = windNoiseFinal > 0.0 ? (windNoiseFinal *= 0.04 + 0.1 * (double)f) : (windNoiseFinal *= 0.04 + 0.1 * (double)f + (double)(0.05f * (f * f)));
        f = ClimateManager.clamp01(f + (float)windNoiseFinal);
        windTickFinal = f;
    }

    public void updateOLD() {
        this.tickIsClimateTick = false;
        this.tickIsHourChange = false;
        this.tickIsDayChange = false;
        this.gt = GameTime.getInstance();
        this.worldAgeHours = this.gt.getWorldAgeHours();
        if (this.lastMinuteStamp != this.gt.getMinutesStamp()) {
            this.lastMinuteStamp = this.gt.getMinutesStamp();
            this.tickIsClimateTick = true;
            this.updateDayInfo(this.gt.getDay(), this.gt.getMonth(), this.gt.getYear());
            this.currentDay.hour = this.gt.getHour();
            this.currentDay.minutes = this.gt.getMinutes();
            if (this.gt.getHour() != this.lastHourStamp) {
                this.tickIsHourChange = true;
                this.lastHourStamp = this.gt.getHour();
            }
        }
        if (GameClient.bClient) {
            if (!this.DISABLE_SIMULATION) {
                int n;
                this.networkLerp = 1.0f;
                long l = System.currentTimeMillis();
                if ((float)l < (float)this.networkUpdateStamp + this.networkLerpTime) {
                    this.networkLerp = (float)(l - this.networkUpdateStamp) / this.networkLerpTime;
                    if (this.networkLerp < 0.0f) {
                        this.networkLerp = 0.0f;
                    }
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    this.climateFloats[n].interpolate = this.networkLerp;
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].interpolate = this.networkLerp;
                }
                if (this.tickIsClimateTick) {
                    LuaEventManager.triggerEvent("OnClimateTick", this);
                }
                this.updateOnTick();
                this.updateTestFlare();
                this.thunderStorm.update(this.worldAgeHours);
                this.updateSnow();
                if (this.tickIsTenMins) {
                    this.tickIsTenMins = false;
                }
            }
            this.updateFx();
        } else {
            if (!this.DISABLE_SIMULATION) {
                if (this.tickIsClimateTick) {
                    this.updateValues();
                    this.weatherPeriod.update(this.gt.getWorldAgeHours());
                }
                this.updateOnTick();
                this.updateTestFlare();
                this.thunderStorm.update(this.worldAgeHours);
                if (this.tickIsClimateTick) {
                    this.updateSnow();
                    LuaEventManager.triggerEvent("OnClimateTick", this);
                }
                this.updateViewDistance();
                if (this.tickIsClimateTick && this.tickIsTenMins) {
                    if (GameServer.bServer) {
                        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
                    }
                    this.tickIsTenMins = false;
                }
            }
            if (!this.DISABLE_FX_UPDATE && this.tickIsClimateTick) {
                this.updateFx();
            }
            if (this.DISABLE_SIMULATION) {
                IsoPlayer[] isoPlayerArray = IsoPlayer.players;
                for (int i = 0; i < isoPlayerArray.length; ++i) {
                    IsoPlayer isoPlayer = isoPlayerArray[i];
                    if (isoPlayer == null) continue;
                    isoPlayer.dirtyRecalcGridStackTime = 1.0f;
                }
            }
        }
    }

    private void updateFx() {
        IsoWeatherFX isoWeatherFX = IsoWorld.instance.getCell().getWeatherFX();
        if (isoWeatherFX == null) {
            return;
        }
        isoWeatherFX.setPrecipitationIntensity(this.precipitationIntensity.finalValue);
        isoWeatherFX.setWindIntensity(this.windIntensity.finalValue);
        isoWeatherFX.setWindPrecipIntensity((float)windTickFinal * (float)windTickFinal);
        isoWeatherFX.setWindAngleIntensity(this.windAngleIntensity.finalValue);
        isoWeatherFX.setFogIntensity(this.fogIntensity.finalValue);
        isoWeatherFX.setCloudIntensity(this.cloudIntensity.finalValue);
        isoWeatherFX.setPrecipitationIsSnow(this.precipitationIsSnow.finalValue);
        SkyBox.getInstance().update(this);
        IsoWater.getInstance().update(this);
        IsoPuddles.getInstance().update(this);
    }

    private void updateSnow() {
        if (GameClient.bClient) {
            IsoWorld.instance.CurrentCell.setSnowTarget((int)(this.snowFracNow * 100.0f));
            ErosionIceQueen.instance.setSnow(this.canDoWinterSprites && this.snowFracNow > 0.2f);
            return;
        }
        if (!this.tickIsHourChange) {
            boolean bl = this.canDoWinterSprites = this.season.isSeason(5) || WINTER_IS_COMING;
            if (this.precipitationIsSnow.finalValue && this.precipitationIntensity.finalValue > this.snowFall) {
                this.snowFall = this.precipitationIntensity.finalValue;
            }
            if (this.temperature.finalValue > 0.0f) {
                float f = this.temperature.finalValue / 10.0f;
                if ((f = f * 0.2f + f * 0.8f * this.dayLightStrength.finalValue) > this.snowMeltStrength) {
                    this.snowMeltStrength = f;
                }
            }
            if (!this.precipitationIsSnow.finalValue && this.precipitationIntensity.finalValue > 0.0f) {
                this.snowMeltStrength += this.precipitationIntensity.finalValue;
            }
        } else {
            this.snowStrength += this.snowFall;
            this.snowStrength -= this.snowMeltStrength;
            this.snowStrength = ClimateManager.clamp(0.0f, 10.0f, this.snowStrength);
            this.snowFracNow = this.snowStrength > 7.5f ? 1.0f : this.snowStrength / 7.5f;
            IsoWorld.instance.CurrentCell.setSnowTarget((int)(this.snowFracNow * 100.0f));
            ErosionIceQueen.instance.setSnow(this.canDoWinterSprites && this.snowFracNow > 0.2f);
            this.snowFall = 0.0f;
            this.snowMeltStrength = 0.0f;
        }
    }

    private void updateSnowOLD() {
    }

    public float getSnowFracNow() {
        return this.snowFracNow;
    }

    public void resetOverrides() {
        int n;
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n].setEnableOverride(false);
        }
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n].setEnableOverride(false);
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n].setEnableOverride(false);
        }
    }

    public void resetModded() {
        int n;
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n].setEnableModded(false);
        }
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n].setEnableModded(false);
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n].setEnableModded(false);
        }
    }

    public void resetAdmin() {
        int n;
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n].setEnableAdmin(false);
        }
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n].setEnableAdmin(false);
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n].setEnableAdmin(false);
        }
    }

    public void triggerWinterIsComingStorm() {
        if (!GameClient.bClient && !this.weatherPeriod.isRunning()) {
            AirFront airFront = new AirFront();
            airFront.copyFrom(this.currentFront);
            airFront.strength = 0.95f;
            airFront.type = 1;
            GameTime gameTime = GameTime.getInstance();
            this.weatherPeriod.init(airFront, this.worldAgeHours, gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne());
        }
    }

    public boolean triggerCustomWeather(float f, boolean bl) {
        if (!GameClient.bClient && !this.weatherPeriod.isRunning()) {
            AirFront airFront = new AirFront();
            airFront.strength = f;
            airFront.type = bl ? 1 : -1;
            GameTime gameTime = GameTime.getInstance();
            this.weatherPeriod.init(airFront, this.worldAgeHours, gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne());
            return true;
        }
        return false;
    }

    public boolean triggerCustomWeatherStage(int n, float f) {
        if (!GameClient.bClient && !this.weatherPeriod.isRunning()) {
            AirFront airFront = new AirFront();
            airFront.strength = 0.95f;
            airFront.type = 1;
            GameTime gameTime = GameTime.getInstance();
            this.weatherPeriod.init(airFront, this.worldAgeHours, gameTime.getYear(), gameTime.getMonth(), gameTime.getDayPlusOne(), n, f);
            return true;
        }
        return false;
    }

    private void updateOnTick() {
        int n;
        for (n = 0; n < this.climateColors.length; ++n) {
            this.climateColors[n].calculate();
        }
        for (n = 0; n < this.climateFloats.length; ++n) {
            this.climateFloats[n].calculate();
        }
        for (n = 0; n < this.climateBooleans.length; ++n) {
            this.climateBooleans[n].calculate();
        }
    }

    private void updateTestFlare() {
        WorldFlares.update();
    }

    public void launchFlare() {
        DebugLog.log("Launching improved flare.");
        IsoPlayer isoPlayer = IsoPlayer.getInstance();
        float f = 0.0f;
        WorldFlares.launchFlare(7200.0f, (int)isoPlayer.getX(), (int)isoPlayer.getY(), 50, f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (IsoPlayer.getInstance() != null && !this.flareLaunched) {
            this.flareLaunched = true;
            this.flareLifeTime = 0.0f;
            this.flareMaxLifeTime = 7200.0f;
            this.flareIntensity.overrideCurrentValue(1.0f);
            this.flareIntens = 1.0f;
            this.nextRandomTargetIntens = 10;
        }
    }

    protected double getAirMassNoiseFrequencyMod(int n) {
        if (n == 1) {
            return 300.0;
        }
        if (n == 2) {
            return 240.0;
        }
        if (n != 3) {
            if (n == 4) {
                return 145.0;
            }
            if (n == 5) {
                return 120.0;
            }
        }
        return 166.0;
    }

    protected float getRainTimeMultiplierMod(int n) {
        if (n == 1) {
            return 0.5f;
        }
        if (n == 2) {
            return 0.75f;
        }
        if (n == 4) {
            return 1.25f;
        }
        if (n == 5) {
            return 1.5f;
        }
        return 1.0f;
    }

    private void updateValues() {
        float f;
        float f2;
        int n;
        if (this.tickIsDayChange && Core.bDebug && !GameClient.bClient && !GameServer.bServer) {
            ErosionMain.getInstance().DebugUpdateMapNow();
        }
        this.climateValues.updateValues(this.worldAgeHours, this.gt.getTimeOfDay(), this.currentDay, this.nextDay);
        this.airMass = this.climateValues.getNoiseAirmass();
        this.airMassTemperature = this.climateValues.getAirMassTemperature();
        if (this.tickIsHourChange) {
            int n2 = n = this.airMass < 0.0f ? -1 : 1;
            if (this.currentFront.type != n) {
                if (!this.DISABLE_WEATHER_GENERATION && (!WINTER_IS_COMING || WINTER_IS_COMING && GameTime.instance.getWorldAgeHours() > 96.0)) {
                    if (THE_DESCENDING_FOG) {
                        this.currentFront.type = -1;
                        this.currentFront.strength = Rand.Next(0.2f, 0.45f);
                        this.weatherPeriod.init(this.currentFront, this.worldAgeHours, this.gt.getYear(), this.gt.getMonth(), this.gt.getDayPlusOne());
                    } else {
                        this.CalculateWeatherFrontStrength(this.gt.getYear(), this.gt.getMonth(), this.gt.getDayPlusOne(), this.currentFront);
                        this.weatherPeriod.init(this.currentFront, this.worldAgeHours, this.gt.getYear(), this.gt.getMonth(), this.gt.getDayPlusOne());
                    }
                }
                this.currentFront.setFrontType(n);
            }
            if (WINTER_IS_COMING || THE_DESCENDING_FOG || !(GameTime.instance.getWorldAgeHours() >= 72.0) || !(GameTime.instance.getWorldAgeHours() <= 96.0) || this.DISABLE_WEATHER_GENERATION || this.weatherPeriod.isRunning() || Rand.Next(0, 1000) < 50) {
                // empty if block
            }
            if (this.tickIsDayChange) {
                // empty if block
            }
        }
        this.dayDoFog = this.climateValues.isDayDoFog();
        this.dayFogStrength = this.climateValues.getDayFogStrength();
        this.dayFogStrength = PerformanceSettings.FogQuality == 2 ? 0.5f + 0.5f * this.dayFogStrength : 0.2f + 0.8f * this.dayFogStrength;
        this.baseTemperature = this.climateValues.getBaseTemperature();
        this.dayLightLagged = this.climateValues.getDayLightLagged();
        this.nightLagged = this.climateValues.getDayLightLagged();
        this.temperature.internalValue = this.climateValues.getTemperature();
        this.precipitationIsSnow.internalValue = this.climateValues.isTemperatureIsSnow();
        this.humidity.internalValue = this.climateValues.getHumidity();
        this.windIntensity.internalValue = this.climateValues.getWindIntensity();
        this.windAngleIntensity.internalValue = this.climateValues.getWindAngleIntensity();
        this.windPower = this.windIntensity.internalValue;
        this.currentFront.setFrontWind(this.climateValues.getWindAngleDegrees());
        this.cloudIntensity.internalValue = this.climateValues.getCloudIntensity();
        this.precipitationIntensity.internalValue = 0.0f;
        this.nightStrength.internalValue = this.climateValues.getNightStrength();
        this.dayLightStrength.internalValue = this.climateValues.getDayLightStrength();
        this.ambient.internalValue = this.climateValues.getAmbient();
        this.desaturation.internalValue = this.climateValues.getDesaturation();
        n = this.season.getSeason();
        float f3 = this.season.getSeasonProgression();
        float f4 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        if (n == 2) {
            n3 = SeasonColor.SPRING;
            n4 = SeasonColor.SUMMER;
            f4 = 0.5f + f3 * 0.5f;
        } else if (n == 3) {
            n3 = SeasonColor.SUMMER;
            n4 = SeasonColor.FALL;
            f4 = f3 * 0.5f;
        } else if (n == 4) {
            if (f3 < 0.5f) {
                n3 = SeasonColor.SUMMER;
                n4 = SeasonColor.FALL;
                f4 = 0.5f + f3;
            } else {
                n3 = SeasonColor.FALL;
                n4 = SeasonColor.WINTER;
                f4 = f3 - 0.5f;
            }
        } else if (n == 5) {
            if (f3 < 0.5f) {
                n3 = SeasonColor.FALL;
                n4 = SeasonColor.WINTER;
                f4 = 0.5f + f3;
            } else {
                n3 = SeasonColor.WINTER;
                n4 = SeasonColor.SPRING;
                f4 = f3 - 0.5f;
            }
        } else if (n == 1) {
            if (f3 < 0.5f) {
                n3 = SeasonColor.WINTER;
                n4 = SeasonColor.SPRING;
                f4 = 0.5f + f3;
            } else {
                n3 = SeasonColor.SPRING;
                n4 = SeasonColor.SUMMER;
                f4 = f3 - 0.5f;
            }
        }
        float f5 = this.climateValues.getCloudyT();
        this.colDawn = this.seasonColorDawn.update(f5, f4, n3, n4);
        this.colDay = this.seasonColorDay.update(f5, f4, n3, n4);
        this.colDusk = this.seasonColorDusk.update(f5, f4, n3, n4);
        float f6 = this.climateValues.getTime();
        float f7 = this.climateValues.getDawn();
        float f8 = this.climateValues.getDusk();
        float f9 = this.climateValues.getNoon();
        float f10 = this.climateValues.getDayFogDuration();
        if (!THE_DESCENDING_FOG) {
            if (this.dayDoFog && this.dayFogStrength > 0.0f && f6 > f7 - 2.0f && f6 < f7 + f10) {
                f2 = this.getTimeLerpHours(f6, f7 - 2.0f, f7 + f10, true);
                this.fogLerpValue = f2 = ClimateManager.clamp(0.0f, 1.0f, f2 * (f10 / 3.0f));
                this.cloudIntensity.internalValue = ClimateManager.lerp(f2, this.cloudIntensity.internalValue, 0.0f);
                f = this.dayFogStrength;
                this.fogIntensity.internalValue = ClimateManager.clerp(f2, 0.0f, f);
                this.desaturation.internalValue = Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null ? (PerformanceSettings.FogQuality == 2 ? ClimateManager.clerp(f2, this.desaturation.internalValue, 0.8f * f) : ClimateManager.clerp(f2, this.desaturation.internalValue, 0.65f * f)) : ClimateManager.clerp(f2, this.desaturation.internalValue, 0.8f * f);
            } else {
                this.fogIntensity.internalValue = 0.0f;
            }
        } else {
            this.fogIntensity.internalValue = this.gt.getWorldAgeHours() < 72.0 ? (float)this.gt.getWorldAgeHours() / 72.0f : 1.0f;
            this.cloudIntensity.internalValue = Math.min(this.cloudIntensity.internalValue, 1.0f - this.fogIntensity.internalValue);
            if (this.weatherPeriod.isRunning()) {
                this.fogIntensity.internalValue = Math.min(this.fogIntensity.internalValue, 0.6f);
            }
            if (PerformanceSettings.FogQuality == 2) {
                this.fogIntensity.internalValue *= 0.93f;
                this.desaturation.internalValue = 0.8f * this.fogIntensity.internalValue;
            } else {
                this.desaturation.internalValue = 0.65f * this.fogIntensity.internalValue;
            }
        }
        this.humidity.internalValue = ClimateManager.clamp01(this.humidity.internalValue + this.fogIntensity.internalValue * 0.6f);
        f2 = 0.6f * this.climateValues.getDayLightStrengthBase();
        f = 0.4f;
        float f11 = 0.25f * this.climateValues.getDayLightStrengthBase();
        if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
            f11 = 0.8f * this.climateValues.getDayLightStrengthBase();
        }
        if (f6 < f7 || f6 > f8) {
            float f12 = 24.0f - f8 + f7;
            if (f6 > f8) {
                var15_17 = (f6 - f8) / f12;
                this.colDusk.interp(this.colDawn, var15_17, this.globalLight.internalValue);
            } else {
                var15_17 = (24.0f - f8 + f6) / f12;
                this.colDusk.interp(this.colDawn, var15_17, this.globalLight.internalValue);
            }
            this.globalLightIntensity.internalValue = ClimateManager.lerp(this.climateValues.getLerpNight(), f11, f);
        } else if (f6 < f9 + 2.0f) {
            var15_17 = (f6 - f7) / (f9 + 2.0f - f7);
            this.colDawn.interp(this.colDay, var15_17, this.globalLight.internalValue);
            this.globalLightIntensity.internalValue = ClimateManager.lerp(var15_17, f11, f2);
        } else {
            var15_17 = (f6 - (f9 + 2.0f)) / (f8 - (f9 + 2.0f));
            this.colDay.interp(this.colDusk, var15_17, this.globalLight.internalValue);
            this.globalLightIntensity.internalValue = ClimateManager.lerp(var15_17, f2, f11);
        }
        if (this.fogIntensity.internalValue > 0.0f) {
            if (Core.getInstance().RenderShader != null && Core.getInstance().getOffscreenBuffer() != null) {
                if (PerformanceSettings.FogQuality == 2) {
                    this.globalLight.internalValue.interp(this.colFog, this.fogIntensity.internalValue, this.globalLight.internalValue);
                } else {
                    this.globalLight.internalValue.interp(this.colFogNew, this.fogIntensity.internalValue, this.globalLight.internalValue);
                }
            } else {
                this.globalLight.internalValue.interp(this.colFogLegacy, this.fogIntensity.internalValue, this.globalLight.internalValue);
            }
            this.globalLightIntensity.internalValue = ClimateManager.clerp(this.fogLerpValue, this.globalLightIntensity.internalValue, 0.8f);
        }
        this.colNightNoMoon.interp(this.colNightMoon, ClimateMoon.getMoonFloat(), this.colNight);
        this.globalLight.internalValue.interp(this.colNight, this.nightStrength.internalValue, this.globalLight.internalValue);
        IsoPlayer[] isoPlayerArray = IsoPlayer.players;
        for (int i = 0; i < isoPlayerArray.length; ++i) {
            IsoPlayer isoPlayer = isoPlayerArray[i];
            if (isoPlayer == null) continue;
            isoPlayer.dirtyRecalcGridStackTime = 1.0f;
        }
    }

    private void updateViewDistance() {
        float f = this.dayLightStrength.finalValue;
        float f2 = this.fogIntensity.finalValue;
        float f3 = 19.0f - f2 * 8.0f;
        float f4 = f3 + 4.0f + 7.0f * f * (1.0f - f2);
        this.gt.setViewDistMin(f3 *= 3.0f);
        this.gt.setViewDistMax(f4 *= 3.0f);
        this.viewDistance.finalValue = this.viewDistance.internalValue = f3 + (f4 - f3) * f;
    }

    public void setSeasonColorDawn(int n, int n2, float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            this.seasonColorDawn.setColorExterior(n, n2, f, f2, f3, f4);
        } else {
            this.seasonColorDawn.setColorInterior(n, n2, f, f2, f3, f4);
        }
    }

    public void setSeasonColorDay(int n, int n2, float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            this.seasonColorDay.setColorExterior(n, n2, f, f2, f3, f4);
        } else {
            this.seasonColorDay.setColorInterior(n, n2, f, f2, f3, f4);
        }
    }

    public void setSeasonColorDusk(int n, int n2, float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            this.seasonColorDusk.setColorExterior(n, n2, f, f2, f3, f4);
        } else {
            this.seasonColorDusk.setColorInterior(n, n2, f, f2, f3, f4);
        }
    }

    public ClimateColorInfo getSeasonColor(int n, int n2, int n3) {
        SeasonColor seasonColor = null;
        if (n == 0) {
            seasonColor = this.seasonColorDawn;
        } else if (n == 1) {
            seasonColor = this.seasonColorDay;
        } else if (n == 2) {
            seasonColor = this.seasonColorDusk;
        }
        if (seasonColor != null) {
            return seasonColor.getColor(n2, n3);
        }
        return null;
    }

    private void initSeasonColors() {
        SeasonColor seasonColor = new SeasonColor();
        seasonColor.setIgnoreNormal(true);
        this.seasonColorDawn = seasonColor;
        seasonColor = new SeasonColor();
        seasonColor.setIgnoreNormal(true);
        this.seasonColorDay = seasonColor;
        seasonColor = new SeasonColor();
        seasonColor.setIgnoreNormal(false);
        this.seasonColorDusk = seasonColor;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (!GameClient.bClient || GameServer.bServer) {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeDouble(this.simplexOffsetA);
            dataOutputStream.writeDouble(this.simplexOffsetB);
            dataOutputStream.writeDouble(this.simplexOffsetC);
            dataOutputStream.writeDouble(this.simplexOffsetD);
            this.currentFront.save(dataOutputStream);
            dataOutputStream.writeFloat(this.snowFracNow);
            dataOutputStream.writeFloat(this.snowStrength);
            dataOutputStream.writeBoolean(this.canDoWinterSprites);
            dataOutputStream.writeBoolean(this.dayDoFog);
            dataOutputStream.writeFloat(this.dayFogStrength);
        } else {
            dataOutputStream.writeByte(0);
        }
        this.weatherPeriod.save(dataOutputStream);
        this.thunderStorm.save(dataOutputStream);
        if (GameServer.bServer) {
            this.desaturation.saveAdmin(dataOutputStream);
            this.globalLightIntensity.saveAdmin(dataOutputStream);
            this.nightStrength.saveAdmin(dataOutputStream);
            this.precipitationIntensity.saveAdmin(dataOutputStream);
            this.temperature.saveAdmin(dataOutputStream);
            this.fogIntensity.saveAdmin(dataOutputStream);
            this.windIntensity.saveAdmin(dataOutputStream);
            this.windAngleIntensity.saveAdmin(dataOutputStream);
            this.cloudIntensity.saveAdmin(dataOutputStream);
            this.ambient.saveAdmin(dataOutputStream);
            this.viewDistance.saveAdmin(dataOutputStream);
            this.dayLightStrength.saveAdmin(dataOutputStream);
            this.globalLight.saveAdmin(dataOutputStream);
            this.precipitationIsSnow.saveAdmin(dataOutputStream);
        }
        if (this.modDataTable != null) {
            dataOutputStream.writeByte(1);
            this.modDataTable.save(dataOutputStream);
        } else {
            dataOutputStream.writeByte(0);
        }
        if (GameServer.bServer) {
            this.humidity.saveAdmin(dataOutputStream);
        }
    }

    public void load(DataInputStream dataInputStream, int n) throws IOException {
        boolean bl;
        boolean bl2 = bl = dataInputStream.readByte() == 1;
        if (bl) {
            this.simplexOffsetA = dataInputStream.readDouble();
            this.simplexOffsetB = dataInputStream.readDouble();
            this.simplexOffsetC = dataInputStream.readDouble();
            this.simplexOffsetD = dataInputStream.readDouble();
            this.currentFront.load(dataInputStream);
            this.snowFracNow = dataInputStream.readFloat();
            this.snowStrength = dataInputStream.readFloat();
            this.canDoWinterSprites = dataInputStream.readBoolean();
            this.dayDoFog = dataInputStream.readBoolean();
            this.dayFogStrength = dataInputStream.readFloat();
        }
        this.weatherPeriod.load(dataInputStream, n);
        this.thunderStorm.load(dataInputStream);
        if (n >= 140 && GameServer.bServer) {
            this.desaturation.loadAdmin(dataInputStream, n);
            this.globalLightIntensity.loadAdmin(dataInputStream, n);
            this.nightStrength.loadAdmin(dataInputStream, n);
            this.precipitationIntensity.loadAdmin(dataInputStream, n);
            this.temperature.loadAdmin(dataInputStream, n);
            this.fogIntensity.loadAdmin(dataInputStream, n);
            this.windIntensity.loadAdmin(dataInputStream, n);
            this.windAngleIntensity.loadAdmin(dataInputStream, n);
            this.cloudIntensity.loadAdmin(dataInputStream, n);
            this.ambient.loadAdmin(dataInputStream, n);
            this.viewDistance.loadAdmin(dataInputStream, n);
            this.dayLightStrength.loadAdmin(dataInputStream, n);
            this.globalLight.loadAdmin(dataInputStream, n);
            this.precipitationIsSnow.loadAdmin(dataInputStream, n);
        }
        if (n >= 141 && dataInputStream.readByte() == 1) {
            if (this.modDataTable == null) {
                this.modDataTable = LuaManager.platform.newTable();
            }
            this.modDataTable.load(dataInputStream, n);
        }
        if (n >= 150 && GameServer.bServer) {
            this.humidity.loadAdmin(dataInputStream, n);
        }
        this.climateValues = new ClimateValues(this);
    }

    public void postCellLoadSetSnow() {
        IsoWorld.instance.CurrentCell.setSnowTarget((int)(this.snowFracNow * 100.0f));
        ErosionIceQueen.instance.setSnow(this.canDoWinterSprites && this.snowFracNow > 0.2f);
    }

    public void forceDayInfoUpdate() {
        this.currentDay.day = -1;
        this.currentDay.month = -1;
        this.currentDay.year = -1;
        this.gt = GameTime.getInstance();
        this.updateDayInfo(this.gt.getDayPlusOne(), this.gt.getMonth(), this.gt.getYear());
        this.currentDay.hour = this.gt.getHour();
        this.currentDay.minutes = this.gt.getMinutes();
    }

    private void updateDayInfo(int n, int n2, int n3) {
        this.tickIsDayChange = false;
        if (this.currentDay == null || this.currentDay.day != n || this.currentDay.month != n2 || this.currentDay.year != n3) {
            boolean bl = this.tickIsDayChange = this.currentDay != null;
            if (this.currentDay == null) {
                this.currentDay = new DayInfo();
            }
            this.setDayInfo(this.currentDay, n, n2, n3, 0);
            if (this.previousDay == null) {
                this.previousDay = new DayInfo();
                this.previousDay.season = this.season.clone();
            }
            this.setDayInfo(this.previousDay, n, n2, n3, -1);
            if (this.nextDay == null) {
                this.nextDay = new DayInfo();
                this.nextDay.season = this.season.clone();
            }
            this.setDayInfo(this.nextDay, n, n2, n3, 1);
        }
    }

    protected void setDayInfo(DayInfo dayInfo, int n, int n2, int n3, int n4) {
        dayInfo.calendar = new GregorianCalendar(n3, n2, n, 0, 0);
        dayInfo.calendar.add(5, n4);
        dayInfo.day = dayInfo.calendar.get(5);
        dayInfo.month = dayInfo.calendar.get(2);
        dayInfo.year = dayInfo.calendar.get(1);
        dayInfo.dateValue = dayInfo.calendar.getTime().getTime();
        if (dayInfo.season == null) {
            dayInfo.season = this.season.clone();
        }
        dayInfo.season.setDay(dayInfo.day, dayInfo.month, dayInfo.year);
    }

    protected final void transmitClimatePacket(ClimateNetAuth climateNetAuth, byte by, UdpConnection udpConnection) {
        if (!GameClient.bClient && !GameServer.bServer) {
            return;
        }
        if (climateNetAuth == ClimateNetAuth.Denied) {
            DebugLog.log("Denied ClimatePacket, id = " + by + ", isClient = " + GameClient.bClient);
            return;
        }
        if (GameClient.bClient && (climateNetAuth == ClimateNetAuth.ClientOnly || climateNetAuth == ClimateNetAuth.ClientAndServer)) {
            try {
                if (this.writePacketContents(GameClient.connection, by)) {
                    PacketTypes.PacketType.ClimateManagerPacket.send(GameClient.connection);
                } else {
                    GameClient.connection.cancelPacket();
                }
            }
            catch (Exception exception) {
                DebugLog.log(exception.getMessage());
            }
        }
        if (GameServer.bServer && (climateNetAuth == ClimateNetAuth.ServerOnly || climateNetAuth == ClimateNetAuth.ClientAndServer)) {
            try {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection2 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection != null && udpConnection == udpConnection2) continue;
                    if (this.writePacketContents(udpConnection2, by)) {
                        PacketTypes.PacketType.ClimateManagerPacket.send(udpConnection2);
                        continue;
                    }
                    udpConnection2.cancelPacket();
                }
            }
            catch (Exception exception) {
                DebugLog.log(exception.getMessage());
            }
        }
    }

    private boolean writePacketContents(UdpConnection udpConnection, byte by) throws IOException {
        if (!GameClient.bClient && !GameServer.bServer) {
            return false;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.ClimateManagerPacket.doPacket(byteBufferWriter);
        ByteBuffer byteBuffer = byteBufferWriter.bb;
        byteBuffer.put(by);
        switch (by) {
            case 0: {
                int n;
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketUpdateClimateVars");
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    byteBuffer.putFloat(this.climateFloats[n].finalValue);
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].finalValue.write(byteBuffer);
                }
                for (n = 0; n < this.climateBooleans.length; ++n) {
                    byteBuffer.put(this.climateBooleans[n].finalValue ? (byte)1 : 0);
                }
                byteBuffer.putFloat(this.airMass);
                byteBuffer.putFloat(this.airMassDaily);
                byteBuffer.putFloat(this.airMassTemperature);
                byteBuffer.putFloat(this.snowFracNow);
                byteBuffer.putFloat(this.snowStrength);
                byteBuffer.putFloat(this.windPower);
                byteBuffer.put(this.dayDoFog ? (byte)1 : 0);
                byteBuffer.putFloat(this.dayFogStrength);
                byteBuffer.put(this.canDoWinterSprites ? (byte)1 : 0);
                this.weatherPeriod.writeNetWeatherData(byteBuffer);
                return true;
            }
            case 1: {
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketWeatherUpdate");
                }
                this.weatherPeriod.writeNetWeatherData(byteBuffer);
                return true;
            }
            case 2: {
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketThunderEvent");
                }
                this.thunderStorm.writeNetThunderEvent(byteBuffer);
                return true;
            }
            case 3: {
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketFlare");
                }
                return true;
            }
            case 5: {
                if (!GameClient.bClient) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketRequestAdminVars");
                }
                byteBuffer.put((byte)1);
                return true;
            }
            case 6: {
                int n;
                if (!GameClient.bClient) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketClientChangedAdminVars");
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    this.climateFloats[n].writeAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].writeAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateBooleans.length; ++n) {
                    this.climateBooleans[n].writeAdmin(byteBuffer);
                }
                return true;
            }
            case 4: {
                int n;
                if (!GameServer.bServer) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketAdminVarsUpdate");
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    this.climateFloats[n].writeAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].writeAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateBooleans.length; ++n) {
                    this.climateBooleans[n].writeAdmin(byteBuffer);
                }
                return true;
            }
            case 7: {
                if (!GameClient.bClient) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: send PacketClientChangedWeather");
                }
                byteBuffer.put(this.netInfo.IsStopWeather ? (byte)1 : 0);
                byteBuffer.put(this.netInfo.IsTrigger ? (byte)1 : 0);
                byteBuffer.put(this.netInfo.IsGenerate ? (byte)1 : 0);
                byteBuffer.putFloat(this.netInfo.TriggerDuration);
                byteBuffer.put(this.netInfo.TriggerStorm ? (byte)1 : 0);
                byteBuffer.put(this.netInfo.TriggerTropical ? (byte)1 : 0);
                byteBuffer.put(this.netInfo.TriggerBlizzard ? (byte)1 : 0);
                byteBuffer.putFloat(this.netInfo.GenerateStrength);
                byteBuffer.putInt(this.netInfo.GenerateFront);
                return true;
            }
        }
        return false;
    }

    public final void receiveClimatePacket(ByteBuffer byteBuffer, UdpConnection udpConnection) throws IOException {
        if (!GameClient.bClient && !GameServer.bServer) {
            return;
        }
        byte by = byteBuffer.get();
        this.readPacketContents(byteBuffer, by, udpConnection);
    }

    private boolean readPacketContents(ByteBuffer byteBuffer, byte by, UdpConnection udpConnection) throws IOException {
        switch (by) {
            case 0: {
                if (!GameClient.bClient) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketUpdateClimateVars");
                }
                for (int i = 0; i < this.climateFloats.length; ++i) {
                    ClimateFloat climateFloat = this.climateFloats[i];
                    climateFloat.internalValue = climateFloat.finalValue;
                    climateFloat.setOverride(byteBuffer.getFloat(), 0.0f);
                }
                for (int i = 0; i < this.climateColors.length; ++i) {
                    ClimateColor climateColor = this.climateColors[i];
                    climateColor.internalValue.setTo(climateColor.finalValue);
                    climateColor.setOverride(byteBuffer, 0.0f);
                }
                for (int i = 0; i < this.climateBooleans.length; ++i) {
                    ClimateBool climateBool = this.climateBooleans[i];
                    climateBool.setOverride(byteBuffer.get() == 1);
                }
                this.airMass = byteBuffer.getFloat();
                this.airMassDaily = byteBuffer.getFloat();
                this.airMassTemperature = byteBuffer.getFloat();
                this.snowFracNow = byteBuffer.getFloat();
                this.snowStrength = byteBuffer.getFloat();
                this.windPower = byteBuffer.getFloat();
                this.dayDoFog = byteBuffer.get() == 1;
                this.dayFogStrength = byteBuffer.getFloat();
                this.canDoWinterSprites = byteBuffer.get() == 1;
                long l = System.currentTimeMillis();
                if ((float)(l - this.networkUpdateStamp) < this.networkLerpTime) {
                    this.networkAdjustVal += 1.0f;
                    if (this.networkAdjustVal > 10.0f) {
                        this.networkAdjustVal = 10.0f;
                    }
                } else {
                    this.networkAdjustVal -= 1.0f;
                    if (this.networkAdjustVal < 0.0f) {
                        this.networkAdjustVal = 0.0f;
                    }
                }
                this.networkLerpTime = this.networkAdjustVal > 0.0f ? this.networkLerpTimeBase / this.networkAdjustVal : this.networkLerpTimeBase;
                this.networkUpdateStamp = l;
                this.weatherPeriod.readNetWeatherData(byteBuffer);
                return true;
            }
            case 1: {
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketWeatherUpdate");
                }
                this.weatherPeriod.readNetWeatherData(byteBuffer);
                return true;
            }
            case 2: {
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketThunderEvent");
                }
                this.thunderStorm.readNetThunderEvent(byteBuffer);
                return true;
            }
            case 3: {
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketFlare");
                }
                return true;
            }
            case 5: {
                if (!GameServer.bServer) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketRequestAdminVars");
                }
                byteBuffer.get();
                this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)4, null);
                return true;
            }
            case 6: {
                int n;
                if (!GameServer.bServer) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketClientChangedAdminVars");
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    this.climateFloats[n].readAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].readAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateBooleans.length; ++n) {
                    this.climateBooleans[n].readAdmin(byteBuffer);
                    if (n != 0) continue;
                    DebugLog.log("Snow = " + this.climateBooleans[n].adminValue + ", enabled = " + this.climateBooleans[n].isAdminOverride);
                }
                this.serverReceiveClientChangeAdminVars();
                return true;
            }
            case 4: {
                int n;
                if (!GameClient.bClient) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketAdminVarsUpdate");
                }
                for (n = 0; n < this.climateFloats.length; ++n) {
                    this.climateFloats[n].readAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateColors.length; ++n) {
                    this.climateColors[n].readAdmin(byteBuffer);
                }
                for (n = 0; n < this.climateBooleans.length; ++n) {
                    this.climateBooleans[n].readAdmin(byteBuffer);
                }
                return true;
            }
            case 7: {
                if (!GameServer.bServer) {
                    return false;
                }
                if (this.networkPrint) {
                    DebugLog.log("clim: receive PacketClientChangedWeather");
                }
                this.netInfo.IsStopWeather = byteBuffer.get() == 1;
                this.netInfo.IsTrigger = byteBuffer.get() == 1;
                this.netInfo.IsGenerate = byteBuffer.get() == 1;
                this.netInfo.TriggerDuration = byteBuffer.getFloat();
                this.netInfo.TriggerStorm = byteBuffer.get() == 1;
                this.netInfo.TriggerTropical = byteBuffer.get() == 1;
                this.netInfo.TriggerBlizzard = byteBuffer.get() == 1;
                this.netInfo.GenerateStrength = byteBuffer.getFloat();
                this.netInfo.GenerateFront = byteBuffer.getInt();
                this.serverReceiveClientChangeWeather();
                return true;
            }
        }
        return false;
    }

    private void serverReceiveClientChangeAdminVars() {
        if (!GameServer.bServer) {
            return;
        }
        if (this.networkPrint) {
            DebugLog.log("clim: serverReceiveClientChangeAdminVars");
        }
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)4, null);
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    private void serverReceiveClientChangeWeather() {
        if (!GameServer.bServer) {
            return;
        }
        if (this.networkPrint) {
            DebugLog.log("clim: serverReceiveClientChangeWeather");
        }
        if (this.netInfo.IsStopWeather) {
            if (this.networkPrint) {
                DebugLog.log("clim: IsStopWeather");
            }
            this.stopWeatherAndThunder();
        } else if (this.netInfo.IsTrigger) {
            this.stopWeatherAndThunder();
            if (this.netInfo.TriggerStorm) {
                if (this.networkPrint) {
                    DebugLog.log("clim: Trigger Storm");
                }
                this.triggerCustomWeatherStage(3, this.netInfo.TriggerDuration);
            } else if (this.netInfo.TriggerTropical) {
                if (this.networkPrint) {
                    DebugLog.log("clim: Trigger Tropical");
                }
                this.triggerCustomWeatherStage(8, this.netInfo.TriggerDuration);
            } else if (this.netInfo.TriggerBlizzard) {
                if (this.networkPrint) {
                    DebugLog.log("clim: Trigger Blizzard");
                }
                this.triggerCustomWeatherStage(7, this.netInfo.TriggerDuration);
            }
        } else if (this.netInfo.IsGenerate) {
            if (this.networkPrint) {
                DebugLog.log("clim: IsGenerate");
            }
            this.stopWeatherAndThunder();
            this.triggerCustomWeather(this.netInfo.GenerateStrength, this.netInfo.GenerateFront == 0);
        }
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    public void transmitServerStopWeather() {
        if (!GameServer.bServer) {
            return;
        }
        this.stopWeatherAndThunder();
        if (this.networkPrint) {
            DebugLog.log("clim: SERVER transmitStopWeather");
        }
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    public void transmitServerTriggerStorm(float f) {
        if (!GameServer.bServer) {
            return;
        }
        if (this.networkPrint) {
            DebugLog.log("clim: SERVER transmitTriggerStorm");
        }
        this.netInfo.TriggerDuration = f;
        this.triggerCustomWeatherStage(3, this.netInfo.TriggerDuration);
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    public void transmitServerTriggerLightning(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!GameServer.bServer) {
            return;
        }
        if (this.networkPrint) {
            DebugLog.log("clim: SERVER transmitTriggerLightning");
        }
        this.thunderStorm.triggerThunderEvent(n, n2, bl, bl2, bl3);
    }

    public void transmitServerStartRain(float f) {
        if (!GameServer.bServer) {
            return;
        }
        this.precipitationIntensity.setAdminValue(ClimateManager.clamp01(f));
        this.precipitationIntensity.setEnableAdmin(true);
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    public void transmitServerStopRain() {
        if (!GameServer.bServer) {
            return;
        }
        this.precipitationIntensity.setEnableAdmin(false);
        this.updateOnTick();
        this.transmitClimatePacket(ClimateNetAuth.ServerOnly, (byte)0, null);
    }

    public void transmitRequestAdminVars() {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitRequestAdminVars");
        }
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)5, null);
    }

    public void transmitClientChangeAdminVars() {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitClientChangeAdminVars");
        }
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)6, null);
    }

    public void transmitStopWeather() {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitStopWeather");
        }
        this.netInfo.reset();
        this.netInfo.IsStopWeather = true;
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)7, null);
    }

    public void transmitTriggerStorm(float f) {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitTriggerStorm");
        }
        this.netInfo.reset();
        this.netInfo.IsTrigger = true;
        this.netInfo.TriggerStorm = true;
        this.netInfo.TriggerDuration = f;
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)7, null);
    }

    public void transmitTriggerTropical(float f) {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitTriggerTropical");
        }
        this.netInfo.reset();
        this.netInfo.IsTrigger = true;
        this.netInfo.TriggerTropical = true;
        this.netInfo.TriggerDuration = f;
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)7, null);
    }

    public void transmitTriggerBlizzard(float f) {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitTriggerBlizzard");
        }
        this.netInfo.reset();
        this.netInfo.IsTrigger = true;
        this.netInfo.TriggerBlizzard = true;
        this.netInfo.TriggerDuration = f;
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)7, null);
    }

    public void transmitGenerateWeather(float f, int n) {
        if (this.networkPrint) {
            DebugLog.log("clim: transmitGenerateWeather");
        }
        this.netInfo.reset();
        this.netInfo.IsGenerate = true;
        this.netInfo.GenerateStrength = ClimateManager.clamp01(f);
        this.netInfo.GenerateFront = n;
        if (this.netInfo.GenerateFront < 0 || this.netInfo.GenerateFront > 1) {
            this.netInfo.GenerateFront = 0;
        }
        this.transmitClimatePacket(ClimateNetAuth.ClientOnly, (byte)7, null);
    }

    protected float getTimeLerpHours(float f, float f2, float f3) {
        return this.getTimeLerpHours(f, f2, f3, false);
    }

    protected float getTimeLerpHours(float f, float f2, float f3, boolean bl) {
        return this.getTimeLerp(ClimateManager.clamp(0.0f, 1.0f, f / 24.0f), ClimateManager.clamp(0.0f, 1.0f, f2 / 24.0f), ClimateManager.clamp(0.0f, 1.0f, f3 / 24.0f), bl);
    }

    protected float getTimeLerp(float f, float f2, float f3) {
        return this.getTimeLerp(f, f2, f3, false);
    }

    protected float getTimeLerp(float f, float f2, float f3, boolean bl) {
        float f4;
        float f5;
        float f6;
        boolean bl2;
        boolean bl3 = bl2 = f2 > f3;
        if (!bl2) {
            if (f < f2 || f > f3) {
                return 0.0f;
            }
            float f7 = f - f2;
            float f8 = f3 - f2;
            float f9 = f8 * 0.5f;
            if (f7 < f9) {
                return bl ? ClimateManager.clerp(f7 / f9, 0.0f, 1.0f) : ClimateManager.lerp(f7 / f9, 0.0f, 1.0f);
            }
            return bl ? ClimateManager.clerp((f7 - f9) / f9, 1.0f, 0.0f) : ClimateManager.lerp((f7 - f9) / f9, 1.0f, 0.0f);
        }
        if (f < f2 && f > f3) {
            return 0.0f;
        }
        float f10 = f >= f2 ? f - f2 : f + f6;
        if (f10 < (f5 = (f4 = f3 + (f6 = 1.0f - f2)) * 0.5f)) {
            return bl ? ClimateManager.clerp(f10 / f5, 0.0f, 1.0f) : ClimateManager.lerp(f10 / f5, 0.0f, 1.0f);
        }
        return bl ? ClimateManager.clerp((f10 - f5) / f5, 1.0f, 0.0f) : ClimateManager.lerp((f10 - f5) / f5, 1.0f, 0.0f);
    }

    public static float clamp01(float f) {
        return ClimateManager.clamp(0.0f, 1.0f, f);
    }

    public static float clamp(float f, float f2, float f3) {
        f3 = Math.min(f2, f3);
        f3 = Math.max(f, f3);
        return f3;
    }

    public static int clamp(int n, int n2, int n3) {
        n3 = Math.min(n2, n3);
        n3 = Math.max(n, n3);
        return n3;
    }

    public static float lerp(float f, float f2, float f3) {
        return f2 + f * (f3 - f2);
    }

    public static float clerp(float f, float f2, float f3) {
        float f4 = (float)(1.0 - Math.cos((double)f * Math.PI)) / 2.0f;
        return f2 * (1.0f - f4) + f3 * f4;
    }

    public static float normalizeRange(float f, float f2) {
        return ClimateManager.clamp(0.0f, 1.0f, f / f2);
    }

    public static float posToPosNegRange(float f) {
        if (f > 0.5f) {
            return (f - 0.5f) * 2.0f;
        }
        if (f < 0.5f) {
            return -((0.5f - f) * 2.0f);
        }
        return 0.0f;
    }

    public void execute_Simulation() {
        if (Core.bDebug) {
            ClimMngrDebug climMngrDebug = new ClimMngrDebug();
            int n = 365;
            int n2 = 5000;
            climMngrDebug.SimulateDays(n, n2);
        }
    }

    public void execute_Simulation(int n) {
        if (Core.bDebug) {
            ClimMngrDebug climMngrDebug = new ClimMngrDebug();
            climMngrDebug.setRainModOverride(n);
            int n2 = 365;
            int n3 = 5000;
            climMngrDebug.SimulateDays(n2, n3);
        }
    }

    public void triggerKateBobIntroStorm(int n, int n2, double d, float f, float f2, float f3, float f4) {
        this.triggerKateBobIntroStorm(n, n2, d, f, f2, f3, f4, null);
    }

    public void triggerKateBobIntroStorm(int n, int n2, double d, float f, float f2, float f3, float f4, ClimateColorInfo climateColorInfo) {
        if (!GameClient.bClient) {
            this.stopWeatherAndThunder();
            if (this.weatherPeriod.startCreateModdedPeriod(true, f, f3)) {
                this.weatherPeriod.setKateBobStormProgress(f2);
                this.weatherPeriod.setKateBobStormCoords(n, n2);
                this.weatherPeriod.createAndAddStage(11, d);
                this.weatherPeriod.createAndAddStage(2, d / 2.0);
                this.weatherPeriod.createAndAddStage(4, d / 4.0);
                this.weatherPeriod.endCreateModdedPeriod();
                if (climateColorInfo != null) {
                    this.weatherPeriod.setCloudColor(climateColorInfo);
                } else {
                    this.weatherPeriod.setCloudColor(this.weatherPeriod.getCloudColorBlueish());
                }
                IsoPuddles.PuddlesFloat puddlesFloat = IsoPuddles.getInstance().getPuddlesFloat(3);
                puddlesFloat.setFinalValue(f4);
                puddlesFloat = IsoPuddles.getInstance().getPuddlesFloat(1);
                puddlesFloat.setFinalValue(PZMath.clamp_01(f4 * 1.2f));
            }
        }
    }

    public double getSimplexOffsetA() {
        return this.simplexOffsetA;
    }

    public double getSimplexOffsetB() {
        return this.simplexOffsetB;
    }

    public double getSimplexOffsetC() {
        return this.simplexOffsetC;
    }

    public double getSimplexOffsetD() {
        return this.simplexOffsetD;
    }

    public double getWorldAgeHours() {
        return this.worldAgeHours;
    }

    public ClimateValues getClimateValuesCopy() {
        return this.climateValues.getCopy();
    }

    public void CopyClimateValues(ClimateValues climateValues) {
        this.climateValues.CopyValues(climateValues);
    }

    public ClimateForecaster getClimateForecaster() {
        return this.climateForecaster;
    }

    public ClimateHistory getClimateHistory() {
        return this.climateHistory;
    }

    public void CalculateWeatherFrontStrength(int n, int n2, int n3, AirFront airFront) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3, 0, 0);
        gregorianCalendar.add(5, -3);
        if (this.climateValuesFronts == null) {
            this.climateValuesFronts = this.climateValues.getCopy();
        }
        int n4 = airFront.type;
        for (int i = 0; i < 4; ++i) {
            int n5;
            this.climateValuesFronts.pollDate(gregorianCalendar);
            float f = this.climateValuesFronts.getAirFrontAirmass();
            int n6 = n5 = f < 0.0f ? -1 : 1;
            if (n5 == n4) {
                airFront.addDaySample(f);
            }
            gregorianCalendar.add(5, 1);
        }
        DebugLog.log("Calculate weather front strength = " + airFront.getStrength());
    }

    public static String getWindAngleString(float f) {
        for (int i = 0; i < windAngles.length; ++i) {
            if (!(f < windAngles[i])) continue;
            return windAngleStr[i];
        }
        return windAngleStr[windAngleStr.length - 1];
    }

    public void sendInitialState(UdpConnection udpConnection) throws IOException {
        if (!GameServer.bServer) {
            return;
        }
        if (this.writePacketContents(udpConnection, (byte)0)) {
            PacketTypes.PacketType.ClimateManagerPacket.send(udpConnection);
        } else {
            udpConnection.cancelPacket();
        }
    }

    public boolean isUpdated() {
        return this.lastMinuteStamp != -1L;
    }

    public static class AirFront {
        private float days = 0.0f;
        private float maxNoise = 0.0f;
        private float totalNoise = 0.0f;
        private int type = 0;
        private float strength = 0.0f;
        private float tmpNoiseAbs = 0.0f;
        private float[] noiseCache = new float[2];
        private float noiseCacheValue = 0.0f;
        private float frontWindAngleDegrees = 0.0f;

        public float getDays() {
            return this.days;
        }

        public float getMaxNoise() {
            return this.maxNoise;
        }

        public float getTotalNoise() {
            return this.totalNoise;
        }

        public int getType() {
            return this.type;
        }

        public float getStrength() {
            return this.strength;
        }

        public float getAngleDegrees() {
            return this.frontWindAngleDegrees;
        }

        public AirFront() {
            this.reset();
        }

        public void setFrontType(int n) {
            this.reset();
            this.type = n;
        }

        protected void setFrontWind(float f) {
            this.frontWindAngleDegrees = f;
        }

        public void setStrength(float f) {
            this.strength = f;
        }

        protected void reset() {
            this.days = 0.0f;
            this.maxNoise = 0.0f;
            this.totalNoise = 0.0f;
            this.type = 0;
            this.strength = 0.0f;
            this.frontWindAngleDegrees = 0.0f;
            for (int i = 0; i < this.noiseCache.length; ++i) {
                this.noiseCache[i] = -1.0f;
            }
        }

        public void save(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeFloat(this.days);
            dataOutputStream.writeFloat(this.maxNoise);
            dataOutputStream.writeFloat(this.totalNoise);
            dataOutputStream.writeInt(this.type);
            dataOutputStream.writeFloat(this.strength);
            dataOutputStream.writeFloat(this.frontWindAngleDegrees);
            dataOutputStream.writeInt(this.noiseCache.length);
            for (int i = 0; i < this.noiseCache.length; ++i) {
                dataOutputStream.writeFloat(this.noiseCache[i]);
            }
        }

        public void load(DataInputStream dataInputStream) throws IOException {
            this.days = dataInputStream.readFloat();
            this.maxNoise = dataInputStream.readFloat();
            this.totalNoise = dataInputStream.readFloat();
            this.type = dataInputStream.readInt();
            this.strength = dataInputStream.readFloat();
            this.frontWindAngleDegrees = dataInputStream.readFloat();
            int n = dataInputStream.readInt();
            int n2 = n > this.noiseCache.length ? n : this.noiseCache.length;
            for (int i = 0; i < n2; ++i) {
                if (i < n) {
                    float f = dataInputStream.readFloat();
                    if (i >= this.noiseCache.length) continue;
                    this.noiseCache[i] = f;
                    continue;
                }
                if (i >= this.noiseCache.length) continue;
                this.noiseCache[i] = -1.0f;
            }
        }

        public void addDaySample(float f) {
            this.days += 1.0f;
            if (this.type == 1 && f <= 0.0f || this.type == -1 && f >= 0.0f) {
                this.strength = 0.0f;
                return;
            }
            this.tmpNoiseAbs = Math.abs(f);
            if (this.tmpNoiseAbs > this.maxNoise) {
                this.maxNoise = this.tmpNoiseAbs;
            }
            this.totalNoise += this.tmpNoiseAbs;
            this.noiseCacheValue = 0.0f;
            for (int i = this.noiseCache.length - 1; i >= 0; --i) {
                if (this.noiseCache[i] > this.noiseCacheValue) {
                    this.noiseCacheValue = this.noiseCache[i];
                }
                if (i >= this.noiseCache.length - 1) continue;
                this.noiseCache[i + 1] = this.noiseCache[i];
            }
            this.noiseCache[0] = this.tmpNoiseAbs;
            if (this.tmpNoiseAbs > this.noiseCacheValue) {
                this.noiseCacheValue = this.tmpNoiseAbs;
            }
            this.strength = this.noiseCacheValue * 0.75f + this.maxNoise * 0.25f;
        }

        public void copyFrom(AirFront airFront) {
            this.days = airFront.days;
            this.maxNoise = airFront.maxNoise;
            this.totalNoise = airFront.totalNoise;
            this.type = airFront.type;
            this.strength = airFront.strength;
            this.frontWindAngleDegrees = airFront.frontWindAngleDegrees;
        }
    }

    public static class ClimateFloat {
        protected float internalValue;
        protected float finalValue;
        protected boolean isOverride = false;
        protected float override;
        protected float interpolate;
        private boolean isModded = false;
        private float moddedValue;
        private float modInterpolate;
        private boolean isAdminOverride = false;
        private float adminValue;
        private float min = 0.0f;
        private float max = 1.0f;
        private int ID;
        private String name;

        public ClimateFloat init(int n, String string) {
            this.ID = n;
            this.name = string;
            return this;
        }

        public int getID() {
            return this.ID;
        }

        public String getName() {
            return this.name;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public float getInternalValue() {
            return this.internalValue;
        }

        public float getOverride() {
            return this.override;
        }

        public float getOverrideInterpolate() {
            return this.interpolate;
        }

        public void setOverride(float f, float f2) {
            this.override = f;
            this.interpolate = f2;
            this.isOverride = true;
        }

        public void setEnableOverride(boolean bl) {
            this.isOverride = bl;
        }

        public boolean isEnableOverride() {
            return this.isOverride;
        }

        public void setEnableAdmin(boolean bl) {
            this.isAdminOverride = bl;
        }

        public boolean isEnableAdmin() {
            return this.isAdminOverride;
        }

        public void setAdminValue(float f) {
            this.adminValue = ClimateManager.clamp(this.min, this.max, f);
        }

        public float getAdminValue() {
            return this.adminValue;
        }

        public void setEnableModded(boolean bl) {
            this.isModded = bl;
        }

        public void setModdedValue(float f) {
            this.moddedValue = ClimateManager.clamp(this.min, this.max, f);
        }

        public float getModdedValue() {
            return this.moddedValue;
        }

        public void setModdedInterpolate(float f) {
            this.modInterpolate = ClimateManager.clamp01(f);
        }

        public void setFinalValue(float f) {
            this.finalValue = f;
        }

        public float getFinalValue() {
            return this.finalValue;
        }

        private void calculate() {
            if (this.isAdminOverride && !GameClient.bClient) {
                this.finalValue = this.adminValue;
                return;
            }
            if (this.isModded && this.modInterpolate > 0.0f) {
                this.internalValue = ClimateManager.lerp(this.modInterpolate, this.internalValue, this.moddedValue);
            }
            this.finalValue = this.isOverride && this.interpolate > 0.0f ? ClimateManager.lerp(this.interpolate, this.internalValue, this.override) : this.internalValue;
        }

        private void writeAdmin(ByteBuffer byteBuffer) {
            byteBuffer.put(this.isAdminOverride ? (byte)1 : 0);
            byteBuffer.putFloat(this.adminValue);
        }

        private void readAdmin(ByteBuffer byteBuffer) {
            this.isAdminOverride = byteBuffer.get() == 1;
            this.adminValue = byteBuffer.getFloat();
        }

        private void saveAdmin(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(this.isAdminOverride);
            dataOutputStream.writeFloat(this.adminValue);
        }

        private void loadAdmin(DataInputStream dataInputStream, int n) throws IOException {
            this.isAdminOverride = dataInputStream.readBoolean();
            this.adminValue = dataInputStream.readFloat();
        }
    }

    public static class ClimateColor {
        protected ClimateColorInfo internalValue = new ClimateColorInfo();
        protected ClimateColorInfo finalValue = new ClimateColorInfo();
        protected boolean isOverride = false;
        protected ClimateColorInfo override = new ClimateColorInfo();
        protected float interpolate;
        private boolean isModded = false;
        private ClimateColorInfo moddedValue = new ClimateColorInfo();
        private float modInterpolate;
        private boolean isAdminOverride = false;
        private ClimateColorInfo adminValue = new ClimateColorInfo();
        private int ID;
        private String name;

        public ClimateColor init(int n, String string) {
            this.ID = n;
            this.name = string;
            return this;
        }

        public int getID() {
            return this.ID;
        }

        public String getName() {
            return this.name;
        }

        public ClimateColorInfo getInternalValue() {
            return this.internalValue;
        }

        public ClimateColorInfo getOverride() {
            return this.override;
        }

        public float getOverrideInterpolate() {
            return this.interpolate;
        }

        public void setOverride(ClimateColorInfo climateColorInfo, float f) {
            this.override.setTo(climateColorInfo);
            this.interpolate = f;
            this.isOverride = true;
        }

        public void setOverride(ByteBuffer byteBuffer, float f) {
            this.override.read(byteBuffer);
            this.interpolate = f;
            this.isOverride = true;
        }

        public void setEnableOverride(boolean bl) {
            this.isOverride = bl;
        }

        public boolean isEnableOverride() {
            return this.isOverride;
        }

        public void setEnableAdmin(boolean bl) {
            this.isAdminOverride = bl;
        }

        public boolean isEnableAdmin() {
            return this.isAdminOverride;
        }

        public void setAdminValue(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.adminValue.getExterior().r = f;
            this.adminValue.getExterior().g = f2;
            this.adminValue.getExterior().b = f3;
            this.adminValue.getExterior().a = f4;
            this.adminValue.getInterior().r = f5;
            this.adminValue.getInterior().g = f6;
            this.adminValue.getInterior().b = f7;
            this.adminValue.getInterior().a = f8;
        }

        public void setAdminValueExterior(float f, float f2, float f3, float f4) {
            this.adminValue.getExterior().r = f;
            this.adminValue.getExterior().g = f2;
            this.adminValue.getExterior().b = f3;
            this.adminValue.getExterior().a = f4;
        }

        public void setAdminValueInterior(float f, float f2, float f3, float f4) {
            this.adminValue.getInterior().r = f;
            this.adminValue.getInterior().g = f2;
            this.adminValue.getInterior().b = f3;
            this.adminValue.getInterior().a = f4;
        }

        public void setAdminValue(ClimateColorInfo climateColorInfo) {
            this.adminValue.setTo(climateColorInfo);
        }

        public ClimateColorInfo getAdminValue() {
            return this.adminValue;
        }

        public void setEnableModded(boolean bl) {
            this.isModded = bl;
        }

        public void setModdedValue(ClimateColorInfo climateColorInfo) {
            this.moddedValue.setTo(climateColorInfo);
        }

        public ClimateColorInfo getModdedValue() {
            return this.moddedValue;
        }

        public void setModdedInterpolate(float f) {
            this.modInterpolate = ClimateManager.clamp01(f);
        }

        public void setFinalValue(ClimateColorInfo climateColorInfo) {
            this.finalValue.setTo(climateColorInfo);
        }

        public ClimateColorInfo getFinalValue() {
            return this.finalValue;
        }

        private void calculate() {
            if (this.isAdminOverride && !GameClient.bClient) {
                this.finalValue.setTo(this.adminValue);
                return;
            }
            if (this.isModded && this.modInterpolate > 0.0f) {
                this.internalValue.interp(this.moddedValue, this.modInterpolate, this.internalValue);
            }
            if (this.isOverride && this.interpolate > 0.0f) {
                this.internalValue.interp(this.override, this.interpolate, this.finalValue);
            } else {
                this.finalValue.setTo(this.internalValue);
            }
        }

        private void writeAdmin(ByteBuffer byteBuffer) {
            byteBuffer.put(this.isAdminOverride ? (byte)1 : 0);
            this.adminValue.write(byteBuffer);
        }

        private void readAdmin(ByteBuffer byteBuffer) {
            this.isAdminOverride = byteBuffer.get() == 1;
            this.adminValue.read(byteBuffer);
        }

        private void saveAdmin(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(this.isAdminOverride);
            this.adminValue.save(dataOutputStream);
        }

        private void loadAdmin(DataInputStream dataInputStream, int n) throws IOException {
            this.isAdminOverride = dataInputStream.readBoolean();
            if (n < 143) {
                this.adminValue.getInterior().r = dataInputStream.readFloat();
                this.adminValue.getInterior().g = dataInputStream.readFloat();
                this.adminValue.getInterior().b = dataInputStream.readFloat();
                this.adminValue.getInterior().a = dataInputStream.readFloat();
                this.adminValue.getExterior().r = this.adminValue.getInterior().r;
                this.adminValue.getExterior().g = this.adminValue.getInterior().g;
                this.adminValue.getExterior().b = this.adminValue.getInterior().b;
                this.adminValue.getExterior().a = this.adminValue.getInterior().a;
            } else {
                this.adminValue.load(dataInputStream, n);
            }
        }
    }

    public static class ClimateBool {
        protected boolean internalValue;
        protected boolean finalValue;
        protected boolean isOverride;
        protected boolean override;
        private boolean isModded = false;
        private boolean moddedValue;
        private boolean isAdminOverride = false;
        private boolean adminValue;
        private int ID;
        private String name;

        public ClimateBool init(int n, String string) {
            this.ID = n;
            this.name = string;
            return this;
        }

        public int getID() {
            return this.ID;
        }

        public String getName() {
            return this.name;
        }

        public boolean getInternalValue() {
            return this.internalValue;
        }

        public boolean getOverride() {
            return this.override;
        }

        public void setOverride(boolean bl) {
            this.isOverride = true;
            this.override = bl;
        }

        public void setEnableOverride(boolean bl) {
            this.isOverride = bl;
        }

        public boolean isEnableOverride() {
            return this.isOverride;
        }

        public void setEnableAdmin(boolean bl) {
            this.isAdminOverride = bl;
        }

        public boolean isEnableAdmin() {
            return this.isAdminOverride;
        }

        public void setAdminValue(boolean bl) {
            this.adminValue = bl;
        }

        public boolean getAdminValue() {
            return this.adminValue;
        }

        public void setEnableModded(boolean bl) {
            this.isModded = bl;
        }

        public void setModdedValue(boolean bl) {
            this.moddedValue = bl;
        }

        public boolean getModdedValue() {
            return this.moddedValue;
        }

        public void setFinalValue(boolean bl) {
            this.finalValue = bl;
        }

        private void calculate() {
            if (this.isAdminOverride && !GameClient.bClient) {
                this.finalValue = this.adminValue;
                return;
            }
            if (this.isModded) {
                this.finalValue = this.moddedValue;
                return;
            }
            this.finalValue = this.isOverride ? this.override : this.internalValue;
        }

        private void writeAdmin(ByteBuffer byteBuffer) {
            byteBuffer.put(this.isAdminOverride ? (byte)1 : 0);
            byteBuffer.put(this.adminValue ? (byte)1 : 0);
        }

        private void readAdmin(ByteBuffer byteBuffer) {
            this.isAdminOverride = byteBuffer.get() == 1;
            this.adminValue = byteBuffer.get() == 1;
        }

        private void saveAdmin(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(this.isAdminOverride);
            dataOutputStream.writeBoolean(this.adminValue);
        }

        private void loadAdmin(DataInputStream dataInputStream, int n) throws IOException {
            this.isAdminOverride = dataInputStream.readBoolean();
            this.adminValue = dataInputStream.readBoolean();
        }
    }

    private static class ClimateNetInfo {
        public boolean IsStopWeather = false;
        public boolean IsTrigger = false;
        public boolean IsGenerate = false;
        public float TriggerDuration = 0.0f;
        public boolean TriggerStorm = false;
        public boolean TriggerTropical = false;
        public boolean TriggerBlizzard = false;
        public float GenerateStrength = 0.0f;
        public int GenerateFront = 0;

        private ClimateNetInfo() {
        }

        private void reset() {
            this.IsStopWeather = false;
            this.IsTrigger = false;
            this.IsGenerate = false;
            this.TriggerDuration = 0.0f;
            this.TriggerStorm = false;
            this.TriggerTropical = false;
            this.TriggerBlizzard = false;
            this.GenerateStrength = 0.0f;
            this.GenerateFront = 0;
        }
    }

    public static class DayInfo {
        public int day;
        public int month;
        public int year;
        public int hour;
        public int minutes;
        public long dateValue;
        public GregorianCalendar calendar;
        public ErosionSeason season;

        public void set(int n, int n2, int n3) {
            this.calendar = new GregorianCalendar(n3, n2, n, 0, 0);
            this.dateValue = this.calendar.getTime().getTime();
            this.day = n;
            this.month = n2;
            this.year = n3;
        }

        public int getDay() {
            return this.day;
        }

        public int getMonth() {
            return this.month;
        }

        public int getYear() {
            return this.year;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public long getDateValue() {
            return this.dateValue;
        }

        public ErosionSeason getSeason() {
            return this.season;
        }
    }

    public static enum ClimateNetAuth {
        Denied,
        ClientOnly,
        ServerOnly,
        ClientAndServer;

    }

    protected static class SeasonColor {
        public static int WARM = 0;
        public static int NORMAL = 1;
        public static int CLOUDY = 2;
        public static int SUMMER = 0;
        public static int FALL = 1;
        public static int WINTER = 2;
        public static int SPRING = 3;
        private ClimateColorInfo finalCol = new ClimateColorInfo();
        private ClimateColorInfo[] tempCol = new ClimateColorInfo[3];
        private ClimateColorInfo[][] colors = new ClimateColorInfo[3][4];
        private boolean ignoreNormal = true;

        public SeasonColor() {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.colors[i][j] = new ClimateColorInfo();
                }
                this.tempCol[i] = new ClimateColorInfo();
            }
        }

        public void setIgnoreNormal(boolean bl) {
            this.ignoreNormal = bl;
        }

        public ClimateColorInfo getColor(int n, int n2) {
            return this.colors[n][n2];
        }

        public void setColorInterior(int n, int n2, float f, float f2, float f3, float f4) {
            this.colors[n][n2].getInterior().r = f;
            this.colors[n][n2].getInterior().g = f2;
            this.colors[n][n2].getInterior().b = f3;
            this.colors[n][n2].getInterior().a = f4;
        }

        public void setColorExterior(int n, int n2, float f, float f2, float f3, float f4) {
            this.colors[n][n2].getExterior().r = f;
            this.colors[n][n2].getExterior().g = f2;
            this.colors[n][n2].getExterior().b = f3;
            this.colors[n][n2].getExterior().a = f4;
        }

        public ClimateColorInfo update(float f, float f2, int n, int n2) {
            for (int i = 0; i < 3; ++i) {
                if (this.ignoreNormal && i == 1) continue;
                this.colors[i][n].interp(this.colors[i][n2], f2, this.tempCol[i]);
            }
            if (!this.ignoreNormal) {
                if (f < 0.5f) {
                    float f3 = f * 2.0f;
                    this.tempCol[WARM].interp(this.tempCol[NORMAL], f3, this.finalCol);
                } else {
                    float f4 = 1.0f - (f - 0.5f) * 2.0f;
                    this.tempCol[CLOUDY].interp(this.tempCol[NORMAL], f4, this.finalCol);
                }
            } else {
                this.tempCol[WARM].interp(this.tempCol[CLOUDY], f, this.finalCol);
            }
            return this.finalCol;
        }
    }
}

