/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.weather;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import zombie.ZomboidFileSystem;
import zombie.core.Color;
import zombie.debug.DebugLog;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.WeatherPeriod;

public class ClimateColorInfo {
    private Color interior = new Color(0, 0, 0, 1);
    private Color exterior = new Color(0, 0, 0, 1);
    private static BufferedWriter writer;

    public ClimateColorInfo() {
    }

    public ClimateColorInfo(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, f, f2, f3, f4);
    }

    public ClimateColorInfo(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.interior.r = f;
        this.interior.g = f2;
        this.interior.b = f3;
        this.interior.a = f4;
        this.exterior.r = f5;
        this.exterior.g = f6;
        this.exterior.b = f7;
        this.exterior.a = f8;
    }

    public void setInterior(Color color) {
        this.interior.set(color);
    }

    public void setInterior(float f, float f2, float f3, float f4) {
        this.interior.r = f;
        this.interior.g = f2;
        this.interior.b = f3;
        this.interior.a = f4;
    }

    public Color getInterior() {
        return this.interior;
    }

    public void setExterior(Color color) {
        this.exterior.set(color);
    }

    public void setExterior(float f, float f2, float f3, float f4) {
        this.exterior.r = f;
        this.exterior.g = f2;
        this.exterior.b = f3;
        this.exterior.a = f4;
    }

    public Color getExterior() {
        return this.exterior;
    }

    public void setTo(ClimateColorInfo climateColorInfo) {
        this.interior.set(climateColorInfo.interior);
        this.exterior.set(climateColorInfo.exterior);
    }

    public ClimateColorInfo interp(ClimateColorInfo climateColorInfo, float f, ClimateColorInfo climateColorInfo2) {
        this.interior.interp(climateColorInfo.interior, f, climateColorInfo2.interior);
        this.exterior.interp(climateColorInfo.exterior, f, climateColorInfo2.exterior);
        return climateColorInfo2;
    }

    public void scale(float f) {
        this.interior.scale(f);
        this.exterior.scale(f);
    }

    public static ClimateColorInfo interp(ClimateColorInfo climateColorInfo, ClimateColorInfo climateColorInfo2, float f, ClimateColorInfo climateColorInfo3) {
        return climateColorInfo.interp(climateColorInfo2, f, climateColorInfo3);
    }

    public void write(ByteBuffer byteBuffer) {
        byteBuffer.putFloat(this.interior.r);
        byteBuffer.putFloat(this.interior.g);
        byteBuffer.putFloat(this.interior.b);
        byteBuffer.putFloat(this.interior.a);
        byteBuffer.putFloat(this.exterior.r);
        byteBuffer.putFloat(this.exterior.g);
        byteBuffer.putFloat(this.exterior.b);
        byteBuffer.putFloat(this.exterior.a);
    }

    public void read(ByteBuffer byteBuffer) {
        this.interior.r = byteBuffer.getFloat();
        this.interior.g = byteBuffer.getFloat();
        this.interior.b = byteBuffer.getFloat();
        this.interior.a = byteBuffer.getFloat();
        this.exterior.r = byteBuffer.getFloat();
        this.exterior.g = byteBuffer.getFloat();
        this.exterior.b = byteBuffer.getFloat();
        this.exterior.a = byteBuffer.getFloat();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.interior.r);
        dataOutputStream.writeFloat(this.interior.g);
        dataOutputStream.writeFloat(this.interior.b);
        dataOutputStream.writeFloat(this.interior.a);
        dataOutputStream.writeFloat(this.exterior.r);
        dataOutputStream.writeFloat(this.exterior.g);
        dataOutputStream.writeFloat(this.exterior.b);
        dataOutputStream.writeFloat(this.exterior.a);
    }

    public void load(DataInputStream dataInputStream, int n) throws IOException {
        this.interior.r = dataInputStream.readFloat();
        this.interior.g = dataInputStream.readFloat();
        this.interior.b = dataInputStream.readFloat();
        this.interior.a = dataInputStream.readFloat();
        this.exterior.r = dataInputStream.readFloat();
        this.exterior.g = dataInputStream.readFloat();
        this.exterior.b = dataInputStream.readFloat();
        this.exterior.a = dataInputStream.readFloat();
    }

    public static boolean writeColorInfoConfig() {
        boolean bl = false;
        try {
            String string = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String string2 = "ClimateMain_" + string;
            String string3 = ZomboidFileSystem.instance.getCacheDir() + File.separator + string2 + ".lua";
            DebugLog.log("Attempting to save color config to: " + string3);
            File file = new File(string3);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));){
                writer = bufferedWriter;
                ClimateManager climateManager = ClimateManager.getInstance();
                ClimateColorInfo.write("--[[");
                ClimateColorInfo.write("-- Generated file (" + string2 + ")");
                ClimateColorInfo.write("-- Climate color configuration");
                ClimateColorInfo.write("-- File should be placed in: media/lua/server/Climate/ClimateMain.lua (remove date stamp)");
                ClimateColorInfo.write("--]]");
                bufferedWriter.newLine();
                ClimateColorInfo.write("ClimateMain = {};");
                ClimateColorInfo.write("ClimateMain.versionStamp = \"" + string + "\";");
                bufferedWriter.newLine();
                ClimateColorInfo.write("local WARM,NORMAL,CLOUDY = 0,1,2;");
                bufferedWriter.newLine();
                ClimateColorInfo.write("local SUMMER,FALL,WINTER,SPRING = 0,1,2,3;");
                bufferedWriter.newLine();
                ClimateColorInfo.write("function ClimateMain.onClimateManagerInit(_clim)");
                int n = 1;
                ClimateColorInfo.write(n, "local c;");
                ClimateColorInfo.write(n, "c = _clim:getColNightNoMoon();");
                ClimateColorInfo.writeColor(n, climateManager.getColNightNoMoon());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getColNightMoon();");
                ClimateColorInfo.writeColor(n, climateManager.getColNightMoon());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getColFog();");
                ClimateColorInfo.writeColor(n, climateManager.getColFog());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getColFogLegacy();");
                ClimateColorInfo.writeColor(n, climateManager.getColFogLegacy());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getColFogNew();");
                ClimateColorInfo.writeColor(n, climateManager.getColFogNew());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getFogTintStorm();");
                ClimateColorInfo.writeColor(n, climateManager.getFogTintStorm());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = _clim:getFogTintTropical();");
                ClimateColorInfo.writeColor(n, climateManager.getFogTintTropical());
                bufferedWriter.newLine();
                WeatherPeriod weatherPeriod = climateManager.getWeatherPeriod();
                ClimateColorInfo.write(n, "local w = _clim:getWeatherPeriod();");
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorReddish();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorReddish());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorGreenish();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorGreenish());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorBlueish();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorBlueish());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorPurplish();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorPurplish());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorTropical();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorTropical());
                bufferedWriter.newLine();
                ClimateColorInfo.write(n, "c = w:getCloudColorBlizzard();");
                ClimateColorInfo.writeColor(n, weatherPeriod.getCloudColorBlizzard());
                bufferedWriter.newLine();
                String[] stringArray = new String[]{"Dawn", "Day", "Dusk"};
                String[] stringArray2 = new String[]{"SUMMER", "FALL", "WINTER", "SPRING"};
                String[] stringArray3 = new String[]{"WARM", "NORMAL", "CLOUDY"};
                for (int i = 0; i < 3; ++i) {
                    ClimateColorInfo.write(n, "-- ###################### " + stringArray[i] + " ######################");
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            if (k != 0 && k != 2 && (k != 1 || i != 2)) continue;
                            ClimateColorInfo climateColorInfo = climateManager.getSeasonColor(i, k, j);
                            ClimateColorInfo.writeSeasonColor(n, climateColorInfo, stringArray[i], stringArray2[j], stringArray3[k]);
                            bufferedWriter.newLine();
                        }
                    }
                }
                ClimateColorInfo.write("end");
                bufferedWriter.newLine();
                ClimateColorInfo.write("Events.OnClimateManagerInit.Add(ClimateMain.onClimateManagerInit);");
                writer = null;
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private static void writeSeasonColor(int n, ClimateColorInfo climateColorInfo, String string, String string2, String string3) throws IOException {
        Color color = climateColorInfo.exterior;
        ClimateColorInfo.write(n, "_clim:setSeasonColor" + string + "(" + string3 + "," + string2 + "," + color.r + "," + color.g + "," + color.b + "," + color.a + ",true);\t\t--exterior");
        color = climateColorInfo.interior;
        ClimateColorInfo.write(n, "_clim:setSeasonColor" + string + "(" + string3 + "," + string2 + "," + color.r + "," + color.g + "," + color.b + "," + color.a + ",false);\t\t--interior");
    }

    private static void writeColor(int n, ClimateColorInfo climateColorInfo) throws IOException {
        Color color = climateColorInfo.exterior;
        ClimateColorInfo.write(n, "c:setExterior(" + color.r + "," + color.g + "," + color.b + "," + color.a + ");");
        color = climateColorInfo.interior;
        ClimateColorInfo.write(n, "c:setInterior(" + color.r + "," + color.g + "," + color.b + "," + color.a + ");");
    }

    private static void write(int n, String string) throws IOException {
        String string2 = new String(new char[n]).replace("\u0000", "\t");
        writer.write(string2);
        writer.write(string);
        writer.newLine();
    }

    private static void write(String string) throws IOException {
        writer.write(string);
        writer.newLine();
    }
}

