/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite.shapers;

import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.iso.sprite.shapers.SpritePaddingSettings;

public class SpritePadding {
    public static void applyPadding(TextureDraw textureDraw, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = textureDraw.x0;
        float f10 = textureDraw.y0;
        float f11 = textureDraw.x1;
        float f12 = textureDraw.y1;
        float f13 = textureDraw.x2;
        float f14 = textureDraw.y2;
        float f15 = textureDraw.x3;
        float f16 = textureDraw.y3;
        float f17 = textureDraw.u0;
        float f18 = textureDraw.v0;
        float f19 = textureDraw.u1;
        float f20 = textureDraw.v1;
        float f21 = textureDraw.u2;
        float f22 = textureDraw.v2;
        float f23 = textureDraw.u3;
        float f24 = textureDraw.v3;
        textureDraw.x0 = f9 - f;
        textureDraw.y0 = f10 - f2;
        textureDraw.u0 = f17 - f5;
        textureDraw.v0 = f18 - f6;
        textureDraw.x1 = f11 + f3;
        textureDraw.y1 = f12 - f2;
        textureDraw.u1 = f19 + f7;
        textureDraw.v1 = f20 - f6;
        textureDraw.x2 = f13 + f3;
        textureDraw.y2 = f14 + f4;
        textureDraw.u2 = f21 + f7;
        textureDraw.v2 = f22 + f8;
        textureDraw.x3 = f15 - f;
        textureDraw.y3 = f16 + f4;
        textureDraw.u3 = f23 - f5;
        textureDraw.v3 = f24 + f8;
    }

    public static void applyPaddingBorder(TextureDraw textureDraw, float f, float f2) {
        float f3 = textureDraw.x1 - textureDraw.x0;
        float f4 = textureDraw.y2 - textureDraw.y1;
        float f5 = textureDraw.u1 - textureDraw.u0;
        float f6 = textureDraw.v2 - textureDraw.v1;
        float f7 = f;
        float f8 = f;
        float f9 = f5 * f7 / f3;
        float f10 = f6 * f8 / f4;
        float f11 = f2 * f9;
        float f12 = f2 * f10;
        SpritePadding.applyPadding(textureDraw, f7, f8, f7, f8, f11, f12, f11, f12);
    }

    public static void applyIsoPadding(TextureDraw textureDraw, IsoPaddingSettings isoPaddingSettings) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.IsoPadding.getValue()) {
            return;
        }
        IsoPaddingSettings.IsoBorderSetting isoBorderSetting = isoPaddingSettings.getCurrentZoomSetting();
        float f = isoBorderSetting.borderThickness;
        float f2 = isoBorderSetting.uvFraction;
        SpritePadding.applyPaddingBorder(textureDraw, f, f2);
    }

    public static class IsoPaddingSettings
    extends SpritePaddingSettings.GenericZoomBasedSettingGroup {
        public IsoBorderSetting ZoomedIn = new IsoBorderSetting(1.0f, 0.99f);
        public IsoBorderSetting NotZoomed = new IsoBorderSetting(1.0f, 0.99f);
        public IsoBorderSetting ZoomedOut = new IsoBorderSetting(2.0f, 0.01f);

        public IsoBorderSetting getCurrentZoomSetting() {
            return IsoPaddingSettings.getCurrentZoomSetting(this.ZoomedIn, this.NotZoomed, this.ZoomedOut);
        }

        public static class IsoBorderSetting {
            public float borderThickness;
            public float uvFraction;

            public IsoBorderSetting() {
            }

            public IsoBorderSetting(float f, float f2) {
                this.borderThickness = f;
                this.uvFraction = f2;
            }
        }
    }
}

