/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite.shapers;

import javax.xml.bind.annotation.XmlType;
import zombie.core.Color;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.iso.sprite.shapers.FloorShaper;
import zombie.iso.sprite.shapers.SpritePadding;
import zombie.iso.sprite.shapers.SpritePaddingSettings;

public class FloorShaperDeDiamond
extends FloorShaper {
    public static final FloorShaperDeDiamond instance = new FloorShaperDeDiamond();

    @Override
    public void accept(TextureDraw textureDraw) {
        int n = this.colTint;
        this.colTint = 0;
        super.accept(textureDraw);
        this.applyDeDiamondPadding(textureDraw);
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.Floor.Lighting.getValue()) {
            return;
        }
        int n2 = this.col[0];
        int n3 = this.col[1];
        int n4 = this.col[2];
        int n5 = this.col[3];
        int n6 = Color.lerpABGR(n2, n5, 0.5f);
        int n7 = Color.lerpABGR(n3, n2, 0.5f);
        int n8 = Color.lerpABGR(n4, n3, 0.5f);
        int n9 = Color.lerpABGR(n5, n4, 0.5f);
        textureDraw.col0 = Color.blendBGR(textureDraw.col0, n6);
        textureDraw.col1 = Color.blendBGR(textureDraw.col1, n7);
        textureDraw.col2 = Color.blendBGR(textureDraw.col2, n8);
        textureDraw.col3 = Color.blendBGR(textureDraw.col3, n9);
        if (n != 0) {
            textureDraw.col0 = Color.tintABGR(textureDraw.col0, n);
            textureDraw.col1 = Color.tintABGR(textureDraw.col1, n);
            textureDraw.col2 = Color.tintABGR(textureDraw.col2, n);
            textureDraw.col3 = Color.tintABGR(textureDraw.col3, n);
        }
    }

    private void applyDeDiamondPadding(TextureDraw textureDraw) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.IsoPaddingDeDiamond.getValue()) {
            return;
        }
        Settings settings = this.getSettings();
        Settings.BorderSetting borderSetting = settings.getCurrentZoomSetting();
        float f = borderSetting.borderThicknessUp;
        float f2 = borderSetting.borderThicknessDown;
        float f3 = borderSetting.borderThicknessLR;
        float f4 = borderSetting.uvFraction;
        float f5 = textureDraw.x1 - textureDraw.x0;
        float f6 = textureDraw.y2 - textureDraw.y1;
        float f7 = textureDraw.u1 - textureDraw.u0;
        float f8 = textureDraw.v2 - textureDraw.v1;
        float f9 = f3;
        float f10 = f;
        float f11 = f2;
        float f12 = f7 * f9 / f5;
        float f13 = f8 * f10 / f6;
        float f14 = f8 * f11 / f6;
        float f15 = f4 * f12;
        float f16 = f4 * f13;
        float f17 = f4 * f14;
        SpritePadding.applyPadding(textureDraw, f9, f10, f9, f11, f15, f16, f15, f17);
    }

    private Settings getSettings() {
        return SpritePaddingSettings.getSettings().FloorDeDiamond;
    }

    @XmlType(name="FloorShaperDeDiamondSettings")
    public static class Settings
    extends SpritePaddingSettings.GenericZoomBasedSettingGroup {
        public BorderSetting ZoomedIn = new BorderSetting(2.0f, 1.0f, 2.0f, 0.01f);
        public BorderSetting NotZoomed = new BorderSetting(2.0f, 1.0f, 2.0f, 0.01f);
        public BorderSetting ZoomedOut = new BorderSetting(2.0f, 0.0f, 2.5f, 0.0f);

        public BorderSetting getCurrentZoomSetting() {
            return Settings.getCurrentZoomSetting(this.ZoomedIn, this.NotZoomed, this.ZoomedOut);
        }

        public static class BorderSetting {
            public float borderThicknessUp = 3.0f;
            public float borderThicknessDown = 3.0f;
            public float borderThicknessLR = 0.0f;
            public float uvFraction = 0.01f;

            public BorderSetting() {
            }

            public BorderSetting(float f, float f2, float f3, float f4) {
                this.borderThicknessUp = f;
                this.borderThicknessDown = f2;
                this.borderThicknessLR = f3;
                this.uvFraction = f4;
            }
        }
    }
}

