/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite.shapers;

import javax.xml.bind.annotation.XmlType;
import zombie.core.textures.TextureDraw;
import zombie.debug.DebugOptions;
import zombie.iso.sprite.shapers.FloorShaper;
import zombie.iso.sprite.shapers.SpritePadding;
import zombie.iso.sprite.shapers.SpritePaddingSettings;

public class FloorShaperAttachedSprites
extends FloorShaper {
    public static final FloorShaperAttachedSprites instance = new FloorShaperAttachedSprites();

    @Override
    public void accept(TextureDraw textureDraw) {
        super.accept(textureDraw);
        this.applyAttachedSpritesPadding(textureDraw);
    }

    private void applyAttachedSpritesPadding(TextureDraw textureDraw) {
        if (!DebugOptions.instance.Terrain.RenderTiles.IsoGridSquare.IsoPaddingAttached.getValue()) {
            return;
        }
        Settings settings = this.getSettings();
        Settings.ASBorderSetting aSBorderSetting = settings.getCurrentZoomSetting();
        float f = aSBorderSetting.borderThicknessUp;
        float f2 = aSBorderSetting.borderThicknessDown;
        float f3 = aSBorderSetting.borderThicknessLR;
        float f4 = aSBorderSetting.uvFraction;
        float f5 = textureDraw.x1 - textureDraw.x0;
        float f6 = textureDraw.y2 - textureDraw.y1;
        float f7 = textureDraw.u1 - textureDraw.u0;
        float f8 = textureDraw.v2 - textureDraw.v1;
        float f9 = f3;
        float f10 = f;
        float f11 = f2;
        float f12 = f7 * f9 / f5;
        float f13 = f8 * f10 / f6;
        float f14 = f8 * f11 / f6;
        float f15 = f4 * f12;
        float f16 = f4 * f13;
        float f17 = f4 * f14;
        SpritePadding.applyPadding(textureDraw, f9, f10, f9, f11, f15, f16, f15, f17);
    }

    private Settings getSettings() {
        return SpritePaddingSettings.getSettings().AttachedSprites;
    }

    @XmlType(name="FloorShaperAttachedSpritesSettings")
    public static class Settings
    extends SpritePaddingSettings.GenericZoomBasedSettingGroup {
        public ASBorderSetting ZoomedIn = new ASBorderSetting(2.0f, 1.0f, 3.0f, 0.01f);
        public ASBorderSetting NotZoomed = new ASBorderSetting(2.0f, 1.0f, 3.0f, 0.01f);
        public ASBorderSetting ZoomedOut = new ASBorderSetting(2.0f, 0.0f, 2.5f, 0.0f);

        public ASBorderSetting getCurrentZoomSetting() {
            return Settings.getCurrentZoomSetting(this.ZoomedIn, this.NotZoomed, this.ZoomedOut);
        }

        public static class ASBorderSetting {
            public float borderThicknessUp;
            public float borderThicknessDown;
            public float borderThicknessLR;
            public float uvFraction;

            public ASBorderSetting() {
            }

            public ASBorderSetting(float f, float f2, float f3, float f4) {
                this.borderThicknessUp = f;
                this.borderThicknessDown = f2;
                this.borderThicknessLR = f3;
                this.uvFraction = f4;
            }
        }
    }
}

