/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.sprite;

import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL;
import zombie.GameTime;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureFBO;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugOptions;
import zombie.interfaces.ITexture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoObject;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.SkyBoxShader;
import zombie.iso.weather.ClimateManager;

public class SkyBox
extends IsoObject {
    private static SkyBox instance;
    public IsoSpriteInstance def = null;
    private TextureFBO textureFBOA;
    private TextureFBO textureFBOB;
    private boolean isCurrentA;
    public Shader Effect;
    private final UpdateLimit renderLimit = new UpdateLimit(1000L);
    private boolean isUpdated = false;
    private int SkyBoxTime;
    private float SkyBoxParamCloudCount;
    private float SkyBoxParamCloudSize;
    private final Vector3f SkyBoxParamSunLight = new Vector3f();
    private final Color SkyBoxParamSunColor = new Color(1.0f, 1.0f, 1.0f);
    private final Color SkyBoxParamSkyHColour = new Color(1.0f, 1.0f, 1.0f);
    private final Color SkyBoxParamSkyLColour = new Color(1.0f, 1.0f, 1.0f);
    private float SkyBoxParamCloudLight;
    private float SkyBoxParamStars;
    private float SkyBoxParamFog;
    private final Vector3f SkyBoxParamWind;
    private boolean isSetAVG = false;
    private float SkyBoxParamCloudCountAVG;
    private float SkyBoxParamCloudSizeAVG;
    private final Vector3f SkyBoxParamSunLightAVG = new Vector3f();
    private final Color SkyBoxParamSunColorAVG = new Color(1.0f, 1.0f, 1.0f);
    private final Color SkyBoxParamSkyHColourAVG = new Color(1.0f, 1.0f, 1.0f);
    private final Color SkyBoxParamSkyLColourAVG = new Color(1.0f, 1.0f, 1.0f);
    private float SkyBoxParamCloudLightAVG;
    private float SkyBoxParamStarsAVG;
    private float SkyBoxParamFogAVG;
    private final Vector3f SkyBoxParamWindINT;
    private Texture texAM;
    private Texture texPM;
    private final Color SkyHColourDay = new Color(0.1f, 0.1f, 0.4f);
    private final Color SkyHColourDawn = new Color(0.2f, 0.2f, 0.3f);
    private final Color SkyHColourDusk = new Color(0.2f, 0.2f, 0.3f);
    private final Color SkyHColourNight = new Color(0.01f, 0.01f, 0.04f);
    private final Color SkyLColourDay = new Color(0.1f, 0.45f, 0.7f);
    private final Color SkyLColourDawn = new Color(0.1f, 0.4f, 0.6f);
    private final Color SkyLColourDusk = new Color(0.1f, 0.4f, 0.6f);
    private final Color SkyLColourNight = new Color(0.01f, 0.045f, 0.07f);
    private int apiId;

    public static synchronized SkyBox getInstance() {
        if (instance == null) {
            instance = new SkyBox();
        }
        return instance;
    }

    public void update(ClimateManager climateManager) {
        float f;
        if (this.isUpdated) {
            return;
        }
        this.isUpdated = true;
        GameTime gameTime = GameTime.getInstance();
        ClimateManager.DayInfo dayInfo = climateManager.getCurrentDay();
        float f2 = dayInfo.season.getDawn();
        float f3 = dayInfo.season.getDusk();
        float f4 = dayInfo.season.getDayHighNoon();
        float f5 = gameTime.getTimeOfDay();
        if (f5 < f2 || f5 > f3) {
            f = 24.0f - f3 + f2;
            if (f5 > f3) {
                float f6 = (f5 - f3) / f;
                this.SkyHColourDusk.interp(this.SkyHColourDawn, f6, this.SkyBoxParamSkyHColour);
                this.SkyLColourDusk.interp(this.SkyLColourDawn, f6, this.SkyBoxParamSkyLColour);
                this.SkyBoxParamSunLight.set(0.35f, 0.22f, 0.3f);
                this.SkyBoxParamSunLight.normalize();
                this.SkyBoxParamSunLight.mul(Math.min(1.0f, f6 * 5.0f));
            } else {
                float f7 = (24.0f - f3 + f5) / f;
                this.SkyHColourDusk.interp(this.SkyHColourDawn, f7, this.SkyBoxParamSkyHColour);
                this.SkyLColourDusk.interp(this.SkyLColourDawn, f7, this.SkyBoxParamSkyLColour);
                this.SkyBoxParamSunLight.set(0.35f, 0.22f, 0.3f);
                this.SkyBoxParamSunLight.normalize();
                this.SkyBoxParamSunLight.mul(Math.min(1.0f, (1.0f - f7) * 5.0f));
            }
            this.SkyBoxParamSunColor.set(climateManager.getGlobalLight().getExterior());
            this.SkyBoxParamSunColor.scale(climateManager.getNightStrength());
        } else if (f5 < f4) {
            f = (f5 - f2) / (f4 - f2);
            this.SkyHColourDawn.interp(this.SkyHColourDay, f, this.SkyBoxParamSkyHColour);
            this.SkyLColourDawn.interp(this.SkyLColourDay, f, this.SkyBoxParamSkyLColour);
            this.SkyBoxParamSunLight.set(4.0f * f - 4.0f, 0.22f, 0.3f);
            this.SkyBoxParamSunLight.normalize();
            this.SkyBoxParamSunLight.mul(Math.min(1.0f, f * 10.0f));
            this.SkyBoxParamSunColor.set(climateManager.getGlobalLight().getExterior());
        } else {
            f = (f5 - f4) / (f3 - f4);
            this.SkyHColourDay.interp(this.SkyHColourDusk, f, this.SkyBoxParamSkyHColour);
            this.SkyLColourDay.interp(this.SkyLColourDusk, f, this.SkyBoxParamSkyLColour);
            this.SkyBoxParamSunLight.set(4.0f * f, 0.22f, 0.3f);
            this.SkyBoxParamSunLight.normalize();
            this.SkyBoxParamSunLight.mul(Math.min(1.0f, (1.0f - f) * 10.0f));
            this.SkyBoxParamSunColor.set(climateManager.getGlobalLight().getExterior());
        }
        this.SkyBoxParamSkyHColour.interp(this.SkyHColourNight, climateManager.getNightStrength(), this.SkyBoxParamSkyHColour);
        this.SkyBoxParamSkyLColour.interp(this.SkyLColourNight, climateManager.getNightStrength(), this.SkyBoxParamSkyLColour);
        this.SkyBoxParamCloudCount = Math.min(Math.max(climateManager.getCloudIntensity(), climateManager.getPrecipitationIntensity() * 2.0f), 0.999f);
        this.SkyBoxParamCloudSize = 0.02f + climateManager.getTemperature() / 70.0f;
        this.SkyBoxParamFog = climateManager.getFogIntensity();
        this.SkyBoxParamStars = climateManager.getNightStrength();
        this.SkyBoxParamCloudLight = (float)(1.0 - (1.0 - 1.0 * Math.pow(1000.0, -climateManager.getPrecipitationIntensity() - climateManager.getNightStrength())));
        f = (1.0f - (climateManager.getWindAngleIntensity() + 1.0f) * 0.5f + 0.25f) % 1.0f;
        this.SkyBoxParamWind.set((float)Math.cos(Math.toRadians(f *= 360.0f)), 0.0f, (float)Math.sin(Math.toRadians(f)));
        this.SkyBoxParamWind.mul(climateManager.getWindIntensity());
        if (!this.isSetAVG) {
            this.isSetAVG = true;
            this.SkyBoxParamCloudCountAVG = this.SkyBoxParamCloudCount;
            this.SkyBoxParamCloudSizeAVG = this.SkyBoxParamCloudSize;
            this.SkyBoxParamSunLightAVG.set((Vector3fc)this.SkyBoxParamSunLight);
            this.SkyBoxParamSunColorAVG.set(this.SkyBoxParamSunColor);
            this.SkyBoxParamSkyHColourAVG.set(this.SkyBoxParamSkyHColour);
            this.SkyBoxParamSkyLColourAVG.set(this.SkyBoxParamSkyLColour);
            this.SkyBoxParamCloudLightAVG = this.SkyBoxParamCloudLight;
            this.SkyBoxParamStarsAVG = this.SkyBoxParamStars;
            this.SkyBoxParamFogAVG = this.SkyBoxParamFog;
            this.SkyBoxParamWindINT.set((Vector3fc)this.SkyBoxParamWind);
        } else {
            this.SkyBoxParamCloudCountAVG += (this.SkyBoxParamCloudCount - this.SkyBoxParamCloudCountAVG) * 0.1f;
            this.SkyBoxParamCloudSizeAVG += (this.SkyBoxParamCloudSizeAVG + this.SkyBoxParamCloudSize) * 0.1f;
            this.SkyBoxParamSunLightAVG.lerp((Vector3fc)this.SkyBoxParamSunLight, 0.1f);
            this.SkyBoxParamSunColorAVG.interp(this.SkyBoxParamSunColor, 0.1f, this.SkyBoxParamSunColorAVG);
            this.SkyBoxParamSkyHColourAVG.interp(this.SkyBoxParamSkyHColour, 0.1f, this.SkyBoxParamSkyHColourAVG);
            this.SkyBoxParamSkyLColourAVG.interp(this.SkyBoxParamSkyLColour, 0.1f, this.SkyBoxParamSkyLColourAVG);
            this.SkyBoxParamCloudLightAVG += (this.SkyBoxParamCloudLight - this.SkyBoxParamCloudLightAVG) * 0.1f;
            this.SkyBoxParamStarsAVG += (this.SkyBoxParamStars - this.SkyBoxParamStarsAVG) * 0.1f;
            this.SkyBoxParamFogAVG += (this.SkyBoxParamFog - this.SkyBoxParamFogAVG) * 0.1f;
            this.SkyBoxParamWindINT.add((Vector3fc)this.SkyBoxParamWind);
        }
    }

    public int getShaderTime() {
        return this.SkyBoxTime;
    }

    public float getShaderCloudCount() {
        return this.SkyBoxParamCloudCount;
    }

    public float getShaderCloudSize() {
        return this.SkyBoxParamCloudSize;
    }

    public Vector3f getShaderSunLight() {
        return this.SkyBoxParamSunLight;
    }

    public Color getShaderSunColor() {
        return this.SkyBoxParamSunColor;
    }

    public Color getShaderSkyHColour() {
        return this.SkyBoxParamSkyHColour;
    }

    public Color getShaderSkyLColour() {
        return this.SkyBoxParamSkyLColour;
    }

    public float getShaderCloudLight() {
        return this.SkyBoxParamCloudLight;
    }

    public float getShaderStars() {
        return this.SkyBoxParamStars;
    }

    public float getShaderFog() {
        return this.SkyBoxParamFog;
    }

    public Vector3f getShaderWind() {
        return this.SkyBoxParamWindINT;
    }

    public SkyBox() {
        this.texAM = Texture.getSharedTexture("media/textures/CMVehicleReflection/ref_am.png");
        this.texPM = Texture.getSharedTexture("media/textures/CMVehicleReflection/ref_am.png");
        try {
            Texture texture = new Texture(512, 512, 16);
            Texture texture2 = new Texture(512, 512, 16);
            this.textureFBOA = new TextureFBO(texture);
            this.textureFBOB = new TextureFBO(texture2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.def = IsoSpriteInstance.get(this.sprite);
        this.SkyBoxTime = 0;
        this.SkyBoxParamSunLight.set(0.35f, 0.22f, 0.3f);
        this.SkyBoxParamSunColor.set(1.0f, 0.86f, 0.7f, 1.0f);
        this.SkyBoxParamSkyHColour.set(0.1f, 0.1f, 0.4f, 1.0f);
        this.SkyBoxParamSkyLColour.set(0.1f, 0.45f, 0.7f, 1.0f);
        this.SkyBoxParamCloudLight = 0.99f;
        this.SkyBoxParamCloudCount = 0.3f;
        this.SkyBoxParamCloudSize = 0.2f;
        this.SkyBoxParamFog = 0.0f;
        this.SkyBoxParamStars = 0.0f;
        this.SkyBoxParamWind = new Vector3f(0.0f);
        this.SkyBoxParamWindINT = new Vector3f(0.0f);
        RenderThread.invokeOnRenderContext(() -> {
            this.Effect = Core.getInstance().getPerfSkybox() == 0 ? new SkyBoxShader("skybox_hires") : new SkyBoxShader("skybox");
            if (GL.getCapabilities().OpenGL30) {
                this.apiId = 1;
            }
            if (GL.getCapabilities().GL_ARB_framebuffer_object) {
                this.apiId = 2;
            }
            if (GL.getCapabilities().GL_EXT_framebuffer_object) {
                this.apiId = 3;
            }
        });
    }

    public ITexture getTextureCurrent() {
        if (!Core.getInstance().getUseShaders() || Core.getInstance().getPerfSkybox() == 2) {
            return this.texAM;
        }
        if (this.isCurrentA) {
            return this.textureFBOA.getTexture();
        }
        return this.textureFBOB.getTexture();
    }

    public ITexture getTexturePrev() {
        if (!Core.getInstance().getUseShaders() || Core.getInstance().getPerfSkybox() == 2) {
            return this.texPM;
        }
        if (this.isCurrentA) {
            return this.textureFBOB.getTexture();
        }
        return this.textureFBOA.getTexture();
    }

    public TextureFBO getTextureFBOPrev() {
        if (!Core.getInstance().getUseShaders() || Core.getInstance().getPerfSkybox() == 2) {
            return null;
        }
        if (this.isCurrentA) {
            return this.textureFBOB;
        }
        return this.textureFBOA;
    }

    public float getTextureShift() {
        if (!Core.getInstance().getUseShaders() || Core.getInstance().getPerfSkybox() == 2) {
            return 1.0f - GameTime.getInstance().getNight();
        }
        float f = (float)this.renderLimit.getTimePeriod();
        return f;
    }

    public void swapTextureFBO() {
        this.renderLimit.updateTimePeriod();
        this.isCurrentA = !this.isCurrentA;
    }

    public void render() {
        if (!Core.getInstance().getUseShaders() || Core.getInstance().getPerfSkybox() == 2) {
            return;
        }
        if (!this.renderLimit.Check()) {
            if (GameTime.getInstance().getMultiplier() >= 20.0f) {
                ++this.SkyBoxTime;
            }
            return;
        }
        ++this.SkyBoxTime;
        int n = IsoCamera.frameState.playerIndex;
        int n2 = IsoCamera.getOffscreenLeft(n);
        int n3 = IsoCamera.getOffscreenTop(n);
        int n4 = IsoCamera.getOffscreenWidth(n);
        int n5 = IsoCamera.getOffscreenHeight(n);
        SpriteRenderer.instance.drawSkyBox(this.Effect, n, this.apiId, this.getTextureFBOPrev().getBufferId());
        this.isUpdated = false;
    }

    public void draw() {
        if (Core.bDebug && DebugOptions.instance.SkyboxShow.getValue()) {
            ((Texture)this.getTextureCurrent()).render(0.0f, 0.0f, 512.0f, 512.0f, 1.0f, 1.0f, 1.0f, 1.0f, null);
        }
    }
}

